/*
 * Decompiled with CFR 0.152.
 */
package test;

import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGServerVersion;
import com.franz.agraph.repository.AGTupleQuery;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.URI;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.junit.Assert;
import test.AGAbstractTest;

public class Util {
    public static File resource(String path) {
        return new File(Util.class.getResource(path).toExternalForm());
    }

    public static void add(RepositoryConnection conn, String path, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws RepositoryException, RDFParseException {
        try (InputStream input = Util.resourceAsStream(path);){
            conn.add(input, baseURI, dataFormat, contexts);
        }
        catch (IOException e) {
            throw new RepositoryException("Unable to load " + path, (Throwable)e);
        }
    }

    public static InputStream resourceAsStream(String path) {
        return Util.class.getResourceAsStream(path);
    }

    public static File resourceAsTempFile(String path) {
        return Util.resourceAsTempFile(path, false);
    }

    public static File resourceAsTempFile(String path, boolean executable) {
        File result;
        EnumSet<PosixFilePermission> permissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
        if (executable) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        FileAttribute[] attributes = FileSystems.getDefault().supportedFileAttributeViews().contains("posix") ? new FileAttribute[]{PosixFilePermissions.asFileAttribute(permissions)} : new FileAttribute[]{};
        try {
            result = Files.createTempFile("resource", "tmp", attributes).toFile();
            result.deleteOnExit();
            FileUtils.copyInputStreamToFile((InputStream)Util.resourceAsStream(path), (File)result);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStatementId(AGRepositoryConnection conn, Resource subj, URI pred, Value obj) throws QueryEvaluationException {
        String qs = "select ?id { ?id <http://franz.com/ns/allegrograph/4.0/tripleId> (?s ?p ?o) }";
        AGTupleQuery query = conn.prepareTupleQuery(QueryLanguage.SPARQL, "select ?id { ?id <http://franz.com/ns/allegrograph/4.0/tripleId> (?s ?p ?o) }");
        query.setBinding("s", (Value)subj);
        query.setBinding("p", (Value)pred);
        query.setBinding("o", obj);
        try (TupleQueryResult result = query.evaluate();){
            if (result.hasNext()) {
                String uri = ((BindingSet)result.next()).getValue("id").stringValue();
                String string = uri.substring(uri.indexOf(35) + 1);
                return string;
            }
        }
        return null;
    }

    public static String get(String[] arr, int i, String defaultVal) {
        if (arr != null && arr.length > i) {
            return arr[i];
        }
        return defaultVal;
    }

    public static int hashCode(Object o) {
        if (o == null) {
            return 0;
        }
        return o.hashCode();
    }

    @SafeVarargs
    public static <Type> Type coalesce(Type ... values) {
        for (Type e : values) {
            if (e == null) continue;
            return e;
        }
        return null;
    }

    public static String ifBlank(String str, String defaultValue) {
        if (str == null || str.trim().isEmpty()) {
            return defaultValue;
        }
        return str;
    }

    public static void gzip(File in, File out) throws IOException {
        try (GZIPOutputStream os = new GZIPOutputStream(new FileOutputStream(out));){
            FileUtils.copyFile((File)in, (OutputStream)os);
            ((OutputStream)os).flush();
        }
    }

    public static void zip(File in, File out) throws IOException {
        try (ZipOutputStream os = new ZipOutputStream(new FileOutputStream(out));){
            FileUtils.copyFile((File)in, (OutputStream)os);
            ((OutputStream)os).flush();
        }
    }

    public static List arrayList(Object ... elements) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < elements.length; ++i) {
            list.add(elements[i]);
        }
        return list;
    }

    public static List toList(Object arr) {
        if (arr == null) {
            return null;
        }
        if (arr instanceof List) {
            return (List)arr;
        }
        if (arr instanceof Object[]) {
            return Arrays.asList((Object[])arr);
        }
        ArrayList<Comparable<Byte>> list = new ArrayList<Comparable<Byte>>();
        if (arr instanceof byte[]) {
            byte[] a = (byte[])arr;
            for (int i = 0; i < a.length; ++i) {
                list.add(Byte.valueOf(a[i]));
            }
        } else if (arr instanceof char[]) {
            char[] a = (char[])arr;
            for (int i = 0; i < a.length; ++i) {
                list.add(Character.valueOf(a[i]));
            }
        } else if (arr instanceof int[]) {
            int[] a = (int[])arr;
            for (int i = 0; i < a.length; ++i) {
                list.add(Integer.valueOf(a[i]));
            }
        } else if (arr instanceof long[]) {
            long[] a = (long[])arr;
            for (int i = 0; i < a.length; ++i) {
                list.add(Long.valueOf(a[i]));
            }
        } else if (arr instanceof float[]) {
            float[] a = (float[])arr;
            for (int i = 0; i < a.length; ++i) {
                list.add(Float.valueOf(a[i]));
            }
        } else if (arr instanceof double[]) {
            double[] a = (double[])arr;
            for (int i = 0; i < a.length; ++i) {
                list.add(Double.valueOf(a[i]));
            }
        } else {
            throw new IllegalArgumentException("type not handled: " + arr.getClass());
        }
        return list;
    }

    public static List toListDeep(Object obj) {
        List in = Util.toList(obj);
        if (in == null) {
            return null;
        }
        ArrayList out = new ArrayList(in.size());
        for (Object o : in) {
            if (o == null) {
                out.add(null);
                continue;
            }
            if (o instanceof List || o.getClass().isArray()) {
                out.add(Util.toListDeep(o));
                continue;
            }
            out.add(o);
        }
        return out;
    }

    public static long fromHumanInt(String value) {
        char c;
        int len = value.length();
        if (len > 1 && !Character.isDigit(c = value.charAt(len - 1))) {
            int n = Integer.parseInt(value.substring(0, len - 1));
            if (c == 'm') {
                return (long)n * (long)Math.pow(10.0, 6.0);
            }
            if (c == 'b') {
                return (long)n * (long)Math.pow(10.0, 9.0);
            }
            if (c == 't') {
                return (long)n * (long)Math.pow(10.0, 12.0);
            }
        }
        return Long.parseLong(value);
    }

    public static String toHumanInt(long num, int type) {
        String[] abbrevs;
        long[] mult;
        if (type == 2) {
            mult = new long[]{1024L, 1024L, 1024L, 1024L, 1024L};
        } else if (type == 10) {
            mult = new long[]{1000L, 1000L, 1000L, 1000L, 1000L};
        } else if (type == 60) {
            mult = new long[]{1000L, 60L, 60L, 24L, 30L};
        } else {
            throw new IllegalArgumentException("unknown type: " + type);
        }
        if (type == 2) {
            abbrevs = new String[]{"b", "k", "m", "g", "t"};
        } else if (type == 10) {
            abbrevs = new String[]{"", "k", "m", "b", "t"};
        } else if (type == 60) {
            abbrevs = new String[]{"ms", "s", "m", "h", "d"};
        } else {
            throw new IllegalArgumentException("unknown type: " + type);
        }
        for (int i = 0; i < abbrevs.length; ++i) {
            if (num < mult[i] * 10L) {
                return num + abbrevs[i];
            }
            num /= mult[i];
        }
        return "" + num;
    }

    public static List reverse(List list) {
        list = new ArrayList(list);
        Collections.reverse(list);
        return list;
    }

    public static <ReturnType> ReturnType waitFor(TimeUnit unit, long sleep, long maxWait, Callable<ReturnType> fn) throws Exception {
        return Util.waitFor(unit.toMillis(sleep), unit.toNanos(maxWait), fn);
    }

    public static <ReturnType> ReturnType waitFor(long sleepMillis, long maxWaitNanos, Callable<ReturnType> fn) throws Exception {
        ReturnType ret;
        long start = System.nanoTime();
        while (true) {
            if ((ret = fn.call()) == null || Boolean.FALSE.equals(ret)) {
                return ret;
            }
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                continue;
            }
            if (System.nanoTime() - start >= maxWaitNanos) break;
        }
        return ret;
    }

    public static List<String> netstat() throws IOException {
        String[] cmd = new String[]{"bash", "-c", "netstat -ntap 2>/dev/null | egrep '\\<'$PPID/java'\\>'"};
        Process p = Runtime.getRuntime().exec(cmd);
        String string = IOUtil.readString((InputStream)p.getInputStream());
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(string.split("\n")));
        list.remove("");
        return list;
    }

    public static List<String> closeWait(List<String> netstat) throws Exception {
        return netstat.stream().filter(line -> line.contains("CLOSE_WAIT")).collect(Collectors.toList());
    }

    public static List<String> waitForNetStat(int maxWaitSeconds, final List<String> excluding) throws Exception {
        return Util.waitFor(TimeUnit.SECONDS, 1L, maxWaitSeconds, new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                List<String> netstat = Util.netstat().stream().filter(line -> {
                    for (String exclude : excluding) {
                        if (!line.matches(exclude)) continue;
                        return false;
                    }
                    return true;
                }).collect(Collectors.toList());
                return netstat.isEmpty() ? null : netstat;
            }
        });
    }

    public static Map<String, String> waitForSessionsToGoAway(final AGServer server, final String repoName) throws Exception {
        Map<String, String> sessions = Util.waitFor(TimeUnit.SECONDS, 1L, 30L, new Callable<Map<String, String>>(){

            @Override
            public Map<String, String> call() throws Exception {
                Map<String, String> sessions = AGAbstractTest.sessions(server);
                for (Map.Entry<String, String> entry : sessions.entrySet()) {
                    if (!entry.getValue().contains(repoName)) continue;
                    return sessions;
                }
                return null;
            }
        });
        return sessions;
    }

    public static void logTimeStamped(String message) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        System.out.println(sdf.format(Calendar.getInstance().getTime()) + " " + message);
    }

    public static String GetLogDirFromAgraphCFG(String filename) throws FileNotFoundException, IOException {
        String line;
        String res = null;
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            if (!line.matches("(?i)LogDir\\s+.*")) continue;
            res = line.split("\\s+", 2)[1];
            break;
        }
        br.close();
        return res;
    }

    public static String GetAgraphCfgFilenameFromAgraphRoot(String filename) throws FileNotFoundException, IOException {
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String res = br.readLine();
        br.close();
        return res;
    }

    public static void DumpFile(String filename) throws FileNotFoundException, IOException {
        String line;
        System.out.println("Dump of " + filename);
        System.out.println("--------------------------------------------------------------");
        BufferedReader br = new BufferedReader(new FileReader(filename));
        while ((line = br.readLine()) != null) {
            System.out.println(line);
        }
        br.close();
        System.out.println("--------------------------------------------------------------");
    }

    public static void DumpAgraphLog() throws FileNotFoundException, IOException {
        String AgraphRootFilename = "../agraph/lisp/agraph.root";
        File AgraphRootFile = new File(AgraphRootFilename);
        if (AgraphRootFile.exists()) {
            String AgraphCfgFilename = Util.GetAgraphCfgFilenameFromAgraphRoot(AgraphRootFilename);
            String LogDir = Util.GetLogDirFromAgraphCFG(AgraphCfgFilename);
            Util.DumpFile(LogDir + "/agraph.log");
        }
    }

    public static int getLogSize(AGServer server) {
        return server.getLogFile().length();
    }

    public static LogSearchResult searchLog(AGServer server, String text, int after) {
        String logs = server.getLogFile();
        int index = logs.lastIndexOf(text);
        if (index == -1) {
            return LogSearchResult.NOT_FOUND;
        }
        if (index < after) {
            return LogSearchResult.TOO_OLD;
        }
        return LogSearchResult.FOUND;
    }

    private static boolean isWarmupLogged(AGServer server) {
        AGServerVersion minVersion = new AGServerVersion("v6.3.0");
        return server.getComparableVersion().compareTo(minVersion) >= 0;
    }

    public static LogSearchResult searchLogForStringsWarmup(AGServer server, int after, String repo) {
        String strings = String.format("%s\", Warmup of strings", repo);
        return Util.searchLog(server, strings, after);
    }

    public static LogSearchResult searchLogForTriplesWarmup(AGServer server, int after, String repo) {
        String strings = String.format("%s\", Warmup of triples", repo);
        return Util.searchLog(server, strings, after);
    }

    public static void assertStringsWarmedUpRecently(AGServer server, int after, String repo) {
        if (Util.isWarmupLogged(server)) {
            switch (Util.searchLogForStringsWarmup(server, after, repo)) {
                case NOT_FOUND: {
                    Assert.fail((String)"Warmup message not found in logs");
                }
                case TOO_OLD: {
                    Assert.fail((String)"Last occurrence of the warmup message is too old.");
                }
            }
        }
    }

    public static void assertTriplesWarmedUpRecently(AGServer server, int after, String repo) {
        if (Util.isWarmupLogged(server)) {
            switch (Util.searchLogForTriplesWarmup(server, after, repo)) {
                case NOT_FOUND: {
                    Assert.fail((String)"Warmup message not found in logs");
                }
                case TOO_OLD: {
                    Assert.fail((String)"Last occurrence of the warmup message is too old.");
                }
            }
        }
    }

    public static void assertStringsNotWarmedUpRecently(AGServer server, int after, String repo) {
        if (Util.isWarmupLogged(server)) {
            Assert.assertNotEquals((String)"The string table has been warmed up recently", (Object)((Object)LogSearchResult.FOUND), (Object)((Object)Util.searchLogForStringsWarmup(server, after, repo)));
        }
    }

    public static void assertTriplesNotWarmedUpRecently(AGServer server, int after, String repo) {
        if (Util.isWarmupLogged(server)) {
            Assert.assertNotEquals((String)"Triple indices have been warmed up recently", (Object)((Object)LogSearchResult.FOUND), (Object)((Object)Util.searchLogForTriplesWarmup(server, after, repo)));
        }
    }

    public static enum LogSearchResult {
        FOUND,
        NOT_FOUND,
        TOO_OLD;

    }

    public static class RandomLong
    extends Random {
        private static final long serialVersionUID = 4874437974204550876L;

        @Override
        public long nextLong(long max) {
            if (max <= 0L) {
                throw new IllegalArgumentException("max must be positive");
            }
            if (max <= Integer.MAX_VALUE) {
                return this.nextInt((int)max);
            }
            int x = (int)(max >> 31);
            if (x == 0) {
                return this.nextInt();
            }
            return ((long)this.nextInt((int)(max >> 31)) << 32) + (long)this.nextInt();
        }
    }
}

