/*
 * Decompiled with CFR 0.152.
 */
package test.pool;

import com.franz.agraph.pool.AGConnPool;
import com.franz.agraph.pool.AGConnProp;
import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.util.Closer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class AGConnPoolSessionTest
extends Closer {
    private static final String ns = "http://example.com/#";
    private final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    @After
    public void closeAfter() {
        this.close();
    }

    private void assertSuccess(List<Future<Boolean>> errors, long timeout, TimeUnit unit) throws Exception {
        boolean fail = false;
        for (Future<Boolean> f : errors) {
            Boolean e = f.get(timeout, unit);
            if (e.booleanValue()) continue;
            fail = true;
        }
        if (fail) {
            throw new RuntimeException("See log for details.");
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testPlain() throws Exception {
        AGServer server = (AGServer)this.closeLater((AutoCloseable)new AGServer(AGAbstractTest.findServerUrl(), AGAbstractTest.username(), AGAbstractTest.password()));
        AGCatalog catalog = server.getCatalog("java-catalog");
        AGRepository repo = (AGRepository)this.closeLater((AutoCloseable)catalog.createRepository("pool.testPlain"));
        AGRepositoryConnection conn = (AGRepositoryConnection)this.closeLater((AutoCloseable)repo.getConnection());
        Assert.assertTrue((String)conn.toString(), (boolean)conn.prepareHttpRepoClient().getRoot().contains(AGAbstractTest.findServerUrl()));
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        conn.deleteDatatypeMapping(XMLSchema.DOUBLE);
        conn.setSessionLifetime(60);
        conn.setAutoCommit(true);
        conn.deleteDatatypeMapping(XMLSchema.FLOAT);
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testPoolDedicated() throws Exception {
        String oldOverride = System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", "true");
        AGConnPool pool = (AGConnPool)this.closeLater((AutoCloseable)AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, "pool.testPoolDedicated", AGConnProp.session, AGConnProp.Session.DEDICATED, AGConnProp.sessionLifetime, TimeUnit.MINUTES.toSeconds(1L), AGPoolProp.shutdownHook, true, AGPoolProp.testOnBorrow, true, AGPoolProp.maxWait, TimeUnit.SECONDS.toMillis(30L)}));
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        AGCatalog catalog = server.getCatalog("java-catalog");
        AGRepository repo = (AGRepository)this.closeLater((AutoCloseable)catalog.createRepository("pool.testPoolDedicated"));
        repo.setConnPool(pool);
        AGRepositoryConnection conn = (AGRepositoryConnection)this.closeLater((AutoCloseable)repo.getConnection());
        Assert.assertFalse((String)conn.toString(), (boolean)conn.prepareHttpRepoClient().getRoot().contains(AGAbstractTest.findServerUrl()));
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        conn.deleteDatatypeMapping(XMLSchema.DOUBLE);
        conn.deleteDatatypeMapping(XMLSchema.FLOAT);
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        if (oldOverride != null) {
            System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", oldOverride);
        } else {
            System.clearProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions");
        }
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testPoolTx() throws Exception {
        String oldOverride = System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", "true");
        AGConnPool pool = (AGConnPool)this.closeLater((AutoCloseable)AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, "pool.testPoolTx", AGConnProp.session, AGConnProp.Session.TX, AGConnProp.sessionLifetime, TimeUnit.MINUTES.toSeconds(1L), AGPoolProp.testOnBorrow, true, AGPoolProp.maxWait, TimeUnit.SECONDS.toMillis(30L)}));
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        AGCatalog catalog = server.getCatalog("java-catalog");
        AGRepository repo = (AGRepository)this.closeLater((AutoCloseable)catalog.createRepository("pool.testPoolTx"));
        repo.setConnPool(pool);
        AGRepositoryConnection conn = (AGRepositoryConnection)this.closeLater((AutoCloseable)repo.getConnection());
        Assert.assertFalse((String)conn.toString(), (boolean)conn.prepareHttpRepoClient().getRoot().contains(AGAbstractTest.findServerUrl()));
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        conn.deleteDatatypeMapping(XMLSchema.DOUBLE);
        conn.deleteDatatypeMapping(XMLSchema.FLOAT);
        Assert.assertEquals((long)0L, (long)conn.size(new Resource[0]));
        if (oldOverride != null) {
            System.setProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", oldOverride);
        } else {
            System.clearProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions");
        }
    }

    @Test
    @Category(value={TestSuites.Stress.class})
    public void deleteDatatypeMapping() throws Exception {
        int NUM = 20;
        boolean MINUTES = true;
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        AGCatalog catalog = server.getCatalog("java-catalog");
        final AGRepository repo = (AGRepository)this.closeLater((AutoCloseable)catalog.createRepository("pool.deleteDatatypeMapping"));
        AGRepositoryConnection conn = (AGRepositoryConnection)this.closeLater((AutoCloseable)repo.getConnection());
        Assert.assertTrue((String)conn.toString(), (boolean)conn.prepareHttpRepoClient().getRoot().contains(AGAbstractTest.findServerUrl()));
        AGValueFactory vf = conn.getValueFactory();
        for (int i = 0; i < 200; ++i) {
            Util.add((RepositoryConnection)conn, "/tutorial/java-kennedy.ntriples", ns, RDFFormat.NTRIPLES, new Resource[]{vf.createIRI(ns + i)});
        }
        this.log.debug("size=" + conn.size(new Resource[0]));
        this.close((AutoCloseable)conn);
        ExecutorService exec = Executors.newFixedThreadPool(20);
        final ArrayList errors = new ArrayList();
        final AtomicLong count = new AtomicLong(0L);
        for (int i = 0; i < 20; ++i) {
            exec.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        long now;
                        long start = System.nanoTime();
                        while ((now = System.nanoTime()) - start <= TimeUnit.MINUTES.toNanos(0L)) {
                            try (AGRepositoryConnection conn = repo.getConnection();){
                                conn.deleteDatatypeMapping(XMLSchema.DOUBLE);
                                count.incrementAndGet();
                                conn.deleteDatatypeMapping(XMLSchema.FLOAT);
                                count.incrementAndGet();
                            }
                        }
                    }
                    catch (Throwable e) {
                        errors.add(e);
                    }
                }
            });
        }
        exec.awaitTermination(1L, TimeUnit.MINUTES);
        this.log.debug("count=" + count);
        if (!errors.isEmpty()) {
            for (Throwable e : errors) {
                this.log.error("error", e);
            }
            Assert.fail((String)("see log for details: " + ((Object)errors).toString()));
        }
    }

    @Test
    @Category(value={TestSuites.Broken.class})
    public void maxActive() throws Exception {
        int seconds = 5;
        int clients = 4;
        int wait = 40;
        AGConnPool pool = (AGConnPool)this.closeLater((AutoCloseable)AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, "pool.maxActive", AGConnProp.session, AGConnProp.Session.DEDICATED, AGConnProp.sessionLifetime, 40, AGConnProp.httpSocketTimeout, TimeUnit.SECONDS.toMillis(40L), AGPoolProp.shutdownHook, true, AGPoolProp.testOnBorrow, true, AGPoolProp.maxActive, 2, AGPoolProp.maxWait, TimeUnit.SECONDS.toMillis(40L), AGPoolProp.maxIdle, 8}));
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        AGCatalog catalog = server.getCatalog("java-catalog");
        final AGRepository repo = (AGRepository)this.closeLater((AutoCloseable)catalog.createRepository("pool.maxActive"));
        repo.setConnPool(pool);
        ExecutorService exec = Executors.newFixedThreadPool(4);
        ArrayList<Future<Boolean>> errors = new ArrayList<Future<Boolean>>(4);
        final AtomicLong idx = new AtomicLong(0L);
        for (int i = 0; i < 4; ++i) {
            errors.add(exec.submit(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    try {
                        long id = idx.incrementAndGet();
                        AGConnPoolSessionTest.this.log.debug(id + " start");
                        AGRepositoryConnection conn = repo.getConnection();
                        try {
                            AGConnPoolSessionTest.this.log.debug(id + " open");
                            conn.size(new Resource[0]);
                            Thread.sleep(TimeUnit.SECONDS.toMillis(5L));
                            conn.size(new Resource[0]);
                        }
                        finally {
                            conn.close();
                            AGConnPoolSessionTest.this.log.debug(id + " close");
                        }
                        return true;
                    }
                    catch (Throwable e) {
                        AGConnPoolSessionTest.this.log.error("error " + this, e);
                        return false;
                    }
                }
            }));
        }
        this.assertSuccess(errors, 40L, TimeUnit.SECONDS);
    }

    @Test
    @Category(value={TestSuites.Stress.class})
    public void fast() throws Exception {
        int seconds = 35;
        int clients = 8;
        int wait = 560;
        AGAbstractTest.deleteRepository("java-catalog", "pool.fast");
        AGConnPool pool = (AGConnPool)this.closeLater((AutoCloseable)AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "/", AGConnProp.repository, "pool.fast", AGConnProp.session, AGConnProp.Session.DEDICATED, AGConnProp.sessionLifetime, 560, AGConnProp.httpSocketTimeout, TimeUnit.SECONDS.toMillis(560L), AGPoolProp.shutdownHook, true, AGPoolProp.testOnBorrow, true, AGPoolProp.maxActive, 2, AGPoolProp.maxWait, TimeUnit.SECONDS.toMillis(560L), AGPoolProp.maxIdle, 8}));
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        AGCatalog catalog = server.getCatalog("java-catalog");
        final AGRepository repo = (AGRepository)this.closeLater((AutoCloseable)catalog.createRepository("pool.fast"));
        repo.setConnPool(pool);
        final AtomicLong idx = new AtomicLong(0L);
        final AtomicLong count = new AtomicLong(0L);
        ExecutorService exec = Executors.newFixedThreadPool(8);
        ArrayList<Future<Boolean>> errors = new ArrayList<Future<Boolean>>(8);
        for (int i = 0; i < 8; ++i) {
            errors.add(exec.submit(new Callable<Boolean>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Boolean call() throws Exception {
                    try {
                        long id = idx.incrementAndGet();
                        int myCount = 0;
                        AGConnPoolSessionTest.this.log.debug(id + " start");
                        long duration = TimeUnit.SECONDS.toNanos(35L);
                        long start = System.nanoTime();
                        while (System.nanoTime() - start < duration) {
                            try (AGRepositoryConnection conn = repo.getConnection();){
                                ++myCount;
                                count.incrementAndGet();
                                conn.size(new Resource[0]);
                            }
                        }
                        AGConnPoolSessionTest.this.log.debug(id + " finished " + myCount);
                        return true;
                    }
                    catch (Throwable e) {
                        AGConnPoolSessionTest.this.log.error("error " + this, e);
                        return false;
                    }
                }
            }));
        }
        this.assertSuccess(errors, 560L, TimeUnit.SECONDS);
        this.log.info("count=" + count);
    }

    @Test
    @Category(value={TestSuites.NonPrepushTest.class})
    public void connectionTimeTest() throws Exception {
        System.out.println("Testing AGConnProp.Session.SHARED");
        this.doTestConnection(AGConnProp.Session.SHARED, true, 1000);
        this.doTestConnection(AGConnProp.Session.SHARED, false, 1000);
        System.out.println();
        System.out.println("Testing AGConnProp.Session.TX");
        this.doTestConnection(AGConnProp.Session.TX, true, 1000);
        this.doTestConnection(AGConnProp.Session.TX, false, 1000);
        System.out.println();
        System.out.println("Testing AGConnProp.Session.DEDICATED");
        this.doTestConnection(AGConnProp.Session.DEDICATED, true, 1000);
        this.doTestConnection(AGConnProp.Session.DEDICATED, false, 1000);
    }

    private void doTestConnection(AGConnProp.Session style, boolean usePooling, int iterations) throws Exception {
        AGServer server = (AGServer)this.closeLater((AutoCloseable)AGAbstractTest.newAGServer());
        AGCatalog catalog = server.getCatalog("java-catalog");
        AGRepository repository = catalog.createRepository("spr43583");
        AGConnPool pool = null;
        if (usePooling) {
            pool = AGConnPool.create((Object[])new Object[]{AGConnProp.serverUrl, server.getServerURL(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, catalog.getCatalogName(), AGConnProp.repository, repository.getRepositoryID(), AGConnProp.session, style});
            repository.setConnPool(pool);
        }
        Instant start = Instant.now();
        for (int i = 0; i < iterations; ++i) {
            AGRepositoryConnection connection = repository.getConnection();
            if (connection == null) {
                Assert.fail((String)"Connection is null");
            }
            if (!(usePooling || style != AGConnProp.Session.TX && style != AGConnProp.Session.DEDICATED)) {
                connection.setAutoCommit(style == AGConnProp.Session.DEDICATED);
            }
            connection.close();
        }
        System.out.println("TIMER: usePooling=" + usePooling + ". It took " + Duration.between(start, Instant.now()) + " to make " + iterations + " iterations of " + "get-close connection.");
        if (pool != null) {
            pool.close();
        }
        repository.close();
        server.close();
    }
}

