/*
 * Decompiled with CFR 0.152.
 */
package test.pool;

import com.franz.agraph.pool.AGConnPool;
import com.franz.agraph.pool.AGConnProp;
import com.franz.agraph.pool.AGPoolProp;
import com.franz.agraph.repository.AGServer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import test.AGAbstractTest;
import test.TestSuites;
import test.Util;

public class AGConnPoolWarmupTest {
    private static final String STORE = "pool.testPoolWarmup";
    private AGServer server;
    private int logLengthBeforeTest;

    @Before
    public void setUp() {
        this.server = AGAbstractTest.newAGServer();
        this.logLengthBeforeTest = Util.getLogSize(this.server);
    }

    @AfterClass
    public static void tearDownClass() {
        AGAbstractTest.deleteRepository("java-catalog", STORE);
    }

    private AGConnPool makePool(Boolean warmupStrings, Boolean warmupTriples) {
        ArrayList<Serializable> args = new ArrayList<Serializable>(Arrays.asList(AGConnProp.serverUrl, AGAbstractTest.findServerUrl(), AGConnProp.username, AGAbstractTest.username(), AGConnProp.password, AGAbstractTest.password(), AGConnProp.catalog, "java-catalog", AGConnProp.repository, STORE, AGPoolProp.warmup, true));
        if (warmupStrings != null) {
            args.add((Serializable)AGPoolProp.warmupIncludeStrings);
            args.add(warmupStrings);
        }
        if (warmupTriples != null) {
            args.add((Serializable)AGPoolProp.warmupIncludeTriples);
            args.add(warmupTriples);
        }
        return AGConnPool.create((Object[])args.toArray());
    }

    private void assertTriplesWarmedUpRecently() {
        Util.assertTriplesWarmedUpRecently(this.server, this.logLengthBeforeTest, STORE);
    }

    private void assertStringsWarmedUpRecently() {
        Util.assertStringsWarmedUpRecently(this.server, this.logLengthBeforeTest, STORE);
    }

    private void assertTriplesNotWarmedUpRecently() {
        Util.assertTriplesNotWarmedUpRecently(this.server, this.logLengthBeforeTest, STORE);
    }

    private void assertStringsNotWarmedUpRecently() {
        Util.assertStringsNotWarmedUpRecently(this.server, this.logLengthBeforeTest, STORE);
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testDefaultWarmup() {
        this.makePool(null, null).close();
        this.assertStringsWarmedUpRecently();
        this.assertTriplesWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testWarmupNoStrings() {
        this.makePool(false, null).close();
        this.assertStringsNotWarmedUpRecently();
        this.assertTriplesWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testWarmupNoTriples() {
        this.makePool(null, false).close();
        this.assertStringsWarmedUpRecently();
        this.assertTriplesNotWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testWarmupAllExplicit() {
        this.makePool(true, true).close();
        this.assertStringsWarmedUpRecently();
        this.assertTriplesWarmedUpRecently();
    }

    @Test
    @Category(value={TestSuites.Prepush.class})
    public void testWarmupNothing() {
        this.makePool(false, false).close();
        this.assertStringsNotWarmedUpRecently();
        this.assertTriplesNotWarmedUpRecently();
    }
}

