/*
 * Decompiled with CFR 0.152.
 */
package test.stress;

import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGStreamTupleQuery;
import com.franz.agraph.repository.AGTupleQuery;
import com.franz.agraph.repository.AGValueFactory;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.junit.Before;
import org.junit.Test;
import test.AGAbstractTest;
import test.Util;
import test.stress.Events;

public class StreamingTest
extends AGAbstractTest {
    static final MemoryMXBean mem = ManagementFactory.getMemoryMXBean();
    private static final int SIZE = 300000;
    protected AGCatalog cat;
    protected AGRepository repo;
    protected AGRepositoryConnection conn;
    protected AGValueFactory vf;
    protected long repoSize = 0L;
    private String limit = null;
    private long minSeconds = 20L;

    @Before
    public void openLargeRepo() throws Exception {
        AGCatalog cat = server.getCatalog(Events.Defaults.CATALOG);
        if (cat.hasRepository(Events.Defaults.REPOSITORY)) {
            this.repo = this.closeLater(cat.openRepository(Events.Defaults.REPOSITORY));
            this.repo.initialize();
            this.conn = this.closeLater(this.repo.getConnection());
            this.repoSize = this.conn.size(new Resource[0]);
            if (this.repoSize < 300000L) {
                this.log.info("size of " + this.repo.getCatalogPrefixedRepositoryID() + " = " + this.repoSize);
                this.closer.close((AutoCloseable)this.conn);
                this.closer.close((AutoCloseable)this.repo);
                cat = null;
            } else {
                this.vf = this.repo.getValueFactory();
                this.conn.setAutoCommit(false);
            }
        }
        if (this.repo == null) {
            cat = server.getCatalog("java-catalog");
            this.repo = this.closeLater(cat.createRepository("big-java-test"));
            this.repo.initialize();
            this.vf = this.repo.getValueFactory();
            this.conn = this.closeLater(this.repo.getConnection());
            this.conn.setAutoCommit(false);
            IRI subj = this.vf.createIRI("http://example.org/subj");
            IRI pred = this.vf.createIRI("http://example.org/pred");
            long size = this.conn.size(new Resource[0]);
            while (size < 300000L) {
                Literal obj = this.vf.createLiteral(size);
                this.conn.add((Resource)subj, pred, (Value)obj, new Resource[0]);
                if (++size % (long)Math.round(3000.0f) != 0L) continue;
                this.conn.commit();
                this.log.info("commit, size: " + this.conn.size(new Resource[0]));
            }
            this.conn.commit();
        }
        this.repoSize = this.conn.size(new Resource[0]);
        this.log.info("size of " + this.repo.getCatalogPrefixedRepositoryID() + " = " + this.repoSize);
        System.gc();
        Thread.yield();
    }

    public Stats measurePerf1(STREAM stream) throws Exception {
        Stats stats;
        block17: {
            AGTupleQuery qu = this.conn.prepareTupleQuery(QueryLanguage.SPARQL, "SELECT ?s ?p ?o WHERE {?s ?p ?o . }" + this.limit);
            if (stream == STREAM.PULL || stream == STREAM.PULH) {
                qu = new AGStreamTupleQuery(qu);
            }
            stats = new Stats();
            stats.memUsed = this.memUsed(mem);
            stats.nano = System.nanoTime();
            try {
                if (stream == STREAM.HAND || stream == STREAM.PULH) {
                    qu.evaluate(new TupleQueryResultHandler(){

                        public void startQueryResult(List<String> bindingNames) throws TupleQueryResultHandlerException {
                            StreamingTest.this.log.debug("bindings: " + bindingNames);
                        }

                        public void handleSolution(BindingSet bindingSet) throws TupleQueryResultHandlerException {
                            ++stats.count;
                            if (stats.count % 100L == 0L) {
                                stats.memUsed = Math.max(stats.memUsed, StreamingTest.this.memUsed(mem));
                            }
                        }

                        public void endQueryResult() throws TupleQueryResultHandlerException {
                        }

                        public void handleBoolean(boolean arg0) throws QueryResultHandlerException {
                        }

                        public void handleLinks(List<String> arg0) throws QueryResultHandlerException {
                        }
                    });
                    break block17;
                }
                try (TupleQueryResult results = qu.evaluate();){
                    this.log.debug("bindings: " + results.getBindingNames());
                    while (results.hasNext()) {
                        results.next();
                        ++stats.count;
                        if (stats.count % 100L != 0L) continue;
                        stats.memUsed = Math.max(stats.memUsed, this.memUsed(mem));
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("count=" + stats.count, e);
            }
        }
        stats.nano = System.nanoTime() - stats.nano;
        stats.memUsed = Math.max(stats.memUsed, this.memUsed(mem));
        return stats;
    }

    public Stats measurePerf(STREAM stream) throws Exception {
        System.gc();
        long maxNano = this.minSeconds * 1000L * 1000L * 1000L;
        Stats stats = new Stats();
        try {
            do {
                Stats tmp = this.measurePerf1(stream);
                stats.add(tmp);
            } while (stats.nano < maxNano);
        }
        catch (Error e) {
            throw new Error((Object)((Object)stream) + "\t" + stats, e);
        }
        catch (Throwable e) {
            throw new RuntimeException((Object)((Object)stream) + "\t" + stats, e);
        }
        this.log.info((Object)((Object)stream) + "\t" + stats);
        return stats;
    }

    private long memUsed(MemoryMXBean mem) {
        MemoryUsage heap = mem.getHeapMemoryUsage();
        return heap.getUsed();
    }

    @Test
    public void n10() throws Exception {
        this.minSeconds = 30L;
        this.limit = " limit 10";
        this.measurePerf(STREAM.NONE);
        this.measurePerf(STREAM.HAND);
        this.measurePerf(STREAM.PULL);
        this.measurePerf(STREAM.PULH);
    }

    @Test
    public void n500() throws Exception {
        this.minSeconds = 60L;
        this.limit = " limit 500";
        this.measurePerf(STREAM.NONE);
        this.measurePerf(STREAM.HAND);
        this.measurePerf(STREAM.PULL);
        this.measurePerf(STREAM.PULH);
    }

    @Test
    public void n100000() throws Exception {
        this.minSeconds = 300L;
        this.limit = " limit 100000";
        this.measurePerf(STREAM.NONE);
        this.measurePerf(STREAM.HAND);
        this.measurePerf(STREAM.PULL);
        this.measurePerf(STREAM.PULH);
    }

    @Test
    public void none() throws Exception {
        this.minSeconds = 300L;
        this.limit = " limit 1000000";
        this.measurePerf(STREAM.NONE);
    }

    @Test
    public void pull() throws Exception {
        this.minSeconds = 300L;
        this.limit = " limit 1000000";
        this.measurePerf(STREAM.PULL);
    }

    @Test
    public void hand() throws Exception {
        this.minSeconds = 300L;
        this.limit = " limit 1000000";
        this.measurePerf(STREAM.HAND);
    }

    @Test
    public void pulh() throws Exception {
        this.minSeconds = 300L;
        this.limit = " limit 1000000";
        this.measurePerf(STREAM.PULH);
    }

    @Test
    public void concurrentNone() throws Exception {
        this.concurrent(STREAM.NONE, STREAM.HAND);
    }

    @Test
    public void concurrentPull() throws Exception {
        this.concurrent(STREAM.PULL, STREAM.PULH);
    }

    public void concurrent(STREAM ... sts) throws Exception {
        this.minSeconds = 300L;
        this.limit = " limit 15000";
        int proc = Runtime.getRuntime().availableProcessors();
        ExecutorService exec = Executors.newFixedThreadPool(proc);
        LinkedList<2> tasks = new LinkedList<2>();
        for (int i = 0; i < proc / sts.length; ++i) {
            for (int j = 0; j < sts.length; ++j) {
                final STREAM st = sts[j];
                tasks.add(new Callable<Stats>(){

                    @Override
                    public Stats call() throws Exception {
                        return StreamingTest.this.measurePerf(st);
                    }
                });
            }
        }
        Stats stats = new Stats();
        List futures = exec.invokeAll(tasks);
        for (Future future : futures) {
            stats.add((Stats)future.get());
        }
        this.log.info("concurrent " + Arrays.asList(sts) + "\t" + stats);
    }

    static class Stats {
        long count = 0L;
        long memUsed = 0L;
        long nano = 0L;
        long iterations = 0L;

        Stats() {
        }

        public String toString() {
            return "Count=" + Util.toHumanInt(this.count, 10) + "\tMaxMemUsed=" + Util.toHumanInt(this.memUsed, 2) + "\tTime=" + Util.toHumanInt(this.nano / 1000000L, 60) + "\tIterations=" + this.iterations;
        }

        public void add(Stats tmp) {
            this.count += tmp.count;
            this.memUsed = Math.max(this.memUsed, tmp.memUsed);
            this.nano += tmp.nano;
            ++this.iterations;
        }
    }

    public static enum STREAM {
        NONE,
        PULL,
        HAND,
        PULH;

    }
}

