/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.exception.AGCustomStoredProcException;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGJSONArrayHandler;
import com.franz.agraph.http.handler.AGJSONHandler;
import com.franz.agraph.http.handler.AGLongHandler;
import com.franz.agraph.http.handler.AGRDFHandler;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGStringHandler;
import com.franz.agraph.http.handler.AGTQRHandler;
import com.franz.agraph.http.storedproc.AGDeserializer;
import com.franz.agraph.http.storedproc.AGSerializer;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGMaterializer;
import com.franz.agraph.repository.AGQuery;
import com.franz.agraph.repository.AGServerVersion;
import com.franz.agraph.repository.AGSpinFunction;
import com.franz.agraph.repository.AGSpinMagicProperty;
import com.franz.agraph.repository.AGUpdate;
import com.franz.agraph.repository.AGValueFactory;
import com.franz.agraph.repository.AGXid;
import com.franz.agraph.repository.WarmupConfig;
import com.franz.agraph.repository.repl.DurabilityLevel;
import com.franz.agraph.repository.repl.DurabilityVisitor;
import com.franz.agraph.repository.repl.TransactionSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.http.protocol.Protocol;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.TupleQueryResultHandler;
import org.eclipse.rdf4j.query.TupleQueryResultHandlerException;
import org.eclipse.rdf4j.query.impl.TupleQueryResultBuilder;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.ntriples.NTriplesUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGHttpRepoClient
implements AutoCloseable {
    private static final DurabilityVisitor<String> durabilityToString = new DurabilityVisitor<String>(){

        @Override
        public String visitInteger(int numberOfInstances) {
            return "durability=" + Integer.toString(numberOfInstances);
        }

        @Override
        public String visitDurabilityLevel(DurabilityLevel level) {
            switch (level) {
                case MIN: {
                    return "durability=min";
                }
                case MAX: {
                    return "durability=max";
                }
                case QUORUM: {
                    return "durability=quorum";
                }
                case DEFAULT: {
                    return "";
                }
            }
            assert (false) : "Unsupported symbolic durability level.";
            return "";
        }
    };
    private static int defaultSessionLifetimeInSeconds = 3600;
    private static NameValuePair[] emptyParams = new NameValuePair[0];
    private static AGServerVersion supportedTSVTQRVersion = new AGServerVersion("6.4.2");
    final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ScheduledExecutorService executor;
    public ConcurrentLinkedQueue<String> savedQueryDeleteQueue;
    private int lifetimeInSeconds = defaultSessionLifetimeInSeconds;
    private boolean usingDedicatedSession = false;
    private boolean autoCommit = true;
    private int uploadCommitPeriod = 0;
    private String sessionRoot;
    private String repoRoot;
    private boolean loadInitFile = false;
    private List<String> scripts = null;
    private TupleQueryResultFormat preferredTQRFormat;
    private BooleanQueryResultFormat preferredBQRFormat = BooleanQueryResultFormat.TEXT;
    private RDFFormat preferredRDFFormat = this.getDefaultRDFFormat();
    private AGHTTPClient client;
    private AGAbstractRepository repo;
    private boolean allowExternalBlankNodeIds = false;
    private ScheduledFuture<?> pinger;
    private String userAttributes;
    private TransactionSettings transactionSettings;
    private boolean sendRollbackHeader = false;
    private Boolean hasWarmupBug = null;

    public AGHttpRepoClient(AGAbstractRepository repo, AGHTTPClient client, String repoRoot, String sessionRoot, ScheduledExecutorService executor) {
        this.repo = repo;
        this.sessionRoot = sessionRoot;
        this.repoRoot = repoRoot;
        this.client = client;
        this.executor = executor;
        this.savedQueryDeleteQueue = new ConcurrentLinkedQueue();
    }

    public AGHttpRepoClient(AGAbstractRepository repo, AGHTTPClient client, String repoRoot, String sessionRoot) {
        this(repo, client, repoRoot, sessionRoot, repo.getCatalog().getServer().getExecutor());
    }

    public static long getDefaultSessionLifetime() {
        return defaultSessionLifetimeInSeconds;
    }

    public static void setDefaultSessionLifetime(int lifetimeInSeconds) {
        defaultSessionLifetimeInSeconds = lifetimeInSeconds;
    }

    public static Value getStorableValue(Value v, AGValueFactory vf, boolean allowExternalBlankNodeIds) {
        Value storable = v;
        if (v instanceof BNode && !vf.isAGBlankNodeId(v.stringValue())) {
            if (allowExternalBlankNodeIds) {
                storable = vf.createIRI(vf.PREFIX_FOR_EXTERNAL_BNODES + v.stringValue());
            } else {
                throw new IllegalArgumentException("Cannot store external blank node " + v + " in AllegroGraph with the current settings. Please see javadoc for AGHttpRepoClient#setAllowExternalBlankNodeIds(boolean) for more details and options.");
            }
        }
        return storable;
    }

    public static Resource getApplicationResource(Resource stored, AGValueFactory vf) {
        Resource app = stored;
        if (stored instanceof IRI && vf.isURIForExternalBlankNode((Value)stored)) {
            app = vf.createBNode(stored.stringValue().substring(vf.PREFIX_FOR_EXTERNAL_BNODES.length()));
        }
        return app;
    }

    public static Value getApplicationValue(Value stored, AGValueFactory vf) {
        Value app = stored;
        if (stored instanceof IRI && vf.isURIForExternalBlankNode(stored)) {
            app = vf.createBNode(stored.stringValue().substring(vf.PREFIX_FOR_EXTERNAL_BNODES.length()));
        }
        return app;
    }

    public String toString() {
        return "{" + super.toString() + " " + this.client + " rr=" + this.repoRoot + " sr=" + this.sessionRoot + "}";
    }

    public String getRoot() throws AGHttpException {
        if (this.sessionRoot != null) {
            return this.sessionRoot;
        }
        if (this.repoRoot != null) {
            return this.repoRoot;
        }
        throw new AGHttpException("This session-only connection has been closed. Re-open a new one to start using it again.");
    }

    public boolean usingMainPortForSessions() {
        boolean b = Boolean.parseBoolean(System.getProperty("com.franz.agraph.http.useMainPortForSessions", "false"));
        this.logger.debug("com.franz.agraph.http.useMainPortForSessions=" + b);
        return b;
    }

    private boolean overrideServerUseMainPortForSessions() {
        boolean b = Boolean.parseBoolean(System.getProperty("com.franz.agraph.http.overrideServerUseMainPortForSessions", "false"));
        this.logger.debug("com.franz.agraph.http.overrideServerUseMainPortForSessions=" + b);
        return b;
    }

    public AGValueFactory getValueFactory() {
        return this.repo.getValueFactory();
    }

    public int getSessionLifetime() {
        return this.lifetimeInSeconds;
    }

    public void setSessionLifetime(int lifetimeInSeconds) {
        this.lifetimeInSeconds = lifetimeInSeconds;
    }

    public boolean getSessionLoadInitFile() {
        return this.loadInitFile;
    }

    public void setSessionLoadInitFile(boolean loadInitFile) {
        this.loadInitFile = loadInitFile;
    }

    public void addSessionLoadScript(String scriptName) {
        if (this.scripts == null) {
            this.scripts = new ArrayList<String>();
        }
        this.scripts.add(scriptName);
    }

    public TupleQueryResultFormat getPreferredTQRFormat() {
        if (this.preferredTQRFormat == null) {
            this.preferredTQRFormat = this.repo.getServer().getComparableVersion().compareTo(supportedTSVTQRVersion) >= 0 ? TupleQueryResultFormat.TSV : TupleQueryResultFormat.SPARQL;
        }
        return this.preferredTQRFormat;
    }

    public void setPreferredTQRFormat(TupleQueryResultFormat preferredTQRFormat) {
        this.preferredTQRFormat = preferredTQRFormat;
    }

    public BooleanQueryResultFormat getPreferredBQRFormat() {
        return this.preferredBQRFormat;
    }

    public void setPreferredBQRFormat(BooleanQueryResultFormat preferredBQRFormat) {
        this.preferredBQRFormat = preferredBQRFormat;
    }

    public RDFFormat getDefaultRDFFormat() {
        RDFFormat format = System.getProperty("com.franz.agraph.http.defaultRDFFormat", "TRIX").equalsIgnoreCase("NQUADS") ? RDFFormat.NQUADS : RDFFormat.TRIX;
        this.logger.debug("Defaulting to " + format.getDefaultMIMEType() + " for requests that return RDF statements.");
        return format;
    }

    public RDFFormat getPreferredRDFFormat() {
        return this.preferredRDFFormat;
    }

    public void setPreferredRDFFormat(RDFFormat preferredRDFFormat) {
        this.logger.debug("Defaulting to " + preferredRDFFormat.getDefaultMIMEType() + " for requests that return RDF statements.");
        this.preferredRDFFormat = preferredRDFFormat;
    }

    public String getServerURL() {
        return this.client.getServerURL();
    }

    public AGHTTPClient getHTTPClient() {
        return this.client;
    }

    private Header[] prepareHeaders(List<Header> headers) {
        if (headers == null) {
            headers = new ArrayList<Header>(0);
        }
        if (this.userAttributes != null) {
            headers.add(new Header("x-user-attributes", this.userAttributes));
        }
        if (this.sendRollbackHeader) {
            headers.add(new Header("x-rollback", "yes"));
        }
        this.addReplHeader(headers);
        return headers.toArray(new Header[headers.size()]);
    }

    private void addReplHeader(List<Header> headers) {
        Integer transactionLatencyTimeout;
        Integer transactionLatencyCount;
        if (this.transactionSettings == null) {
            return;
        }
        StringBuilder value = new StringBuilder();
        value.append(this.transactionSettings.visitDurability(durabilityToString));
        Integer distributedTransactionTimeout = this.transactionSettings.getDistributedTransactionTimeout();
        if (distributedTransactionTimeout != null) {
            if (value.length() > 0) {
                value.append(' ');
            }
            value.append("distributedTransactionTimeout=");
            value.append(distributedTransactionTimeout.toString());
        }
        if ((transactionLatencyCount = this.transactionSettings.getTransactionLatencyCount()) != null) {
            if (value.length() > 0) {
                value.append(' ');
            }
            value.append("transactionLatencyCount=");
            value.append(transactionLatencyCount.toString());
        }
        if ((transactionLatencyTimeout = this.transactionSettings.getTransactionLatencyTimeout()) != null) {
            if (value.length() > 0) {
                value.append(' ');
            }
            value.append("transactionLatencyTimeout=");
            value.append(transactionLatencyTimeout.toString());
        }
        if (value.length() > 0) {
            headers.add(new Header("x-repl-settings", value.toString()));
        }
    }

    private NameValuePair[] prepareParams(Collection<? extends NameValuePair> params) {
        if (params != null) {
            return params.toArray(new NameValuePair[params.size()]);
        }
        return emptyParams;
    }

    protected void get(String url, List<Header> headers, Collection<? extends NameValuePair> params, AGResponseHandler handler) throws AGHttpException {
        this.getHTTPClient().get(url, this.prepareHeaders(headers), this.prepareParams(params), handler);
    }

    protected void post(String url, List<Header> headers, Collection<? extends NameValuePair> params, RequestEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        this.getHTTPClient().post(url, this.prepareHeaders(headers), this.prepareParams(params), requestEntity, handler);
    }

    protected void put(String url, List<Header> headers, Collection<? extends NameValuePair> params, RequestEntity requestEntity, AGResponseHandler handler) throws AGHttpException {
        this.getHTTPClient().put(url, this.prepareHeaders(headers), this.prepareParams(params), requestEntity, handler);
    }

    protected void delete(String url, List<Header> headers, Collection<? extends NameValuePair> params, AGResponseHandler handler) throws AGHttpException {
        this.getHTTPClient().delete(url, this.prepareHeaders(headers), this.prepareParams(params), handler);
    }

    private void useDedicatedSession(boolean autoCommit) throws AGHttpException {
        if (this.sessionRoot == null) {
            String url = AGProtocol.getSessionURL(this.getRoot());
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(3);
            params.add(new NameValuePair("lifetime", Integer.toString(this.lifetimeInSeconds)));
            params.add(new NameValuePair("autoCommit", Boolean.toString(autoCommit)));
            params.add(new NameValuePair("loadInitFile", Boolean.toString(this.loadInitFile)));
            if (this.scripts != null) {
                for (String script : this.scripts) {
                    params.add(new NameValuePair("script", script));
                }
            }
            AGStringHandler handler = new AGStringHandler();
            this.post(url, null, params, null, handler);
            this.usingDedicatedSession = true;
            this.sessionRoot = this.adjustSessionUrlIfUsingMainPort(handler.getResult());
            this.startPinger();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("openSession: {}", (Object)this.sessionRoot);
            }
        }
    }

    private void startPinger() {
        assert (this.pinger == null);
        if (this.executor == null) {
            return;
        }
        long delay = this.getSessionLifetime() * 1000 / 2;
        long initialDelay = (long)(Math.random() * (double)delay);
        this.pinger = this.executor.scheduleWithFixedDelay(() -> {
            try {
                this.ping();
            }
            catch (AGHttpException e) {
                this.logger.debug("Pinger exception", (Throwable)((Object)e));
            }
        }, initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    private void stopPinger() {
        if (this.pinger != null) {
            this.pinger.cancel(false);
        }
    }

    private String adjustSessionUrlIfUsingMainPort(String dedicatedSessionUrl) throws AGHttpException {
        boolean usesMainPort = dedicatedSessionUrl.contains("/session/");
        if (this.usingMainPortForSessions() && !usesMainPort) {
            String tail = dedicatedSessionUrl.substring(dedicatedSessionUrl.lastIndexOf(58) + 1);
            String port = tail.substring(0, tail.indexOf(47));
            try {
                Integer.parseInt(port);
            }
            catch (NumberFormatException e) {
                throw new AGHttpException("problem finding port in session url: " + tail);
            }
            return this.repoRoot + "/session/" + tail;
        }
        if (!this.usingMainPortForSessions() && usesMainPort && this.overrideServerUseMainPortForSessions()) {
            int mainPortStart = dedicatedSessionUrl.lastIndexOf(":") + 1;
            int mainPortEnd = dedicatedSessionUrl.indexOf("/", mainPortStart);
            int sessionPortStart = dedicatedSessionUrl.indexOf("/session/") + 9;
            int sessionPortEnd = dedicatedSessionUrl.indexOf("/", sessionPortStart);
            return dedicatedSessionUrl.substring(0, mainPortStart) + dedicatedSessionUrl.substring(sessionPortStart, sessionPortEnd) + dedicatedSessionUrl.substring(sessionPortEnd);
        }
        return dedicatedSessionUrl;
    }

    private void closeSession() throws AGHttpException {
        if (this.sessionRoot != null && !this.getHTTPClient().isClosed()) {
            this.stopPinger();
            String url = AGProtocol.getSessionCloseLocation(this.sessionRoot);
            try {
                this.post(url, null, null, null, null);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("closeSession: {}", (Object)url);
                }
            }
            catch (AGHttpException aGHttpException) {
            }
            finally {
                this.sessionRoot = null;
            }
        }
    }

    public void getStatements(Resource subj, IRI pred, Value obj, String includeInferred, RDFHandler handler, Resource ... contexts) throws RDFHandlerException, AGHttpException {
        this.getStatements(subj, pred, obj, includeInferred, new AGRDFHandler(this.getPreferredRDFFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()), contexts);
    }

    public void getStatements(Resource subj, IRI pred, Value obj, String includeInferred, AGResponseHandler handler, Resource ... contexts) throws AGHttpException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType()));
        AGValueFactory vf = this.getValueFactory();
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            subj = this.getStorableResource(subj, vf);
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            obj = this.getStorableValue(obj, vf);
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (Resource ctx : contexts) {
            ctx = this.getStorableResource(ctx, vf);
            params.add(new NameValuePair("context", Protocol.encodeContext((Resource)ctx)));
        }
        params.add(new NameValuePair("infer", includeInferred));
        this.get(uri, headers, params, handler);
    }

    public void getStatements(RDFHandler handler, String ... ids) throws AGHttpException {
        this.getStatements(new AGRDFHandler(this.getPreferredRDFFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()), ids);
    }

    public void getStatements(AGResponseHandler handler, String ... ids) throws AGHttpException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot()) + "/id";
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        for (String id : ids) {
            params.add(new NameValuePair("id", id));
        }
        this.get(uri, headers, params, handler);
    }

    public void addStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws AGHttpException {
        String uri = Protocol.getStatementsLocation((String)this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Content-Type", RDFFormat.NTRIPLES.getDefaultMIMEType()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        this.post(uri, headers, params, null, null);
    }

    public void deleteStatements(Resource subj, IRI pred, Value obj, Resource ... contexts) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (subj != null) {
            params.add(new NameValuePair("subj", Protocol.encodeValue((Value)subj)));
        }
        if (pred != null) {
            params.add(new NameValuePair("pred", Protocol.encodeValue((Value)pred)));
        }
        if (obj != null) {
            params.add(new NameValuePair("obj", Protocol.encodeValue((Value)obj)));
        }
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        this.delete(url, null, params, null);
    }

    public boolean isDedicatedSession() {
        return this.usingDedicatedSession;
    }

    public boolean isAutoCommit() throws AGHttpException {
        return this.autoCommit;
    }

    public void setAutoCommit(boolean autoCommit) throws AGHttpException {
        this.useDedicatedSession(autoCommit);
        String url = AGProtocol.getAutoCommitLocation(this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("on", Boolean.toString(autoCommit)));
        this.post(url, null, params, null, null);
        this.autoCommit = autoCommit;
    }

    public int getUploadCommitPeriod() {
        return this.uploadCommitPeriod;
    }

    public void setUploadCommitPeriod(int period) {
        if (period < 0) {
            throw new IllegalArgumentException("upload commit period must be non-negative.");
        }
        this.uploadCommitPeriod = period;
    }

    public void commit(CommitPhase phase, Xid xid) throws AGHttpException {
        String url = this.getRoot() + "/" + "commit";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("phase", phase.toString()));
        params.add(new NameValuePair("xid", new AGXid(xid).toString()));
        this.post(url, null, params, null, null);
    }

    public void commit() throws AGHttpException {
        String url = this.getRoot() + "/" + "commit";
        this.post(url, null, null, null, null);
    }

    public void rollback() throws AGHttpException {
        String url = this.getRoot() + "/" + "rollback";
        this.post(url, null, null, null, null);
    }

    public void rollback(Xid xid) throws AGHttpException {
        String url = this.getRoot() + "/" + "rollback";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("xid", new AGXid(xid).toString()));
        this.post(url, null, params, null, null);
    }

    public Xid[] getPreparedTransactions() throws DecoderException {
        String url = this.getRoot() + "/" + "getPreparedTransactions";
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", "application/json"));
        AGJSONArrayHandler handler = new AGJSONArrayHandler();
        this.get(url, headers, null, handler);
        ArrayList<AGXid> res = new ArrayList<AGXid>();
        for (Object entry : handler.getResult().toList()) {
            res.add(AGXid.AGXidFromString((String)entry));
        }
        return res.toArray(new Xid[0]);
    }

    public void setSendRollbackHeader(boolean sendRollbackHeader) {
        this.sendRollbackHeader = sendRollbackHeader;
    }

    public void clearNamespaces() throws AGHttpException {
        String url = Protocol.getNamespacesLocation((String)this.getRoot());
        this.delete(url, null, null, null);
    }

    public void upload(final Reader contents, String baseURI, final RDFFormat dataFormat, boolean overwrite, JSONObject attributes, Resource ... contexts) throws RDFParseException, AGHttpException {
        final Charset charset = dataFormat.hasCharset() ? dataFormat.getCharset() : Charset.forName("UTF-8");
        RequestEntity entity = new RequestEntity(){

            public long getContentLength() {
                return -1L;
            }

            public String getContentType() {
                String format = dataFormat.getDefaultMIMEType();
                return format + "; charset=" + charset.name();
            }

            public boolean isRepeatable() {
                return false;
            }

            public void writeRequest(OutputStream out) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(out, charset);
                IOUtil.transfer((Reader)contents, (Writer)writer);
                writer.flush();
            }
        };
        this.upload(entity, baseURI, overwrite, null, null, null, attributes, contexts);
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, JSONObject attributes, Resource ... contexts) throws RDFParseException, AGHttpException {
        this.upload(contents, baseURI, dataFormat, overwrite, -1L, null, attributes, contexts);
    }

    public void upload(InputStream contents, String baseURI, RDFFormat dataFormat, boolean overwrite, long size, String contentEncoding, JSONObject attributes, Resource ... contexts) throws RDFParseException, AGHttpException {
        String format = dataFormat.getDefaultMIMEType();
        InputStreamRequestEntity entity = new InputStreamRequestEntity(contents, size, format);
        this.upload((RequestEntity)entity, baseURI, overwrite, null, null, null, attributes, contentEncoding, contexts);
    }

    public void sendRDFTransaction(InputStream rdftransaction) throws AGHttpException {
        InputStreamRequestEntity entity = new InputStreamRequestEntity(rdftransaction, -1L, "application/x-rdftransaction");
        this.upload((RequestEntity)entity, null, false, null, null, null, null, new Resource[0]);
    }

    public void sendRDFTransaction(InputStream rdftransaction, JSONObject attributes) throws AGHttpException {
        InputStreamRequestEntity entity = new InputStreamRequestEntity(rdftransaction, -1L, "application/x-rdftransaction");
        this.upload((RequestEntity)entity, null, false, null, null, null, attributes, new Resource[0]);
    }

    public void uploadJSON(JSONArray rows, Resource ... contexts) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        this.uploadJSON(url, rows, contexts);
    }

    public void uploadJSON(String url, JSONArray rows, Resource ... contexts) throws AGHttpException {
        if (rows == null) {
            return;
        }
        try {
            String data = rows.toString();
            StringRequestEntity entity = new StringRequestEntity(data, "application/json", "UTF-8");
            this.upload(url, (RequestEntity)entity, null, false, null, null, null, contexts);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteJSON(JSONArray rows, Resource ... contexts) throws AGHttpException {
        this.uploadJSON(AGProtocol.getStatementsDeleteLocation(this.getRoot()), rows, contexts);
    }

    public void load(IRI source, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws AGHttpException {
        this.upload(null, baseURI, false, null, source, dataFormat, null, contexts);
    }

    public void load(IRI source, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws AGHttpException {
        this.upload(null, baseURI, false, null, source, dataFormat, attributes, contexts);
    }

    public void load(String serverAbsolutePath, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws AGHttpException {
        this.upload(null, baseURI, false, serverAbsolutePath, null, dataFormat, null, contexts);
    }

    public void load(String serverAbsolutePath, String baseURI, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws AGHttpException {
        this.upload(null, baseURI, false, serverAbsolutePath, null, dataFormat, attributes, contexts);
    }

    public void upload(RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, IRI serverSideURL, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        this.upload(url, reqEntity, baseURI, overwrite, serverSideFile, serverSideURL, dataFormat, attributes, contexts);
    }

    public void upload(RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, IRI serverSideURL, RDFFormat dataFormat, JSONObject attributes, String contentEncoding, Resource ... contexts) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot());
        this.upload(url, reqEntity, baseURI, overwrite, serverSideFile, serverSideURL, dataFormat, attributes, contentEncoding, contexts);
    }

    public void upload(String url, RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, IRI serverSideURL, RDFFormat dataFormat, Resource ... contexts) throws AGHttpException {
        this.upload(url, reqEntity, baseURI, overwrite, serverSideFile, serverSideURL, dataFormat, (JSONObject)null, contexts);
    }

    public void upload(String url, RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, IRI serverSideURL, RDFFormat dataFormat, JSONObject attributes, Resource ... contexts) throws AGHttpException {
        this.upload(url, reqEntity, baseURI, overwrite, serverSideFile, serverSideURL, dataFormat, attributes, (String)null, contexts);
    }

    public void upload(String url, RequestEntity reqEntity, String baseURI, boolean overwrite, String serverSideFile, IRI serverSideURL, RDFFormat dataFormat, JSONObject attributes, String contentEncoding, Resource ... contexts) throws AGHttpException {
        OpenRDFUtil.verifyContextNotNull((Resource[])contexts);
        ArrayList<Header> headers = new ArrayList<Header>(1);
        if (dataFormat != null) {
            String format = dataFormat.getDefaultMIMEType();
            headers.add(new Header("Content-Type", format));
        }
        if (contentEncoding != null) {
            headers.add(new Header("Content-Encoding", contentEncoding));
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        for (String encodedContext : Protocol.encodeContexts((Resource[])contexts)) {
            params.add(new NameValuePair("context", encodedContext));
        }
        if (baseURI != null && baseURI.trim().length() != 0) {
            String encodedBaseURI = Protocol.encodeValue((Value)this.getValueFactory().createIRI(baseURI));
            params.add(new NameValuePair("baseURI", encodedBaseURI));
        }
        if (this.uploadCommitPeriod > 0) {
            params.add(new NameValuePair("commit", Integer.toString(this.uploadCommitPeriod)));
        }
        if (serverSideFile != null && serverSideFile.trim().length() != 0) {
            params.add(new NameValuePair("file", serverSideFile));
        }
        if (serverSideURL != null) {
            params.add(new NameValuePair("url", serverSideURL.stringValue()));
        }
        if (attributes != null) {
            params.add(new NameValuePair("attributes", attributes.toString()));
        }
        if (overwrite) {
            throw new UnsupportedOperationException();
        }
        this.post(url, headers, params, reqEntity, null);
    }

    public TupleQueryResult getContextIDs() throws AGHttpException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getContextIDs((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getContextIDs(TupleQueryResultHandler handler) throws TupleQueryResultHandlerException, AGHttpException {
        String url = Protocol.getContextsLocation((String)this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredTQRFormat().getDefaultMIMEType()));
        this.get(url, headers, null, new AGTQRHandler(this.getPreferredTQRFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()));
    }

    public long size(Resource ... contexts) throws AGHttpException {
        String url = Protocol.getSizeLocation((String)this.getRoot());
        String[] encodedContexts = Protocol.encodeContexts((Resource[])contexts);
        ArrayList<NameValuePair> contextParams = new ArrayList<NameValuePair>(encodedContexts.length);
        for (String encodedContext : encodedContexts) {
            contextParams.add(new NameValuePair("context", encodedContext));
        }
        AGLongHandler handler = new AGLongHandler();
        this.get(url, null, contextParams, handler);
        return handler.getResult();
    }

    public TupleQueryResult getNamespaces() throws AGHttpException {
        try {
            TupleQueryResultBuilder builder = new TupleQueryResultBuilder();
            this.getNamespaces((TupleQueryResultHandler)builder);
            return builder.getQueryResult();
        }
        catch (TupleQueryResultHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void getNamespaces(TupleQueryResultHandler handler) throws TupleQueryResultHandlerException, AGHttpException {
        String url = Protocol.getNamespacesLocation((String)this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredTQRFormat().getDefaultMIMEType()));
        this.get(url, headers, null, new AGTQRHandler(this.getPreferredTQRFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()));
    }

    public String getNamespace(String prefix) throws AGHttpException {
        AGStringHandler handler;
        block2: {
            String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
            handler = new AGStringHandler();
            try {
                this.get(url, null, null, handler);
            }
            catch (AGHttpException e) {
                if (e.getMessage().equals("Not found.")) break block2;
                throw e;
            }
        }
        return handler.getResult();
    }

    public void setNamespacePrefix(String prefix, String name) throws AGHttpException {
        String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
        try {
            this.put(url, null, null, (RequestEntity)new StringRequestEntity(name, "text/plain", "UTF-8"), null);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void removeNamespacePrefix(String prefix) throws AGHttpException {
        String url = Protocol.getNamespacePrefixLocation((String)this.getRoot(), (String)prefix);
        this.delete(url, null, null, null);
    }

    public void query(AGQuery q, boolean analyzeOnly, AGResponseHandler handler) throws AGHttpException {
        String url = this.getRoot();
        if (q.isPrepared()) {
            this.processSavedQueryDeleteQueue();
            url = AGProtocol.getSavedQueryLocation(url, q.getName());
        }
        ArrayList<Header> headers = new ArrayList<Header>(5);
        headers.add(new Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        if (handler.getRequestMIMEType() != null) {
            headers.add(new Header("Accept", handler.getRequestMIMEType()));
        }
        List<NameValuePair> queryParams = this.getQueryMethodParameters(q);
        if (analyzeOnly) {
            queryParams.add(new NameValuePair("analyzeIndicesUsed", "true"));
        }
        this.post(url, headers, queryParams, null, handler);
        if (this.sessionRoot != null && q.getName() != null) {
            q.setPrepared(true);
        }
    }

    protected List<NameValuePair> getQueryMethodParameters(AGQuery q) {
        QueryLanguage ql = q.getLanguage();
        Dataset dataset = q.getDataset();
        boolean includeInferred = q.getIncludeInferred();
        String planner = q.getPlanner();
        Binding[] bindings = q.getBindingsArray();
        String save = q.getName();
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(bindings.length + 10);
        if (!q.isPrepared()) {
            queryParams.add(new NameValuePair("queryLn", ql.getName()));
            if (q instanceof AGUpdate) {
                queryParams.add(new NameValuePair("update", q.getQueryString()));
            } else {
                queryParams.add(new NameValuePair("query", q.getQueryString()));
            }
            if (q.getBaseURI() != null) {
                queryParams.add(new NameValuePair("baseURI", q.getBaseURI()));
            }
            if (q.getMaxExecutionTime() > 0) {
                queryParams.add(new NameValuePair("timeout", Integer.toString(q.getMaxExecutionTime())));
            }
            queryParams.add(new NameValuePair("infer", Boolean.toString(includeInferred)));
            if (q.isCheckVariables()) {
                queryParams.add(new NameValuePair("checkVariables", Boolean.toString(q.isCheckVariables())));
            }
            if (q.getLimit() >= 0) {
                queryParams.add(new NameValuePair("limit", Integer.toString(q.getLimit())));
            }
            if (q.getOffset() >= 0) {
                queryParams.add(new NameValuePair("offset", Integer.toString(q.getOffset())));
            }
            if (q.isLoggingEnabled()) {
                queryParams.add(new NameValuePair("logQuery", "true"));
            }
            if (planner != null) {
                queryParams.add(new NameValuePair("planner", planner));
            }
            if (q.getEngine() != null) {
                queryParams.add(new NameValuePair("engine", q.getEngine()));
            }
            if (this.sessionRoot != null && save != null) {
                queryParams.add(new NameValuePair("save", save));
            }
            if (ql == QueryLanguage.SPARQL && dataset != null) {
                if (q instanceof AGUpdate) {
                    for (IRI graphURI : dataset.getDefaultRemoveGraphs()) {
                        queryParams.add(new NameValuePair("remove-graph-uri", String.valueOf(graphURI)));
                    }
                    if (dataset.getDefaultInsertGraph() != null) {
                        queryParams.add(new NameValuePair("insert-graph-uri", String.valueOf(dataset.getDefaultInsertGraph())));
                    }
                    for (IRI defaultGraphURI : dataset.getDefaultGraphs()) {
                        queryParams.add(new NameValuePair("using-graph-uri", String.valueOf(defaultGraphURI)));
                    }
                    for (IRI namedGraphURI : dataset.getNamedGraphs()) {
                        queryParams.add(new NameValuePair("using-named-graph-uri", String.valueOf(namedGraphURI)));
                    }
                } else {
                    for (IRI defaultGraphURI : dataset.getDefaultGraphs()) {
                        if (defaultGraphURI == null) {
                            queryParams.add(new NameValuePair("context", "null"));
                            continue;
                        }
                        queryParams.add(new NameValuePair("default-graph-uri", defaultGraphURI.toString()));
                    }
                    for (IRI namedGraphURI : dataset.getNamedGraphs()) {
                        queryParams.add(new NameValuePair("named-graph-uri", namedGraphURI.toString()));
                    }
                }
            }
        }
        for (Binding binding : bindings) {
            String paramName = "$" + binding.getName();
            String paramValue = Protocol.encodeValue((Value)this.getStorableValue(binding.getValue(), this.getValueFactory()));
            queryParams.add(new NameValuePair(paramName, paramValue));
        }
        return queryParams;
    }

    private void processSavedQueryDeleteQueue() throws AGHttpException {
        String queryName;
        while ((queryName = this.savedQueryDeleteQueue.poll()) != null) {
            this.deleteSavedQuery(queryName);
        }
    }

    public void deleteSavedQuery(String queryName) throws AGHttpException {
        String url = AGProtocol.getSavedQueryLocation(this.getRoot(), queryName);
        this.delete(url, null, null, null);
    }

    @Override
    public synchronized void close() throws AGHttpException {
        if (this.sessionRoot != null) {
            this.closeSession();
        }
    }

    public void createFreetextIndex(String name, List<String> predicates, boolean indexLiterals, List<String> indexLiteralTypes, String indexResources, List<String> indexFields, int minimumWordSize, List<String> stopWords, List<String> wordFilters, List<String> innerChars, List<String> borderChars, String tokenizer) throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), name);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        if (predicates != null) {
            for (String pred : predicates) {
                params.add(new NameValuePair("predicate", pred));
            }
        }
        if (indexLiterals) {
            if (indexLiteralTypes != null) {
                for (String type : indexLiteralTypes) {
                    params.add(new NameValuePair("indexLiteralType", type));
                }
            }
        } else {
            params.add(new NameValuePair("indexLiterals", "false"));
        }
        if (!indexResources.equals("true")) {
            params.add(new NameValuePair("indexResources", indexResources));
        }
        if (indexFields != null) {
            for (String field : indexFields) {
                params.add(new NameValuePair("indexField", field));
            }
        }
        if (minimumWordSize != 3) {
            params.add(new NameValuePair("minimumWordSize", Integer.toString(minimumWordSize)));
        }
        if (stopWords != null) {
            for (String word : stopWords) {
                params.add(new NameValuePair("stopWord", word));
            }
        }
        if (wordFilters != null) {
            for (String filter : wordFilters) {
                params.add(new NameValuePair("wordFilter", filter));
            }
        }
        if (innerChars != null) {
            for (String inner : innerChars) {
                params.add(new NameValuePair("innerChars", inner));
            }
        }
        if (borderChars != null) {
            for (String border : borderChars) {
                params.add(new NameValuePair("borderChars", border));
            }
        }
        if (!tokenizer.equals("default")) {
            params.add(new NameValuePair("tokenizer", tokenizer));
        }
        this.put(url, null, params, null, null);
    }

    public void deleteFreetextIndex(String index) throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), index);
        this.delete(url, null, null, null);
    }

    public List<String> listFreetextIndices() throws AGHttpException {
        return Arrays.asList(this.getFreetextIndices());
    }

    public String[] getFreetextIndices() throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot());
        AGStringHandler handler = new AGStringHandler();
        this.getHTTPClient().get(url, new Header[0], new NameValuePair[0], handler);
        return handler.getResult().split("\n");
    }

    public JSONObject getFreetextIndexConfiguration(String index) throws AGHttpException, JSONException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), index);
        AGJSONHandler handler = new AGJSONHandler();
        this.get(url, null, null, handler);
        return handler.getResult();
    }

    public String[] getFreetextPredicates(String index) throws AGHttpException {
        String url = AGProtocol.getFreetextIndexLocation(this.getRoot(), index) + "/predicates";
        AGStringHandler handler = new AGStringHandler();
        this.get(url, null, null, handler);
        return handler.getResult().split("\n");
    }

    public void evalFreetextQuery(String pattern, String expression, String index, boolean sorted, int limit, int offset, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getFreetextLocation(this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(5);
        headers.add(new Header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8"));
        if (handler.getRequestMIMEType() != null) {
            headers.add(new Header("Accept", handler.getRequestMIMEType()));
        }
        ArrayList<NameValuePair> queryParams = new ArrayList<NameValuePair>(6);
        if (pattern != null) {
            queryParams.add(new NameValuePair("pattern", pattern));
        }
        if (expression != null) {
            queryParams.add(new NameValuePair("expression", expression));
        }
        if (index != null) {
            queryParams.add(new NameValuePair("index", index));
        }
        if (sorted) {
            queryParams.add(new NameValuePair("sorted", "true"));
        }
        if (limit > 0) {
            queryParams.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        if (offset > 0) {
            queryParams.add(new NameValuePair("offset", Integer.toString(offset)));
        }
        this.post(url, headers, queryParams, null, handler);
    }

    public void registerPredicateMapping(IRI predicate, IRI primitiveType) throws AGHttpException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        String pred_nt = NTriplesUtil.toNTriplesString((IRI)predicate);
        String primtype_nt = NTriplesUtil.toNTriplesString((IRI)primitiveType);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("predicate", pred_nt));
        params.add(new NameValuePair("encoding", primtype_nt));
        this.post(url, null, params, null, null);
    }

    public void deletePredicateMapping(IRI predicate) throws AGHttpException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        String pred_nt = NTriplesUtil.toNTriplesString((IRI)predicate);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("predicate", pred_nt));
        this.delete(url, null, params, null);
    }

    public String[] getPredicateMappings() throws AGHttpException {
        String url = AGProtocol.getPredicateMappingLocation(this.getRoot());
        AGStringHandler handler = new AGStringHandler();
        this.get(url, null, null, handler);
        String result = handler.getResult();
        if (result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public void registerDatatypeMapping(IRI datatype, IRI primitiveType) throws AGHttpException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        String datatype_nt = NTriplesUtil.toNTriplesString((IRI)datatype);
        String primtype_nt = NTriplesUtil.toNTriplesString((IRI)primitiveType);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("type", datatype_nt));
        params.add(new NameValuePair("encoding", primtype_nt));
        this.post(url, null, params, null, null);
    }

    public void deleteDatatypeMapping(IRI datatype) throws AGHttpException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        String datatype_nt = NTriplesUtil.toNTriplesString((IRI)datatype);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("type", datatype_nt));
        this.delete(url, null, params, null);
    }

    public String[] getDatatypeMappings() throws AGHttpException {
        String url = AGProtocol.getDatatypeMappingLocation(this.getRoot());
        AGStringHandler handler = new AGStringHandler();
        this.get(url, null, null, handler);
        String result = handler.getResult();
        if (result.equals("")) {
            return new String[0];
        }
        return result.split("\n");
    }

    public void clearMappings() throws AGHttpException {
        this.clearMappings(false);
    }

    public void clearMappings(boolean includeAutoEncodedPrimitiveTypes) throws AGHttpException {
        String url = AGProtocol.getMappingLocation(this.getRoot());
        if (includeAutoEncodedPrimitiveTypes) {
            url = url + "/all";
        }
        this.delete(url, null, null, null);
    }

    public void addRules(String rules) throws AGHttpException {
        ByteArrayInputStream rulestream;
        try {
            rulestream = new ByteArrayInputStream(rules.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.addRules(rulestream);
    }

    public void addRules(InputStream rulestream) throws AGHttpException {
        this.useDedicatedSession(this.isAutoCommit());
        String url = AGProtocol.getFunctorLocation(this.getRoot());
        InputStreamRequestEntity entity = new InputStreamRequestEntity(rulestream, -1L, null);
        this.post(url, null, null, (RequestEntity)entity, null);
    }

    public String evalInServer(String lispForm) throws AGHttpException {
        ByteArrayInputStream stream = new ByteArrayInputStream(lispForm.getBytes(StandardCharsets.UTF_8));
        String result = this.evalInServer(stream);
        return result;
    }

    public String evalInServer(InputStream stream) throws AGHttpException {
        String url = AGProtocol.getEvalLocation(this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add(new Header("Content-Type", "text/plain; charset=utf-8"));
        AGStringHandler handler = new AGStringHandler();
        InputStreamRequestEntity entity = new InputStreamRequestEntity(stream, -1L, null);
        this.post(url, headers, null, (RequestEntity)entity, handler);
        return handler.getResult();
    }

    public void ping() throws AGHttpException {
        if (this.usingDedicatedSession) {
            String url = AGProtocol.getSessionPingLocation(this.getRoot());
            this.get(url, null, null, null);
        }
    }

    public String[] getGeoTypes() throws AGHttpException {
        String url = AGProtocol.getGeoTypesLocation(this.getRoot());
        AGStringHandler handler = new AGStringHandler();
        this.get(url, null, null, handler);
        return handler.getResult().split("\n");
    }

    public String registerCartesianType(float stripWidth, float xmin, float xmax, float ymin, float ymax) throws AGHttpException {
        String url = AGProtocol.getGeoTypesCartesianLocation(this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        params.add(new NameValuePair("stripWidth", Float.toString(stripWidth)));
        params.add(new NameValuePair("xmin", Float.toString(xmin)));
        params.add(new NameValuePair("xmax", Float.toString(xmax)));
        params.add(new NameValuePair("ymin", Float.toString(ymin)));
        params.add(new NameValuePair("ymax", Float.toString(ymax)));
        AGStringHandler handler = new AGStringHandler();
        this.post(url, null, params, null, handler);
        return handler.getResult();
    }

    public String registerSphericalType(float stripWidth, String unit, float latmin, float longmin, float latmax, float longmax) throws AGHttpException {
        String url = AGProtocol.getGeoTypesSphericalLocation(this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        params.add(new NameValuePair("stripWidth", Float.toString(stripWidth)));
        params.add(new NameValuePair("unit", unit));
        params.add(new NameValuePair("latmin", Float.toString(latmin)));
        params.add(new NameValuePair("longmin", Float.toString(longmin)));
        params.add(new NameValuePair("latmax", Float.toString(latmax)));
        params.add(new NameValuePair("longmax", Float.toString(longmax)));
        AGStringHandler handler = new AGStringHandler();
        this.post(url, null, params, null, handler);
        return handler.getResult();
    }

    public void registerPolygon(String polygon, List<String> points) throws AGHttpException {
        if (points.size() < 3) {
            throw new IllegalArgumentException("A minimum of three points are required to register a polygon.");
        }
        String url = AGProtocol.getGeoPolygonLocation(this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("resource", polygon));
        for (String point : points) {
            params.add(new NameValuePair("point", point));
        }
        this.put(url, null, params, null, null);
    }

    public void getGeoBox(String type_uri, String predicate_uri, float xmin, float xmax, float ymin, float ymax, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoBoxLocation(this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("xmin", Float.toString(xmin)));
        params.add(new NameValuePair("xmax", Float.toString(xmax)));
        params.add(new NameValuePair("ymin", Float.toString(ymin)));
        params.add(new NameValuePair("ymax", Float.toString(ymax)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.get(url, headers, params, handler);
    }

    public void getGeoCircle(String type_uri, String predicate_uri, float x, float y, float radius, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoCircleLocation(this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("x", Float.toString(x)));
        params.add(new NameValuePair("y", Float.toString(y)));
        params.add(new NameValuePair("radius", Float.toString(radius)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.get(url, headers, params, handler);
    }

    public void getGeoHaversine(String type_uri, String predicate_uri, float lat, float lon, float radius, String unit, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoHaversineLocation(this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("lat", Float.toString(lat)));
        params.add(new NameValuePair("long", Float.toString(lon)));
        params.add(new NameValuePair("radius", Float.toString(radius)));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.get(url, headers, params, handler);
    }

    public void getGeoPolygon(String type_uri, String predicate_uri, String polygon, int limit, boolean infer, AGResponseHandler handler) throws AGHttpException {
        String url = AGProtocol.getGeoPolygonLocation(this.getRoot());
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("type", type_uri));
        params.add(new NameValuePair("predicate", predicate_uri));
        params.add(new NameValuePair("polygon", polygon));
        params.add(new NameValuePair("infer", Boolean.toString(infer)));
        if (0 != limit) {
            params.add(new NameValuePair("limit", Integer.toString(limit)));
        }
        this.get(url, headers, params, handler);
    }

    public void registerSNAGenerator(String generator, List<String> objectOfs, List<String> subjectOfs, List<String> undirecteds, String query) throws AGHttpException {
        this.useDedicatedSession(this.autoCommit);
        String url = AGProtocol.getSNAGeneratorLocation(this.getRoot(), generator);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        for (String objectOf : objectOfs) {
            params.add(new NameValuePair("objectOf", objectOf));
        }
        for (String subjectOf : subjectOfs) {
            params.add(new NameValuePair("subjectOf", subjectOf));
        }
        for (String undirected : undirecteds) {
            params.add(new NameValuePair("undirected", undirected));
        }
        if (query != null) {
            params.add(new NameValuePair("query", query));
        }
        this.put(url, null, params, null, null);
    }

    public void registerSNANeighborMatrix(String matrix, String generator, List<String> group, int depth) throws AGHttpException {
        String url = AGProtocol.getSNANeighborMatrixLocation(this.getRoot(), matrix);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(7);
        params.add(new NameValuePair("generator", generator));
        for (String node : group) {
            params.add(new NameValuePair("group", node));
        }
        params.add(new NameValuePair("depth", Integer.toString(depth)));
        this.put(url, null, params, null, null);
    }

    public List<String> listIndices(boolean listValid) throws AGHttpException {
        String url = AGProtocol.getIndicesURL(this.getRoot());
        ArrayList<NameValuePair> data = new ArrayList<NameValuePair>(1);
        data.add(new NameValuePair("listValid", Boolean.toString(listValid)));
        AGStringHandler handler = new AGStringHandler();
        this.get(url, null, data, handler);
        return Arrays.asList(handler.getResult().split("\n"));
    }

    public void addIndex(String index) throws AGHttpException {
        String url = AGProtocol.getIndicesURL(this.getRoot()) + "/" + index;
        this.put(url, null, null, null, null);
    }

    public void dropIndex(String index) throws AGHttpException {
        String url = AGProtocol.getIndicesURL(this.getRoot()) + "/" + index;
        this.delete(url, null, null, null);
    }

    public void registerEncodableNamespace(String namespace, String format) throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("prefix", namespace));
        params.add(new NameValuePair("format", format));
        this.post(url, null, params, null, null);
    }

    public void unregisterEncodableNamespace(String namespace) throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("prefix", namespace));
        this.delete(url, null, params, null);
    }

    public void enableTripleCache(long size) throws AGHttpException {
        String url = this.getRoot() + "/tripleCache";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("size", Long.toString(size)));
        this.put(url, null, params, null, null);
    }

    public void registerEncodableNamespaces(JSONArray formattedNamespaces) throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        this.uploadJSON(url, formattedNamespaces, new Resource[0]);
    }

    public TupleQueryResult getEncodableNamespaces() throws AGHttpException {
        String url = this.getRoot() + "/encodedIds/prefixes";
        return this.getHTTPClient().getTupleQueryResult(url);
    }

    public String callStoredProcEncoded(String functionName, String moduleName, String argsEncoded) throws AGHttpException {
        String url = AGProtocol.getStoredProcLocation(this.getRoot()) + "/" + functionName;
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("x-scripts", moduleName));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("spargstr", argsEncoded));
        AGStringHandler handler = new AGStringHandler();
        this.post(url, headers, params, null, handler);
        return handler.getResult();
    }

    public Object callStoredProc(String functionName, String moduleName, Object ... args) throws AGHttpException {
        Object[] a;
        Object o = AGDeserializer.decodeAndDeserialize(this.callStoredProcEncoded(functionName, moduleName, AGSerializer.serializeAndEncode(args)));
        if (o instanceof Object[] && (a = (Object[])o).length == 2 && "_fail_".equals(a[0])) {
            throw new AGCustomStoredProcException(a[1] == null ? null : a[1].toString());
        }
        return o;
    }

    public long getStoreID() throws AGHttpException {
        String url = this.getRoot() + "/storeID";
        AGStringHandler handler = new AGStringHandler();
        this.get(url, null, null, handler);
        return Long.parseLong(handler.getResult(), 16);
    }

    public long getTripleCacheSize() throws AGHttpException {
        String url = this.getRoot() + "/tripleCache";
        AGLongHandler handler = new AGLongHandler();
        this.get(url, null, null, handler);
        return handler.getResult();
    }

    public void disableTripleCache() throws AGHttpException {
        String url = this.getRoot() + "/tripleCache";
        this.delete(url, null, null, null);
    }

    public String[] getBlankNodes(int blankNodeAmount) throws AGHttpException {
        return this.getHTTPClient().getBlankNodes(this.getRoot(), blankNodeAmount);
    }

    public void deleteDuplicates(String comparisonMode) throws AGHttpException {
        String url = Protocol.getStatementsLocation((String)this.getRoot()) + "/duplicates";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        if (comparisonMode != null) {
            params.add(new NameValuePair("mode", comparisonMode));
        }
        this.delete(url, null, params, null);
    }

    public void getDuplicateStatements(String comparisonMode, RDFHandler handler) throws AGHttpException, RDFHandlerException {
        String url = Protocol.getStatementsLocation((String)this.getRoot()) + "/duplicates";
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new Header("Accept", this.getPreferredRDFFormat().getDefaultMIMEType()));
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        if (comparisonMode != null) {
            params.add(new NameValuePair("mode", comparisonMode));
        }
        this.get(url, headers, params, new AGRDFHandler(this.getPreferredRDFFormat(), handler, this.getValueFactory(), this.getAllowExternalBlankNodeIds()));
    }

    public long materialize(AGMaterializer materializer) throws AGHttpException {
        String url = this.getRoot() + "/materializeEntailed";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        if (materializer != null) {
            Resource inferredGraph;
            Boolean useTypeSubproperty;
            for (String with : materializer.getWithRulesets()) {
                params.add(new NameValuePair("with", with));
            }
            for (String without : materializer.getWithoutRulesets()) {
                params.add(new NameValuePair("without", without));
            }
            Integer period = materializer.getCommitPeriod();
            if (period != null) {
                params.add(new NameValuePair("commit", period.toString()));
            }
            if ((useTypeSubproperty = materializer.getUseTypeSubproperty()) != null) {
                params.add(new NameValuePair("useTypeSubproperty", useTypeSubproperty.toString()));
            }
            if ((inferredGraph = materializer.getInferredGraph()) != null) {
                params.add(new NameValuePair("inferredGraph", Protocol.encodeContext((Resource)inferredGraph)));
            }
        }
        AGLongHandler handler = new AGLongHandler();
        this.put(url, null, params, null, handler);
        return handler.getResult();
    }

    public long deleteMaterialized(Resource inferredGraph) throws RepositoryException {
        String url = this.getRoot() + "/materializeEntailed";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        if (inferredGraph != null) {
            params.add(new NameValuePair("inferredGraph", Protocol.encodeContext((Resource)inferredGraph)));
        }
        AGLongHandler handler = new AGLongHandler();
        this.delete(url, null, params, handler);
        return handler.getResult();
    }

    public void optimizeIndices(Boolean wait, int level) throws AGHttpException {
        String url = this.repoRoot + "/indices/optimize";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
        params.add(new NameValuePair("wait", Boolean.toString(wait)));
        params.add(new NameValuePair("level", Integer.toString(level)));
        this.post(url, null, params, null, null);
    }

    public void optimizeIndices(Boolean wait) throws AGHttpException {
        String url = this.repoRoot + "/indices/optimize";
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("wait", Boolean.toString(wait)));
        this.post(url, null, params, null, null);
    }

    private void putSpinX(String x, AGSpinFunction fn) throws AGHttpException {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>((fn.getArguments() == null ? 0 : fn.getArguments().length) + 1);
        params.add(new NameValuePair("query", fn.getQuery()));
        for (int i = 0; fn.getArguments() != null && i < fn.getArguments().length; ++i) {
            params.add(new NameValuePair("arguments", fn.getArguments()[i]));
        }
        this.put(AGProtocol.spinURL(this.getRoot(), x, fn.getUri()), null, params, null, null);
    }

    public String getSpinFunction(String uri) throws AGHttpException {
        return this.getHTTPClient().getString(AGProtocol.spinURL(this.getRoot(), "function", uri));
    }

    public TupleQueryResult listSpinFunctions() throws AGHttpException {
        return this.getHTTPClient().getTupleQueryResult(AGProtocol.spinURL(this.getRoot(), "function", null));
    }

    public void putSpinFunction(AGSpinFunction fn) throws AGHttpException {
        this.putSpinX("function", fn);
    }

    public void deleteSpinFunction(String uri) throws AGHttpException {
        this.delete(AGProtocol.spinURL(this.getRoot(), "function", uri), null, null, null);
    }

    public void deleteHardSpinFunction(String uri) throws AGHttpException {
        block2: {
            try {
                this.deleteSpinFunction(uri);
            }
            catch (AGHttpException e) {
                if (e.getMessage().contains(uri + " is not a registered SPIN function")) break block2;
                throw e;
            }
        }
    }

    public String getSpinMagicProperty(String uri) throws AGHttpException {
        return this.getHTTPClient().getString(AGProtocol.spinURL(this.getRoot(), "magicproperty", uri));
    }

    public TupleQueryResult listSpinMagicProperties() throws AGHttpException {
        return this.getHTTPClient().getTupleQueryResult(AGProtocol.spinURL(this.getRoot(), "magicproperty", null));
    }

    public void putSpinMagicProperty(AGSpinMagicProperty fn) throws AGHttpException {
        this.putSpinX("magicproperty", fn);
    }

    public void deleteSpinMagicProperty(String uri) throws AGHttpException {
        this.delete(AGProtocol.spinURL(this.getRoot(), "magicproperty", uri), null, null, null);
    }

    public void deleteHardSpinMagicProperty(String uri) throws AGHttpException {
        block2: {
            try {
                this.deleteSpinMagicProperty(uri);
            }
            catch (AGHttpException e) {
                if (e.getMessage().contains(uri + " is not a registered SPIN magic property")) break block2;
                throw e;
            }
        }
    }

    public boolean getAllowExternalBlankNodeIds() {
        return this.allowExternalBlankNodeIds;
    }

    public void setAllowExternalBlankNodeIds(boolean allow) {
        this.allowExternalBlankNodeIds = allow;
    }

    public Resource getStorableResource(Resource r, AGValueFactory vf) {
        Resource storable = r;
        if (r instanceof BNode && !vf.isAGBlankNodeId(r.stringValue())) {
            if (this.allowExternalBlankNodeIds) {
                storable = vf.createIRI(vf.PREFIX_FOR_EXTERNAL_BNODES + r.stringValue());
            } else {
                throw new IllegalArgumentException("Cannot store external blank node " + r + " in AllegroGraph with the current settings. " + "Please see javadoc for " + "AGHttpRepoClient#setAllowExternalBlankNodeIds(boolean)" + "for more details and options.");
            }
        }
        return storable;
    }

    public Value getStorableValue(Value v, AGValueFactory vf) {
        return AGHttpRepoClient.getStorableValue(v, vf, this.getAllowExternalBlankNodeIds());
    }

    public void setMasqueradeAsUser(String user) throws RepositoryException {
        this.useDedicatedSession(this.autoCommit);
        this.getHTTPClient().setMasqueradeAsUser(user);
    }

    public void addAttributeDefinition(String name, List<String> allowedValues, boolean ordered, long minimum, long maximum) throws AGHttpException {
        String url = AGProtocol.getAttributeDefinitionLocation(this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(5);
        params.add(new NameValuePair("name", name));
        params.add(new NameValuePair("ordered", Boolean.toString(ordered)));
        if (minimum >= 0L) {
            params.add(new NameValuePair("minimum-number", Long.toString(minimum)));
        }
        if (maximum >= 0L) {
            params.add(new NameValuePair("maximum-number", Long.toString(maximum)));
        }
        if (allowedValues != null) {
            for (String value : allowedValues) {
                params.add(new NameValuePair("allowed-values", value));
            }
        }
        this.post(url, null, params, null, null);
    }

    public void deleteAttributeDefinition(String name) throws AGHttpException {
        String url = AGProtocol.getAttributeDefinitionLocation(this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("name", name));
        this.delete(url, null, params, null);
    }

    public JSONArray getAttributeDefinition() throws AGHttpException, JSONException {
        return this.getAttributeDefinition(null);
    }

    public JSONArray getAttributeDefinition(String name) throws AGHttpException, JSONException {
        String url = AGProtocol.getAttributeDefinitionLocation(this.getRoot());
        ArrayList<NameValuePair> params = null;
        AGJSONHandler handler = new AGJSONHandler();
        if (name != null) {
            params = new ArrayList<NameValuePair>(1);
            params.add(new NameValuePair("name", name));
        }
        this.get(url, null, params, handler);
        return handler.getArrayResult();
    }

    public String getStaticAttributeFilter() throws AGHttpException {
        String url = AGProtocol.getStaticFilterLocation(this.getRoot());
        AGStringHandler handler = new AGStringHandler();
        this.get(url, null, null, handler);
        String result = handler.getResult();
        if (result != null && result.trim().length() == 0) {
            result = null;
        }
        return result;
    }

    public void setStaticAttributeFilter(String filter) throws AGHttpException {
        String url = AGProtocol.getStaticFilterLocation(this.getRoot());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(1);
        params.add(new NameValuePair("filter", filter));
        this.post(url, null, params, null, null);
    }

    public void deleteStaticAttributeFilter() throws AGHttpException {
        String url = AGProtocol.getStaticFilterLocation(this.getRoot());
        this.delete(url, null, null, null);
    }

    public String getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(String value) {
        this.userAttributes = value != null && value.trim().length() == 0 ? null : value;
    }

    public TransactionSettings getTransactionSettings() {
        return this.transactionSettings;
    }

    public void setTransactionSettings(TransactionSettings transactionSettings) {
        this.transactionSettings = transactionSettings;
    }

    private boolean hasWarmupBug() {
        if (this.hasWarmupBug == null) {
            AGServerVersion version = this.repo.getServer().getComparableVersion();
            this.hasWarmupBug = version.compareTo(new AGServerVersion("6.3.0")) < 0;
        }
        return this.hasWarmupBug;
    }

    public void warmup() {
        this.warmup(null);
    }

    public void warmup(WarmupConfig config) {
        block3: {
            String url = this.getRoot() + "/" + "warmup";
            ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(2);
            if (config != null) {
                params.add(new NameValuePair("includeStrings", Boolean.toString(config.getIncludeStrings())));
                params.add(new NameValuePair("includeTriples", Boolean.toString(config.getIncludeTriples())));
            }
            try {
                this.put(url, null, params, null, null);
            }
            catch (AGHttpException e) {
                if (this.hasWarmupBug() && e.getMessage().contains("commit operation is not allowed")) break block3;
                throw e;
            }
        }
    }

    public static enum CommitPhase {
        PREPARE("prepare"),
        COMMIT("commit");

        private String string;

        private CommitPhase(String string2) {
            this.string = string2;
        }

        public String toString() {
            return this.string;
        }
    }
}

