/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http;

import com.franz.agraph.http.exception.AGHttpException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.eclipse.rdf4j.http.protocol.Protocol;

public class AGProtocol
extends Protocol {
    public static final String CATALOGS = "catalogs";
    public static final String VERSION = "version";
    public static final String RECONFIGURE = "reconfigure";
    public static final String USERS = "users";
    public static final String USER_ROLES = "roles";
    public static final String USER_PERMISSIONS = "permissions";
    public static final String USER_DATA = "data";
    public static final String PROCESSES = "processes";
    public static final String SESSION = "session";
    public static final String LIFETIME_PARAM_NAME = "lifetime";
    public static final String LOAD_INIT_FILE_PARAM_NAME = "loadInitFile";
    public static final String AUTOCOMMIT_PARAM_NAME = "autoCommit";
    public static final String OVERRIDE_PARAM_NAME = "override";
    public static final String CLOSE = "close";
    public static final String PING = "ping";
    public static final String QUERIES = "queries";
    public static final String BLANK_NODES = "blankNodes";
    public static final String AMOUNT_PARAM_NAME = "amount";
    public static final String DELETE = "delete";
    public static final String AUTOCOMMIT = "autoCommit";
    public static final String CUSTOM = "custom";
    public static final String ON_PARAM_NAME = "on";
    public static final String FILE_PARAM_NAME = "file";
    public static final String COMMIT = "commit";
    public static final String COMMIT_PHASE = "phase";
    public static final String XID = "xid";
    public static final String ROLLBACK = "rollback";
    public static final String GET_PREPARED_TRANSACTIONS = "getPreparedTransactions";
    public static final String EVAL = "eval";
    public static final String FUNCTOR = "functor";
    public static final String FREETEXT = "freetext";
    public static final String FTI_INDICES = "indices";
    public static final String FTI_PREDICATE_PARAM_NAME = "predicate";
    public static final String MAPPING = "mapping";
    public static final String MAPPING_DATATYPE = "type";
    public static final String TYPE_PARAM_NAME = "type";
    public static final String ENCODED_TYPE_PARAM_NAME = "encoding";
    public static final String MAPPING_PREDICATE = "predicate";
    public static final String URL_PARAM_NAME = "url";
    public static final String REPO_PARAM_NAME = "repo";
    public static final String PLANNER_PARAM_NAME = "planner";
    public static final String SAVE_PARAM_NAME = "save";
    public static final String GEO = "geo";
    public static final String TYPES = "types";
    public static final String CARTESIAN = "cartesian";
    public static final String SPHERICAL = "spherical";
    public static final String STRIP_WIDTH_PARAM_NAME = "stripWidth";
    public static final String XMIN_PARAM_NAME = "xmin";
    public static final String XMAX_PARAM_NAME = "xmax";
    public static final String YMIN_PARAM_NAME = "ymin";
    public static final String YMAX_PARAM_NAME = "ymax";
    public static final String LATMIN_PARAM_NAME = "latmin";
    public static final String LONGMIN_PARAM_NAME = "longmin";
    public static final String LATMAX_PARAM_NAME = "latmax";
    public static final String LONGMAX_PARAM_NAME = "longmax";
    public static final String UNIT_PARAM_NAME = "unit";
    public static final String DEGREE_PARAM_VALUE = "degree";
    public static final String RADIAN_PARAM_VALUE = "radian";
    public static final String KM_PARAM_VALUE = "km";
    public static final String MILE_PARAM_VALUE = "mile";
    public static final String LIMIT_PARAM_NAME = "limit";
    public static final String BOX = "box";
    public static final String GEO_PREDICATE_PARAM_NAME = "predicate";
    public static final String CIRCLE = "circle";
    public static final String X_PARAM_NAME = "x";
    public static final String Y_PARAM_NAME = "y";
    public static final String RADIUS_PARAM_NAME = "radius";
    public static final String HAVERSINE = "haversine";
    public static final String LAT_PARAM_NAME = "lat";
    public static final String LON_PARAM_NAME = "long";
    public static final String POLYGON = "polygon";
    public static final String RESOURCE_PARAM_NAME = "resource";
    public static final String POLYGON_PARAM_NAME = "polygon";
    public static final String POINT_PARAM_NAME = "point";
    public static final String SNA_GENERATORS = "snaGenerators";
    public static final String OBJECTOF_PARAM_NAME = "objectOf";
    public static final String SUBJECTOF_PARAM_NAME = "subjectOf";
    public static final String UNDIRECTED_PARAM_NAME = "undirected";
    public static final String NEIGHBOR_MATRICES = "neighborMatrices";
    public static final String GENERATOR_PARAM_NAME = "generator";
    public static final String GROUP_PARAM_NAME = "group";
    public static final String DEPTH_PARAM_NAME = "depth";
    public static final String INDICES = "indices";
    public static final String SPIN = "spin";
    public static final String SPIN_MAGICPROPERTY = "magicproperty";
    public static final String SPIN_FUNCTION = "function";
    public static final String SPIN_QUERY = "query";
    public static final String SPIN_ARGUMENTS = "arguments";
    public static final String WARMUP = "warmup";
    public static final String INCLUDE_STRINGS = "includeStrings";
    public static final String INCLUDE_TRIPLES = "includeTriples";
    public static final String LOGFILE = "logfile";
    public static final String CHECK_VARIABLES = "checkVariables";
    public static final String SESSION_DOC = "Consult the Server Installation document for correct settings for SessionPorts: http://www.franz.com/agraph/support/documentation/current/server-installation.html#sessionport. Or the session may have been idle for its lifetime setting and been collected - see AGRepositoryConnection.setSessionLifetime()";
    public static final String BEGIN = "begin";
    public static final String DEFINE_ATTRIBUTE_LOCATION = "attributes/definitions";
    public static final String NAME_PARAM_NAME = "name";
    public static final String ORDERED_PARAM_NAME = "ordered";
    public static final String ALLOWED_VALUE_PARAM_NAME = "allowed-values";
    public static final String MAXIMUM_PARAM_NAME = "maximum-number";
    public static final String MINIMUM_PARAM_NAME = "minimum-number";
    public static final String ATTRIBUTES_PARAM_NAME = "attributes";
    public static final String STATIC_FILTER_LOCATION = "attributes/staticFilter";
    public static final String FILTER_PARAM_NAME = "filter";
    public static final String USER_ATTRIBUTE_HEADER = "x-user-attributes";
    public static final String X_COMMIT_HEADER = "x-commit";
    public static final String X_ROLLBACK_HEADER = "x-rollback";
    public static final String X_REPL_SETTINGS = "x-repl-settings";

    public static String getLogLocation(String serverURL) {
        return serverURL + "/" + LOGFILE;
    }

    public static final String getRootCatalogURL(String serverURL) {
        return serverURL;
    }

    public static final String getNamedCatalogsURL(String serverURL) {
        return serverURL + "/" + CATALOGS;
    }

    public static final String getNamedCatalogLocation(String serverURL, String catalogName) {
        return AGProtocol.getNamedCatalogsURL(serverURL) + "/" + AGProtocol.encode(catalogName);
    }

    public static final String getBlankNodesURL(String repositoryLocation) {
        return repositoryLocation + "/" + BLANK_NODES;
    }

    public static final String getSessionURL(String serverLocation) {
        return serverLocation + "/" + SESSION;
    }

    public static final String getSessionCloseLocation(String sessionRoot) {
        return AGProtocol.getSessionURL(sessionRoot) + "/" + CLOSE;
    }

    public static final String getSessionPingLocation(String sessionRoot) {
        return AGProtocol.getSessionURL(sessionRoot) + "/" + PING;
    }

    public static final String getQueriesLocation(String sessionRoot) {
        return sessionRoot + "/" + QUERIES;
    }

    public static final String getSavedQueryLocation(String sessionRoot, String queryName) {
        return AGProtocol.getQueriesLocation(sessionRoot) + "/" + AGProtocol.encode(queryName);
    }

    public static final String getAutoCommitLocation(String sessionRoot) {
        return AGProtocol.getSessionURL(sessionRoot) + "/" + "autoCommit";
    }

    public static final String getStoredProcLocation(String sessionRoot) {
        return sessionRoot + "/" + CUSTOM;
    }

    public static String getStatementsDeleteLocation(String sessionRoot) {
        return AGProtocol.getStatementsLocation((String)sessionRoot) + "/" + DELETE;
    }

    public static String getFreetextLocation(String sessionRoot) {
        return sessionRoot + "/" + FREETEXT;
    }

    public static String getFreetextIndexLocation(String sessionRoot) {
        return AGProtocol.getFreetextLocation(sessionRoot) + "/" + "indices";
    }

    public static String getFreetextIndexLocation(String sessionRoot, String name) {
        return AGProtocol.getFreetextLocation(sessionRoot) + "/" + "indices" + "/" + AGProtocol.encode(name);
    }

    public static String getMappingLocation(String sessionRoot) {
        return sessionRoot + "/" + MAPPING;
    }

    public static String getDatatypeMappingLocation(String sessionRoot) {
        return AGProtocol.getMappingLocation(sessionRoot) + "/" + "type";
    }

    public static String getPredicateMappingLocation(String sessionRoot) {
        return AGProtocol.getMappingLocation(sessionRoot) + "/" + "predicate";
    }

    public static String getFunctorLocation(String serverRoot) {
        return serverRoot + "/" + FUNCTOR;
    }

    public static String getNamedCatalogRepositoriesLocation(String catalogURL) {
        return catalogURL + "/" + "repositories";
    }

    public static String getRootCatalogRepositoriesLocation(String catalogURL) {
        return catalogURL + "/" + "repositories";
    }

    public static String getEvalLocation(String sessionRoot) {
        return sessionRoot + "/" + EVAL;
    }

    public static String getGeoLocation(String sessionRoot) {
        return sessionRoot + "/" + GEO;
    }

    public static String getGeoTypesLocation(String sessionRoot) {
        return AGProtocol.getGeoLocation(sessionRoot) + "/" + TYPES;
    }

    public static String getGeoTypesCartesianLocation(String sessionRoot) {
        return AGProtocol.getGeoTypesLocation(sessionRoot) + "/" + CARTESIAN;
    }

    public static String getGeoTypesSphericalLocation(String sessionRoot) {
        return AGProtocol.getGeoTypesLocation(sessionRoot) + "/" + SPHERICAL;
    }

    public static String getGeoBoxLocation(String sessionRoot) {
        return AGProtocol.getGeoLocation(sessionRoot) + "/" + BOX;
    }

    public static String getGeoCircleLocation(String sessionRoot) {
        return AGProtocol.getGeoLocation(sessionRoot) + "/" + CIRCLE;
    }

    public static String getGeoHaversineLocation(String sessionRoot) {
        return AGProtocol.getGeoLocation(sessionRoot) + "/" + HAVERSINE;
    }

    public static String getGeoPolygonLocation(String sessionRoot) {
        return AGProtocol.getGeoLocation(sessionRoot) + "/" + "polygon";
    }

    public static String getSNAGeneratorsLocation(String sessionRoot) {
        return sessionRoot + "/" + SNA_GENERATORS;
    }

    public static String getSNAGeneratorLocation(String sessionRoot, String generator) {
        return AGProtocol.getSNAGeneratorsLocation(sessionRoot) + "/" + AGProtocol.encode(generator);
    }

    public static String getSNANeighborMatricesLocation(String sessionRoot) {
        return sessionRoot + "/" + NEIGHBOR_MATRICES;
    }

    public static String getSNANeighborMatrixLocation(String sessionRoot, String matrix) {
        return AGProtocol.getSNANeighborMatricesLocation(sessionRoot) + "/" + AGProtocol.encode(matrix);
    }

    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This JVM does not support UTF-8?");
        }
    }

    public static String getIndicesURL(String root) {
        return root + "/" + "indices";
    }

    public static String spinURL(String root, String type, String uri) throws AGHttpException {
        try {
            if (uri == null) {
                return root + "/" + SPIN + "/" + type;
            }
            return root + "/" + SPIN + "/" + type + "/" + URIUtil.encodeAll((String)uri);
        }
        catch (URIException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
    }

    public static String getAttributeDefinitionLocation(String root) {
        return root + "/" + DEFINE_ATTRIBUTE_LOCATION;
    }

    public static String getStaticFilterLocation(String root) {
        return root + "/" + STATIC_FILTER_LOCATION;
    }
}

