/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.input.AutoCloseInputStream;
import org.eclipse.rdf4j.query.resultio.BooleanQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.rio.RDFFormat;

public class AGRawStreamer
extends AGResponseHandler {
    private HttpMethod method;

    public AGRawStreamer(String mimeType) {
        super(mimeType);
    }

    public AGRawStreamer() {
        this("*/*");
    }

    public AGRawStreamer(RDFFormat format) {
        this(format.getDefaultMIMEType());
    }

    public AGRawStreamer(TupleQueryResultFormat format) {
        this(format.getDefaultMIMEType());
    }

    public AGRawStreamer(BooleanQueryResultFormat format) {
        this(format.getDefaultMIMEType());
    }

    public InputStream getStream() throws AGHttpException {
        try {
            return new AutoCloseInputStream(AGRawStreamer.getInputStream(this.method)){
                private boolean closed;
                {
                    this.closed = false;
                }

                public void close() throws IOException {
                    if (!this.closed) {
                        super.close();
                        this.closed = true;
                        AGRawStreamer.this.method.releaseConnection();
                    }
                }
            };
        }
        catch (IOException e) {
            throw new AGHttpException(e);
        }
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        this.method = method;
    }

    @Override
    public boolean releaseConnection() {
        return false;
    }
}

