/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.IOUtils;

public abstract class AGResponseHandler {
    private final String requestMIMEType;

    public AGResponseHandler(String mimeType) {
        this.requestMIMEType = mimeType;
    }

    protected static InputStream getInputStream(HttpMethod method) throws IOException {
        InputStream is = method.getResponseBodyAsStream();
        Header h = method.getResponseHeader("Content-Encoding");
        if (h != null && h.getValue().equals("gzip")) {
            is = new GZIPInputStream(is);
        }
        return is;
    }

    protected static String streamToString(InputStream in) throws IOException {
        return IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
    }

    public String getRequestMIMEType() {
        return this.requestMIMEType;
    }

    public abstract void handleResponse(HttpMethod var1) throws IOException, AGHttpException;

    public boolean releaseConnection() {
        return true;
    }

    protected String getResponseMIMEType(HttpMethod method) throws IOException {
        Header[] headers;
        for (Header header : headers = method.getResponseHeaders("Content-Type")) {
            HeaderElement[] headerElements;
            for (HeaderElement headerEl : headerElements = header.getElements()) {
                String mimeType = headerEl.getName();
                if (mimeType == null) continue;
                return mimeType;
            }
        }
        return null;
    }
}

