/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGTQRStreamer;
import com.franz.agraph.repository.AGValueFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryResultHandlerException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.QueryResultParseException;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.UnsupportedQueryResultFormatException;

public class AGTQRJSONStreamer
extends AGTQRStreamer {
    private InputStream in;

    public AGTQRJSONStreamer(AGValueFactory vf) {
        super(TupleQueryResultFormat.JSON.getDefaultMIMEType());
        this.vf = vf;
    }

    @Override
    public String getRequestMIMEType() {
        return TupleQueryResultFormat.JSON.getDefaultMIMEType();
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        this.method = method;
        this.in = AGResponseHandler.getInputStream(method);
    }

    @Override
    public TupleQueryResult getResult() {
        return new Result();
    }

    private class Result
    implements TupleQueryResult {
        private BindingSet next;
        private InputStreamReader r;
        private BufferedReader reader;
        private List<String> bindingNames;
        private final JsonParser jp;
        private final JsonFactory JSON_FACTORY;

        public Result() {
            this.r = new InputStreamReader(AGTQRJSONStreamer.this.in, Charset.forName("UTF-8"));
            this.reader = new BufferedReader(this.r);
            this.JSON_FACTORY = new JsonFactory();
            this.JSON_FACTORY.disable(JsonFactory.Feature.INTERN_FIELD_NAMES);
            this.JSON_FACTORY.disable(JsonFactory.Feature.CANONICALIZE_FIELD_NAMES);
            this.JSON_FACTORY.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
            try {
                this.jp = this.JSON_FACTORY.createParser(AGTQRJSONStreamer.this.in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public List<String> getBindingNames() {
            try {
                this.parseBindingNames();
            }
            catch (IOException e) {
                throw new UnsupportedQueryResultFormatException((Throwable)e);
            }
            return this.bindingNames;
        }

        public void remove() throws QueryEvaluationException {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            try {
                if (this.next == null) {
                    this.next = this.parseNext();
                }
            }
            catch (IOException e) {
                throw new UnsupportedQueryResultFormatException((Throwable)e);
            }
            return this.next != null;
        }

        public BindingSet next() throws QueryEvaluationException {
            if (this.hasNext()) {
                BindingSet curr = this.next;
                this.next = null;
                return curr;
            }
            throw new NoSuchElementException();
        }

        public void close() throws QueryEvaluationException {
            AGTQRJSONStreamer.this.method.releaseConnection();
        }

        private void parseBindingNames() throws IOException {
            if (this.bindingNames == null) {
                while (this.jp.nextToken() != JsonToken.END_OBJECT) {
                    String baseStr = this.jp.getCurrentName();
                    if (baseStr == null || !baseStr.equals("head")) continue;
                    if (this.jp.nextToken() != JsonToken.START_OBJECT) {
                        throw new QueryResultParseException("Did not find object under " + baseStr + " field", (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                    }
                    if (this.jp.nextToken() == JsonToken.END_OBJECT) break;
                    this.bindingNames = new ArrayList<String>();
                    String headStr = this.jp.getCurrentName();
                    if (headStr.equals("vars")) {
                        if (this.jp.nextToken() != JsonToken.START_ARRAY) {
                            throw new QueryResultParseException("Expected variable labels to be an array", (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                        }
                        while (this.jp.nextToken() != JsonToken.END_ARRAY) {
                            this.bindingNames.add(this.jp.getText());
                        }
                        continue;
                    }
                    throw new QueryResultParseException("Found unexpected object in head field: " + headStr, (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                }
            }
        }

        private MapBindingSet parseNext() throws IOException, QueryResultParseException, QueryResultHandlerException {
            MapBindingSet bindings = null;
            this.parseBindingNames();
            while (this.jp.nextToken() != JsonToken.END_OBJECT) {
                if (this.jp.getCurrentName().equals("bindings")) {
                    if (this.jp.nextToken() != JsonToken.START_ARRAY) {
                        throw new QueryResultParseException("Found unexpected token in bindings object", (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                    }
                    while (this.jp.nextToken() != JsonToken.END_ARRAY) {
                        bindings = new MapBindingSet();
                        if (this.jp.getCurrentToken() != JsonToken.START_OBJECT) {
                            throw new QueryResultParseException("Did not find object in bindings array: " + this.jp.getCurrentName(), (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                        }
                        while (this.jp.nextToken() != JsonToken.END_OBJECT) {
                            if (this.jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                throw new QueryResultParseException("Did not find binding name", (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                            }
                            String bindingStr = this.jp.getCurrentName();
                            if (this.jp.nextToken() != JsonToken.START_OBJECT) {
                                throw new QueryResultParseException("Did not find object for binding value", (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                            }
                            String lang = null;
                            String type = null;
                            String datatype = null;
                            String value = null;
                            while (this.jp.nextToken() != JsonToken.END_OBJECT) {
                                if (this.jp.getCurrentToken() != JsonToken.FIELD_NAME) {
                                    throw new QueryResultParseException("Did not find value attribute under " + bindingStr + " field", (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                                }
                                String fieldName = this.jp.getCurrentName();
                                this.jp.nextToken();
                                if ("type".equals(fieldName)) {
                                    type = this.jp.getText();
                                    continue;
                                }
                                if ("xml:lang".equals(fieldName)) {
                                    lang = this.jp.getText();
                                    continue;
                                }
                                if ("datatype".equals(fieldName)) {
                                    datatype = this.jp.getText();
                                    continue;
                                }
                                if (!"value".equals(fieldName)) {
                                    throw new QueryResultParseException("Unexpected field name: " + fieldName, (long)this.jp.getCurrentLocation().getLineNr(), (long)this.jp.getCurrentLocation().getColumnNr());
                                }
                                value = this.jp.getText();
                            }
                            bindings.addBinding(bindingStr, AGHttpRepoClient.getApplicationValue(this.parseValue(type, value, lang, datatype), AGTQRJSONStreamer.this.vf));
                        }
                    }
                    continue;
                }
                this.jp.nextToken();
            }
            return bindings;
        }

        private Value parseValue(String type, String value, String language, String datatype) {
            Literal result = null;
            if (!type.equals("literal") && !type.equals("typed-literal")) {
                if (type.equals("bnode")) {
                    result = AGTQRJSONStreamer.this.vf.createBNode(value);
                } else if (type.equals("uri")) {
                    result = AGTQRJSONStreamer.this.vf.createIRI(value);
                }
            } else {
                result = language != null ? AGTQRJSONStreamer.this.vf.createLiteral(value, language) : (datatype != null ? AGTQRJSONStreamer.this.vf.createLiteral(value, AGTQRJSONStreamer.this.vf.createIRI(datatype)) : AGTQRJSONStreamer.this.vf.createLiteral(value));
            }
            return result;
        }
    }
}

