/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGTQRJSONStreamer;
import com.franz.agraph.http.handler.AGTQRTSVStreamer;
import com.franz.agraph.http.handler.AGTQRXMLStreamer;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AGTQRStreamer
extends AGResponseHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected AGValueFactory vf;
    protected HttpMethod method;

    public AGTQRStreamer(String mimeType) {
        super(mimeType);
    }

    @Override
    public abstract String getRequestMIMEType();

    @Override
    public boolean releaseConnection() {
        return false;
    }

    @Override
    public abstract void handleResponse(HttpMethod var1) throws IOException, AGHttpException;

    public abstract TupleQueryResult getResult();

    public static AGTQRStreamer createStreamer(TupleQueryResultFormat format, AGValueFactory vf) {
        if (format.equals((Object)TupleQueryResultFormat.TSV)) {
            return new AGTQRTSVStreamer(vf);
        }
        if (format.equals((Object)TupleQueryResultFormat.SPARQL)) {
            return new AGTQRXMLStreamer(vf);
        }
        if (format.equals((Object)TupleQueryResultFormat.JSON)) {
            return new AGTQRJSONStreamer(vf);
        }
        throw new IllegalArgumentException("Unable to find AGTQRStreamer for format " + format);
    }
}

