/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.http.handler;

import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGResponseHandler;
import com.franz.agraph.http.handler.AGTQRStreamer;
import com.franz.agraph.repository.AGValueFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.httpclient.HttpMethod;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;

public class AGTQRXMLStreamer
extends AGTQRStreamer {
    private static final XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
    private final AGValueFactory vf;
    private XMLStreamReader xml;
    private HttpMethod method;

    public AGTQRXMLStreamer(AGValueFactory vf) {
        super(TupleQueryResultFormat.SPARQL.getDefaultMIMEType());
        this.vf = vf;
    }

    @Override
    public String getRequestMIMEType() {
        return TupleQueryResultFormat.SPARQL.getDefaultMIMEType();
    }

    @Override
    public boolean releaseConnection() {
        return false;
    }

    @Override
    public void handleResponse(HttpMethod method) throws IOException, AGHttpException {
        this.method = method;
        try {
            this.xml = xmlInputFactory.createXMLStreamReader(AGResponseHandler.getInputStream(method));
        }
        catch (XMLStreamException e) {
            throw new AGHttpException(e);
        }
    }

    @Override
    public TupleQueryResult getResult() {
        return new Result();
    }

    class Result
    implements TupleQueryResult {
        private List<String> bindingNames;
        private MapBindingSet next = null;
        private boolean closed = false;

        Result() {
        }

        private void parseBindingNames() {
            if (this.bindingNames == null) {
                try {
                    while (AGTQRXMLStreamer.this.xml.hasNext()) {
                        block1 : switch (AGTQRXMLStreamer.this.xml.next()) {
                            case 1: {
                                switch (AGTQRXMLStreamer.this.xml.getLocalName()) {
                                    case "head": {
                                        this.bindingNames = new ArrayList<String>();
                                        break block1;
                                    }
                                    case "variable": {
                                        for (int i = 0; i < AGTQRXMLStreamer.this.xml.getAttributeCount(); ++i) {
                                            if (!"name".equals(AGTQRXMLStreamer.this.xml.getAttributeLocalName(i))) continue;
                                            this.bindingNames.add(AGTQRXMLStreamer.this.xml.getAttributeValue(i));
                                        }
                                        break block1;
                                    }
                                    case "sparql": {
                                        break block1;
                                    }
                                    default: {
                                        throw new RuntimeException("Unexpected tag: " + AGTQRXMLStreamer.this.xml.getLocalName());
                                    }
                                }
                            }
                            case 2: {
                                if (!"head".equals(AGTQRXMLStreamer.this.xml.getLocalName())) break;
                                return;
                            }
                        }
                    }
                }
                catch (XMLStreamException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public List<String> getBindingNames() {
            this.parseBindingNames();
            return this.bindingNames;
        }

        public boolean hasNext() throws QueryEvaluationException {
            if (this.next == null) {
                if (this.closed) {
                    return false;
                }
                this.parseBindingNames();
                try {
                    String bindingName = null;
                    while (AGTQRXMLStreamer.this.xml.hasNext()) {
                        int event = AGTQRXMLStreamer.this.xml.next();
                        if (AGTQRXMLStreamer.this.xml.isStartElement()) {
                            String name = AGTQRXMLStreamer.this.xml.getLocalName();
                            if ("result".equals(name)) {
                                this.next = new MapBindingSet(this.bindingNames.size());
                                continue;
                            }
                            if ("results".equals(AGTQRXMLStreamer.this.xml.getLocalName())) continue;
                            if ("binding".equals(name)) {
                                for (int i = 0; i < AGTQRXMLStreamer.this.xml.getAttributeCount(); ++i) {
                                    if (!"name".equals(AGTQRXMLStreamer.this.xml.getAttributeLocalName(i))) continue;
                                    bindingName = AGTQRXMLStreamer.this.xml.getAttributeValue(i);
                                }
                                continue;
                            }
                            if ("literal".equals(name)) {
                                Literal value;
                                String lang = null;
                                String datatype = null;
                                for (int i = 0; i < AGTQRXMLStreamer.this.xml.getAttributeCount(); ++i) {
                                    if ("lang".equals(AGTQRXMLStreamer.this.xml.getAttributeLocalName(i)) && "http://www.w3.org/XML/1998/namespace".equals(AGTQRXMLStreamer.this.xml.getAttributeNamespace(i))) {
                                        lang = AGTQRXMLStreamer.this.xml.getAttributeValue(i);
                                        continue;
                                    }
                                    if (!"datatype".equals(AGTQRXMLStreamer.this.xml.getAttributeLocalName(i))) continue;
                                    datatype = AGTQRXMLStreamer.this.xml.getAttributeValue(i);
                                }
                                String text = AGTQRXMLStreamer.this.xml.getElementText();
                                if (datatype != null) {
                                    try {
                                        value = AGTQRXMLStreamer.this.vf.createLiteral(text, AGTQRXMLStreamer.this.vf.createIRI(datatype));
                                    }
                                    catch (IllegalArgumentException e) {
                                        throw new QueryEvaluationException(e.getMessage(), (Throwable)e);
                                    }
                                } else {
                                    value = lang != null ? AGTQRXMLStreamer.this.vf.createLiteral(text, lang) : AGTQRXMLStreamer.this.vf.createLiteral(text);
                                }
                                this.next.addBinding(bindingName, (Value)value);
                                continue;
                            }
                            if ("uri".equals(name)) {
                                this.next.addBinding(bindingName, (Value)AGHttpRepoClient.getApplicationResource((Resource)AGTQRXMLStreamer.this.vf.createIRI(AGTQRXMLStreamer.this.xml.getElementText()), AGTQRXMLStreamer.this.vf));
                                continue;
                            }
                            if ("bnode".equals(name)) {
                                this.next.addBinding(bindingName, (Value)AGTQRXMLStreamer.this.vf.createBNode(AGTQRXMLStreamer.this.xml.getElementText()));
                                continue;
                            }
                            AGTQRXMLStreamer.this.log.warn("unknown elem: " + name + " attrs=" + AGTQRXMLStreamer.this.xml.getAttributeCount());
                            continue;
                        }
                        if (AGTQRXMLStreamer.this.xml.isEndElement()) {
                            if ("result".equals(AGTQRXMLStreamer.this.xml.getLocalName())) {
                                return this.next != null;
                            }
                            if ("results".equals(AGTQRXMLStreamer.this.xml.getLocalName())) {
                                this.close();
                                return false;
                            }
                            if ("sparql".equals(AGTQRXMLStreamer.this.xml.getLocalName())) {
                                this.close();
                                return false;
                            }
                            if ("binding".equals(AGTQRXMLStreamer.this.xml.getLocalName())) continue;
                            AGTQRXMLStreamer.this.log.warn("unknown elem end: " + AGTQRXMLStreamer.this.xml.getLocalName());
                            continue;
                        }
                        if (event != 8) continue;
                        this.close();
                        return false;
                    }
                }
                catch (XMLStreamException e) {
                    throw new QueryEvaluationException((Throwable)e);
                }
            }
            return this.next != null;
        }

        public BindingSet next() throws QueryEvaluationException {
            if (this.hasNext()) {
                MapBindingSet curr = this.next;
                this.next = null;
                return curr;
            }
            if (this.closed) {
                throw new IllegalStateException("closed");
            }
            throw new NoSuchElementException();
        }

        public void close() throws QueryEvaluationException {
            if (!this.closed) {
                this.closed = true;
                try {
                    AGTQRXMLStreamer.this.method.getResponseBodyAsStream().close();
                    AGTQRXMLStreamer.this.method.releaseConnection();
                }
                catch (IOException e) {
                    throw new QueryEvaluationException("I/O error closing resources", (Throwable)e);
                }
            }
        }

        public void remove() throws QueryEvaluationException {
            throw new UnsupportedOperationException();
        }
    }
}

