/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.jena.AGCapabilities;
import com.franz.agraph.jena.AGGraphMaker;
import com.franz.agraph.jena.AGPrefixMapping;
import com.franz.agraph.jena.AGTransactionHandler;
import com.franz.agraph.jena.AGTripleIterator;
import com.franz.agraph.repository.AGBooleanQuery;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGValueFactory;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEvents;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphBase;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.DatasetImpl;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;

public class AGGraph
extends GraphBase
implements Graph,
Closeable {
    protected final AGGraphMaker maker;
    protected final Node graphNode;
    protected final Resource context;
    protected final Resource[] contexts;
    protected AGRepositoryConnection conn;
    protected AGValueFactory vf;
    protected String entailmentRegime = "false";

    AGGraph(AGGraphMaker maker, Node graphNode) {
        this.maker = maker;
        this.graphNode = graphNode;
        this.conn = maker.getRepositoryConnection();
        this.vf = this.conn.getValueFactory();
        this.context = this.vf.asResource(graphNode);
        this.contexts = new Resource[]{this.context};
    }

    AGGraph(AGGraphMaker maker, Resource context, Resource ... contexts) {
        this.maker = maker;
        this.graphNode = null;
        this.conn = maker.getRepositoryConnection();
        this.vf = this.conn.getValueFactory();
        this.context = context;
        this.contexts = contexts;
    }

    public static String toString(String prefix, Graph graph) {
        StringBuilder b = new StringBuilder(prefix + " {");
        String gap = "";
        ExtendedIterator it = GraphUtil.findAll((Graph)graph);
        while (it.hasNext()) {
            b.append(gap);
            gap = "; ";
            b.append(((Triple)it.next()).toString());
        }
        b.append("}");
        return b.toString();
    }

    AGGraphMaker getGraphMaker() {
        return this.maker;
    }

    Node getGraphNode() {
        return this.graphNode;
    }

    public String getName() {
        if (this.graphNode == null) {
            return "default-graph";
        }
        return this.graphNode.toString();
    }

    Resource getGraphContext() {
        return this.context;
    }

    Resource[] getGraphContexts() {
        return this.contexts;
    }

    AGRepositoryConnection getConnection() {
        return this.conn;
    }

    String getEntailmentRegime() {
        return this.entailmentRegime;
    }

    public Capabilities getCapabilities() {
        if (this.capabilities == null) {
            this.capabilities = new AGCapabilities();
        }
        return this.capabilities;
    }

    public PrefixMapping getPrefixMapping() {
        return new AGPrefixMapping(this);
    }

    public TransactionHandler getTransactionHandler() {
        return new AGTransactionHandler(this);
    }

    public String toString() {
        return AGGraph.toString(this.getName() + (this.closed ? " (closed) " : " (size: " + this.graphBaseSize() + ")."), this);
    }

    protected Dataset getDataset() {
        DatasetImpl dataset = new DatasetImpl();
        if (Arrays.stream(this.contexts).anyMatch(Objects::nonNull)) {
            for (Resource c : this.contexts) {
                if (c == null) {
                    dataset.addDefaultGraph(null);
                    continue;
                }
                if (!(c instanceof IRI)) continue;
                dataset.addDefaultGraph((IRI)c);
                dataset.addNamedGraph((IRI)c);
            }
        }
        return dataset;
    }

    protected ExtendedIterator<Triple> graphBaseFind(Triple m) {
        RepositoryResult result;
        try {
            Node s = m.getMatchSubject();
            Node p = m.getMatchPredicate();
            Node o = m.getMatchObject();
            if (s != null && s.isLiteral() || p != null && (p.isLiteral() || p.isBlank())) {
                result = this.conn.createRepositoryResult(new ArrayList());
            } else {
                StatementCollector collector = new StatementCollector();
                this.conn.prepareHttpRepoClient().getStatements(this.vf.asResource(s), this.vf.asURI(p), this.vf.asValue(o), this.entailmentRegime, (RDFHandler)collector, this.contexts);
                result = this.conn.createRepositoryResult(collector.getStatements());
            }
        }
        catch (AGHttpException | RDFHandlerException e) {
            throw new RuntimeException((Throwable)e);
        }
        return new AGTripleIterator(this, result);
    }

    public void performAdd(Triple t) {
        try {
            AGRepositoryConnection conn = this.maker.getRepositoryConnection();
            AGValueFactory vf = conn.getValueFactory();
            conn.add(vf.asResource(t.getSubject()), vf.asURI(t.getPredicate()), vf.asValue(t.getObject()), this.context);
        }
        catch (UnauthorizedException e) {
            throw new AddDeniedException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public void performDelete(Triple t) {
        try {
            this.conn.remove(this.vf.asResource(t.getSubject()), this.vf.asURI(t.getPredicate()), this.vf.asValue(t.getObject()), this.contexts);
        }
        catch (UnauthorizedException e) {
            throw new DeleteDeniedException(e.getMessage());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    protected int graphBaseSize() {
        int size;
        try {
            size = (int)this.conn.size(this.contexts);
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
        return size;
    }

    public boolean isEmpty() {
        String queryString = "ask {?s ?p ?o}";
        AGBooleanQuery bq = this.conn.prepareBooleanQuery(QueryLanguage.SPARQL, queryString);
        bq.setDataset(this.getDataset());
        try {
            return !bq.evaluate();
        }
        catch (QueryEvaluationException e) {
            throw new RuntimeException(e);
        }
    }

    public void clear() {
        this.conn.remove((Resource)null, null, null, new Resource[0]);
        this.getEventManager().notifyEvent((Graph)this, (Object)GraphEvents.removeAll);
    }

    public void remove(Node s, Node p, Node o) {
        this.conn.remove(this.vf.asResource(s), this.vf.asURI(p), this.vf.asValue(o), new Resource[0]);
        this.getEventManager().notifyEvent((Graph)this, (Object)GraphEvents.remove((Node)s, (Node)p, (Node)o));
    }
}

