/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.jena;

import com.franz.agraph.jena.AGModel;
import com.franz.agraph.jena.AGNodeFactory;
import java.util.Iterator;
import org.apache.jena.graph.Node;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;

public class AGQuerySolution
implements QuerySolution {
    private final BindingSet bs;
    private final AGModel model;

    public AGQuerySolution(BindingSet bs, AGModel model) {
        this.bs = bs;
        this.model = model;
    }

    public boolean contains(String varName) {
        return this.bs.hasBinding(varName);
    }

    public RDFNode get(String varName) {
        Value val = this.bs.getValue(varName);
        if (val == null) {
            return null;
        }
        Node node = AGNodeFactory.asNode(val);
        return this.model.asRDFNode(node);
    }

    public Literal getLiteral(String varName) {
        return (Literal)this.get(varName);
    }

    public Resource getResource(String varName) {
        return (Resource)this.get(varName);
    }

    public Iterator<String> varNames() {
        return this.bs.getBindingNames().iterator();
    }

    public String toString() {
        return this.bs.toString();
    }
}

