/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.pool;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGHttpRepoClient;
import com.franz.agraph.pool.AGConnConfig;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServer;
import java.net.ConnectException;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AGConnFactory
extends BasePooledObjectFactory<AGRepositoryConnection>
implements PooledObjectFactory<AGRepositoryConnection> {
    private static final Logger log = LoggerFactory.getLogger(AGConnFactory.class);
    private final AGConnConfig props;

    public AGConnFactory(AGConnConfig props) {
        this.props = props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AGRepositoryConnection create() throws Exception {
        AGRepository repo;
        HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        if (this.props.httpSocketTimeout != null) {
            params.setSoTimeout(this.props.httpSocketTimeout.intValue());
        }
        AGHTTPClient httpClient = new AGHTTPClient(this.props.serverUrl, params);
        AGServer server = new AGServer(this.props.username, this.props.password, httpClient);
        AGCatalog catalog = this.props.catalog != null ? server.getCatalog(this.props.catalog) : server.getRootCatalog();
        if (!catalog.hasRepository(this.props.repository)) {
            AGConnFactory aGConnFactory = this;
            synchronized (aGConnFactory) {
                repo = catalog.createRepository(this.props.repository, false);
            }
        } else {
            repo = new AGRepository(catalog, this.props.repository);
            repo.initialize();
        }
        AGRepositoryConnection conn = repo.getConnection();
        if (this.props.sessionLifetime != null) {
            conn.setSessionLifetime(this.props.sessionLifetime);
        }
        return conn;
    }

    public PooledObject<AGRepositoryConnection> wrap(AGRepositoryConnection conn) {
        return new DefaultPooledObject((Object)conn);
    }

    public void activateObject(PooledObject<AGRepositoryConnection> pooled) throws RepositoryException {
        AGRepositoryConnection conn = (AGRepositoryConnection)pooled.getObject();
        if (!conn.isAutoCommit()) {
            conn.rollback();
        }
        switch (this.props.session) {
            case SHARED: {
                if (conn.isAutoCommit()) break;
                conn.setAutoCommit(true);
                log.debug("Dedicated (not shared) backend: " + conn.prepareHttpRepoClient().getRoot());
                break;
            }
            case DEDICATED: {
                if (conn.prepareHttpRepoClient().isDedicatedSession() && conn.isAutoCommit()) break;
                conn.setAutoCommit(true);
                log.debug("Dedicated backend: " + conn.prepareHttpRepoClient().getRoot());
                break;
            }
            case TX: {
                if (!conn.isAutoCommit()) break;
                conn.setAutoCommit(false);
                log.debug("TX dedicated backend: " + conn.prepareHttpRepoClient().getRoot());
            }
        }
    }

    public boolean validateObject(PooledObject<AGRepositoryConnection> pooled) {
        AGRepositoryConnection conn = (AGRepositoryConnection)pooled.getObject();
        try {
            AGHttpRepoClient client = conn.prepareHttpRepoClient();
            client.setSendRollbackHeader(true);
            conn.size(new Resource[0]);
            client.setSendRollbackHeader(false);
            return true;
        }
        catch (Exception e) {
            log.debug("validateObject " + conn, (Throwable)e);
            return false;
        }
    }

    public void destroyObject(PooledObject<AGRepositoryConnection> pooled) {
        AGRepositoryConnection conn = (AGRepositoryConnection)pooled.getObject();
        conn.setPool(null);
        try {
            conn.close();
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof ConnectException && cause.getMessage().equals("Connection refused")) {
                log.debug("ignoring close error (probably session timeout): " + conn, (Throwable)e);
            }
            throw e;
        }
        conn.getRepository().shutDown();
        conn.getServer().close();
    }
}

