/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.franz.agraph.http.AGHTTPClient;
import com.franz.agraph.http.AGProtocol;
import com.franz.agraph.http.exception.AGHttpException;
import com.franz.agraph.http.handler.AGJSONArrayHandler;
import com.franz.agraph.http.handler.AGRawStreamer;
import com.franz.agraph.repository.AGAbstractRepository;
import com.franz.agraph.repository.AGCatalog;
import com.franz.agraph.repository.AGRepository;
import com.franz.agraph.repository.AGRepositoryConnection;
import com.franz.agraph.repository.AGServerVersion;
import com.franz.agraph.repository.AGVirtualRepository;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.json.JSONArray;

public class AGServer
implements Closeable {
    public static final int DEFAULT_HTTP_PORT = 10035;
    public static final int DEFAULT_HTTPS_PORT = 10036;
    private static final int THREAD_POOL_SIZE = 4;
    private static ScheduledThreadPoolExecutor sharedExecutor;
    private final String serverURL;
    private final String user;
    private final String password;
    private final AGHTTPClient httpClient;
    private final AGCatalog rootCatalog;
    private ScheduledExecutorService executor = AGServer.getSharedExecutor();
    private AGServerVersion cachedServerVersion;

    public AGServer(String serverURL, String username, String password) {
        this.serverURL = serverURL.replaceAll("/$", "");
        this.user = username;
        this.password = password;
        this.httpClient = new AGHTTPClient(this.serverURL);
        this.httpClient.setUsernameAndPassword(username, password);
        this.rootCatalog = new AGCatalog(this, 0);
    }

    public AGServer(String username, String password, AGHTTPClient httpClient) {
        this.serverURL = httpClient.getServerURL();
        this.user = username;
        this.password = password;
        this.httpClient = httpClient;
        this.httpClient.setUsernameAndPassword(username, password);
        this.rootCatalog = new AGCatalog(this, 0);
    }

    public AGServer(AGHTTPClient httpClient) {
        this.serverURL = httpClient.getServerURL();
        String[] userInfo = httpClient.getUsernameAndPassword();
        this.user = userInfo[0];
        this.password = userInfo[1];
        this.httpClient = httpClient;
        this.rootCatalog = new AGCatalog(this, 0);
    }

    public AGServer(String serverURL) {
        this.serverURL = serverURL.replaceAll("/$", "");
        this.httpClient = new AGHTTPClient(serverURL);
        this.user = null;
        this.password = null;
        this.rootCatalog = new AGCatalog(this, 0);
    }

    private static synchronized ScheduledExecutorService getSharedExecutor() {
        if (sharedExecutor == null) {
            sharedExecutor = new ScheduledThreadPoolExecutor(4);
            sharedExecutor.setThreadFactory(runnable -> {
                Thread thread = Executors.defaultThreadFactory().newThread(runnable);
                thread.setDaemon(true);
                return thread;
            });
            sharedExecutor.setRemoveOnCancelPolicy(true);
        }
        return sharedExecutor;
    }

    public static AGRepository createRepository(String repoName, String catalogName, String serverURL, String username, String password) throws RepositoryException {
        return new AGServer(serverURL, username, password).createRepository(repoName, catalogName);
    }

    public static AGRepositoryConnection createRepositoryConnection(String repoName, String catalogName, String serverURL, String username, String password) throws RepositoryException {
        return AGServer.createRepository(repoName, catalogName, serverURL, username, password).getConnection();
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public AGHTTPClient getHTTPClient() {
        return this.httpClient;
    }

    public String getVersion() throws AGHttpException {
        return this.getHTTPClient().getString(this.serverURL + "/version");
    }

    public AGServerVersion getComparableVersion() throws AGHttpException {
        if (this.cachedServerVersion == null) {
            this.cachedServerVersion = new AGServerVersion(this.getVersion());
        }
        return this.cachedServerVersion;
    }

    public String getBuildDate() throws AGHttpException {
        return this.getHTTPClient().getString(this.serverURL + "/version/date");
    }

    public String getRevision() throws AGHttpException {
        return this.getHTTPClient().getString(this.serverURL + "/version/revision");
    }

    public AGCatalog getRootCatalog() {
        return this.rootCatalog;
    }

    public List<String> listCatalogs() throws AGHttpException {
        String url = AGProtocol.getNamedCatalogsURL(this.serverURL);
        TupleQueryResult tqresult = this.getHTTPClient().getTupleQueryResult(url);
        ArrayList<String> result = new ArrayList<String>(5);
        try {
            while (tqresult.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqresult.next();
                Value id = bindingSet.getValue("id");
                result.add(id.stringValue());
            }
        }
        catch (QueryEvaluationException e) {
            throw new AGHttpException((Exception)((Object)e));
        }
        return result;
    }

    public AGCatalog getCatalog(String catalogID) throws AGHttpException {
        if (AGCatalog.isRootID(catalogID)) {
            return this.rootCatalog;
        }
        if (this.listCatalogs().contains(catalogID)) {
            return new AGCatalog(this, catalogID);
        }
        return null;
    }

    public AGCatalog getCatalog() {
        return this.rootCatalog;
    }

    public AGCatalog createCatalog(String catalogID) throws AGHttpException {
        AGCatalog catalog = this.getCatalog(catalogID);
        if (catalog == null) {
            String catalogURL = AGProtocol.getNamedCatalogLocation(this.getServerURL(), catalogID);
            this.getHTTPClient().putCatalog(catalogURL);
            catalog = new AGCatalog(this, catalogID);
        }
        return catalog;
    }

    public void deleteCatalog(String catalogID) throws AGHttpException {
        String catalogURL = AGProtocol.getNamedCatalogLocation(this.getServerURL(), catalogID);
        this.getHTTPClient().deleteCatalog(catalogURL);
    }

    public AGVirtualRepository virtualRepository(String storeSpec) {
        return new AGVirtualRepository(this, storeSpec, null);
    }

    public AGVirtualRepository federate(AGAbstractRepository ... repositories) {
        String[] specstrings = new String[repositories.length];
        for (int i = 0; i < repositories.length; ++i) {
            specstrings[i] = repositories[i].getSpec();
        }
        String spec = AGVirtualRepository.federatedSpec(specstrings);
        return new AGVirtualRepository(this, spec, null);
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public List<String> listUsers() throws AGHttpException {
        return this.getHTTPClient().getListOfStrings(this.serverURL + "/users");
    }

    public void addUser(String user, String password) throws AGHttpException {
        String url = this.serverURL + "/users/" + user;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("password", password)};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void deleteUser(String user) throws AGHttpException {
        String url = this.serverURL + "/users/" + user;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public void addUserAccess(String user, boolean read, boolean write, String catalog, String repository) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/access";
        Header[] headers = new Header[]{};
        if (catalog == null) {
            catalog = "*";
        }
        if (repository == null) {
            repository = "*";
        }
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("read", Boolean.toString(read)), new NameValuePair("write", Boolean.toString(write)), new NameValuePair("catalog", catalog), new NameValuePair("repository", repository)};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void deleteUserAccess(String user, boolean read, boolean write, String catalog, String repository) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/access";
        Header[] headers = new Header[]{};
        if (catalog == null) {
            catalog = "*";
        }
        if (repository == null) {
            repository = "*";
        }
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("read", Boolean.toString(read)), new NameValuePair("write", Boolean.toString(write)), new NameValuePair("catalog", catalog), new NameValuePair("repository", repository)};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public JSONArray listUserAccess(String user) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/access";
        Header[] headers = new Header[]{new Header("Accept", "application/json")};
        NameValuePair[] params = new NameValuePair[]{};
        AGJSONArrayHandler handler = new AGJSONArrayHandler();
        this.getHTTPClient().get(url, headers, params, handler);
        return handler.getResult();
    }

    public void addUserSecurityFilter(String user, String type, String s, String p, String o, String g) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/security-filters/" + type;
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(4);
        if (s != null) {
            params.add(new NameValuePair("s", s));
        }
        if (p != null) {
            params.add(new NameValuePair("p", p));
        }
        if (o != null) {
            params.add(new NameValuePair("o", o));
        }
        if (g != null) {
            params.add(new NameValuePair("g", g));
        }
        this.getHTTPClient().post(url, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public void deleteUserSecurityFilter(String user, String type, String s, String p, String o, String g) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/security-filters/" + type;
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(4);
        if (s != null) {
            params.add(new NameValuePair("s", s));
        }
        if (p != null) {
            params.add(new NameValuePair("p", p));
        }
        if (o != null) {
            params.add(new NameValuePair("o", o));
        }
        if (g != null) {
            params.add(new NameValuePair("g", g));
        }
        this.getHTTPClient().post(url, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public JSONArray listUserSecurityFilters(String user, String type) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/security-filters/" + type;
        Header[] headers = new Header[]{new Header("Accept", "application/json")};
        NameValuePair[] params = new NameValuePair[]{};
        AGJSONArrayHandler handler = new AGJSONArrayHandler();
        this.getHTTPClient().get(url, headers, params, handler);
        return handler.getResult();
    }

    public void changeUserPassword(String user, String password) {
    }

    public JSONArray listUserEffectiveAccess(String user) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/effectiveAccess";
        Header[] headers = new Header[]{new Header("Accept", "application/json")};
        NameValuePair[] params = new NameValuePair[]{};
        AGJSONArrayHandler handler = new AGJSONArrayHandler();
        this.getHTTPClient().get(url, headers, params, handler);
        return handler.getResult();
    }

    public List<String> listUserPermissions(String user) throws AGHttpException {
        return this.getHTTPClient().getListOfStrings(this.serverURL + "/users/" + user + "/permissions");
    }

    public List<String> listUserEffectivePermissions(String user) throws AGHttpException {
        return this.getHTTPClient().getListOfStrings(this.serverURL + "/users/" + user + "/effectivePermissions");
    }

    public void addUserPermission(String user, String permission) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/permissions/" + permission;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void deleteUserPermission(String user, String permission) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/permissions/" + permission;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public List<String> listRoles() throws AGHttpException {
        return this.getHTTPClient().getListOfStrings(this.serverURL + "/roles");
    }

    public void addRole(String role) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void addRoleAccess(String role, boolean read, boolean write, String catalog, String repository) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/access";
        Header[] headers = new Header[]{};
        if (catalog == null) {
            catalog = "*";
        }
        if (repository == null) {
            repository = "*";
        }
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("read", Boolean.toString(read)), new NameValuePair("write", Boolean.toString(write)), new NameValuePair("catalog", catalog), new NameValuePair("repository", repository)};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public JSONArray listRoleAccess(String role) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/access";
        Header[] headers = new Header[]{new Header("Accept", "application/json")};
        NameValuePair[] params = new NameValuePair[]{};
        AGJSONArrayHandler handler = new AGJSONArrayHandler();
        this.getHTTPClient().get(url, headers, params, handler);
        return handler.getResult();
    }

    public void addRoleSecurityFilter(String role, String type, String s, String p, String o, String g) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/security-filters/" + type;
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(4);
        if (s != null) {
            params.add(new NameValuePair("s", s));
        }
        if (p != null) {
            params.add(new NameValuePair("p", p));
        }
        if (o != null) {
            params.add(new NameValuePair("o", o));
        }
        if (g != null) {
            params.add(new NameValuePair("g", g));
        }
        this.getHTTPClient().post(url, headers, params.toArray(new NameValuePair[params.size()]), null, null);
    }

    public JSONArray listRoleSecurityFilters(String role, String type) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/security-filters/" + type;
        Header[] headers = new Header[]{new Header("Accept", "application/json")};
        NameValuePair[] params = new NameValuePair[]{};
        AGJSONArrayHandler handler = new AGJSONArrayHandler();
        this.getHTTPClient().get(url, headers, params, handler);
        return handler.getResult();
    }

    public void deleteRoleSecurityFilter(String role, String type, String s, String p, String o, String g) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/security-filters/" + type;
        Header[] headers = new Header[]{};
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(4);
        if (s != null) {
            params.add(new NameValuePair("s", s));
        }
        if (p != null) {
            params.add(new NameValuePair("p", p));
        }
        if (o != null) {
            params.add(new NameValuePair("o", o));
        }
        if (g != null) {
            params.add(new NameValuePair("g", g));
        }
        this.getHTTPClient().delete(url, headers, params.toArray(new NameValuePair[params.size()]), null);
    }

    public List<String> listUserRoles(String user) throws AGHttpException {
        return this.getHTTPClient().getListOfStrings(this.serverURL + "/users/" + user + "/roles");
    }

    public void addUserRole(String user, String role) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/roles/" + role;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void deleteUserRole(String user, String role) throws AGHttpException {
        String url = this.serverURL + "/users/" + user + "/roles/" + role;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public void deleteRoleAccess(String role, boolean read, boolean write, String catalog, String repository) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/access";
        Header[] headers = new Header[]{};
        if (catalog == null) {
            catalog = "*";
        }
        if (repository == null) {
            repository = "*";
        }
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("read", Boolean.toString(read)), new NameValuePair("write", Boolean.toString(write)), new NameValuePair("catalog", catalog), new NameValuePair("repository", repository)};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public void deleteRole(String role) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public void addRolePermission(String role, String permission) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/permissions/" + permission;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().put(url, headers, params, null, null);
    }

    public void deleteRolePermission(String role, String permission) throws AGHttpException {
        String url = this.serverURL + "/roles/" + role + "/permissions/" + permission;
        Header[] headers = new Header[]{};
        NameValuePair[] params = new NameValuePair[]{};
        this.getHTTPClient().delete(url, headers, params, null);
    }

    public List<String> listRolePermissions(String role) throws AGHttpException {
        return this.getHTTPClient().getListOfStrings(this.serverURL + "/roles/" + role + "/permissions");
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public AGRepository createRepository(String reponame, AGCatalog catalog, boolean strict) throws RepositoryException {
        AGRepository repo = catalog.createRepository(reponame.trim(), strict);
        repo.initialize();
        return repo;
    }

    public AGRepository createRepository(String reponame, String catname, boolean strict) throws RepositoryException {
        if (catname == null || catname.trim().isEmpty()) {
            return this.createRepository(reponame, this.rootCatalog, strict);
        }
        AGCatalog cat = this.getCatalog(catname);
        if (cat == null) {
            throw new RepositoryException("Unable to create repository " + catname + "/" + reponame + " because " + catname + " does not exist.");
        }
        return this.createRepository(reponame, cat, strict);
    }

    public AGRepository createRepository(String reponame, String catname) throws RepositoryException {
        return this.createRepository(reponame, catname, false);
    }

    public AGRepository createRepository(String reponame) throws RepositoryException {
        return this.createRepository(reponame, this.rootCatalog, false);
    }

    public AGRepositoryConnection createRepositoryConnection(String reponame, AGCatalog cat, boolean strict) throws RepositoryException {
        return this.createRepository(reponame, cat, strict).getConnection();
    }

    public AGRepositoryConnection createRepositoryConnection(String reponame, String catname, boolean strict) throws RepositoryException {
        return this.createRepository(reponame, catname, strict).getConnection();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLogFile() throws AGHttpException {
        try (Reader reader = this.readLogFile();){
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new AGHttpException(e);
        }
    }

    public Reader readLogFile() {
        String url = AGProtocol.getLogLocation(this.serverURL);
        NameValuePair[] params = new NameValuePair[]{new NameValuePair("all", "true")};
        AGRawStreamer handler = new AGRawStreamer();
        this.getHTTPClient().get(url, null, params, handler);
        return new InputStreamReader(handler.getStream(), StandardCharsets.UTF_8);
    }
}

