/*
 * Decompiled with CFR 0.152.
 */
package com.franz.agraph.repository;

import com.atomikos.datasource.ResourceException;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.franz.agraph.repository.AGRepository;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.transaction.xa.XAResource;
import org.apache.commons.codec.binary.Hex;

public class AGTransactionalResource
extends XATransactionalResource {
    private final AGRepository repo;

    public AGTransactionalResource(AGRepository repo) throws NoSuchAlgorithmException {
        super(AGTransactionalResource.repoToHash(repo));
        this.repo = repo;
    }

    private static String repoToHash(AGRepository repo) throws NoSuchAlgorithmException {
        String repoUrl = repo.getRepositoryURL();
        byte[] repoUrlEncoded = repoUrl.getBytes(StandardCharsets.UTF_8);
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        return new String(Hex.encodeHex((byte[])md5.digest(repoUrlEncoded)));
    }

    protected XAResource refreshXAConnection() throws ResourceException {
        return this.repo.getConnection().getXAResource();
    }
}

