/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.junit;

import com.galenframework.api.Galen;
import com.galenframework.browser.Browser;
import com.galenframework.browser.SeleniumBrowserFactory;
import com.galenframework.junit.Exclude;
import com.galenframework.junit.Include;
import com.galenframework.junit.Size;
import com.galenframework.junit.Spec;
import com.galenframework.junit.Url;
import com.galenframework.speclang2.pagespec.SectionFilter;
import com.galenframework.specs.page.PageSection;
import com.galenframework.suite.GalenPageAction;
import com.galenframework.validation.PageValidation;
import com.galenframework.validation.ValidationListener;
import com.galenframework.validation.ValidationResult;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;

public class GalenSpecRunner
extends Runner {
    private static final Map<String, Object> NO_JS_VARIABLES = Collections.emptyMap();
    private static final Properties NO_PROPERTIES = new Properties();
    private static final File NO_SCREENSHOT = null;
    private static final List<String> NO_TAGS = Collections.emptyList();
    private Class<?> testClass;

    public GalenSpecRunner(Class<?> testClass) throws InitializationError {
        this.testClass = testClass;
    }

    public Description getDescription() {
        return Description.createSuiteDescription(this.testClass);
    }

    public void run(RunNotifier notifier) {
        try {
            Dimension windowsSize = this.getWindowSize();
            String specPath = this.getSpecPath();
            String pageUrl = this.getUrl();
            SectionFilter sectionFilter = this.getSectionFilter();
            this.run(notifier, windowsSize, sectionFilter, specPath, pageUrl);
        }
        catch (Throwable e) {
            Failure failure = new Failure(this.getDescription(), e);
            notifier.fireTestFailure(failure);
        }
    }

    private void run(RunNotifier notifier, Dimension windowsSize, SectionFilter sectionFilter, String specPath, String pageUrl) throws IOException {
        JUnitListener listener = new JUnitListener(notifier);
        this.run(listener, windowsSize, sectionFilter, specPath, pageUrl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(JUnitListener listener, Dimension windowsSize, SectionFilter sectionFilter, String specPath, String url) throws IOException {
        Browser browser = this.createBrowser();
        try {
            browser.load(url);
            browser.changeWindowSize(windowsSize);
            Galen.checkLayout((Browser)browser, (String)specPath, (SectionFilter)sectionFilter, (Properties)NO_PROPERTIES, NO_JS_VARIABLES, (File)NO_SCREENSHOT, (ValidationListener)listener);
        }
        finally {
            browser.quit();
        }
    }

    private Browser createBrowser() {
        return new SeleniumBrowserFactory().openBrowser();
    }

    private SectionFilter getSectionFilter() {
        return new SectionFilter(this.getIncludedTags(), this.getExcludedTags());
    }

    private List<String> getExcludedTags() {
        Exclude annotation = this.testClass.getAnnotation(Exclude.class);
        return annotation == null ? NO_TAGS : Arrays.asList(annotation.value());
    }

    private List<String> getIncludedTags() {
        Include annotation = this.testClass.getAnnotation(Include.class);
        return annotation == null ? NO_TAGS : Arrays.asList(annotation.value());
    }

    private String getSpecPath() {
        return this.getMandatoryAnnotation(Spec.class).value();
    }

    private String getUrl() {
        return this.getMandatoryAnnotation(Url.class).value();
    }

    private Dimension getWindowSize() {
        Size size = this.getMandatoryAnnotation(Size.class);
        return new Dimension(size.width(), size.height());
    }

    private <A extends Annotation> A getMandatoryAnnotation(Class<A> annotationType) {
        A annotation = this.testClass.getAnnotation(annotationType);
        if (annotation == null) {
            throw new IllegalStateException("The annotation @" + annotationType.getSimpleName() + " is missing.");
        }
        return annotation;
    }

    private static class JUnitListener
    implements ValidationListener {
        private final RunNotifier runNotifier;

        public JUnitListener(RunNotifier runNotifier) {
            this.runNotifier = runNotifier;
        }

        public void onObject(PageValidation pageValidation, String objectName) {
        }

        public void onAfterObject(PageValidation pageValidation, String objectName) {
        }

        public void onBeforeSpec(PageValidation pageValidation, String objectName, com.galenframework.specs.Spec spec) {
            Description description = this.createDescriptionForSpec(objectName, spec);
            this.runNotifier.fireTestStarted(description);
        }

        public void onSpecError(PageValidation pageValidation, String objectName, com.galenframework.specs.Spec spec, ValidationResult validationResult) {
            Description description = this.createDescriptionForSpec(objectName, spec);
            Failure failure = new Failure(description, (Throwable)((Object)new AssertionError(validationResult.getError().getMessages())));
            this.runNotifier.fireTestFailure(failure);
            this.runNotifier.fireTestFinished(description);
        }

        public void onSpecSuccess(PageValidation pageValidation, String objectName, com.galenframework.specs.Spec spec, ValidationResult validationResult) {
            Description description = this.createDescriptionForSpec(objectName, spec);
            this.runNotifier.fireTestFinished(description);
        }

        private Description createDescriptionForSpec(String objectName, com.galenframework.specs.Spec spec) {
            return Description.createTestDescription((String)objectName, (String)spec.getOriginalText(), (Annotation[])new Annotation[0]);
        }

        public void onGlobalError(Exception e) {
        }

        public void onBeforePageAction(GalenPageAction action) {
        }

        public void onAfterPageAction(GalenPageAction action) {
        }

        public void onBeforeSection(PageValidation pageValidation, PageSection pageSection) {
        }

        public void onAfterSection(PageValidation pageValidation, PageSection pageSection) {
        }

        public void onSubLayout(PageValidation pageValidation, String objectName) {
        }

        public void onAfterSubLayout(PageValidation pageValidation, String objectName) {
        }

        public void onSpecGroup(PageValidation pageValidation, String specGroupName) {
        }

        public void onAfterSpecGroup(PageValidation pageValidation, String specGroupName) {
        }
    }
}

