/*
 * Decompiled with CFR 0.152.
 */
package com.galenframework.support;

import com.galenframework.reports.GalenTestInfo;
import com.galenframework.reports.TestReport;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

public enum GalenReportsContainer {
    INSTANCE;

    private final List<GalenTestInfo> tests = new LinkedList<GalenTestInfo>();

    public static GalenReportsContainer get() {
        return INSTANCE;
    }

    public TestReport registerTest(Method method) {
        GalenTestInfo testInfo = GalenTestInfo.fromMethod((Method)method);
        this.tests.add(testInfo);
        return testInfo.getReport();
    }

    public TestReport registerTest(String name, List<String> groups) {
        GalenTestInfo testInfo = GalenTestInfo.fromString((String)name, groups);
        this.tests.add(testInfo);
        return testInfo.getReport();
    }

    public TestReport registerTest(GalenTestInfo testInfo) {
        this.tests.add(testInfo);
        return testInfo.getReport();
    }

    public List<GalenTestInfo> getAllTests() {
        return this.tests;
    }
}

