/*
 * Decompiled with CFR 0.152.
 */
package com.gengoai.python;

import com.gengoai.io.MonitoredObject;
import com.gengoai.io.ResourceMonitor;
import java.util.Map;
import jep.Jep;
import jep.SharedInterpreter;
import lombok.NonNull;

public final class PythonInterpreter
implements AutoCloseable {
    private final MonitoredObject<SharedInterpreter> interpreter;

    public PythonInterpreter() {
        this.interpreter = ResourceMonitor.monitor((Object)new SharedInterpreter());
    }

    public PythonInterpreter(@NonNull String initCode) {
        if (initCode == null) {
            throw new NullPointerException("initCode is marked non-null but is null");
        }
        this.interpreter = ResourceMonitor.monitor((Object)new SharedInterpreter(), Jep::close);
        ((SharedInterpreter)this.interpreter.object).exec(initCode);
    }

    public void exec(String pythonCode) {
        ((SharedInterpreter)this.interpreter.object).exec(pythonCode);
    }

    public boolean eval(String pythonCode) {
        return ((SharedInterpreter)this.interpreter.object).eval(pythonCode);
    }

    public void runScript(String script) {
        ((SharedInterpreter)this.interpreter.object).runScript(script);
    }

    public Object invoke(String function, Object ... objects) {
        return ((SharedInterpreter)this.interpreter.object).invoke(function, objects);
    }

    public Object invoke(String function, Map<String, Object> map) {
        return ((SharedInterpreter)this.interpreter.object).invoke(function, map);
    }

    public Object invoke(String function, Object[] objects, Map<String, Object> map) {
        return ((SharedInterpreter)this.interpreter.object).invoke(function, objects, map);
    }

    public Object getValue(String variable) {
        return ((SharedInterpreter)this.interpreter.object).getValue(variable);
    }

    public <T> T getValue(String variable, Class<T> tClass) {
        return (T)((SharedInterpreter)this.interpreter.object).getValue(variable, tClass);
    }

    public void setValue(String variable, Object value) {
        ((SharedInterpreter)this.interpreter.object).set(variable, value);
    }

    @Override
    public void close() throws Exception {
        ((SharedInterpreter)this.interpreter.object).close();
    }
}

