/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.tools.httpclient.client;

import cn.cliveyuan.tools.common.MapTools;
import cn.cliveyuan.tools.httpclient.HttpClientSingleton;
import cn.cliveyuan.tools.httpclient.bean.HttpClientRequest;
import cn.cliveyuan.tools.httpclient.bean.HttpClientResponse;
import cn.cliveyuan.tools.httpclient.bean.RequestContextTypeEnum;
import cn.cliveyuan.tools.httpclient.bean.RequestMethodEnum;
import cn.cliveyuan.tools.httpclient.client.HttpClient;
import cn.cliveyuan.tools.httpclient.ssl.SSL;
import cn.cliveyuan.tools.httpclient.ssl.TrustAnySSL;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.FormBody;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal.Util;
import okio.BufferedSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpHttpClient
implements HttpClient {
    private static final Logger log = LoggerFactory.getLogger(OkHttpHttpClient.class);

    @Override
    public HttpClientResponse request(HttpClientRequest httpClientRequest) {
        HttpClientResponse httpClientResponse = new HttpClientResponse();
        httpClientResponse.setResponse("");
        OkHttpClient okHttpClient = this.buildOkHttpClient(httpClientRequest);
        HttpUrl httpUrl = OkHttpHttpClient.getHttpUrl(httpClientRequest.getMethod(), httpClientRequest.getUrl(), httpClientRequest.getParams());
        RequestBody requestBody = null;
        if (!RequestMethodEnum.GET.equals((Object)httpClientRequest.getMethod())) {
            requestBody = this.buildRequestBody(httpClientRequest);
        }
        Request.Builder requestBuilder = new Request.Builder().method(httpClientRequest.getMethod().name(), requestBody).url(httpUrl);
        log.debug("HttpClient request: {}", (Object)httpClientRequest);
        Request request = OkHttpHttpClient.buildRequest(requestBuilder, httpClientRequest.getHeaders());
        Call call = okHttpClient.newCall(request);
        try (Response response = call.execute();){
            httpClientResponse.setStatusCode(response.code());
            httpClientResponse.setSuccessful(response.isSuccessful());
            ResponseBody responseBody = response.body();
            if (Objects.nonNull(responseBody)) {
                httpClientResponse.setResponse(this.handleResponse(httpClientRequest, responseBody));
            }
            Headers headers = response.headers();
            httpClientResponse.setHeaders(this.getResponseHeaders(headers));
            httpClientResponse.setCookies(this.getResponseCookies(headers));
        }
        catch (Exception e) {
            log.error("request error: httpClientRequest=" + httpClientRequest, (Throwable)e);
            throw new RuntimeException(e);
        }
        log.debug("HttpClient response: {}", (Object)httpClientResponse);
        return httpClientResponse;
    }

    private RequestBody buildRequestBody(HttpClientRequest httpClientRequest) {
        if (RequestContextTypeEnum.JSON.equals((Object)httpClientRequest.getContextType())) {
            return RequestBody.create((MediaType)httpClientRequest.getContextType().getMediaType(), (String)httpClientRequest.getRequestBody());
        }
        Map<String, Object> params = httpClientRequest.getParams();
        FormBody.Builder formBodyBuilder = new FormBody.Builder(StandardCharsets.UTF_8);
        if (MapTools.isNotEmpty(params)) {
            params.forEach((key, value) -> {
                if (Objects.isNull(key) || Objects.isNull(value)) {
                    return;
                }
                formBodyBuilder.add(key, value.toString());
            });
        }
        return formBodyBuilder.build();
    }

    private OkHttpClient buildOkHttpClient(HttpClientRequest httpClientRequest) {
        OkHttpClient okHttpClient = HttpClientSingleton.getOkHttpClient();
        if (httpClientRequest.getConnectTimeout() != null || httpClientRequest.getReadTimeout() != null || httpClientRequest.getWriteTimeout() != null || httpClientRequest.isIgnoreSslCertificate()) {
            OkHttpClient.Builder builder = okHttpClient.newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(3L, TimeUnit.MINUTES).writeTimeout(1L, TimeUnit.MINUTES).sslSocketFactory(SSL.sslSocketFactory, SSL.x509TrustManager).hostnameVerifier(SSL.hostnameVerifier);
            if (Objects.nonNull(httpClientRequest.getConnectTimeout())) {
                builder.connectTimeout(httpClientRequest.getConnectTimeout());
            }
            if (Objects.nonNull(httpClientRequest.getReadTimeout())) {
                builder.readTimeout(httpClientRequest.getReadTimeout());
            }
            if (Objects.nonNull(httpClientRequest.getWriteTimeout())) {
                builder.writeTimeout(httpClientRequest.getWriteTimeout());
            }
            if (httpClientRequest.isIgnoreSslCertificate()) {
                builder.sslSocketFactory(TrustAnySSL.sslSocketFactory, TrustAnySSL.x509TrustManager).hostnameVerifier(TrustAnySSL.hostnameVerifier);
            }
            return builder.build();
        }
        return okHttpClient;
    }

    private String handleResponse(HttpClientRequest httpClientRequest, ResponseBody responseBody) throws IOException {
        if (Objects.nonNull(httpClientRequest.getCharset())) {
            try (BufferedSource source = responseBody.source();){
                Charset charset = Util.bomAwareCharset((BufferedSource)source, (Charset)httpClientRequest.getCharset());
                String string = source.readString(charset);
                return string;
            }
        }
        return responseBody.string();
    }

    private Map<String, String> getResponseCookies(Headers headers) {
        HashMap<String, String> cookieMap = new HashMap<String, String>();
        String cookieString = headers.get("Set-Cookie");
        if (Objects.nonNull(cookieString)) {
            String[] pairs;
            for (String pair : pairs = cookieString.split(";")) {
                String[] kvs = pair.split("=");
                String key = kvs[0].trim();
                StringJoiner value = new StringJoiner("");
                if (kvs.length >= 2) {
                    for (int i = 1; i < kvs.length; ++i) {
                        value.add(kvs[i]);
                    }
                }
                cookieMap.put(key, value.toString());
            }
        }
        return cookieMap;
    }

    private Map<String, String> getResponseHeaders(Headers headers) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (int i = 0; i < headers.size(); ++i) {
            String name = headers.name(i);
            headerMap.put(name, headers.get(name));
        }
        return headerMap;
    }

    private static Request buildRequest(Request.Builder requestBuilder, Map<String, String> headers) {
        if (!headers.isEmpty()) {
            headers.forEach((key, value) -> {
                if (key != null && value != null) {
                    requestBuilder.addHeader(key, value);
                }
            });
        }
        return requestBuilder.build();
    }

    private static HttpUrl getHttpUrl(RequestMethodEnum method, String url, Map<String, Object> params) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (RequestMethodEnum.GET.equals((Object)method) && httpUrl != null && MapTools.isNotEmpty(params)) {
            HttpUrl.Builder httpUrlBuilder = httpUrl.newBuilder();
            params.forEach((key, value) -> {
                if (key != null && value != null) {
                    httpUrlBuilder.addQueryParameter(key, String.valueOf(value));
                }
            });
            return httpUrlBuilder.build();
        }
        return httpUrl;
    }
}

