/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.tools.httpclient;

import cn.cliveyuan.tools.common.StringTools;
import cn.cliveyuan.tools.common.ValidateTools;
import cn.cliveyuan.tools.httpclient.bean.HttpClientRequest;
import cn.cliveyuan.tools.httpclient.bean.HttpClientResponse;
import cn.cliveyuan.tools.httpclient.bean.RequestContextTypeEnum;
import cn.cliveyuan.tools.httpclient.bean.RequestMethodEnum;
import cn.cliveyuan.tools.httpclient.client.HttpClient;
import cn.cliveyuan.tools.httpclient.client.OkHttpHttpClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class HttpClientTools {
    private static final HttpClient HTTP_CLIENT = new OkHttpHttpClient();
    private static final String DEFAULT_HEADER = "Accept: */*\nAccept-Encoding: deflate\nAccept-Language: zh-CN,zh;q=0.9\nConnection: keep-alive\nUser-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.77 Safari/537.36\nX-Requested-With: XMLHttpRequest";

    public static String get(String url) {
        return HttpClientTools.request(HttpClientRequest.builder().url(url).build()).getResponse();
    }

    public static String get(String url, Map<String, String> headers) {
        return HttpClientTools.request(HttpClientRequest.builder().url(url).headers(headers).build()).getResponse();
    }

    public static String post(String url, Map<String, Object> paramMap) {
        return HttpClientTools.request(HttpClientRequest.builder().url(url).method(RequestMethodEnum.POST).params(paramMap).build()).getResponse();
    }

    public static String post(String url, Map<String, Object> paramMap, Map<String, String> headers) {
        return HttpClientTools.request(HttpClientRequest.builder().url(url).method(RequestMethodEnum.POST).headers(headers).params(paramMap).build()).getResponse();
    }

    public static String postJson(String url, String requestBody) {
        return HttpClientTools.request(HttpClientRequest.builder().url(url).method(RequestMethodEnum.POST).contextType(RequestContextTypeEnum.JSON).requestBody(requestBody).build()).getResponse();
    }

    public static String postJson(String url, String requestBody, Map<String, String> headers) {
        return HttpClientTools.request(HttpClientRequest.builder().url(url).method(RequestMethodEnum.POST).contextType(RequestContextTypeEnum.JSON).headers(headers).requestBody(requestBody).build()).getResponse();
    }

    public static HttpClientResponse request(HttpClientRequest request) {
        HttpClientTools.handleRequest(request);
        try {
            return HTTP_CLIENT.request(request);
        }
        catch (Exception e) {
            if (request.isIgnoreError()) {
                HttpClientResponse response = new HttpClientResponse();
                response.setStatusCode(-1);
                response.setSuccessful(false);
                response.setExceptionMsg(e.getMessage());
                return response;
            }
            throw new RuntimeException(e);
        }
    }

    private static void handleRequest(HttpClientRequest request) {
        ValidateTools.assertValidateEntity((Object)request);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (Objects.nonNull(request.getParams())) {
            params.putAll(request.getParams());
        }
        request.setParams(params);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (Objects.nonNull(request.getHeaders())) {
            headers.putAll(request.getHeaders());
        }
        request.setHeaders(headers);
        HashMap<String, String> cookies = new HashMap<String, String>();
        if (Objects.nonNull(request.getCookies())) {
            cookies.putAll(request.getCookies());
        }
        request.setCookies(cookies);
        if (request.isAddDefaultHeaders()) {
            request.getHeaders().putAll(StringTools.str2Map((String)DEFAULT_HEADER));
        }
        if (StringTools.isNotBlank((CharSequence)request.getKvParams())) {
            request.getParams().putAll(StringTools.str2Map((String)request.getKvParams()));
        }
        if (StringTools.isNotBlank((CharSequence)request.getKvHeaders())) {
            request.getHeaders().putAll(StringTools.str2Map((String)request.getKvHeaders()));
        }
        if (StringTools.isNotBlank((CharSequence)request.getKvCookies())) {
            request.getCookies().putAll(StringTools.str2Map((String)request.getKvCookies()));
        }
        if (!request.getCookies().isEmpty()) {
            request.getHeaders().put("Cookie", StringTools.map2CookieStr(request.getCookies()));
        }
        if (request.isAddDefaultReferer()) {
            request.getHeaders().put("Referer", request.getUrl());
        }
    }
}

