/*
 * Decompiled with CFR 0.152.
 */
package cn.cliveyuan.tools.httpclient.bean;

import cn.cliveyuan.tools.httpclient.bean.RequestContextTypeEnum;
import cn.cliveyuan.tools.httpclient.bean.RequestMethodEnum;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import okhttp3.OkHttpClient;

public class HttpClientRequest {
    @NotBlank(message="url can't be blank")
    private @NotBlank(message="url can't be blank") String url;
    @NotNull(message="method can't be null")
    private @NotNull(message="method can't be null") RequestMethodEnum method;
    @NotNull(message="contextType can't be null")
    private @NotNull(message="contextType can't be null") RequestContextTypeEnum contextType;
    private String requestBody;
    private Map<String, Object> params;
    private String kvParams;
    private Map<String, String> headers;
    private String kvHeaders;
    private Map<String, String> cookies;
    private String kvCookies;
    private Duration connectTimeout;
    private Duration readTimeout;
    private Duration writeTimeout;
    private boolean addDefaultHeaders;
    private boolean addDefaultReferer;
    private boolean ignoreSslCertificate;
    private Charset charset;
    private boolean ignoreError;
    private Consumer<OkHttpClient.Builder> customizedBuilderConsumer;

    private static RequestMethodEnum $default$method() {
        return RequestMethodEnum.GET;
    }

    private static RequestContextTypeEnum $default$contextType() {
        return RequestContextTypeEnum.FORM;
    }

    private static String $default$requestBody() {
        return "";
    }

    HttpClientRequest(String url, RequestMethodEnum method, RequestContextTypeEnum contextType, String requestBody, Map<String, Object> params, String kvParams, Map<String, String> headers, String kvHeaders, Map<String, String> cookies, String kvCookies, Duration connectTimeout, Duration readTimeout, Duration writeTimeout, boolean addDefaultHeaders, boolean addDefaultReferer, boolean ignoreSslCertificate, Charset charset, boolean ignoreError, Consumer<OkHttpClient.Builder> customizedBuilderConsumer) {
        this.url = url;
        this.method = method;
        this.contextType = contextType;
        this.requestBody = requestBody;
        this.params = params;
        this.kvParams = kvParams;
        this.headers = headers;
        this.kvHeaders = kvHeaders;
        this.cookies = cookies;
        this.kvCookies = kvCookies;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.writeTimeout = writeTimeout;
        this.addDefaultHeaders = addDefaultHeaders;
        this.addDefaultReferer = addDefaultReferer;
        this.ignoreSslCertificate = ignoreSslCertificate;
        this.charset = charset;
        this.ignoreError = ignoreError;
        this.customizedBuilderConsumer = customizedBuilderConsumer;
    }

    public static HttpClientRequestBuilder builder() {
        return new HttpClientRequestBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public RequestMethodEnum getMethod() {
        return this.method;
    }

    public RequestContextTypeEnum getContextType() {
        return this.contextType;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public String getKvParams() {
        return this.kvParams;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getKvHeaders() {
        return this.kvHeaders;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public String getKvCookies() {
        return this.kvCookies;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public Duration getWriteTimeout() {
        return this.writeTimeout;
    }

    public boolean isAddDefaultHeaders() {
        return this.addDefaultHeaders;
    }

    public boolean isAddDefaultReferer() {
        return this.addDefaultReferer;
    }

    public boolean isIgnoreSslCertificate() {
        return this.ignoreSslCertificate;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isIgnoreError() {
        return this.ignoreError;
    }

    public Consumer<OkHttpClient.Builder> getCustomizedBuilderConsumer() {
        return this.customizedBuilderConsumer;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setMethod(RequestMethodEnum method) {
        this.method = method;
    }

    public void setContextType(RequestContextTypeEnum contextType) {
        this.contextType = contextType;
    }

    public void setRequestBody(String requestBody) {
        this.requestBody = requestBody;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setKvParams(String kvParams) {
        this.kvParams = kvParams;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setKvHeaders(String kvHeaders) {
        this.kvHeaders = kvHeaders;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public void setKvCookies(String kvCookies) {
        this.kvCookies = kvCookies;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setWriteTimeout(Duration writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setAddDefaultHeaders(boolean addDefaultHeaders) {
        this.addDefaultHeaders = addDefaultHeaders;
    }

    public void setAddDefaultReferer(boolean addDefaultReferer) {
        this.addDefaultReferer = addDefaultReferer;
    }

    public void setIgnoreSslCertificate(boolean ignoreSslCertificate) {
        this.ignoreSslCertificate = ignoreSslCertificate;
    }

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public void setIgnoreError(boolean ignoreError) {
        this.ignoreError = ignoreError;
    }

    public void setCustomizedBuilderConsumer(Consumer<OkHttpClient.Builder> customizedBuilderConsumer) {
        this.customizedBuilderConsumer = customizedBuilderConsumer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpClientRequest)) {
            return false;
        }
        HttpClientRequest other = (HttpClientRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        RequestMethodEnum this$method = this.getMethod();
        RequestMethodEnum other$method = other.getMethod();
        if (this$method == null ? other$method != null : !((Object)((Object)this$method)).equals((Object)other$method)) {
            return false;
        }
        RequestContextTypeEnum this$contextType = this.getContextType();
        RequestContextTypeEnum other$contextType = other.getContextType();
        if (this$contextType == null ? other$contextType != null : !((Object)((Object)this$contextType)).equals((Object)other$contextType)) {
            return false;
        }
        String this$requestBody = this.getRequestBody();
        String other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !this$requestBody.equals(other$requestBody)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        String this$kvParams = this.getKvParams();
        String other$kvParams = other.getKvParams();
        if (this$kvParams == null ? other$kvParams != null : !this$kvParams.equals(other$kvParams)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$kvHeaders = this.getKvHeaders();
        String other$kvHeaders = other.getKvHeaders();
        if (this$kvHeaders == null ? other$kvHeaders != null : !this$kvHeaders.equals(other$kvHeaders)) {
            return false;
        }
        Map<String, String> this$cookies = this.getCookies();
        Map<String, String> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        String this$kvCookies = this.getKvCookies();
        String other$kvCookies = other.getKvCookies();
        if (this$kvCookies == null ? other$kvCookies != null : !this$kvCookies.equals(other$kvCookies)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$readTimeout = this.getReadTimeout();
        Duration other$readTimeout = other.getReadTimeout();
        if (this$readTimeout == null ? other$readTimeout != null : !((Object)this$readTimeout).equals(other$readTimeout)) {
            return false;
        }
        Duration this$writeTimeout = this.getWriteTimeout();
        Duration other$writeTimeout = other.getWriteTimeout();
        if (this$writeTimeout == null ? other$writeTimeout != null : !((Object)this$writeTimeout).equals(other$writeTimeout)) {
            return false;
        }
        if (this.isAddDefaultHeaders() != other.isAddDefaultHeaders()) {
            return false;
        }
        if (this.isAddDefaultReferer() != other.isAddDefaultReferer()) {
            return false;
        }
        if (this.isIgnoreSslCertificate() != other.isIgnoreSslCertificate()) {
            return false;
        }
        Charset this$charset = this.getCharset();
        Charset other$charset = other.getCharset();
        if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
            return false;
        }
        if (this.isIgnoreError() != other.isIgnoreError()) {
            return false;
        }
        Consumer<OkHttpClient.Builder> this$customizedBuilderConsumer = this.getCustomizedBuilderConsumer();
        Consumer<OkHttpClient.Builder> other$customizedBuilderConsumer = other.getCustomizedBuilderConsumer();
        return !(this$customizedBuilderConsumer == null ? other$customizedBuilderConsumer != null : !this$customizedBuilderConsumer.equals(other$customizedBuilderConsumer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpClientRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        RequestMethodEnum $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)((Object)$method)).hashCode());
        RequestContextTypeEnum $contextType = this.getContextType();
        result = result * 59 + ($contextType == null ? 43 : ((Object)((Object)$contextType)).hashCode());
        String $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : $requestBody.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        String $kvParams = this.getKvParams();
        result = result * 59 + ($kvParams == null ? 43 : $kvParams.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $kvHeaders = this.getKvHeaders();
        result = result * 59 + ($kvHeaders == null ? 43 : $kvHeaders.hashCode());
        Map<String, String> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        String $kvCookies = this.getKvCookies();
        result = result * 59 + ($kvCookies == null ? 43 : $kvCookies.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $readTimeout = this.getReadTimeout();
        result = result * 59 + ($readTimeout == null ? 43 : ((Object)$readTimeout).hashCode());
        Duration $writeTimeout = this.getWriteTimeout();
        result = result * 59 + ($writeTimeout == null ? 43 : ((Object)$writeTimeout).hashCode());
        result = result * 59 + (this.isAddDefaultHeaders() ? 79 : 97);
        result = result * 59 + (this.isAddDefaultReferer() ? 79 : 97);
        result = result * 59 + (this.isIgnoreSslCertificate() ? 79 : 97);
        Charset $charset = this.getCharset();
        result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
        result = result * 59 + (this.isIgnoreError() ? 79 : 97);
        Consumer<OkHttpClient.Builder> $customizedBuilderConsumer = this.getCustomizedBuilderConsumer();
        result = result * 59 + ($customizedBuilderConsumer == null ? 43 : $customizedBuilderConsumer.hashCode());
        return result;
    }

    public String toString() {
        return "HttpClientRequest(url=" + this.getUrl() + ", method=" + (Object)((Object)this.getMethod()) + ", contextType=" + (Object)((Object)this.getContextType()) + ", requestBody=" + this.getRequestBody() + ", params=" + this.getParams() + ", kvParams=" + this.getKvParams() + ", headers=" + this.getHeaders() + ", kvHeaders=" + this.getKvHeaders() + ", cookies=" + this.getCookies() + ", kvCookies=" + this.getKvCookies() + ", connectTimeout=" + this.getConnectTimeout() + ", readTimeout=" + this.getReadTimeout() + ", writeTimeout=" + this.getWriteTimeout() + ", addDefaultHeaders=" + this.isAddDefaultHeaders() + ", addDefaultReferer=" + this.isAddDefaultReferer() + ", ignoreSslCertificate=" + this.isIgnoreSslCertificate() + ", charset=" + this.getCharset() + ", ignoreError=" + this.isIgnoreError() + ", customizedBuilderConsumer=" + this.getCustomizedBuilderConsumer() + ")";
    }

    public static class HttpClientRequestBuilder {
        private String url;
        private boolean method$set;
        private RequestMethodEnum method;
        private boolean contextType$set;
        private RequestContextTypeEnum contextType;
        private boolean requestBody$set;
        private String requestBody;
        private ArrayList<String> params$key;
        private ArrayList<Object> params$value;
        private String kvParams;
        private ArrayList<String> headers$key;
        private ArrayList<String> headers$value;
        private String kvHeaders;
        private ArrayList<String> cookies$key;
        private ArrayList<String> cookies$value;
        private String kvCookies;
        private Duration connectTimeout;
        private Duration readTimeout;
        private Duration writeTimeout;
        private boolean addDefaultHeaders;
        private boolean addDefaultReferer;
        private boolean ignoreSslCertificate;
        private Charset charset;
        private boolean ignoreError;
        private Consumer<OkHttpClient.Builder> customizedBuilderConsumer;

        HttpClientRequestBuilder() {
        }

        public HttpClientRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public HttpClientRequestBuilder method(RequestMethodEnum method) {
            this.method = method;
            this.method$set = true;
            return this;
        }

        public HttpClientRequestBuilder contextType(RequestContextTypeEnum contextType) {
            this.contextType = contextType;
            this.contextType$set = true;
            return this;
        }

        public HttpClientRequestBuilder requestBody(String requestBody) {
            this.requestBody = requestBody;
            this.requestBody$set = true;
            return this;
        }

        public HttpClientRequestBuilder param(String paramKey, Object paramValue) {
            if (this.params$key == null) {
                this.params$key = new ArrayList();
                this.params$value = new ArrayList();
            }
            this.params$key.add(paramKey);
            this.params$value.add(paramValue);
            return this;
        }

        public HttpClientRequestBuilder params(Map<? extends String, ? extends Object> params) {
            if (this.params$key == null) {
                this.params$key = new ArrayList();
                this.params$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends Object> $lombokEntry : params.entrySet()) {
                this.params$key.add($lombokEntry.getKey());
                this.params$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public HttpClientRequestBuilder clearParams() {
            if (this.params$key != null) {
                this.params$key.clear();
                this.params$value.clear();
            }
            return this;
        }

        public HttpClientRequestBuilder kvParams(String kvParams) {
            this.kvParams = kvParams;
            return this;
        }

        public HttpClientRequestBuilder header(String headerKey, String headerValue) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            this.headers$key.add(headerKey);
            this.headers$value.add(headerValue);
            return this;
        }

        public HttpClientRequestBuilder headers(Map<? extends String, ? extends String> headers) {
            if (this.headers$key == null) {
                this.headers$key = new ArrayList();
                this.headers$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : headers.entrySet()) {
                this.headers$key.add($lombokEntry.getKey());
                this.headers$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public HttpClientRequestBuilder clearHeaders() {
            if (this.headers$key != null) {
                this.headers$key.clear();
                this.headers$value.clear();
            }
            return this;
        }

        public HttpClientRequestBuilder kvHeaders(String kvHeaders) {
            this.kvHeaders = kvHeaders;
            return this;
        }

        public HttpClientRequestBuilder cooky(String cookyKey, String cookyValue) {
            if (this.cookies$key == null) {
                this.cookies$key = new ArrayList();
                this.cookies$value = new ArrayList();
            }
            this.cookies$key.add(cookyKey);
            this.cookies$value.add(cookyValue);
            return this;
        }

        public HttpClientRequestBuilder cookies(Map<? extends String, ? extends String> cookies) {
            if (this.cookies$key == null) {
                this.cookies$key = new ArrayList();
                this.cookies$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends String> $lombokEntry : cookies.entrySet()) {
                this.cookies$key.add($lombokEntry.getKey());
                this.cookies$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public HttpClientRequestBuilder clearCookies() {
            if (this.cookies$key != null) {
                this.cookies$key.clear();
                this.cookies$value.clear();
            }
            return this;
        }

        public HttpClientRequestBuilder kvCookies(String kvCookies) {
            this.kvCookies = kvCookies;
            return this;
        }

        public HttpClientRequestBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public HttpClientRequestBuilder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public HttpClientRequestBuilder writeTimeout(Duration writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }

        public HttpClientRequestBuilder addDefaultHeaders(boolean addDefaultHeaders) {
            this.addDefaultHeaders = addDefaultHeaders;
            return this;
        }

        public HttpClientRequestBuilder addDefaultReferer(boolean addDefaultReferer) {
            this.addDefaultReferer = addDefaultReferer;
            return this;
        }

        public HttpClientRequestBuilder ignoreSslCertificate(boolean ignoreSslCertificate) {
            this.ignoreSslCertificate = ignoreSslCertificate;
            return this;
        }

        public HttpClientRequestBuilder charset(Charset charset) {
            this.charset = charset;
            return this;
        }

        public HttpClientRequestBuilder ignoreError(boolean ignoreError) {
            this.ignoreError = ignoreError;
            return this;
        }

        public HttpClientRequestBuilder customizedBuilderConsumer(Consumer<OkHttpClient.Builder> customizedBuilderConsumer) {
            this.customizedBuilderConsumer = customizedBuilderConsumer;
            return this;
        }

        public HttpClientRequest build() {
            Map<Object, Object> cookies;
            Map<Object, Object> headers;
            Map<Object, Object> params;
            switch (this.params$key == null ? 0 : this.params$key.size()) {
                case 0: {
                    params = Collections.emptyMap();
                    break;
                }
                case 1: {
                    params = Collections.singletonMap(this.params$key.get(0), this.params$value.get(0));
                    break;
                }
                default: {
                    params = new LinkedHashMap(this.params$key.size() < 0x40000000 ? 1 + this.params$key.size() + (this.params$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.params$key.size(); ++$i) {
                        params.put(this.params$key.get($i), this.params$value.get($i));
                    }
                    params = Collections.unmodifiableMap(params);
                }
            }
            switch (this.headers$key == null ? 0 : this.headers$key.size()) {
                case 0: {
                    headers = Collections.emptyMap();
                    break;
                }
                case 1: {
                    headers = Collections.singletonMap(this.headers$key.get(0), this.headers$value.get(0));
                    break;
                }
                default: {
                    headers = new LinkedHashMap(this.headers$key.size() < 0x40000000 ? 1 + this.headers$key.size() + (this.headers$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.headers$key.size(); ++$i) {
                        headers.put(this.headers$key.get($i), this.headers$value.get($i));
                    }
                    headers = Collections.unmodifiableMap(headers);
                }
            }
            switch (this.cookies$key == null ? 0 : this.cookies$key.size()) {
                case 0: {
                    cookies = Collections.emptyMap();
                    break;
                }
                case 1: {
                    cookies = Collections.singletonMap(this.cookies$key.get(0), this.cookies$value.get(0));
                    break;
                }
                default: {
                    cookies = new LinkedHashMap(this.cookies$key.size() < 0x40000000 ? 1 + this.cookies$key.size() + (this.cookies$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.cookies$key.size(); ++$i) {
                        cookies.put(this.cookies$key.get($i), this.cookies$value.get($i));
                    }
                    cookies = Collections.unmodifiableMap(cookies);
                }
            }
            RequestMethodEnum method = this.method;
            if (!this.method$set) {
                method = HttpClientRequest.$default$method();
            }
            RequestContextTypeEnum contextType = this.contextType;
            if (!this.contextType$set) {
                contextType = HttpClientRequest.$default$contextType();
            }
            String requestBody = this.requestBody;
            if (!this.requestBody$set) {
                requestBody = HttpClientRequest.$default$requestBody();
            }
            return new HttpClientRequest(this.url, method, contextType, requestBody, params, this.kvParams, headers, this.kvHeaders, cookies, this.kvCookies, this.connectTimeout, this.readTimeout, this.writeTimeout, this.addDefaultHeaders, this.addDefaultReferer, this.ignoreSslCertificate, this.charset, this.ignoreError, this.customizedBuilderConsumer);
        }

        public String toString() {
            return "HttpClientRequest.HttpClientRequestBuilder(url=" + this.url + ", method=" + (Object)((Object)this.method) + ", contextType=" + (Object)((Object)this.contextType) + ", requestBody=" + this.requestBody + ", params$key=" + this.params$key + ", params$value=" + this.params$value + ", kvParams=" + this.kvParams + ", headers$key=" + this.headers$key + ", headers$value=" + this.headers$value + ", kvHeaders=" + this.kvHeaders + ", cookies$key=" + this.cookies$key + ", cookies$value=" + this.cookies$value + ", kvCookies=" + this.kvCookies + ", connectTimeout=" + this.connectTimeout + ", readTimeout=" + this.readTimeout + ", writeTimeout=" + this.writeTimeout + ", addDefaultHeaders=" + this.addDefaultHeaders + ", addDefaultReferer=" + this.addDefaultReferer + ", ignoreSslCertificate=" + this.ignoreSslCertificate + ", charset=" + this.charset + ", ignoreError=" + this.ignoreError + ", customizedBuilderConsumer=" + this.customizedBuilderConsumer + ")";
        }
    }
}

