package com.glideapi; 

import java.util.List;

public class Types {

    public static class GlideSdkSettings {
        private String clientId;
        private String clientSecret;
        private String redirectUri;
        private Boolean useEnv;
        private Internal internal;

        public GlideSdkSettings(String clientId, String clientSecret, String redirectUri, Internal internal) {
            this.clientId = clientId;
            this.clientSecret = clientSecret;
            this.redirectUri = redirectUri;
            this.internal = internal;
        }

        public GlideSdkSettings() {}

        // Getters and setters
        public String getClientId() { return clientId; }
        public void setClientId(String clientId) { this.clientId = clientId; }

        public String getClientSecret() { return clientSecret; }
        public void setClientSecret(String clientSecret) { this.clientSecret = clientSecret; }

        public String getRedirectUri() { return redirectUri; }
        public void setRedirectUri(String redirectUri) { this.redirectUri = redirectUri; }

        public Boolean getUseEnv() { return useEnv; }
        public void setUseEnv(Boolean useEnv) { this.useEnv = useEnv; }

        public Internal getInternal() { return internal; }
        public void setInternal(Internal internal) { this.internal = internal; }

        public static class Internal {
            private String authBaseUrl;
            private String apiBaseUrl;

            public Internal(String authBaseUrl, String apiBaseUrl) {
                this.authBaseUrl = authBaseUrl;
                this.apiBaseUrl = apiBaseUrl;
            }
            // Getters and setters
            public String getAuthBaseUrl() { return authBaseUrl; }
            public void setAuthBaseUrl(String authBaseUrl) { this.authBaseUrl = authBaseUrl; }

            public String getApiBaseUrl() { return apiBaseUrl; }
            public void setApiBaseUrl(String apiBaseUrl) { this.apiBaseUrl = apiBaseUrl; }
        }
    }

    public static class Session {
        private String accessToken;
        private long expiresAt;
        private List<String> scopes;

        public Session(String accessToken, long expiresAt, List<String> scopes) {
            this.accessToken = accessToken;
            this.expiresAt = expiresAt;
            this.scopes = scopes;
        }

        // Getters and setters
        public String getAccessToken() { return accessToken; }
        public void setAccessToken(String accessToken) { this.accessToken = accessToken; }

        public long getExpiresAt() { return expiresAt; }
        public void setExpiresAt(long expiresAt) { this.expiresAt = expiresAt; }

        public List<String> getScopes() { return scopes; }
        public void setScopes(List<String> scopes) { this.scopes = scopes; }
    }

    public static class ApiConfig {
        private Session session;
        private String sessionIdentifier;

        // Getter and setter
        public Session getSession() { return session; }
        public void setSession(Session session) { this.session = session; }
        
        public String getSessionIdentifier() { return sessionIdentifier; }
        public void setSessionIdentifier(String sessionIdentifier) { this.sessionIdentifier = sessionIdentifier; }
    }

    public static class UserIdentifier {
        private String phoneNumber;
        private String email;
        private String ipAddress;
        private String userId;

        // Getters and setters

        public String getPhoneNumber() { return phoneNumber; }

        public void setPhoneNumber(String phoneNumber) { this.phoneNumber = phoneNumber; }

        public String getEmail() { return email; }

        public void setEmail(String email) { this.email = email; }

        public String getIpAddress() { return ipAddress; }

        public void setIpAddress(String ipAddress) { this.ipAddress = ipAddress; }

        public String getUserId() { return userId; }

        public void setUserId(String userId) { this.userId = userId; }

        public static class PhoneIdentifier extends UserIdentifier {
            public String phoneNumber;

            public PhoneIdentifier(String phoneNumber) {
                this.phoneNumber = phoneNumber;
            }
        }

        public static class EmailIdentifier extends UserIdentifier {
            public String email;

            public EmailIdentifier(String email) {
                this.email = email;
            }
        }

        public static class IpIdentifier extends UserIdentifier {
            public String ipAddress;

            public IpIdentifier(String ipAddress) {
                this.ipAddress = ipAddress;
            }
        }

        public static class UserIdIdentifier extends UserIdentifier {
            public String userId;

            public UserIdIdentifier(String userId) {
                this.userId = userId;
            }
        }
    }

}