/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.glideapi.Types;
import com.glideapi.Utils;
import io.jsonwebtoken.lang.Arrays;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class NumberVerifyClient {
    private final Types.GlideSdkSettings settings;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public NumberVerifyClient(Types.GlideSdkSettings settings) {
        this.settings = settings;
    }

    public String getAuthUrl(NumberVerifyAuthUrlInput opts) throws Exception {
        if (this.settings.getInternal().getAuthBaseUrl() == null) {
            throw new IllegalStateException("[GlideClient] internal.authBaseUrl is unset");
        }
        if (this.settings.getClientId() == null) {
            throw new IllegalStateException("[GlideClient] Client id is required to generate an auth url");
        }
        String state = opts.state != null ? opts.state : UUID.randomUUID().toString();
        String nonce = UUID.randomUUID().toString();
        return this.settings.getInternal().getAuthBaseUrl() + "/oauth2/auth?client_id=" + URLEncoder.encode(this.settings.getClientId(), StandardCharsets.UTF_8) + "&response_type=code" + (String)(this.settings.getRedirectUri() != null ? "&redirect_uri=" + URLEncoder.encode(this.settings.getRedirectUri(), StandardCharsets.UTF_8) : "") + "&scope=openid&purpose=dpv:FraudPreventionAndDetection:number-verification&state=" + URLEncoder.encode(state, StandardCharsets.UTF_8) + "&nonce=" + URLEncoder.encode(nonce, StandardCharsets.UTF_8) + "&max_age=0" + (opts.printCode != null && opts.printCode != false ? "&dev_print=true" : "") + (String)(opts.useDevNumber != null ? "&login_hint=" + URLEncoder.encode("tel:" + opts.useDevNumber, StandardCharsets.UTF_8) : "");
    }

    public NumberVerifyUserClient forUser(NumberVerifyClientForParams params) throws Exception {
        NumberVerifyUserClient client = new NumberVerifyUserClient(params);
        client.startSession();
        return client;
    }

    public static class NumberVerifyAuthUrlInput {
        public String state;
        public String useDevNumber;
        public Boolean printCode;

        public NumberVerifyAuthUrlInput(String useDevNumber, Boolean printCode) {
            this.useDevNumber = useDevNumber;
            this.printCode = printCode;
        }

        public NumberVerifyAuthUrlInput(String useDevNumber) {
            this(useDevNumber, false);
        }

        public NumberVerifyAuthUrlInput() {
            this.useDevNumber = null;
            this.printCode = false;
        }
    }

    public class NumberVerifyUserClient {
        private final String code;
        private Types.Session session = null;
        private final String phoneNumber;

        public NumberVerifyUserClient(NumberVerifyClientForParams params) {
            this.code = params.code;
            this.phoneNumber = params.phoneNumber;
        }

        public void startSession() throws Exception {
            HttpRequest request;
            if (NumberVerifyClient.this.settings.getInternal().getAuthBaseUrl() == null) {
                throw new IllegalStateException("[GlideClient] internal.authBaseUrl is unset");
            }
            if (NumberVerifyClient.this.settings.getClientId() == null || NumberVerifyClient.this.settings.getClientSecret() == null) {
                throw new IllegalStateException("[GlideClient] Client credentials are required to generate a new session");
            }
            if (this.code == null) {
                throw new IllegalStateException("[GlideClient] Code is required to start a session");
            }
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(NumberVerifyClient.this.settings.getInternal().getAuthBaseUrl() + "/oauth2/token")).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.getEncoder().encodeToString((NumberVerifyClient.this.settings.getClientId() + ":" + NumberVerifyClient.this.settings.getClientSecret()).getBytes(StandardCharsets.UTF_8))).POST(HttpRequest.BodyPublishers.ofString("grant_type=authorization_code&code=" + this.code)).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                throw new Exception("Failed to generate new session: " + response.body());
            }
            Map body = (Map)objectMapper.readValue(response.body(), Map.class);
            this.session = new Types.Session((String)body.get("access_token"), System.currentTimeMillis() + (long)((Integer)body.get("expires_in")).intValue() * 1000L, Arrays.asList((Object[])((String)body.get("scope")).split(" ")));
        }

        public String getOperator() {
            if (this.session == null) {
                throw new IllegalStateException("[GlideClient] Session is required to get operator");
            }
            String token = this.session.getAccessToken();
            try {
                String[] tokenParts = token.split("\\.");
                String decodedPayload = new String(Base64.getDecoder().decode(tokenParts[1]), StandardCharsets.UTF_8);
                Map tokenData = (Map)objectMapper.readValue(decodedPayload, Map.class);
                return (String)((Map)tokenData.get("ext")).get("operator");
            }
            catch (Exception e) {
                e.printStackTrace();
                return "unknown";
            }
        }

        public NumberVerifyResponse verifyNumber(NumberVerifyInput input, Types.ApiConfig conf) throws Exception {
            HttpRequest request;
            String phoneNumber;
            String operator = "unknown";
            if (conf != null && conf.getSessionIdentifier() != null) {
                operator = this.getOperator();
                this.reportNumberVerifyMetric(conf.getSessionIdentifier(), "Glide numberVerify start function", operator);
            }
            if (this.session == null) {
                throw new IllegalStateException("[GlideClient] Session is required to verify a number");
            }
            if (NumberVerifyClient.this.settings.getInternal().getApiBaseUrl() == null) {
                throw new IllegalStateException("[GlideClient] internal.apiBaseUrl is unset");
            }
            String string = phoneNumber = input != null && input.phoneNumber != null ? input.phoneNumber : this.phoneNumber;
            if (phoneNumber == null) {
                throw new IllegalArgumentException("[GlideClient] Phone number is required to verify a number");
            }
            Types.Session sessionToUse = conf != null && conf.getSession() != null ? conf.getSession() : this.session;
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(NumberVerifyClient.this.settings.getInternal().getApiBaseUrl() + "/number-verification/verify")).header("Content-Type", "application/json").header("Authorization", "Bearer " + sessionToUse.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString("{\"phoneNumber\":\"" + phoneNumber + "\"}")).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                throw new Exception("Failed to verify number: " + response.body());
            }
            if (conf != null && conf.getSessionIdentifier() != null) {
                this.reportNumberVerifyMetric(conf.getSessionIdentifier(), "Glide success", operator);
            }
            NumberVerifyResponse result = (NumberVerifyResponse)objectMapper.readValue(response.body(), NumberVerifyResponse.class);
            if (conf != null && conf.getSessionIdentifier() != null) {
                if (result.devicePhoneNumberVerified) {
                    this.reportNumberVerifyMetric(conf.getSessionIdentifier(), "Glide verified", operator);
                } else {
                    this.reportNumberVerifyMetric(conf.getSessionIdentifier(), "Glide unverified", operator);
                }
            }
            return result;
        }

        private void reportNumberVerifyMetric(String sessionId, String metricName, String operator) {
            if (operator == null) {
                operator = "unknown";
            }
            Utils.reportMetric(new Utils.MetricInfo(new Date(), sessionId, metricName, "number-verify", NumberVerifyClient.this.settings.getClientId(), operator));
        }
    }

    public static class NumberVerifyClientForParams {
        public String code;
        public String phoneNumber;

        public NumberVerifyClientForParams(String code, String phoneNumber) {
            this.code = code;
            this.phoneNumber = phoneNumber;
        }

        public NumberVerifyClientForParams() {
        }
    }

    public static class NumberVerifyResponse {
        public boolean devicePhoneNumberVerified;
    }

    public static class NumberVerifyInput {
        public String phoneNumber;

        public NumberVerifyInput(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public NumberVerifyInput() {
        }
    }
}

