/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.services;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.glideapi.Types;
import com.glideapi.Utils;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;

public class SimSwapClient {
    private final Types.GlideSdkSettings settings;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public SimSwapClient(Types.GlideSdkSettings settings) {
        this.settings = settings;
    }

    public SimSwapUserClient forUser(Types.UserIdentifier identifier) throws Exception {
        SimSwapUserClient client = new SimSwapUserClient(this, this.settings, identifier);
        client.startSession();
        return client;
    }

    public class SimSwapUserClient {
        private final Types.GlideSdkSettings settings;
        private final Types.UserIdentifier identifier;
        private Types.Session session = null;
        public boolean requiresConsent = false;
        private String consentUrl = null;
        private String authReqId = null;

        private SimSwapUserClient(SimSwapClient this$0, Types.GlideSdkSettings settings, Types.UserIdentifier identifier) {
            this.settings = settings;
            this.identifier = identifier;
        }

        public String getConsentUrl() {
            return this.consentUrl != null ? this.consentUrl : "";
        }

        public SimSwapCheckResponse check(SimSwapCheckParams params, Types.ApiConfig conf) throws Exception {
            HttpRequest request;
            HttpClient client;
            HttpResponse<String> response;
            if (conf == null) {
                conf = new Types.ApiConfig();
            }
            if (this.settings.getInternal().getApiBaseUrl() == null) {
                throw new IllegalStateException("[GlideClient] internal.apiBaseUrl is unset");
            }
            String phoneNumber = params.phoneNumber;
            if (phoneNumber == null && this.identifier instanceof Types.UserIdentifier.PhoneIdentifier) {
                phoneNumber = ((Types.UserIdentifier.PhoneIdentifier)this.identifier).phoneNumber;
            }
            if (phoneNumber == null) {
                throw new IllegalArgumentException("[GlideClient] phone number not provided");
            }
            Types.Session session = this.getSession(conf);
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("phoneNumber", Utils.formatPhoneNumber(phoneNumber));
            if (params.maxAge != null) {
                body.put("maxAge", params.maxAge);
            }
            if ((response = (client = HttpClient.newHttpClient()).send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/sim-swap/check")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString(body))).build(), HttpResponse.BodyHandlers.ofString())).statusCode() != 200) {
                throw new RuntimeException("[GlideClient] Failed to check sim swap: " + response.body());
            }
            return (SimSwapCheckResponse)objectMapper.readValue(response.body(), SimSwapCheckResponse.class);
        }

        public SimSwapRetrieveDateResponse retrieveDate(SimSwapRetrieveDateParams params, Types.ApiConfig conf) throws Exception {
            HttpRequest request;
            if (conf == null) {
                conf = new Types.ApiConfig();
            }
            if (this.settings.getInternal().getApiBaseUrl() == null) {
                throw new IllegalStateException("[GlideClient] internal.apiBaseUrl is unset");
            }
            String phoneNumber = params.phoneNumber;
            if (phoneNumber == null && this.identifier instanceof Types.UserIdentifier.PhoneIdentifier) {
                phoneNumber = ((Types.UserIdentifier.PhoneIdentifier)this.identifier).phoneNumber;
            }
            if (phoneNumber == null) {
                throw new IllegalArgumentException("[GlideClient] phone number not provided");
            }
            Types.Session session = this.getSession(conf);
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/sim-swap/retrieve-date")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString("{\"phoneNumber\":\"" + Utils.formatPhoneNumber(phoneNumber) + "\"}")).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("[GlideClient] Failed to retrieve sim swap date: " + response.body());
            }
            return (SimSwapRetrieveDateResponse)objectMapper.readValue(response.body(), SimSwapRetrieveDateResponse.class);
        }

        public void startSession() throws Exception {
            if (this.settings.getClientId() == null || this.settings.getClientSecret() == null) {
                throw new IllegalStateException("[GlideClient] Client credentials are required to generate a new session");
            }
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.identifier instanceof Types.UserIdentifier.PhoneIdentifier) {
                params.put("login_hint", "tel:" + Utils.formatPhoneNumber(((Types.UserIdentifier.PhoneIdentifier)this.identifier).phoneNumber));
            } else if (this.identifier instanceof Types.UserIdentifier.IpIdentifier) {
                params.put("login_hint", "ipport:" + ((Types.UserIdentifier.IpIdentifier)this.identifier).ipAddress);
            }
            params.put("scope", "sim-swap");
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getAuthBaseUrl() + "/oauth2/backchannel-authentication")).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.settings.getClientId() + ":" + this.settings.getClientSecret()).getBytes())).POST(HttpRequest.BodyPublishers.ofString(Utils.urlEncodeMap(params))).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to start session: " + response.body());
            }
            Map body = (Map)objectMapper.readValue(response.body(), Map.class);
            if (body.containsKey("consentUrl")) {
                this.requiresConsent = true;
                this.consentUrl = (String)body.get("consentUrl");
            }
            this.authReqId = (String)body.get("auth_req_id");
        }

        private Types.Session getSession(Types.ApiConfig conf) {
            try {
                if (conf.getSession() != null) {
                    return conf.getSession();
                }
                if (this.session != null && this.session.getExpiresAt() > System.currentTimeMillis() + 60000L && this.session.getScopes().stream().anyMatch(s -> s.endsWith("sim-swap"))) {
                    return this.session;
                }
                return this.generateNewSession();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void pollAndWaitForSession() throws Exception {
            while (true) {
                try {
                    Types.Session session = this.getSession(new Types.ApiConfig());
                    if (session != null) {
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.sleep(5000L);
            }
        }

        private Types.Session generateNewSession() throws Exception {
            Types.Session newSession;
            HttpRequest request;
            if (this.settings.getClientId() == null || this.settings.getClientSecret() == null) {
                throw new IllegalStateException("[GlideClient] Client credentials are required to generate a new session");
            }
            if (this.authReqId == null) {
                this.startSession();
            }
            if (this.authReqId == null) {
                throw new IllegalStateException("[GlideClient] Failed to start session");
            }
            HttpClient client = HttpClient.newHttpClient();
            HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getAuthBaseUrl() + "/oauth2/token")).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.settings.getClientId() + ":" + this.settings.getClientSecret()).getBytes())).POST(HttpRequest.BodyPublishers.ofString("grant_type=urn:openid:params:grant-type:ciba&auth_req_id=" + this.authReqId)).build(), HttpResponse.BodyHandlers.ofString());
            if (response.statusCode() != 200) {
                throw new RuntimeException("Failed to generate new session: " + response.body());
            }
            Map body = (Map)objectMapper.readValue(response.body(), Map.class);
            this.session = newSession = new Types.Session((String)body.get("access_token"), System.currentTimeMillis() + (long)((Integer)body.get("expires_in")).intValue() * 1000L, Arrays.asList(((String)body.get("scope")).split(" ")));
            this.authReqId = null;
            return newSession;
        }

        public static class SimSwapCheckParams {
            public String phoneNumber;
            public Integer maxAge;
        }

        public static class SimSwapCheckResponse {
            public boolean swapped;
        }

        public static class SimSwapRetrieveDateParams {
            public String phoneNumber;
        }

        public static class SimSwapRetrieveDateResponse {
            public String latestSimChange;
        }
    }
}

