package com.glideapi.exceptions;

/**
 * Error codes for MagicAuth service
 */
public enum MagicAuthErrorCode {
    // Client errors (4xx)
    VALIDATION_ERROR("VALIDATION_ERROR"),
    INVALID_PARAMETERS("INVALID_PARAMETERS"),
    UNAUTHORIZED("UNAUTHORIZED"),
    CARRIER_NOT_ELIGIBLE("CARRIER_NOT_ELIGIBLE"),
    CARRIER_IDENTIFICATION_FAILED("CARRIER_IDENTIFICATION_FAILED"),
    SESSION_NOT_FOUND("SESSION_NOT_FOUND"),
    RATE_LIMIT_EXCEEDED("RATE_LIMIT_EXCEEDED"),
    TOKEN_ACQUISITION_FAILED("TOKEN_ACQUISITION_FAILED"),
    
    // Server errors (5xx)
    INTERNAL_SERVER_ERROR("INTERNAL_SERVER_ERROR"),
    SERVICE_UNAVAILABLE("SERVICE_UNAVAILABLE"),
    DOWNSTREAM_SERVICE_ERROR("DOWNSTREAM_SERVICE_ERROR"),
    
    // Unknown error
    UNKNOWN_ERROR("UNKNOWN_ERROR");
    
    private final String code;
    
    MagicAuthErrorCode(String code) {
        this.code = code;
    }
    
    public String getCode() {
        return code;
    }
    
    public static MagicAuthErrorCode fromCode(String code) {
        for (MagicAuthErrorCode errorCode : values()) {
            if (errorCode.code.equals(code)) {
                return errorCode;
            }
        }
        return UNKNOWN_ERROR;
    }
} 