package com.glideapi.session;

import com.glideapi.GlideClient;
import com.glideapi.Types.Session;
import java.util.concurrent.CompletableFuture;

/**
 * Session strategy that creates a new session for every request.
 * This provides maximum isolation at the cost of higher overhead.
 * Each API call gets its own fresh session.
 * 
 * Best for: Short-lived operations, maximum security requirements, or testing.
 */
public class PerRequestStrategy implements SessionStrategy {
    private final GlideClient client;
    
    public PerRequestStrategy(GlideClient client) {
        this.client = client;
    }
    
    @Override
    public Session getSession() throws Exception {
        return client.createSession();
    }
    
    @Override
    public Session getSession(String scope) throws Exception {
        return client.createSession(scope);
    }
    
    @Override
    public CompletableFuture<Session> getSessionAsync() {
        return client.createSessionAsync();
    }
    
    @Override
    public void clearCache() {
        // No-op - this strategy doesn't cache sessions
    }
} 