/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.exceptions;

import com.glideapi.exceptions.MagicAuthErrorCode;
import java.util.Map;

public class MagicAuthError
extends Exception {
    private final String code;
    private final int status;
    private final String requestId;
    private final String timestamp;
    private final Object details;

    public MagicAuthError(Map<String, Object> errorResponse) {
        super(MagicAuthError.extractMessage(errorResponse));
        this.code = (String)errorResponse.getOrDefault("code", "UNKNOWN_ERROR");
        this.status = MagicAuthError.extractStatus(errorResponse);
        this.requestId = (String)errorResponse.get("requestId");
        this.timestamp = (String)errorResponse.get("timestamp");
        this.details = errorResponse.get("details");
    }

    public MagicAuthError(String code, int status, String message) {
        super(message);
        this.code = code;
        this.status = status;
        this.requestId = null;
        this.timestamp = null;
        this.details = null;
    }

    private static String extractMessage(Map<String, Object> errorResponse) {
        Object detail;
        Object messageObj = errorResponse.get("message");
        if (messageObj instanceof String) {
            return (String)messageObj;
        }
        Object error = errorResponse.get("error");
        if (error instanceof Map) {
            Map errorMap = (Map)error;
            Object errorMessage = errorMap.get("message");
            if (errorMessage instanceof String) {
                return (String)errorMessage;
            }
        } else if (error instanceof String) {
            return (String)error;
        }
        if (errorResponse.containsKey("detail") && (detail = errorResponse.get("detail")) instanceof String) {
            return (String)detail;
        }
        return "Unknown error occurred";
    }

    private static int extractStatus(Map<String, Object> errorResponse) {
        Object status = errorResponse.get("status");
        if (status instanceof Integer) {
            return (Integer)status;
        }
        if (status instanceof String) {
            try {
                return Integer.parseInt((String)status);
            }
            catch (NumberFormatException e) {
                return 500;
            }
        }
        return 500;
    }

    public boolean is(MagicAuthErrorCode errorCode) {
        return this.code.equals(errorCode.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public int getStatus() {
        return this.status;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Object getDetails() {
        return this.details;
    }

    @Override
    public String toString() {
        return String.format("MagicAuthError{code='%s', status=%d, message='%s', requestId='%s', timestamp='%s'}", this.code, this.status, this.getMessage(), this.requestId, this.timestamp);
    }
}

