/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.services;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.glideapi.Types;
import com.glideapi.Utils;
import com.glideapi.session.SessionStrategy;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class TelcoFinderClient {
    private final Types.GlideSdkSettings settings;
    private Types.Session session = null;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final boolean autoSession;
    private final SessionStrategy sessionStrategy;

    public TelcoFinderClient(Types.GlideSdkSettings settings) {
        this(settings, false, null);
    }

    public TelcoFinderClient(Types.GlideSdkSettings settings, boolean autoSession, SessionStrategy sessionStrategy) {
        this.settings = settings;
        this.autoSession = autoSession;
        this.sessionStrategy = sessionStrategy;
    }

    public TelcoFinderNetworkIdResponse networkIdForNumber(String phoneNumber, Types.ApiConfig conf) throws Exception {
        HttpRequest request;
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new IllegalStateException("[GlideClient] internal.apiBaseUrl is unset");
        }
        Types.Session session = this.getSession(conf);
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/telco-finder/v1/resolve-network-id")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString("{\"phoneNumber\":\"" + Utils.formatPhoneNumber(phoneNumber) + "\"}")).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            if (response.statusCode() == 404) {
                throw new RuntimeException("[GlideClient] Network ID not found for number " + phoneNumber);
            }
            throw new RuntimeException("[GlideClient] Failed to resolve network id: " + response.body());
        }
        return (TelcoFinderNetworkIdResponse)objectMapper.readValue(response.body(), TelcoFinderNetworkIdResponse.class);
    }

    public TelcoFinderSearchResponse lookupIp(String ip, Types.ApiConfig conf) throws Exception {
        return this.lookup("ipport:" + ip, conf);
    }

    public TelcoFinderSearchResponse lookupNumber(String phoneNumber, Types.ApiConfig conf) throws Exception {
        return this.lookup("tel:" + Utils.formatPhoneNumber(phoneNumber), conf);
    }

    private TelcoFinderSearchResponse lookup(String subject, Types.ApiConfig conf) throws Exception {
        HttpRequest request;
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new IllegalStateException("[GlideClient] internal.apiBaseUrl is unset");
        }
        Types.Session session = this.getSession(conf);
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/telco-finder/v1/search")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString("{\"resource\":\"" + subject + "\"}")).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            if (response.statusCode() == 404) {
                throw new RuntimeException("[GlideClient] Lookup failed for subject " + subject);
            }
            throw new RuntimeException("[GlideClient] Failed to lookup telco: " + response.body());
        }
        TelcoFinderSearchResponse resObj = (TelcoFinderSearchResponse)objectMapper.readValue(response.body(), TelcoFinderSearchResponse.class);
        resObj.properties.operatorId = resObj.properties.operatorId;
        return resObj;
    }

    private Types.Session getSession(Types.ApiConfig conf) throws Exception {
        if (conf.getSession() != null) {
            return conf.getSession();
        }
        if (this.autoSession && this.sessionStrategy != null) {
            return this.sessionStrategy.getSession("telco-finder");
        }
        if (this.session != null && this.session.getExpiresAt() > System.currentTimeMillis() + 60000L && this.session.getScopes().stream().anyMatch(s -> s.endsWith("telco-finder"))) {
            return this.session;
        }
        return this.generateNewSession();
    }

    private Types.Session generateNewSession() throws Exception {
        Types.Session newSession;
        HttpRequest request;
        if (this.settings.getClientId() == null || this.settings.getClientSecret() == null) {
            throw new IllegalStateException("[GlideClient] Client credentials are required to generate a new session");
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getAuthBaseUrl() + "/oauth2/token")).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.settings.getClientId() + ":" + this.settings.getClientSecret()).getBytes(StandardCharsets.UTF_8))).POST(HttpRequest.BodyPublishers.ofString("grant_type=client_credentials&scope=telco-finder")).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new RuntimeException("Failed to generate new session: " + response.body());
        }
        Map body = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        this.session = newSession = new Types.Session((String)body.get("access_token"), System.currentTimeMillis() + (long)((Integer)body.get("expires_in")).intValue() * 1000L, Arrays.asList(((String)body.get("scope")).split(" ")));
        return newSession;
    }

    public static class TelcoFinderNetworkIdResponse {
        public String networkId;
    }

    public static class TelcoFinderSearchResponse {
        public String subject;
        public Properties properties;
        public List<Link> links;

        public static class Link {
            public String rel;
            public String href;
        }

        public static class Properties {
            public String operatorId;
        }
    }
}

