/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.session;

import com.glideapi.GlideClient;
import com.glideapi.Types;
import com.glideapi.session.SessionStrategy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class ThreadLocalStrategy
implements SessionStrategy {
    private final GlideClient client;
    private final ThreadLocal<ConcurrentHashMap<String, Types.Session>> threadLocalSessions = new ThreadLocal();

    public ThreadLocalStrategy(GlideClient client) {
        this.client = client;
    }

    @Override
    public Types.Session getSession() throws Exception {
        return this.getSession("magic-auth sim-swap number-verify telco-finder");
    }

    @Override
    public Types.Session getSession(String scope) throws Exception {
        Types.Session session;
        ConcurrentHashMap<String, Types.Session> sessions = this.threadLocalSessions.get();
        if (sessions == null) {
            sessions = new ConcurrentHashMap();
            this.threadLocalSessions.set(sessions);
        }
        if ((session = sessions.get(scope)) != null && session.getExpiresAt() > System.currentTimeMillis() + 60000L) {
            return session;
        }
        session = this.client.createSession(scope);
        sessions.put(scope, session);
        return session;
    }

    @Override
    public CompletableFuture<Types.Session> getSessionAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getSession();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void clearCache() {
        this.threadLocalSessions.remove();
    }
}

