package com.glideapi.session;

import com.glideapi.Types.Session;
import java.util.concurrent.CompletableFuture;

/**
 * Strategy interface for managing OAuth sessions.
 * Different implementations provide different performance and concurrency characteristics.
 */
public interface SessionStrategy {
    /**
     * Get a valid session, creating a new one if necessary.
     * 
     * @return A valid session
     * @throws Exception if session creation fails
     */
    Session getSession() throws Exception;
    
    /**
     * Get a valid session with specific scopes, creating a new one if necessary.
     * 
     * @param scope Space-separated list of scopes to request
     * @return A valid session
     * @throws Exception if session creation fails
     */
    Session getSession(String scope) throws Exception;
    
    /**
     * Get a valid session asynchronously.
     * 
     * @return CompletableFuture that will complete with a valid session
     */
    CompletableFuture<Session> getSessionAsync();
    
    /**
     * Clear any cached sessions.
     * Useful for forcing a fresh session on the next request.
     */
    void clearCache();
} 