/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.glideapi.Types;
import com.glideapi.services.MagicAuthClient;
import com.glideapi.services.NumberVerifyClient;
import com.glideapi.services.SimSwapClient;
import com.glideapi.services.TelcoFinderClient;
import com.glideapi.session.CachedStrategy;
import com.glideapi.session.PerRequestStrategy;
import com.glideapi.session.SessionStrategy;
import com.glideapi.session.ThreadLocalStrategy;
import io.github.cdimascio.dotenv.Dotenv;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class GlideClient {
    private final Types.GlideSdkSettings settings;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final SessionStrategy sessionStrategy;
    private final boolean autoSession;
    public final TelcoFinderClient telcoFinder;
    public final MagicAuthClient magicAuth;
    public final SimSwapClient simSwap;
    public final NumberVerifyClient numberVerify;

    public GlideClient(Types.GlideSdkSettings settings) {
        this(settings, true, SessionManagement.THREAD_LOCAL);
    }

    public GlideClient(Types.GlideSdkSettings settings, boolean autoSession, SessionManagement strategy) {
        Dotenv dotenv = Dotenv.configure().ignoreIfMissing().load();
        Types.GlideSdkSettings defaults = new Types.GlideSdkSettings("", "", "", new Types.GlideSdkSettings.Internal("https://oidc.gateway-x.io", "https://api.gateway-x.io"));
        this.settings = this.mergeSettings(dotenv, defaults, settings);
        if (this.settings.getClientId() == null || this.settings.getClientId().isEmpty()) {
            throw new IllegalArgumentException("clientId is required");
        }
        if (this.settings.getClientSecret() == null || this.settings.getClientSecret().isEmpty()) {
            throw new IllegalArgumentException("clientSecret is required");
        }
        if (this.settings.getInternal().getAuthBaseUrl() == null || this.settings.getInternal().getAuthBaseUrl().isEmpty()) {
            throw new IllegalArgumentException("internal.authBaseUrl is unset");
        }
        this.autoSession = autoSession;
        this.sessionStrategy = autoSession ? this.createStrategy(strategy) : null;
        this.telcoFinder = new TelcoFinderClient(this.settings, this.autoSession, this.sessionStrategy);
        this.magicAuth = new MagicAuthClient(this.settings, this.autoSession, this.sessionStrategy);
        this.simSwap = new SimSwapClient(this.settings, this.autoSession, this.sessionStrategy);
        this.numberVerify = new NumberVerifyClient(this.settings, this.autoSession, this.sessionStrategy);
    }

    public GlideClient(String clientId, String clientSecret) {
        this(new Types.GlideSdkSettings(clientId, clientSecret, "", new Types.GlideSdkSettings.Internal("", "")), true, SessionManagement.THREAD_LOCAL);
    }

    public GlideClient(String clientId, String clientSecret, boolean autoSession) {
        this(new Types.GlideSdkSettings(clientId, clientSecret, "", new Types.GlideSdkSettings.Internal("", "")), autoSession, autoSession ? SessionManagement.THREAD_LOCAL : SessionManagement.MANUAL);
    }

    public GlideClient() {
        this(new Types.GlideSdkSettings(), true, SessionManagement.THREAD_LOCAL);
    }

    public Types.Session createSession(String scope) throws Exception {
        HttpRequest request;
        if (this.settings.getClientId() == null || this.settings.getClientSecret() == null) {
            throw new IllegalStateException("[GlideClient] Client credentials are required to generate a new session");
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getAuthBaseUrl() + "/oauth2/token")).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.settings.getClientId() + ":" + this.settings.getClientSecret()).getBytes(StandardCharsets.UTF_8))).POST(HttpRequest.BodyPublishers.ofString("grant_type=client_credentials&scope=" + scope)).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            if (response.statusCode() == 401) {
                throw new RuntimeException("[GlideClient] Invalid client credentials");
            }
            if (response.statusCode() == 400) {
                Map errorBody = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
                if ("invalid_scope".equals(errorBody.get("error"))) {
                    throw new RuntimeException("[GlideClient] Client does not have required scopes to access this method");
                }
                throw new RuntimeException("[GlideClient] Invalid request");
            }
            throw new RuntimeException("Failed to generate new session: " + response.body());
        }
        Map body = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        return new Types.Session((String)body.get("access_token"), System.currentTimeMillis() + (long)((Integer)body.get("expires_in")).intValue() * 1000L, Arrays.asList(((String)body.get("scope")).split(" ")));
    }

    public Types.Session createSession() throws Exception {
        return this.createSession("magic-auth sim-swap number-verify telco-finder");
    }

    public CompletableFuture<Types.Session> createSessionAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.createSession();
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        });
    }

    private Types.GlideSdkSettings mergeSettings(Dotenv dotenv, Types.GlideSdkSettings defaults, Types.GlideSdkSettings userSettings) {
        return new Types.GlideSdkSettings(userSettings.getClientId() != null && !userSettings.getClientId().isEmpty() ? userSettings.getClientId() : dotenv.get("GLIDE_CLIENT_ID", defaults.getClientId()), userSettings.getClientSecret() != null && !userSettings.getClientSecret().isEmpty() ? userSettings.getClientSecret() : dotenv.get("GLIDE_CLIENT_SECRET", defaults.getClientSecret()), userSettings.getRedirectUri() != null && !userSettings.getRedirectUri().isEmpty() ? userSettings.getRedirectUri() : dotenv.get("GLIDE_REDIRECT_URI", defaults.getRedirectUri()), new Types.GlideSdkSettings.Internal(userSettings.getInternal().getAuthBaseUrl() != null && !userSettings.getInternal().getAuthBaseUrl().isEmpty() ? userSettings.getInternal().getAuthBaseUrl() : dotenv.get("GLIDE_AUTH_BASE_URL", defaults.getInternal().getAuthBaseUrl()), userSettings.getInternal().getApiBaseUrl() != null && !userSettings.getInternal().getApiBaseUrl().isEmpty() ? userSettings.getInternal().getApiBaseUrl() : dotenv.get("GLIDE_API_BASE_URL", defaults.getInternal().getApiBaseUrl())));
    }

    private SessionStrategy createStrategy(SessionManagement strategy) {
        if (strategy == null || strategy == SessionManagement.MANUAL) {
            return null;
        }
        switch (strategy.ordinal()) {
            case 0: {
                return new PerRequestStrategy(this);
            }
            case 1: {
                return new ThreadLocalStrategy(this);
            }
            case 2: {
                return new CachedStrategy(this);
            }
        }
        throw new IllegalArgumentException("Unknown strategy: " + String.valueOf((Object)strategy));
    }

    public void clearSessionCache() {
        if (this.sessionStrategy != null) {
            this.sessionStrategy.clearCache();
        }
    }

    public SessionStrategy getSessionStrategy() {
        return this.sessionStrategy;
    }

    public boolean isAutoSession() {
        return this.autoSession;
    }

    public static enum SessionManagement {
        PER_REQUEST,
        THREAD_LOCAL,
        CACHED,
        MANUAL;

    }
}

