/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class Utils {
    public static String formatPhoneNumber(String phoneNumber) {
        return "+" + phoneNumber.replaceAll("[^0-9]", "");
    }

    public static String urlEncodeMap(Map<String, String> map) {
        return map.entrySet().stream().map(entry -> {
            try {
                return (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), "utf-8");
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining("&"));
    }

    public static FetchXResponse fetchX(String urlString, FetchXInput input) {
        try {
            int statusCode;
            URL url = URI.create(urlString).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(input.getMethod());
            for (Map.Entry<String, String> entry : input.getHeaders().entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            if (input.getBody() != null) {
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] inputAsBytes = input.getBody().getBytes("utf-8");
                    os.write(inputAsBytes, 0, inputAsBytes.length);
                }
            }
            BufferedReader reader = (statusCode = connection.getResponseCode()) >= 400 ? new BufferedReader(new InputStreamReader(connection.getErrorStream())) : new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String data = reader.lines().collect(Collectors.joining("\n"));
            if (statusCode >= 400) {
                throw new FetchError(connection, data);
            }
            return new FetchXResponse(data, statusCode < 400);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String reportMetric(MetricInfo report) {
        String reportToServer = String.format("{\"sessionId\":\"%s\",\"metricName\":\"%s\",\"timestamp\":\"%s\",\"api\":\"%s\",\"clientId\":\"%s\",\"operator\":\"%s\"}", report.getSessionId(), report.getMetricName(), report.getTimestamp().toInstant().toString(), report.getApi(), report.getClientId(), report.getOperator());
        String url = System.getenv("report_metric_url");
        if (url == null) {
            System.err.println("missing process env report_metric_url");
            return "Failed to report metric";
        }
        int maxRetries = 3;
        int attempt = 0;
        while (attempt < maxRetries) {
            try {
                FetchXInput input = new FetchXInput("POST", Map.of("Content-Type", "application/json"), reportToServer);
                FetchXResponse res = Utils.fetchX(url, input);
                if (res.isOk()) {
                    return res.json();
                }
                System.err.printf("Failed to report to metric server. Attempt: %d. Response: %s. Report data: %s%n", attempt + 1, res.text(), reportToServer);
            }
            catch (Exception e) {
                System.err.printf("Error reporting to metric server (attempt %d): %s. Error: %s%n", attempt + 1, reportToServer, e.getMessage());
            }
            if (++attempt >= maxRetries) continue;
            try {
                TimeUnit.SECONDS.sleep((long)Math.pow(2.0, attempt));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return "Failed to report metric after multiple attempts";
            }
        }
        return "Failed to report metric after multiple attempts";
    }

    public static class FetchXInput {
        private final String method;
        private final Map<String, String> headers;
        private final String body;

        public FetchXInput(String method, Map<String, String> headers, String body) {
            this.method = method;
            this.headers = headers;
            this.body = body;
        }

        public String getMethod() {
            return this.method;
        }

        public Map<String, String> getHeaders() {
            return this.headers;
        }

        public String getBody() {
            return this.body;
        }
    }

    public static class FetchError
    extends Exception {
        private final HttpURLConnection response;
        private final String data;

        public FetchError(HttpURLConnection response, String data) throws IOException {
            super("Fetch Error: " + response.getResponseCode() + " " + response.getResponseMessage());
            this.response = response;
            this.data = data;
        }

        public HttpURLConnection getResponse() {
            return this.response;
        }

        public String getData() {
            return this.data;
        }
    }

    public static class FetchXResponse {
        private final String data;
        private final boolean ok;

        public FetchXResponse(String data, boolean ok) {
            this.data = data;
            this.ok = ok;
        }

        public String json() {
            return this.data;
        }

        public String text() {
            return this.data;
        }

        public boolean isOk() {
            return this.ok;
        }
    }

    public static class MetricInfo {
        private final Date timestamp;
        private final String sessionId;
        private final String metricName;
        private final String api;
        private final String clientId;
        private final String operator;

        public MetricInfo(Date timestamp, String sessionId, String metricName, String api, String clientId, String operator) {
            this.timestamp = timestamp;
            this.sessionId = sessionId;
            this.metricName = metricName;
            this.api = api;
            this.clientId = clientId;
            this.operator = operator;
        }

        public Date getTimestamp() {
            return this.timestamp;
        }

        public String getSessionId() {
            return this.sessionId;
        }

        public String getMetricName() {
            return this.metricName;
        }

        public String getApi() {
            return this.api;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getOperator() {
            return this.operator;
        }
    }

    public static class InsufficientSessionError
    extends Exception {
        private final Integer have;
        private final Integer need;

        public InsufficientSessionError(Integer have, Integer need, String message) {
            super(message != null ? message : "Session is required for this request");
            this.have = have;
            this.need = need;
        }

        public Integer getHave() {
            return this.have;
        }

        public Integer getNeed() {
            return this.need;
        }
    }

    public static class HTTPResponseError
    extends Exception {
        private final HttpURLConnection response;

        public HTTPResponseError(HttpURLConnection response) throws IOException {
            super("HTTP Error Response: " + response.getResponseCode() + " " + response.getResponseMessage());
            this.response = response;
        }

        public HttpURLConnection getResponse() {
            return this.response;
        }
    }
}

