/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.services;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.glideapi.Types;
import com.glideapi.Utils;
import com.glideapi.exceptions.MagicAuthError;
import com.glideapi.exceptions.MagicAuthErrorCode;
import com.glideapi.services.dto.MagicAuthDtos;
import com.glideapi.session.SessionStrategy;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class MagicAuthClient {
    private final Types.GlideSdkSettings settings;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final boolean autoSession;
    private final SessionStrategy sessionStrategy;
    private Types.Session session = null;
    private MagicAuthDtos.MagicAuthSession magicAuthSession = null;
    private static final String AGGREGATOR_ID = "glide";

    public MagicAuthClient(Types.GlideSdkSettings settings) {
        this(settings, false, null);
    }

    public MagicAuthClient(Types.GlideSdkSettings settings, boolean autoSession, SessionStrategy sessionStrategy) {
        this.settings = settings;
        this.autoSession = autoSession;
        this.sessionStrategy = sessionStrategy;
    }

    private void handleErrorResponse(HttpResponse<String> response, String operation) throws Exception {
        Map<String, Object> errorBody = new HashMap<String, Object>();
        try {
            errorBody = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        }
        catch (Exception e) {
            errorBody.put("code", MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode());
            errorBody.put("message", "Failed to " + operation + ": " + response.body());
            errorBody.put("status", response.statusCode());
        }
        if (!errorBody.containsKey("status")) {
            errorBody.put("status", response.statusCode());
        }
        throw new MagicAuthError(errorBody);
    }

    public MagicAuthStartResponse startAuth(BaseMagicAuthStartProps props, Types.ApiConfig conf) throws Exception {
        HttpRequest request;
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new MagicAuthError(MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode(), 500, "[GlideClient] internal.apiBaseUrl is unset");
        }
        if (conf.getSessionIdentifier() != null) {
            this.reportMagicAuthMetric(conf.getSessionIdentifier(), "Glide start");
        }
        Types.Session session = conf.getSession() != null ? conf.getSession() : this.getSession();
        HashMap<String, String> data = new HashMap<String, String>();
        if (props.phoneNumber != null) {
            data.put("phoneNumber", props.phoneNumber);
        }
        if (props.email != null) {
            data.put("email", props.email);
        }
        if (props.fallbackChannel != null) {
            data.put("fallbackChannel", props.fallbackChannel.name());
        }
        if (props.redirectUrl != null) {
            data.put("redirectUrl", props.redirectUrl);
        }
        if (props.state != null) {
            data.put("state", props.state);
        }
        if (props.deviceIpAddress != null) {
            data.put("deviceIpAddress", props.deviceIpAddress);
        }
        if (props.phoneNumber == null && props.email == null) {
            throw new IllegalArgumentException("Either phoneNumber or email must be provided");
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/magic-auth/verification/start")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString(data))).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            this.handleErrorResponse(response, "start auth");
        }
        MagicAuthStartResponse result = (MagicAuthStartResponse)objectMapper.readValue(response.body(), MagicAuthStartResponse.class);
        if (conf.getSessionIdentifier() != null && result.getOperatorId() != null) {
            this.reportMagicAuthMetric(conf.getSessionIdentifier(), "Glide verificationStartRes", result.getOperatorId());
        }
        return result;
    }

    public MagicAuthStartServerAuthResponse startServerAuth(BaseMagicAuthStartProps props, Types.ApiConfig conf) throws Exception {
        HttpRequest request;
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new MagicAuthError(MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode(), 500, "[GlideClient] internal.apiBaseUrl is unset");
        }
        Types.Session session = conf.getSession() != null ? conf.getSession() : this.getSession();
        HashMap<String, String> data = new HashMap<String, String>();
        if (props.phoneNumber != null) {
            data.put("phoneNumber", props.phoneNumber);
        }
        if (props.email != null) {
            data.put("email", props.email);
        }
        if (props.fallbackChannel != null) {
            data.put("fallbackChannel", props.fallbackChannel.name());
        }
        if (props.redirectUrl != null) {
            data.put("redirectUrl", props.redirectUrl);
        }
        if (props.state != null) {
            data.put("state", props.state);
        }
        if (props.otpConfirmationUrl != null) {
            data.put("otpConfirmationUrl", props.otpConfirmationUrl);
        }
        if (props.rcsConfirmationUrl != null) {
            data.put("rcsConfirmationUrl", props.rcsConfirmationUrl);
        }
        if (props.phoneNumber == null && props.email == null) {
            throw new IllegalArgumentException("Either phoneNumber or email must be provided");
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/magic-auth/verification/start-server-auth")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString(data))).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            this.handleErrorResponse(response, "start server auth");
        }
        return (MagicAuthStartServerAuthResponse)objectMapper.readValue(response.body(), MagicAuthStartServerAuthResponse.class);
    }

    public MagicAuthCheckResponse verifyAuth(MagicAuthVerifyProps props, Types.ApiConfig conf) throws Exception {
        HttpRequest request;
        boolean hasValidFields;
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new MagicAuthError(MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode(), 500, "[GlideClient] internal.apiBaseUrl is unset");
        }
        Types.Session session = conf.getSession() != null ? conf.getSession() : this.getSession();
        HashMap<String, String> data = new HashMap<String, String>();
        if (props.phoneNumber != null) {
            data.put("phoneNumber", props.phoneNumber);
        }
        if (props.email != null) {
            data.put("email", props.email);
        }
        if (props.code != null) {
            data.put("code", props.code);
        }
        if (props.token != null) {
            data.put("token", props.token);
        }
        if (props.deviceIpAddress != null) {
            data.put("deviceIpAddress", props.deviceIpAddress);
        }
        boolean bl = hasValidFields = props.phoneNumber != null && props.token != null || props.email != null && props.code != null || props.phoneNumber != null && props.code != null;
        if (!hasValidFields) {
            throw new IllegalArgumentException("Invalid combination of fields. Must provide either: (phoneNumber + token) or (email + code) or (phoneNumber + code)");
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/magic-auth/verification/check")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString(data))).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            this.handleErrorResponse(response, "verify auth");
        }
        if (conf.getSessionIdentifier() != null) {
            this.reportMagicAuthMetric(conf.getSessionIdentifier(), "Glide success");
        }
        MagicAuthCheckResponse result = (MagicAuthCheckResponse)objectMapper.readValue(response.body(), MagicAuthCheckResponse.class);
        if (conf.getSessionIdentifier() != null) {
            if (result.isVerified()) {
                this.reportMagicAuthMetric(conf.getSessionIdentifier(), "Glide verified");
            } else {
                this.reportMagicAuthMetric(conf.getSessionIdentifier(), "Glide unverified");
            }
        }
        return result;
    }

    public MagicAuthCheckServerAuthResponse checkServerAuth(String sessionId, Types.ApiConfig conf) throws Exception {
        HttpRequest request;
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new MagicAuthError(MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode(), 500, "[GlideClient] internal.apiBaseUrl is unset");
        }
        Types.Session session = conf.getSession() != null ? conf.getSession() : this.getSession();
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/magic-auth/verification/check-server-auth?sessionId=" + sessionId)).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).GET().build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            this.handleErrorResponse(response, "check server auth");
        }
        return (MagicAuthCheckServerAuthResponse)objectMapper.readValue(response.body(), MagicAuthCheckServerAuthResponse.class);
    }

    public Object prepare(MagicAuthDtos.AuthV2PrepDto props, Types.ApiConfig conf) throws Exception {
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new MagicAuthError(MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode(), 500, "[GlideClient] internal.apiBaseUrl is unset");
        }
        try {
            Object ts43Obj;
            if (props.getUseCase() == null) {
                throw new IllegalArgumentException("use_case is required");
            }
            if (props.getPlmn() == null && props.getPhoneNumber() == null) {
                throw new IllegalArgumentException("Either plmn or phone_number must be provided");
            }
            if (props.getUseCase() == MagicAuthDtos.UseCase.VERIFY_PHONE_NUMBER && props.getPhoneNumber() == null) {
                throw new IllegalArgumentException("phone_number is required for VerifyPhoneNumber use case");
            }
            Types.Session session = conf.getSession() != null ? conf.getSession() : this.getSession();
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            if (props.getPhoneNumber() != null) {
                requestBody.put("phone_number", props.getPhoneNumber());
            }
            if (props.getPlmn() != null) {
                requestBody.put("mcc", props.getPlmn().getMcc());
                requestBody.put("mnc", props.getPlmn().getMnc());
            }
            requestBody.put("nonce", UUID.randomUUID().toString());
            requestBody.put("id", AGGREGATOR_ID);
            requestBody.put("use_case", props.getUseCase().getValue());
            if (props.getConsentData() != null) {
                HashMap<String, String> consentMap = new HashMap<String, String>();
                consentMap.put("consent_text", props.getConsentData().getConsentText());
                consentMap.put("policy_link", props.getConsentData().getPolicyLink());
                consentMap.put("policy_text", props.getConsentData().getPolicyText());
                requestBody.put("consent_data", consentMap);
            }
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + "/magic-auth/v2/auth/prep")).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString(requestBody))).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            Map responseBody = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
            if (response.statusCode() < 200 || response.statusCode() >= 300) {
                this.handleErrorResponse(response, "prepare authentication");
            }
            if (responseBody.containsKey("eligible") && Boolean.FALSE.equals(responseBody.get("eligible"))) {
                return objectMapper.convertValue((Object)responseBody, MagicAuthDtos.AuthV2PrepNotEligibleResponse.class);
            }
            if (responseBody.containsKey("mcc") && responseBody.containsKey("mnc")) {
                String mcc = (String)responseBody.get("mcc");
                String mnc = (String)responseBody.get("mnc");
                long expiresAt = System.currentTimeMillis() + 300000L;
                this.magicAuthSession = new MagicAuthDtos.MagicAuthSession(mcc, mnc, expiresAt);
            }
            if ((ts43Obj = responseBody.get("ts43")) instanceof Map) {
                Object ts43SessionObj;
                Map ts43 = (Map)ts43Obj;
                MagicAuthDtos.AuthV2PrepResponse prepResponse = new MagicAuthDtos.AuthV2PrepResponse();
                prepResponse.setProtocol("openid4vp-v1-unsigned");
                Object ts43RequestObj = ts43.get("request");
                if (ts43RequestObj instanceof Map) {
                    Object claimsObj;
                    Map ts43Request = (Map)ts43RequestObj;
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("nonce", requestBody.get("nonce"));
                    data.put("response_mode", "dc_api");
                    data.put("response_type", "vp_token");
                    HashMap dcqlQuery = new HashMap();
                    ArrayList credentials = new ArrayList();
                    HashMap credential = new HashMap();
                    credential.put("id", ts43Request.get("id"));
                    credential.put("format", ts43Request.get("format"));
                    Object metaObj = ts43Request.get("meta");
                    if (metaObj instanceof Map) {
                        Map meta = (Map)metaObj;
                        credential.put("meta", meta);
                    }
                    if ((claimsObj = ts43Request.get("claims")) instanceof List) {
                        List claims = (List)claimsObj;
                        credential.put("claims", claims);
                    }
                    credentials.add(credential);
                    dcqlQuery.put("credentials", credentials);
                    data.put("dcql_query", dcqlQuery);
                    prepResponse.setData(data);
                }
                if ((ts43SessionObj = ts43.get("session")) instanceof Map) {
                    Map ts43Session = (Map)ts43SessionObj;
                    MagicAuthDtos.SessionPayloadRaw sessionPayload = (MagicAuthDtos.SessionPayloadRaw)objectMapper.convertValue((Object)ts43Session, MagicAuthDtos.SessionPayloadRaw.class);
                    prepResponse.setSession(sessionPayload);
                }
                return prepResponse;
            }
            return responseBody;
        }
        catch (MagicAuthError e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public MagicAuthDtos.AuthenticateResponse processCredential(MagicAuthDtos.AuthV2ProcessCredentialDto props, Types.ApiConfig conf) throws Exception {
        if (conf == null) {
            conf = new Types.ApiConfig();
        }
        if (this.settings.getInternal().getApiBaseUrl() == null) {
            throw new MagicAuthError(MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode(), 500, "[GlideClient] internal.apiBaseUrl is unset");
        }
        try {
            HttpRequest request;
            HttpClient client;
            HttpResponse<String> response;
            Iterator<Map.Entry<String, Object>> iterator;
            if (props.getCredentialResponse() == null || props.getSession() == null) {
                throw new IllegalArgumentException("credentialResponse and session are required");
            }
            Types.Session session = conf.getSession() != null ? conf.getSession() : this.getSession();
            String endpoint = props.getPhoneNumber() != null ? "/magic-auth/v2/auth/verify-phone-number" : "/magic-auth/v2/auth/get-phone-number";
            String vpToken = null;
            if (props.getCredentialResponse().getVpToken() != null && (iterator = props.getCredentialResponse().getVpToken().entrySet().iterator()).hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                Object value = entry.getValue();
                if (value instanceof String) {
                    vpToken = (String)value;
                } else if (value instanceof List && !((List)value).isEmpty()) {
                    vpToken = (String)((List)value).get(0);
                }
            }
            if (vpToken == null) {
                throw new IllegalArgumentException("No VP token found in credential response");
            }
            HashMap<String, Object> requestBody = new HashMap<String, Object>();
            HashMap<String, String> sessionMap = new HashMap<String, String>();
            sessionMap.put("session_key", props.getSession().getSessionKey());
            sessionMap.put("nonce", props.getSession().getNonce());
            sessionMap.put("enc_key", props.getSession().getEncKey());
            requestBody.put("session", sessionMap);
            requestBody.put("ts43_dc", vpToken);
            requestBody.put("carrier_id", "310-260");
            if (props.getPhoneNumber() != null) {
                requestBody.put("phone_number", props.getPhoneNumber());
            }
            if (props.getOptions() != null && props.getOptions().getSessionMeta() != null) {
                HashMap<String, String> sessionMetaMap = new HashMap<String, String>();
                MagicAuthDtos.SessionMeta meta = props.getOptions().getSessionMeta();
                if (meta.getTerminalId() != null) {
                    sessionMetaMap.put("terminal_id", meta.getTerminalId());
                }
                if (meta.getApp() != null) {
                    sessionMetaMap.put("app", meta.getApp());
                }
                if (meta.getAppName() != null) {
                    sessionMetaMap.put("app_name", meta.getAppName());
                }
                if (meta.getTerminalVendor() != null) {
                    sessionMetaMap.put("terminal_vendor", meta.getTerminalVendor());
                }
                if (meta.getTerminalModel() != null) {
                    sessionMetaMap.put("terminal_model", meta.getTerminalModel());
                }
                if (meta.getTerminalSwVersion() != null) {
                    sessionMetaMap.put("terminal_sw_version", meta.getTerminalSwVersion());
                }
                if (meta.getVers() != null) {
                    sessionMetaMap.put("vers", meta.getVers());
                }
                if (meta.getEntitlementVersion() != null) {
                    sessionMetaMap.put("entitlement_version", meta.getEntitlementVersion());
                }
                if (meta.getOperation() != null) {
                    sessionMetaMap.put("operation", meta.getOperation());
                }
                if (meta.getOperationTargets() != null) {
                    sessionMetaMap.put("operation_targets", meta.getOperationTargets());
                }
                if (meta.getEapId() != null) {
                    sessionMetaMap.put("eap_id", meta.getEapId());
                }
                requestBody.put("session_meta", sessionMetaMap);
            }
            if ((response = (client = HttpClient.newHttpClient()).send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getApiBaseUrl() + endpoint)).header("Content-Type", "application/json").header("Authorization", "Bearer " + session.getAccessToken()).POST(HttpRequest.BodyPublishers.ofString(objectMapper.writeValueAsString(requestBody))).build(), HttpResponse.BodyHandlers.ofString())).statusCode() < 200 || response.statusCode() >= 300) {
                this.handleErrorResponse(response, "process credential");
            }
            Map responseBody = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
            responseBody.put("success", true);
            return (MagicAuthDtos.AuthenticateResponse)objectMapper.convertValue((Object)responseBody, MagicAuthDtos.AuthenticateResponse.class);
        }
        catch (MagicAuthError e) {
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    public MagicAuthDtos.MagicAuthSession getMagicAuthSession() {
        if (this.magicAuthSession != null && !this.magicAuthSession.isExpired()) {
            return this.magicAuthSession;
        }
        return null;
    }

    public void setMagicAuthSession(MagicAuthDtos.MagicAuthSession session) {
        this.magicAuthSession = session;
    }

    public void clearMagicAuthSession() {
        this.magicAuthSession = null;
    }

    private void reportMagicAuthMetric(String sessionId, String metricName) {
        this.reportMagicAuthMetric(sessionId, metricName, null);
    }

    private void reportMagicAuthMetric(String sessionId, String metricName, String operator) {
        Utils.reportMetric(new Utils.MetricInfo(new Date(), sessionId, metricName, "magic-auth", this.settings.getClientId(), operator));
    }

    private Types.Session getSession() throws Exception {
        Types.Session session;
        if (this.autoSession && this.sessionStrategy != null) {
            return this.sessionStrategy.getSession("magic-auth");
        }
        if (this.session != null && this.session.getExpiresAt() > System.currentTimeMillis() && this.session.getScopes().contains("magic-auth")) {
            return this.session;
        }
        this.session = session = this.generateNewSession();
        return session;
    }

    private Types.Session generateNewSession() throws Exception {
        HttpRequest request;
        if (this.settings.getClientId() == null || this.settings.getClientSecret() == null) {
            throw new MagicAuthError(MagicAuthErrorCode.INTERNAL_SERVER_ERROR.getCode(), 500, "[GlideClient] Client credentials are required to generate a new session");
        }
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().uri(URI.create(this.settings.getInternal().getAuthBaseUrl() + "/oauth2/token")).header("Content-Type", "application/x-www-form-urlencoded").header("Authorization", "Basic " + Base64.getEncoder().encodeToString((this.settings.getClientId() + ":" + this.settings.getClientSecret()).getBytes(StandardCharsets.UTF_8))).POST(HttpRequest.BodyPublishers.ofString("grant_type=client_credentials&scope=magic-auth")).build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() < 200 || response.statusCode() >= 300) {
            if (response.statusCode() == 401) {
                throw new RuntimeException("[GlideClient] Invalid client credentials");
            }
            if (response.statusCode() == 400) {
                Map errorBody = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
                if ("invalid_scope".equals(errorBody.get("error"))) {
                    throw new RuntimeException("[GlideClient] Client does not have required scopes to access this method");
                }
                throw new RuntimeException("[GlideClient] Invalid request");
            }
            throw new RuntimeException("Failed to generate new session: " + response.body());
        }
        Map body = (Map)objectMapper.readValue(response.body(), (TypeReference)new TypeReference<Map<String, Object>>(this){});
        return new Types.Session((String)body.get("access_token"), System.currentTimeMillis() + (long)((Integer)body.get("expires_in")).intValue() * 1000L, Arrays.asList(((String)body.get("scope")).split(" ")));
    }

    public static class BaseMagicAuthStartProps {
        public String phoneNumber;
        public String email;
        public FallbackVerificationChannel fallbackChannel;
        public String redirectUrl;
        public String state;
        public String deviceIpAddress;
        public String otpConfirmationUrl;
        public String rcsConfirmationUrl;

        public BaseMagicAuthStartProps setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public BaseMagicAuthStartProps setEmail(String email) {
            this.email = email;
            return this;
        }

        public BaseMagicAuthStartProps setFallbackChannel(FallbackVerificationChannel fallbackChannel) {
            this.fallbackChannel = fallbackChannel;
            return this;
        }

        public BaseMagicAuthStartProps setRedirectUrl(String redirectUrl) {
            this.redirectUrl = redirectUrl;
            return this;
        }

        public BaseMagicAuthStartProps setState(String state) {
            this.state = state;
            return this;
        }

        public BaseMagicAuthStartProps setDeviceIpAddress(String deviceIpAddress) {
            this.deviceIpAddress = deviceIpAddress;
            return this;
        }

        public BaseMagicAuthStartProps setOtpConfirmationUrl(String otpConfirmationUrl) {
            this.otpConfirmationUrl = otpConfirmationUrl;
            return this;
        }

        public BaseMagicAuthStartProps setRcsConfirmationUrl(String rcsConfirmationUrl) {
            this.rcsConfirmationUrl = rcsConfirmationUrl;
            return this;
        }
    }

    public static enum FallbackVerificationChannel {
        SMS,
        EMAIL,
        NO_FALLBACK;

    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicAuthStartResponse {
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="authUrl")
        public String authUrl;
        @JsonProperty(value="flatAuthUrl")
        public String flatAuthUrl;
        @JsonProperty(value="operatorId")
        public String operatorId;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAuthUrl() {
            return this.authUrl;
        }

        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }

        public String getFlatAuthUrl() {
            return this.flatAuthUrl;
        }

        public void setFlatAuthUrl(String flatAuthUrl) {
            this.flatAuthUrl = flatAuthUrl;
        }

        public String getOperatorId() {
            return this.operatorId;
        }

        public void setOperatorId(String operatorId) {
            this.operatorId = operatorId;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicAuthStartServerAuthResponse {
        @JsonProperty(value="sessionId")
        public String sessionId;
        @JsonProperty(value="authUrl")
        public String authUrl;

        public String getSessionId() {
            return this.sessionId;
        }

        public void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public String getAuthUrl() {
            return this.authUrl;
        }

        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }
    }

    public static class MagicAuthVerifyProps {
        public String code;
        public String phoneNumber;
        public String email;
        public String token;
        public String deviceIpAddress;

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getDeviceIpAddress() {
            return this.deviceIpAddress;
        }

        public void setDeviceIpAddress(String deviceIpAddress) {
            this.deviceIpAddress = deviceIpAddress;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicAuthCheckResponse {
        @JsonProperty(value="verified")
        public boolean verified;

        public boolean isVerified() {
            return this.verified;
        }

        public void setVerified(boolean verified) {
            this.verified = verified;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicAuthCheckServerAuthResponse {
        @JsonProperty(value="status")
        public String status;
        @JsonProperty(value="verified")
        public boolean verified;

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public boolean isVerified() {
            return this.verified;
        }

        public void setVerified(boolean verified) {
            this.verified = verified;
        }
    }

    public static class MagicAuthStartMagicResponse {
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="authUrl")
        public String authUrl;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getAuthUrl() {
            return this.authUrl;
        }

        public void setAuthUrl(String authUrl) {
            this.authUrl = authUrl;
        }
    }

    public static class MagicAuthStartCodeResponse {
        @JsonProperty(value="type")
        public String type;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

