/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.services.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;

public class MagicAuthDtos {

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuthenticateResponse
    extends HashMap<String, Object> {
        public boolean isSuccess() {
            return Boolean.TRUE.equals(this.get("success"));
        }

        public void setSuccess(boolean success) {
            this.put("success", success);
        }

        public String getPhoneNumber() {
            Object phoneNumber = this.get("phone_number");
            if (phoneNumber == null) {
                phoneNumber = this.get("phoneNumber");
            }
            return phoneNumber != null ? phoneNumber.toString() : null;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.put("phone_number", phoneNumber);
        }

        public Boolean getVerified() {
            Object verified = this.get("verified");
            return verified != null ? Boolean.valueOf(verified.toString()) : null;
        }

        public void setVerified(Boolean verified) {
            this.put("verified", verified);
        }

        public String getError() {
            Object error = this.get("error");
            return error != null ? error.toString() : null;
        }

        public void setError(String error) {
            this.put("error", error);
        }

        public String getAud() {
            Object aud = this.get("aud");
            return aud != null ? aud.toString() : null;
        }

        public void setAud(String aud) {
            this.put("aud", aud);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuthV2PrepNotEligibleResponse {
        @JsonProperty(value="eligible")
        private boolean eligible;
        @JsonProperty(value="carrier_name")
        private String carrierName;
        @JsonProperty(value="reason")
        private String reason;

        public boolean isEligible() {
            return this.eligible;
        }

        public void setEligible(boolean eligible) {
            this.eligible = eligible;
        }

        public String getCarrierName() {
            return this.carrierName;
        }

        public void setCarrierName(String carrierName) {
            this.carrierName = carrierName;
        }

        public String getReason() {
            return this.reason;
        }

        public void setReason(String reason) {
            this.reason = reason;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuthV2PrepResponse {
        @JsonProperty(value="protocol")
        private String protocol;
        @JsonProperty(value="data")
        private Map<String, Object> data;
        @JsonProperty(value="session")
        private SessionPayloadRaw session;

        public String getProtocol() {
            return this.protocol;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }

        public Map<String, Object> getData() {
            return this.data;
        }

        public void setData(Map<String, Object> data) {
            this.data = data;
        }

        public SessionPayloadRaw getSession() {
            return this.session;
        }

        public void setSession(SessionPayloadRaw session) {
            this.session = session;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class MagicAuthSession {
        private String mcc;
        private String mnc;
        private long expiresAt;

        public MagicAuthSession() {
        }

        public MagicAuthSession(String mcc, String mnc, long expiresAt) {
            this.mcc = mcc;
            this.mnc = mnc;
            this.expiresAt = expiresAt;
        }

        public String getMcc() {
            return this.mcc;
        }

        public void setMcc(String mcc) {
            this.mcc = mcc;
        }

        public String getMnc() {
            return this.mnc;
        }

        public void setMnc(String mnc) {
            this.mnc = mnc;
        }

        public long getExpiresAt() {
            return this.expiresAt;
        }

        public void setExpiresAt(long expiresAt) {
            this.expiresAt = expiresAt;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuthV2ProcessCredentialDto {
        private DigitalCredentialResponse credentialResponse;
        private SessionPayloadRaw session;
        private String phoneNumber;
        private ProcessCredentialOptions options;

        public DigitalCredentialResponse getCredentialResponse() {
            return this.credentialResponse;
        }

        public void setCredentialResponse(DigitalCredentialResponse credentialResponse) {
            this.credentialResponse = credentialResponse;
        }

        public SessionPayloadRaw getSession() {
            return this.session;
        }

        public void setSession(SessionPayloadRaw session) {
            this.session = session;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public ProcessCredentialOptions getOptions() {
            return this.options;
        }

        public void setOptions(ProcessCredentialOptions options) {
            this.options = options;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ProcessCredentialOptions {
        @JsonProperty(value="session_meta")
        private SessionMeta sessionMeta;

        public SessionMeta getSessionMeta() {
            return this.sessionMeta;
        }

        public void setSessionMeta(SessionMeta sessionMeta) {
            this.sessionMeta = sessionMeta;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SessionMeta {
        @JsonProperty(value="terminal_id")
        private String terminalId;
        @JsonProperty(value="app")
        private String app;
        @JsonProperty(value="app_name")
        private String appName;
        @JsonProperty(value="terminal_vendor")
        private String terminalVendor;
        @JsonProperty(value="terminal_model")
        private String terminalModel;
        @JsonProperty(value="terminal_sw_version")
        private String terminalSwVersion;
        @JsonProperty(value="vers")
        private String vers;
        @JsonProperty(value="entitlement_version")
        private String entitlementVersion;
        @JsonProperty(value="operation")
        private String operation;
        @JsonProperty(value="operation_targets")
        private String operationTargets;
        @JsonProperty(value="eap_id")
        private String eapId;

        public String getTerminalId() {
            return this.terminalId;
        }

        public void setTerminalId(String terminalId) {
            this.terminalId = terminalId;
        }

        public String getApp() {
            return this.app;
        }

        public void setApp(String app) {
            this.app = app;
        }

        public String getAppName() {
            return this.appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public String getTerminalVendor() {
            return this.terminalVendor;
        }

        public void setTerminalVendor(String terminalVendor) {
            this.terminalVendor = terminalVendor;
        }

        public String getTerminalModel() {
            return this.terminalModel;
        }

        public void setTerminalModel(String terminalModel) {
            this.terminalModel = terminalModel;
        }

        public String getTerminalSwVersion() {
            return this.terminalSwVersion;
        }

        public void setTerminalSwVersion(String terminalSwVersion) {
            this.terminalSwVersion = terminalSwVersion;
        }

        public String getVers() {
            return this.vers;
        }

        public void setVers(String vers) {
            this.vers = vers;
        }

        public String getEntitlementVersion() {
            return this.entitlementVersion;
        }

        public void setEntitlementVersion(String entitlementVersion) {
            this.entitlementVersion = entitlementVersion;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getOperationTargets() {
            return this.operationTargets;
        }

        public void setOperationTargets(String operationTargets) {
            this.operationTargets = operationTargets;
        }

        public String getEapId() {
            return this.eapId;
        }

        public void setEapId(String eapId) {
            this.eapId = eapId;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class DigitalCredentialResponse {
        @JsonProperty(value="vp_token")
        private Map<String, Object> vpToken;

        public Map<String, Object> getVpToken() {
            return this.vpToken;
        }

        public void setVpToken(Map<String, Object> vpToken) {
            this.vpToken = vpToken;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SessionPayloadRaw {
        @JsonProperty(value="session_key")
        private String sessionKey;
        @JsonProperty(value="nonce")
        private String nonce;
        @JsonProperty(value="enc_key")
        private String encKey;

        public String getSessionKey() {
            return this.sessionKey;
        }

        public void setSessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
        }

        public String getNonce() {
            return this.nonce;
        }

        public void setNonce(String nonce) {
            this.nonce = nonce;
        }

        public String getEncKey() {
            return this.encKey;
        }

        public void setEncKey(String encKey) {
            this.encKey = encKey;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class AuthV2PrepDto {
        @JsonProperty(value="plmn")
        private PlmnDto plmn;
        @JsonProperty(value="phone_number")
        private String phoneNumber;
        @JsonProperty(value="fetch_token")
        private Boolean fetchToken;
        @JsonProperty(value="use_case")
        private UseCase useCase;
        @JsonProperty(value="consent_data")
        private ConsentData consentData;

        public PlmnDto getPlmn() {
            return this.plmn;
        }

        public void setPlmn(PlmnDto plmn) {
            this.plmn = plmn;
        }

        public String getPhoneNumber() {
            return this.phoneNumber;
        }

        public void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public Boolean getFetchToken() {
            return this.fetchToken;
        }

        public void setFetchToken(Boolean fetchToken) {
            this.fetchToken = fetchToken;
        }

        public UseCase getUseCase() {
            return this.useCase;
        }

        public void setUseCase(UseCase useCase) {
            this.useCase = useCase;
        }

        public ConsentData getConsentData() {
            return this.consentData;
        }

        public void setConsentData(ConsentData consentData) {
            this.consentData = consentData;
        }
    }

    public static enum UseCase {
        GET_PHONE_NUMBER("GetPhoneNumber"),
        VERIFY_PHONE_NUMBER("VerifyPhoneNumber");

        private final String value;

        private UseCase(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.value;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ConsentData {
        @JsonProperty(value="consent_text")
        private String consentText;
        @JsonProperty(value="policy_link")
        private String policyLink;
        @JsonProperty(value="policy_text")
        private String policyText;

        public ConsentData() {
        }

        public ConsentData(String consentText, String policyLink, String policyText) {
            this.consentText = consentText;
            this.policyLink = policyLink;
            this.policyText = policyText;
        }

        public String getConsentText() {
            return this.consentText;
        }

        public void setConsentText(String consentText) {
            this.consentText = consentText;
        }

        public String getPolicyLink() {
            return this.policyLink;
        }

        public void setPolicyLink(String policyLink) {
            this.policyLink = policyLink;
        }

        public String getPolicyText() {
            return this.policyText;
        }

        public void setPolicyText(String policyText) {
            this.policyText = policyText;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PlmnDto {
        @JsonProperty(value="mcc")
        private String mcc;
        @JsonProperty(value="mnc")
        private String mnc;

        public PlmnDto() {
        }

        public PlmnDto(String mcc, String mnc) {
            this.mcc = mcc;
            this.mnc = mnc;
        }

        public String getMcc() {
            return this.mcc;
        }

        public void setMcc(String mcc) {
            this.mcc = mcc;
        }

        public String getMnc() {
            return this.mnc;
        }

        public void setMnc(String mnc) {
            this.mnc = mnc;
        }
    }
}

