/*
 * Decompiled with CFR 0.152.
 */
package com.glideapi.session;

import com.glideapi.GlideClient;
import com.glideapi.Types;
import com.glideapi.session.SessionStrategy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class CachedStrategy
implements SessionStrategy {
    private final GlideClient client;
    private final ConcurrentHashMap<String, Types.Session> sessionCache = new ConcurrentHashMap();

    public CachedStrategy(GlideClient client) {
        this.client = client;
    }

    @Override
    public synchronized Types.Session getSession() throws Exception {
        return this.getSession("magic-auth sim-swap number-verify telco-finder");
    }

    @Override
    public synchronized Types.Session getSession(String scope) throws Exception {
        Types.Session session = this.sessionCache.get(scope);
        if (session != null && session.getExpiresAt() > System.currentTimeMillis() + 60000L) {
            return session;
        }
        session = this.client.createSession(scope);
        this.sessionCache.put(scope, session);
        return session;
    }

    @Override
    public CompletableFuture<Types.Session> getSessionAsync() {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.getSession();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    public void clearCache() {
        this.sessionCache.clear();
    }
}

