/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataset;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.gooddata.dataset.FailPart;
import com.gooddata.gdc.ErrorStructure;
import com.gooddata.util.GDDateTimeDeserializer;
import com.gooddata.util.GDDateTimeSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FailStatus {
    private final String status;
    private final DateTime date;
    private final ErrorStructure error;
    private final List<FailPart> parts;

    @JsonCreator
    private FailStatus(@JsonProperty(value="status") String status, @JsonProperty(value="date") @JsonDeserialize(using=GDDateTimeDeserializer.class) DateTime date, @JsonProperty(value="error") ErrorStructure error, @JsonProperty(value="parts") List<FailPart> parts) {
        this.status = status;
        this.date = date;
        this.error = error;
        this.parts = parts;
    }

    public String getStatus() {
        return this.status;
    }

    @JsonSerialize(using=GDDateTimeSerializer.class)
    public DateTime getDate() {
        return this.date;
    }

    public ErrorStructure getError() {
        return this.error;
    }

    public List<FailPart> getParts() {
        return this.parts;
    }

    @JsonIgnore
    public List<FailPart> getErrorParts() {
        if (this.parts == null) {
            return Collections.emptyList();
        }
        ArrayList<FailPart> result = new ArrayList<FailPart>(this.parts.size());
        for (FailPart part : this.parts) {
            if (!"ERROR".equals(part.getStatus())) continue;
            result.add(part);
        }
        return result;
    }
}

