/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.collections;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gooddata.collections.Paging;
import com.gooddata.util.Validate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public abstract class PageableListDeserializer<T, E>
extends JsonDeserializer<T> {
    private static final TypeReference<Map<String, String>> LINKS_TYPE = new TypeReference<Map<String, String>>(){};
    private final Class<E> elementType;
    private final String collectionName;

    protected PageableListDeserializer(Class<E> elementType) {
        this(elementType, "items");
    }

    protected PageableListDeserializer(Class<E> elementType, String collectionName) {
        this.elementType = Validate.notNull(elementType, "elementType");
        this.collectionName = Validate.notNull(collectionName, "collectionName");
    }

    protected abstract T createList(List<E> var1, Paging var2, Map<String, String> var3);

    public T deserialize(JsonParser jp, DeserializationContext context) throws IOException, JsonProcessingException {
        List items;
        JsonNode root = (JsonNode)jp.readValueAsTree();
        if (root == null || root.isNull()) {
            return null;
        }
        ObjectMapper objectMapper = (ObjectMapper)jp.getCodec();
        JsonNode pagingNode = root.get("paging");
        Paging paging = pagingNode == null ? null : (Paging)objectMapper.convertValue((Object)pagingNode, Paging.class);
        JsonNode linksNode = root.get("links");
        Map links = linksNode != null ? (Map)objectMapper.convertValue((Object)linksNode, LINKS_TYPE) : null;
        JsonNode itemsNode = root.get(this.collectionName);
        if (itemsNode == null) {
            items = Collections.emptyList();
        } else {
            items = new ArrayList(itemsNode.size());
            for (JsonNode item : itemsNode) {
                items.add(objectMapper.convertValue((Object)item, this.elementType));
            }
        }
        return this.createList(items, paging, links);
    }
}

