/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.featureflag;

import com.gooddata.AbstractService;
import com.gooddata.GoodDataException;
import com.gooddata.featureflag.FeatureFlags;
import com.gooddata.featureflag.ProjectFeatureFlag;
import com.gooddata.featureflag.ProjectFeatureFlags;
import com.gooddata.project.Project;
import com.gooddata.util.Validate;
import java.net.URI;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class FeatureFlagService
extends AbstractService {
    public FeatureFlagService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public FeatureFlags listFeatureFlags(Project project) {
        Validate.notNull(project, "project");
        try {
            FeatureFlags featureFlags = (FeatureFlags)this.restTemplate.getForObject(FeatureFlags.AGGREGATED_FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}), FeatureFlags.class);
            if (featureFlags == null) {
                throw new GoodDataException("empty response from API call");
            }
            return featureFlags;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list aggregated feature flags for project ID=" + project.getId(), e);
        }
    }

    public ProjectFeatureFlags listProjectFeatureFlags(Project project) {
        Validate.notNull(project, "project");
        try {
            ProjectFeatureFlags projectFeatureFlags = (ProjectFeatureFlags)this.restTemplate.getForObject(ProjectFeatureFlags.PROJECT_FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}), ProjectFeatureFlags.class);
            if (projectFeatureFlags == null) {
                throw new GoodDataException("empty response from API call");
            }
            return projectFeatureFlags;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to list project feature flags for project ID=" + project.getId(), e);
        }
    }

    public ProjectFeatureFlag getProjectFeatureFlag(Project project, String featureFlagName) {
        Validate.notNull(project, "project");
        Validate.notEmpty(featureFlagName, "featureFlagName");
        try {
            ProjectFeatureFlag flag = this.getProjectFeatureFlag(this.getProjectFeatureFlagUri(project, featureFlagName));
            if (flag == null) {
                throw new GoodDataException("empty response from API call");
            }
            return flag;
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to get project feature flag: " + featureFlagName, e);
        }
    }

    public ProjectFeatureFlag createProjectFeatureFlag(Project project, ProjectFeatureFlag flag) {
        Validate.notNull(project, "project");
        Validate.notNull(flag, "flag");
        String featureFlagsUri = ProjectFeatureFlags.PROJECT_FEATURE_FLAGS_TEMPLATE.expand(new Object[]{project.getId()}).toString();
        try {
            URI featureFlagUri = this.restTemplate.postForLocation(featureFlagsUri, (Object)flag, new Object[0]);
            if (featureFlagUri == null) {
                throw new GoodDataException("URI of new project feature flag can't be null");
            }
            return this.getProjectFeatureFlag(featureFlagUri.toString());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to create project feature flag: " + flag, e);
        }
    }

    public ProjectFeatureFlag updateProjectFeatureFlag(ProjectFeatureFlag flag) {
        Validate.notNull(flag, "flag");
        Validate.notEmpty(flag.getUri(), "flag.uri");
        try {
            this.restTemplate.put(flag.getUri(), (Object)flag, new Object[0]);
            return this.getProjectFeatureFlag(flag.getUri());
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to update project feature flag: " + flag, e);
        }
    }

    @Deprecated
    public void deleteFeatureFlag(ProjectFeatureFlag flag) {
        this.deleteProjectFeatureFlag(flag);
    }

    public void deleteProjectFeatureFlag(ProjectFeatureFlag flag) {
        Validate.notNull(flag, "flag");
        Validate.notEmpty(flag.getUri(), "flag URI");
        try {
            this.restTemplate.delete(flag.getUri(), new Object[0]);
        }
        catch (GoodDataException | RestClientException e) {
            throw new GoodDataException("Unable to delete project feature flag: " + flag, e);
        }
    }

    String getProjectFeatureFlagUri(Project project, String flagName) {
        return ProjectFeatureFlag.PROJECT_FEATURE_FLAG_TEMPLATE.expand(new Object[]{project.getId(), flagName}).toString();
    }

    private ProjectFeatureFlag getProjectFeatureFlag(String flagUri) {
        ProjectFeatureFlag result = (ProjectFeatureFlag)this.restTemplate.getForObject(flagUri, ProjectFeatureFlag.class, new Object[0]);
        if (result == null) {
            throw new GoodDataException("Project feature flag cannot be retrieved from URI " + flagUri);
        }
        return result;
    }
}

