/*
 * Decompiled with CFR 0.152.
 */
package com.gooddata.dataload;

import com.gooddata.AbstractService;
import com.gooddata.GoodDataException;
import com.gooddata.GoodDataRestException;
import com.gooddata.GoodDataSettings;
import com.gooddata.dataload.OutputStage;
import com.gooddata.project.Project;
import com.gooddata.util.Validate;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class OutputStageService
extends AbstractService {
    public OutputStageService(RestTemplate restTemplate, GoodDataSettings settings) {
        super(restTemplate, settings);
    }

    @Deprecated
    public OutputStageService(RestTemplate restTemplate) {
        super(restTemplate);
    }

    public OutputStage getOutputStageByUri(String uri) {
        Validate.notEmpty((CharSequence)uri, (String)"uri");
        Validate.isTrue((boolean)OutputStage.TEMPLATE.matches(uri), (String)("uri does not match output stage pattern: " + OutputStage.TEMPLATE.toString()));
        try {
            return (OutputStage)this.restTemplate.getForObject(uri, OutputStage.class, new Object[0]);
        }
        catch (RestClientException e) {
            throw new GoodDataException("Unable to get output stage " + uri, (Throwable)e);
        }
    }

    public OutputStage getOutputStage(Project project) {
        Validate.notNull((Object)project, (String)"project");
        Validate.notNull((Object)project.getId(), (String)"project.id");
        return this.getOutputStageByUri(OutputStage.TEMPLATE.expand(new Object[]{project.getId()}).toString());
    }

    public OutputStage updateOutputStage(OutputStage outputStage) {
        Validate.notNull((Object)outputStage, (String)"outputStage");
        Validate.notNull((Object)outputStage.getUri(), (String)"outputStage.uri");
        try {
            HttpEntity outputStageHttpEntity = new HttpEntity((Object)outputStage);
            ResponseEntity response = this.restTemplate.exchange(outputStage.getUri(), HttpMethod.PUT, outputStageHttpEntity, OutputStage.class, new Object[0]);
            if (response.getBody() == null) {
                throw new RestClientException("unexpected response body");
            }
            return (OutputStage)response.getBody();
        }
        catch (GoodDataRestException | RestClientException e) {
            throw new GoodDataException("Unable to update output stage, uri: " + outputStage.getUri());
        }
    }
}

