/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.ServiceAccount;
import com.google.cloud.compute.Tags;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Instance
extends InstanceInfo {
    private static final long serialVersionUID = 3072508155558980677L;
    private final ComputeOptions options;
    private transient Compute compute;

    Instance(Compute compute, InstanceInfo.BuilderImpl infoBuilder) {
        super(infoBuilder);
        this.compute = (Compute)Preconditions.checkNotNull((Object)compute);
        this.options = (ComputeOptions)compute.options();
    }

    public boolean exists() {
        return this.reload(Compute.InstanceOption.fields(new Compute.InstanceField[0])) != null;
    }

    public Instance reload(Compute.InstanceOption ... options) {
        return this.compute.getInstance(this.instanceId(), options);
    }

    public Operation delete(Compute.OperationOption ... options) {
        return this.compute.deleteInstance(this.instanceId(), options);
    }

    public Operation addAccessConfig(String networkInterface, NetworkInterface.AccessConfig accessConfig, Compute.OperationOption ... options) {
        return this.compute.addAccessConfig(this.instanceId(), networkInterface, accessConfig, options);
    }

    public Operation attachDisk(AttachedDisk.PersistentDiskConfiguration configuration, Compute.OperationOption ... options) {
        return this.compute.attachDisk(this.instanceId(), configuration, options);
    }

    public Operation attachDisk(String deviceName, AttachedDisk.PersistentDiskConfiguration configuration, Compute.OperationOption ... options) {
        return this.compute.attachDisk(this.instanceId(), deviceName, configuration, options);
    }

    public Operation attachDisk(String deviceName, AttachedDisk.PersistentDiskConfiguration configuration, int index, Compute.OperationOption ... options) {
        return this.compute.attachDisk(this.instanceId(), deviceName, configuration, index, options);
    }

    public Operation deleteAccessConfig(String networkInterface, String accessConfig, Compute.OperationOption ... options) {
        return this.compute.deleteAccessConfig(this.instanceId(), networkInterface, accessConfig, options);
    }

    public Operation detachDisk(String deviceName, Compute.OperationOption ... options) {
        return this.compute.detachDisk(this.instanceId(), deviceName, options);
    }

    public String getSerialPortOutput(int port) {
        return this.compute.getSerialPortOutput(this.instanceId(), port);
    }

    public String getSerialPortOutput() {
        return this.compute.getSerialPortOutput(this.instanceId());
    }

    public Operation reset(Compute.OperationOption ... options) {
        return this.compute.reset(this.instanceId(), options);
    }

    public Operation setDiskAutoDelete(String deviceName, boolean autoDelete, Compute.OperationOption ... options) {
        return this.compute.setDiskAutoDelete(this.instanceId(), deviceName, autoDelete, options);
    }

    public Operation setMachineType(MachineTypeId machineType, Compute.OperationOption ... options) {
        return this.compute.setMachineType(this.instanceId(), machineType, options);
    }

    public Operation setMetadata(Metadata metadata, Compute.OperationOption ... options) {
        return this.compute.setMetadata(this.instanceId(), metadata, options);
    }

    public Operation setMetadata(Map<String, String> metadata, Compute.OperationOption ... options) {
        return this.setMetadata(this.metadata().toBuilder().values(metadata).build(), options);
    }

    public Operation setSchedulingOptions(SchedulingOptions scheduling, Compute.OperationOption ... options) {
        return this.compute.setSchedulingOptions(this.instanceId(), scheduling, options);
    }

    public Operation setTags(Tags tags, Compute.OperationOption ... options) {
        return this.compute.setTags(this.instanceId(), tags, options);
    }

    public Operation setTags(Iterable<String> tags, Compute.OperationOption ... options) {
        return this.setTags(this.tags().toBuilder().values(tags).build(), options);
    }

    public Operation start(Compute.OperationOption ... options) {
        return this.compute.start(this.instanceId(), options);
    }

    public Operation stop(Compute.OperationOption ... options) {
        return this.compute.stop(this.instanceId(), options);
    }

    public Compute compute() {
        return this.compute;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(Instance.class)) {
            return false;
        }
        Instance other = (Instance)obj;
        return Objects.equals(this.toPb(), other.toPb()) && Objects.equals((Object)this.options, (Object)other.options);
    }

    @Override
    public final int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.options});
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.compute = (Compute)this.options.service();
    }

    static Instance fromPb(Compute compute, com.google.api.services.compute.model.Instance instancePb) {
        return new Instance(compute, new InstanceInfo.BuilderImpl(instancePb));
    }

    public static class Builder
    extends InstanceInfo.Builder {
        private final Compute compute;
        private final InstanceInfo.BuilderImpl infoBuilder;

        Builder(Compute compute, InstanceId instanceId, MachineTypeId machineType, AttachedDisk attachedDisk, NetworkInterface networkInterface) {
            this.compute = compute;
            this.infoBuilder = new InstanceInfo.BuilderImpl(instanceId);
            this.infoBuilder.machineType(machineType);
            this.infoBuilder.attachedDisks((List<AttachedDisk>)ImmutableList.of((Object)attachedDisk));
            this.infoBuilder.networkInterfaces((List<NetworkInterface>)ImmutableList.of((Object)networkInterface));
        }

        Builder(Instance instance) {
            this.compute = instance.compute;
            this.infoBuilder = new InstanceInfo.BuilderImpl(instance);
        }

        @Override
        Builder generatedId(String generatedId) {
            this.infoBuilder.generatedId(generatedId);
            return this;
        }

        @Override
        public Builder instanceId(InstanceId instanceId) {
            this.infoBuilder.instanceId(instanceId);
            return this;
        }

        @Override
        Builder creationTimestamp(Long creationTimestamp) {
            this.infoBuilder.creationTimestamp(creationTimestamp);
            return this;
        }

        @Override
        public Builder description(String description) {
            this.infoBuilder.description(description);
            return this;
        }

        @Override
        Builder status(InstanceInfo.Status status) {
            this.infoBuilder.status(status);
            return this;
        }

        @Override
        Builder statusMessage(String statusMessage) {
            this.infoBuilder.statusMessage(statusMessage);
            return this;
        }

        @Override
        public Builder tags(Tags tags) {
            this.infoBuilder.tags(tags);
            return this;
        }

        @Override
        public Builder machineType(MachineTypeId machineType) {
            this.infoBuilder.machineType(machineType);
            return this;
        }

        @Override
        public Builder canIpForward(Boolean canIpForward) {
            this.infoBuilder.canIpForward(canIpForward);
            return this;
        }

        @Override
        public Builder networkInterfaces(List<NetworkInterface> networkInterfaces) {
            this.infoBuilder.networkInterfaces(networkInterfaces);
            return this;
        }

        @Override
        public Builder networkInterfaces(NetworkInterface ... networkInterfaces) {
            this.infoBuilder.networkInterfaces(networkInterfaces);
            return this;
        }

        @Override
        public Builder attachedDisks(List<AttachedDisk> attachedDisks) {
            this.infoBuilder.attachedDisks(attachedDisks);
            return this;
        }

        @Override
        public Builder attachedDisks(AttachedDisk ... attachedDisks) {
            this.infoBuilder.attachedDisks(attachedDisks);
            return this;
        }

        @Override
        public Builder metadata(Metadata metadata) {
            this.infoBuilder.metadata(metadata);
            return this;
        }

        @Override
        public Builder serviceAccounts(List<ServiceAccount> serviceAccounts) {
            this.infoBuilder.serviceAccounts(serviceAccounts);
            return this;
        }

        @Override
        public Builder schedulingOptions(SchedulingOptions schedulingOptions) {
            this.infoBuilder.schedulingOptions(schedulingOptions);
            return this;
        }

        @Override
        Builder cpuPlatform(String cpuPlatform) {
            this.infoBuilder.cpuPlatform(cpuPlatform);
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this.compute, this.infoBuilder);
        }
    }
}

