/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.GlobalAddressId;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AddressIdTest {
    private static final String PROJECT = "project";
    private static final String REGION = "region";
    private static final String NAME = "addr";
    private static final String GLOBAL_URL = "https://www.googleapis.com/compute/v1/projects/project/global/addresses/addr";
    private static final String REGION_URL = "https://www.googleapis.com/compute/v1/projects/project/regions/region/addresses/addr";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        GlobalAddressId addressId = GlobalAddressId.of((String)PROJECT, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)addressId.project());
        Assert.assertEquals((Object)NAME, (Object)addressId.address());
        Assert.assertEquals((Object)GLOBAL_URL, (Object)addressId.selfLink());
        addressId = GlobalAddressId.of((String)NAME);
        Assert.assertNull((Object)addressId.project());
        Assert.assertEquals((Object)NAME, (Object)addressId.address());
        RegionAddressId regionAddressId = RegionAddressId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)regionAddressId.project());
        Assert.assertEquals((Object)REGION, (Object)regionAddressId.region());
        Assert.assertEquals((Object)NAME, (Object)regionAddressId.address());
        Assert.assertEquals((Object)REGION_URL, (Object)regionAddressId.selfLink());
        regionAddressId = RegionAddressId.of((RegionId)RegionId.of((String)PROJECT, (String)REGION), (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)regionAddressId.project());
        Assert.assertEquals((Object)REGION, (Object)regionAddressId.region());
        Assert.assertEquals((Object)NAME, (Object)regionAddressId.address());
        Assert.assertEquals((Object)REGION_URL, (Object)regionAddressId.selfLink());
        regionAddressId = RegionAddressId.of((String)REGION, (String)NAME);
        Assert.assertNull((Object)regionAddressId.project());
        Assert.assertEquals((Object)REGION, (Object)regionAddressId.region());
        Assert.assertEquals((Object)NAME, (Object)regionAddressId.address());
    }

    @Test
    public void testToAndFromUrlGlobal() {
        GlobalAddressId addressId = GlobalAddressId.of((String)PROJECT, (String)NAME);
        this.compareAddressId(addressId, GlobalAddressId.fromUrl((String)addressId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid global address URL");
        GlobalAddressId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testToAndFromUrlRegion() {
        RegionAddressId regionAddressId = RegionAddressId.of((String)PROJECT, (String)REGION, (String)NAME);
        this.compareRegionAddressId(regionAddressId, RegionAddressId.fromUrl((String)regionAddressId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid region address URL");
        RegionAddressId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        GlobalAddressId addressId = GlobalAddressId.of((String)PROJECT, (String)NAME);
        Assert.assertSame((Object)addressId, (Object)addressId.setProjectId(PROJECT));
        this.compareAddressId(addressId, GlobalAddressId.of((String)NAME).setProjectId(PROJECT));
        RegionAddressId regionAddressId = RegionAddressId.of((String)PROJECT, (String)REGION, (String)NAME);
        Assert.assertSame((Object)regionAddressId, (Object)regionAddressId.setProjectId(PROJECT));
        this.compareRegionAddressId(regionAddressId, RegionAddressId.of((String)REGION, (String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)GlobalAddressId.matchesUrl((String)GlobalAddressId.of((String)PROJECT, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)GlobalAddressId.matchesUrl((String)"notMatchingUrl"));
        Assert.assertTrue((boolean)RegionAddressId.matchesUrl((String)RegionAddressId.of((String)PROJECT, (String)REGION, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)RegionAddressId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareAddressId(GlobalAddressId expected, GlobalAddressId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.address(), (Object)expected.address());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }

    private void compareRegionAddressId(RegionAddressId expected, RegionAddressId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.region(), (Object)expected.region());
        Assert.assertEquals((Object)expected.address(), (Object)expected.address());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

