/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.GlobalAddressId;
import com.google.cloud.compute.GlobalForwardingRuleId;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionForwardingRuleId;
import com.google.cloud.compute.RegionId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AddressInfoTest {
    private static final String ADDRESS = "192.168.1.1";
    private static final Long CREATION_TIMESTAMP = 1452602400000L;
    private static final String DESCRIPTION = "description";
    private static final String GENERATED_ID = "42";
    private static final GlobalAddressId GLOBAL_ADDRESS_ID = GlobalAddressId.of((String)"project", (String)"address");
    private static final RegionAddressId REGION_ADDRESS_ID = RegionAddressId.of((String)"project", (String)"region", (String)"address");
    private static final AddressInfo.Status STATUS = AddressInfo.Status.RESERVED;
    private static final List<GlobalForwardingRuleId> GLOBAL_FORWARDING_RULES = ImmutableList.of((Object)GlobalForwardingRuleId.of((String)"project", (String)"forwardingRule1"), (Object)GlobalForwardingRuleId.of((String)"project", (String)"forwardingRule2"));
    private static final List<RegionForwardingRuleId> REGION_FORWARDING_RULES = ImmutableList.of((Object)RegionForwardingRuleId.of((String)"project", (String)"region", (String)"forwardingRule1"), (Object)RegionForwardingRuleId.of((String)"project", (String)"region", (String)"forwardingRule2"));
    private static final AddressInfo.InstanceUsage INSTANCE_USAGE = new AddressInfo.InstanceUsage(InstanceId.of((String)"project", (String)"zone", (String)"instance1"));
    private static final AddressInfo.GlobalForwardingUsage GLOBAL_FORWARDING_USAGE = new AddressInfo.GlobalForwardingUsage(GLOBAL_FORWARDING_RULES);
    private static final AddressInfo.RegionForwardingUsage REGION_FORWARDING_USAGE = new AddressInfo.RegionForwardingUsage(REGION_FORWARDING_RULES);
    private static final AddressInfo INSTANCE_ADDRESS_INFO = AddressInfo.builder((AddressId)REGION_ADDRESS_ID).address("192.168.1.1").creationTimestamp(CREATION_TIMESTAMP).description("description").generatedId("42").status(STATUS).usage((AddressInfo.Usage)INSTANCE_USAGE).build();
    private static final AddressInfo GLOBAL_FORWARDING_ADDRESS_INFO = AddressInfo.builder((AddressId)GLOBAL_ADDRESS_ID).address("192.168.1.1").creationTimestamp(CREATION_TIMESTAMP).description("description").generatedId("42").status(STATUS).usage((AddressInfo.Usage)GLOBAL_FORWARDING_USAGE).build();
    private static final AddressInfo REGION_FORWARDING_ADDRESS_INFO = AddressInfo.builder((AddressId)REGION_ADDRESS_ID).address("192.168.1.1").creationTimestamp(CREATION_TIMESTAMP).description("description").generatedId("42").status(STATUS).usage((AddressInfo.Usage)REGION_FORWARDING_USAGE).build();

    @Test
    public void testToBuilder() {
        this.compareAddressInfo(INSTANCE_ADDRESS_INFO, INSTANCE_ADDRESS_INFO.toBuilder().build());
        AddressInfo addressInfo = INSTANCE_ADDRESS_INFO.toBuilder().address("192.168.1.2").description("description2").build();
        Assert.assertEquals((Object)"description2", (Object)addressInfo.description());
        Assert.assertEquals((Object)"192.168.1.2", (Object)addressInfo.address());
        addressInfo = addressInfo.toBuilder().address(ADDRESS).description(DESCRIPTION).build();
        this.compareAddressInfo(INSTANCE_ADDRESS_INFO, addressInfo);
    }

    @Test
    public void testToBuilderIncomplete() {
        AddressInfo addressInfo = AddressInfo.builder((AddressId)GLOBAL_ADDRESS_ID).build();
        Assert.assertEquals((Object)addressInfo, (Object)addressInfo.toBuilder().build());
        addressInfo = AddressInfo.builder((AddressId)REGION_ADDRESS_ID).build();
        Assert.assertEquals((Object)addressInfo, (Object)addressInfo.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)ADDRESS, (Object)INSTANCE_ADDRESS_INFO.address());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)INSTANCE_ADDRESS_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)INSTANCE_ADDRESS_INFO.description());
        Assert.assertEquals((Object)GENERATED_ID, (Object)INSTANCE_ADDRESS_INFO.generatedId());
        Assert.assertEquals((Object)REGION_ADDRESS_ID, (Object)INSTANCE_ADDRESS_INFO.addressId());
        Assert.assertEquals((Object)STATUS, (Object)INSTANCE_ADDRESS_INFO.status());
        Assert.assertEquals((Object)INSTANCE_USAGE, (Object)INSTANCE_ADDRESS_INFO.usage());
        Assert.assertEquals((Object)INSTANCE_USAGE.instance(), (Object)((AddressInfo.InstanceUsage)INSTANCE_ADDRESS_INFO.usage()).instance());
        Assert.assertEquals((Object)ADDRESS, (Object)REGION_FORWARDING_ADDRESS_INFO.address());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)REGION_FORWARDING_ADDRESS_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)REGION_FORWARDING_ADDRESS_INFO.description());
        Assert.assertEquals((Object)GENERATED_ID, (Object)REGION_FORWARDING_ADDRESS_INFO.generatedId());
        Assert.assertEquals((Object)REGION_ADDRESS_ID, (Object)REGION_FORWARDING_ADDRESS_INFO.addressId());
        Assert.assertEquals((Object)STATUS, (Object)REGION_FORWARDING_ADDRESS_INFO.status());
        Assert.assertEquals((Object)REGION_FORWARDING_USAGE, (Object)REGION_FORWARDING_ADDRESS_INFO.usage());
        Assert.assertEquals(REGION_FORWARDING_RULES, (Object)((AddressInfo.RegionForwardingUsage)REGION_FORWARDING_ADDRESS_INFO.usage()).forwardingRules());
        Assert.assertEquals((Object)ADDRESS, (Object)GLOBAL_FORWARDING_ADDRESS_INFO.address());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)GLOBAL_FORWARDING_ADDRESS_INFO.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)GLOBAL_FORWARDING_ADDRESS_INFO.description());
        Assert.assertEquals((Object)GENERATED_ID, (Object)GLOBAL_FORWARDING_ADDRESS_INFO.generatedId());
        Assert.assertEquals((Object)GLOBAL_ADDRESS_ID, (Object)GLOBAL_FORWARDING_ADDRESS_INFO.addressId());
        Assert.assertEquals((Object)STATUS, (Object)GLOBAL_FORWARDING_ADDRESS_INFO.status());
        Assert.assertEquals((Object)GLOBAL_FORWARDING_USAGE, (Object)GLOBAL_FORWARDING_ADDRESS_INFO.usage());
        Assert.assertEquals(GLOBAL_FORWARDING_RULES, (Object)((AddressInfo.GlobalForwardingUsage)GLOBAL_FORWARDING_ADDRESS_INFO.usage()).forwardingRules());
    }

    @Test
    public void testOf() {
        AddressInfo addressInfo = AddressInfo.of((String)"address");
        Assert.assertEquals((Object)GlobalAddressId.of((String)"address"), (Object)addressInfo.addressId());
        Assert.assertNull((Object)addressInfo.address());
        Assert.assertNull((Object)addressInfo.creationTimestamp());
        Assert.assertNull((Object)addressInfo.description());
        Assert.assertNull((Object)addressInfo.generatedId());
        Assert.assertNull((Object)addressInfo.status());
        Assert.assertNull((Object)addressInfo.usage());
        addressInfo = AddressInfo.of((AddressId)GLOBAL_ADDRESS_ID);
        Assert.assertEquals((Object)GLOBAL_ADDRESS_ID, (Object)addressInfo.addressId());
        Assert.assertNull((Object)addressInfo.address());
        Assert.assertNull((Object)addressInfo.creationTimestamp());
        Assert.assertNull((Object)addressInfo.description());
        Assert.assertNull((Object)addressInfo.generatedId());
        Assert.assertNull((Object)addressInfo.status());
        Assert.assertNull((Object)addressInfo.usage());
        addressInfo = AddressInfo.of((String)"region", (String)"address");
        Assert.assertEquals((Object)RegionAddressId.of((String)"region", (String)"address"), (Object)addressInfo.addressId());
        Assert.assertNull((Object)addressInfo.address());
        Assert.assertNull((Object)addressInfo.creationTimestamp());
        Assert.assertNull((Object)addressInfo.description());
        Assert.assertNull((Object)addressInfo.generatedId());
        Assert.assertNull((Object)addressInfo.status());
        Assert.assertNull((Object)addressInfo.usage());
        addressInfo = AddressInfo.of((RegionId)RegionId.of((String)"region"), (String)"address");
        Assert.assertEquals((Object)RegionAddressId.of((String)"region", (String)"address"), (Object)addressInfo.addressId());
        Assert.assertNull((Object)addressInfo.address());
        Assert.assertNull((Object)addressInfo.creationTimestamp());
        Assert.assertNull((Object)addressInfo.description());
        Assert.assertNull((Object)addressInfo.generatedId());
        Assert.assertNull((Object)addressInfo.status());
        Assert.assertNull((Object)addressInfo.usage());
    }

    @Test
    public void testToPbAndFromPb() {
        this.compareAddressInfo(INSTANCE_ADDRESS_INFO, AddressInfo.fromPb((Address)INSTANCE_ADDRESS_INFO.toPb()));
        this.compareAddressInfo(REGION_FORWARDING_ADDRESS_INFO, AddressInfo.fromPb((Address)REGION_FORWARDING_ADDRESS_INFO.toPb()));
        this.compareAddressInfo(GLOBAL_FORWARDING_ADDRESS_INFO, AddressInfo.fromPb((Address)GLOBAL_FORWARDING_ADDRESS_INFO.toPb()));
        AddressInfo addressInfo = AddressInfo.builder((AddressId)GLOBAL_ADDRESS_ID).build();
        this.compareAddressInfo(addressInfo, AddressInfo.fromPb((Address)addressInfo.toPb()));
    }

    @Test
    public void testSetProjectId() {
        AddressInfo addressInfo = GLOBAL_FORWARDING_ADDRESS_INFO.toBuilder().addressId((AddressId)GlobalAddressId.of((String)GLOBAL_ADDRESS_ID.address())).build();
        this.compareAddressInfo(GLOBAL_FORWARDING_ADDRESS_INFO, addressInfo.setProjectId("project"));
    }

    private void compareAddressInfo(AddressInfo expected, AddressInfo value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.address(), (Object)value.address());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.addressId(), (Object)value.addressId());
        Assert.assertEquals((Object)expected.usage(), (Object)value.usage());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

