/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.GlobalAddressId;
import com.google.cloud.compute.GlobalForwardingRuleId;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionForwardingRuleId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class AddressTest {
    private static final String ADDRESS = "192.168.1.1";
    private static final Long CREATION_TIMESTAMP = 1452602400000L;
    private static final String DESCRIPTION = "description";
    private static final String GENERATED_ID = "42";
    private static final GlobalAddressId GLOBAL_ADDRESS_ID = GlobalAddressId.of((String)"project", (String)"address");
    private static final RegionAddressId REGION_ADDRESS_ID = RegionAddressId.of((String)"project", (String)"region", (String)"address");
    private static final AddressInfo.Status STATUS = AddressInfo.Status.RESERVED;
    private static final List<GlobalForwardingRuleId> GLOBAL_FORWARDING_RULES = ImmutableList.of((Object)GlobalForwardingRuleId.of((String)"project", (String)"forwardingRule1"), (Object)GlobalForwardingRuleId.of((String)"project", (String)"forwardingRule2"));
    private static final List<RegionForwardingRuleId> REGION_FORWARDING_RULES = ImmutableList.of((Object)RegionForwardingRuleId.of((String)"project", (String)"region", (String)"forwardingRule1"), (Object)RegionForwardingRuleId.of((String)"project", (String)"region", (String)"forwardingRule2"));
    private static final AddressInfo.InstanceUsage INSTANCE_USAGE = new AddressInfo.InstanceUsage(InstanceId.of((String)"project", (String)"zone", (String)"instance1"));
    private static final AddressInfo.GlobalForwardingUsage GLOBAL_FORWARDING_USAGE = new AddressInfo.GlobalForwardingUsage(GLOBAL_FORWARDING_RULES);
    private static final AddressInfo.RegionForwardingUsage REGION_FORWARDING_USAGE = new AddressInfo.RegionForwardingUsage(REGION_FORWARDING_RULES);
    private final Compute serviceMockReturnsOptions = (Compute)EasyMock.createStrictMock(Compute.class);
    private final ComputeOptions mockOptions = (ComputeOptions)EasyMock.createMock(ComputeOptions.class);
    private Compute compute;
    private Address globalForwardingAddress;
    private Address instanceAddress;
    private Address regionForwardingAddress;
    private Address address;

    private void initializeExpectedAddress(int optionsCalls) {
        EasyMock.expect((Object)this.serviceMockReturnsOptions.options()).andReturn((Object)this.mockOptions).times(optionsCalls);
        EasyMock.replay((Object[])new Object[]{this.serviceMockReturnsOptions});
        this.instanceAddress = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)REGION_ADDRESS_ID).address(ADDRESS).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).generatedId(GENERATED_ID).status(STATUS).usage((AddressInfo.Usage)INSTANCE_USAGE).build();
        this.globalForwardingAddress = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)GLOBAL_ADDRESS_ID).address(ADDRESS).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).generatedId(GENERATED_ID).status(STATUS).usage((AddressInfo.Usage)GLOBAL_FORWARDING_USAGE).build();
        this.regionForwardingAddress = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)REGION_ADDRESS_ID).address(ADDRESS).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).generatedId(GENERATED_ID).status(STATUS).usage((AddressInfo.Usage)REGION_FORWARDING_USAGE).build();
        this.compute = (Compute)EasyMock.createStrictMock(Compute.class);
    }

    private void initializeAddress() {
        this.address = new Address.Builder(this.compute, (AddressId)REGION_ADDRESS_ID).address(ADDRESS).creationTimestamp(CREATION_TIMESTAMP).description(DESCRIPTION).generatedId(GENERATED_ID).status(STATUS).usage((AddressInfo.Usage)REGION_FORWARDING_USAGE).build();
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.serviceMockReturnsOptions});
    }

    @Test
    public void testBuilder() {
        this.initializeExpectedAddress(6);
        Assert.assertEquals((Object)ADDRESS, (Object)this.instanceAddress.address());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.instanceAddress.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.instanceAddress.description());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.instanceAddress.generatedId());
        Assert.assertEquals((Object)REGION_ADDRESS_ID, (Object)this.instanceAddress.addressId());
        Assert.assertEquals((Object)STATUS, (Object)this.instanceAddress.status());
        Assert.assertEquals((Object)INSTANCE_USAGE, (Object)this.instanceAddress.usage());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.instanceAddress.compute());
        Assert.assertEquals((Object)ADDRESS, (Object)this.regionForwardingAddress.address());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.regionForwardingAddress.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.regionForwardingAddress.description());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.regionForwardingAddress.generatedId());
        Assert.assertEquals((Object)REGION_ADDRESS_ID, (Object)this.regionForwardingAddress.addressId());
        Assert.assertEquals((Object)STATUS, (Object)this.regionForwardingAddress.status());
        Assert.assertEquals((Object)REGION_FORWARDING_USAGE, (Object)this.regionForwardingAddress.usage());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.regionForwardingAddress.compute());
        Assert.assertEquals((Object)ADDRESS, (Object)this.globalForwardingAddress.address());
        Assert.assertEquals((Object)CREATION_TIMESTAMP, (Object)this.globalForwardingAddress.creationTimestamp());
        Assert.assertEquals((Object)DESCRIPTION, (Object)this.globalForwardingAddress.description());
        Assert.assertEquals((Object)GENERATED_ID, (Object)this.globalForwardingAddress.generatedId());
        Assert.assertEquals((Object)GLOBAL_ADDRESS_ID, (Object)this.globalForwardingAddress.addressId());
        Assert.assertEquals((Object)STATUS, (Object)this.globalForwardingAddress.status());
        Assert.assertEquals((Object)GLOBAL_FORWARDING_USAGE, (Object)this.globalForwardingAddress.usage());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)this.globalForwardingAddress.compute());
        Address address = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)GLOBAL_ADDRESS_ID).build();
        Assert.assertEquals((Object)GLOBAL_ADDRESS_ID, (Object)address.addressId());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)address.compute());
        Assert.assertNull((Object)address.address());
        Assert.assertNull((Object)address.creationTimestamp());
        Assert.assertNull((Object)address.description());
        Assert.assertNull((Object)address.generatedId());
        Assert.assertNull((Object)address.status());
        Assert.assertNull((Object)address.usage());
        address = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)REGION_ADDRESS_ID).build();
        Assert.assertEquals((Object)REGION_ADDRESS_ID, (Object)address.addressId());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)address.compute());
        Assert.assertNull((Object)address.address());
        Assert.assertNull((Object)address.creationTimestamp());
        Assert.assertNull((Object)address.description());
        Assert.assertNull((Object)address.generatedId());
        Assert.assertNull((Object)address.status());
        Assert.assertNull((Object)address.usage());
        address = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)REGION_ADDRESS_ID).addressId((AddressId)GLOBAL_ADDRESS_ID).build();
        Assert.assertEquals((Object)GLOBAL_ADDRESS_ID, (Object)address.addressId());
        Assert.assertSame((Object)this.serviceMockReturnsOptions, (Object)address.compute());
        Assert.assertNull((Object)address.address());
        Assert.assertNull((Object)address.creationTimestamp());
        Assert.assertNull((Object)address.description());
        Assert.assertNull((Object)address.generatedId());
        Assert.assertNull((Object)address.status());
        Assert.assertNull((Object)address.usage());
    }

    @Test
    public void testToBuilder() {
        this.initializeExpectedAddress(16);
        this.compareAddress(this.instanceAddress, this.instanceAddress.toBuilder().build());
        this.compareAddress(this.globalForwardingAddress, this.globalForwardingAddress.toBuilder().build());
        this.compareAddress(this.regionForwardingAddress, this.regionForwardingAddress.toBuilder().build());
        Address newAddress = this.instanceAddress.toBuilder().description("newDescription").build();
        Assert.assertEquals((Object)"newDescription", (Object)newAddress.description());
        newAddress = newAddress.toBuilder().description(DESCRIPTION).build();
        this.compareAddress(this.instanceAddress, newAddress);
    }

    @Test
    public void testToAndFromPb() {
        this.initializeExpectedAddress(20);
        this.compareAddress(this.globalForwardingAddress, Address.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Address)this.globalForwardingAddress.toPb()));
        this.compareAddress(this.regionForwardingAddress, Address.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Address)this.regionForwardingAddress.toPb()));
        this.compareAddress(this.instanceAddress, Address.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Address)this.instanceAddress.toPb()));
        Address address = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)GLOBAL_ADDRESS_ID).build();
        this.compareAddress(address, Address.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Address)address.toPb()));
        address = new Address.Builder(this.serviceMockReturnsOptions, (AddressId)REGION_ADDRESS_ID).build();
        this.compareAddress(address, Address.fromPb((Compute)this.serviceMockReturnsOptions, (com.google.api.services.compute.model.Address)address.toPb()));
    }

    @Test
    public void testDeleteOperation() {
        this.initializeExpectedAddress(4);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        Operation operation = new Operation.Builder(this.serviceMockReturnsOptions).operationId((OperationId)GlobalOperationId.of((String)"project", (String)"op")).build();
        EasyMock.expect((Object)this.compute.deleteAddress((AddressId)REGION_ADDRESS_ID, new Compute.OperationOption[0])).andReturn((Object)operation);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeAddress();
        Assert.assertSame((Object)operation, (Object)this.address.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNull() {
        this.initializeExpectedAddress(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.deleteAddress((AddressId)REGION_ADDRESS_ID, new Compute.OperationOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeAddress();
        Assert.assertNull((Object)this.address.delete(new Compute.OperationOption[0]));
    }

    @Test
    public void testExists_True() throws Exception {
        this.initializeExpectedAddress(3);
        Compute.AddressOption[] expectedOptions = new Compute.AddressOption[]{Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getAddress((AddressId)REGION_ADDRESS_ID, expectedOptions)).andReturn((Object)this.regionForwardingAddress);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeAddress();
        Assert.assertTrue((boolean)this.address.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testExists_False() throws Exception {
        this.initializeExpectedAddress(3);
        Compute.AddressOption[] expectedOptions = new Compute.AddressOption[]{Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[0])};
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getAddress((AddressId)REGION_ADDRESS_ID, expectedOptions)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeAddress();
        Assert.assertFalse((boolean)this.address.exists());
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReload() throws Exception {
        this.initializeExpectedAddress(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getAddress((AddressId)REGION_ADDRESS_ID, new Compute.AddressOption[0])).andReturn((Object)this.regionForwardingAddress);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeAddress();
        Address updatedAddress = this.address.reload(new Compute.AddressOption[0]);
        this.compareAddress(this.regionForwardingAddress, updatedAddress);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadNull() throws Exception {
        this.initializeExpectedAddress(3);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getAddress((AddressId)REGION_ADDRESS_ID, new Compute.AddressOption[0])).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeAddress();
        Assert.assertNull((Object)this.address.reload(new Compute.AddressOption[0]));
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    @Test
    public void testReloadWithOptions() throws Exception {
        this.initializeExpectedAddress(5);
        EasyMock.expect((Object)this.compute.options()).andReturn((Object)this.mockOptions);
        EasyMock.expect((Object)this.compute.getAddress((AddressId)REGION_ADDRESS_ID, new Compute.AddressOption[]{Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[0])})).andReturn((Object)this.regionForwardingAddress);
        EasyMock.replay((Object[])new Object[]{this.compute});
        this.initializeAddress();
        Address updatedAddress = this.address.reload(new Compute.AddressOption[]{Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[0])});
        this.compareAddress(this.regionForwardingAddress, updatedAddress);
        EasyMock.verify((Object[])new Object[]{this.compute});
    }

    private void compareAddress(Address expected, Address value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.compute().options(), (Object)value.compute().options());
        Assert.assertEquals((Object)expected.address(), (Object)value.address());
        Assert.assertEquals((Object)expected.creationTimestamp(), (Object)value.creationTimestamp());
        Assert.assertEquals((Object)expected.description(), (Object)value.description());
        Assert.assertEquals((Object)expected.generatedId(), (Object)value.generatedId());
        Assert.assertEquals((Object)expected.addressId(), (Object)value.addressId());
        Assert.assertEquals((Object)expected.usage(), (Object)value.usage());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

