/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.LicenseId;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class AttachedDiskTest {
    private static final Boolean AUTO_DELETE = true;
    private static final Boolean BOOT = true;
    private static final Integer INDEX = 0;
    private static final String DEVICE_NAME = "deviceName";
    private static final String DISK_NAME = "diskName";
    private static final DiskTypeId DISK_TYPE_ID = DiskTypeId.of((String)"project", (String)"zone", (String)"diskType");
    private static final Long DISK_SIZE_GB = 42L;
    private static final DiskId DISK_ID = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final ImageId IMAGE_ID = ImageId.of((String)"project", (String)"image");
    private static final AttachedDisk.AttachedDiskConfiguration.InterfaceType INTERFACE_TYPE = AttachedDisk.AttachedDiskConfiguration.InterfaceType.NVME;
    private static final AttachedDisk.PersistentDiskConfiguration.Mode MODE = AttachedDisk.PersistentDiskConfiguration.Mode.READ_ONLY;
    private static final AttachedDisk.PersistentDiskConfiguration PERSISTENT_DISK_CONFIGURATION = AttachedDisk.PersistentDiskConfiguration.builder((DiskId)DISK_ID).boot(BOOT.booleanValue()).autoDelete(AUTO_DELETE.booleanValue()).mode(MODE).build();
    private static final AttachedDisk.ScratchDiskConfiguration SCRATCH_DISK_CONFIGURATION = AttachedDisk.ScratchDiskConfiguration.builder((DiskTypeId)DISK_TYPE_ID).interfaceType(INTERFACE_TYPE).build();
    private static final AttachedDisk.CreateDiskConfiguration CREATE_DISK_CONFIGURATION = AttachedDisk.CreateDiskConfiguration.builder((ImageId)IMAGE_ID).autoDelete(AUTO_DELETE).diskName("diskName").diskType(DISK_TYPE_ID).diskSizeGb(DISK_SIZE_GB).sourceImage(IMAGE_ID).build();
    private static final List<LicenseId> LICENSES = ImmutableList.of((Object)LicenseId.of((String)"project", (String)"license1"), (Object)LicenseId.of((String)"project", (String)"license2"));
    private static final AttachedDisk PERSISTENT_DISK = AttachedDisk.builder((AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION).deviceName("deviceName").index(INDEX).licenses(LICENSES).build();
    private static final AttachedDisk SCRATCH_DISK = AttachedDisk.builder((AttachedDisk.AttachedDiskConfiguration)SCRATCH_DISK_CONFIGURATION).deviceName("deviceName").index(INDEX).licenses(LICENSES).build();
    private static final AttachedDisk CREATED_DISK = AttachedDisk.builder((AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION).deviceName("deviceName").index(INDEX).licenses(LICENSES).build();

    @Test
    public void testConfigurationToBuilder() {
        this.comparePersistentDiskConfiguration(PERSISTENT_DISK_CONFIGURATION, PERSISTENT_DISK_CONFIGURATION.toBuilder().build());
        this.compareScratchDiskConfiguration(SCRATCH_DISK_CONFIGURATION, SCRATCH_DISK_CONFIGURATION.toBuilder().build());
        this.compareCreateDiskConfiguration(CREATE_DISK_CONFIGURATION, CREATE_DISK_CONFIGURATION.toBuilder().build());
        AttachedDisk.PersistentDiskConfiguration persistentDiskConfiguration = PERSISTENT_DISK_CONFIGURATION.toBuilder().autoDelete(false).build();
        Assert.assertFalse((boolean)persistentDiskConfiguration.autoDelete());
        persistentDiskConfiguration = persistentDiskConfiguration.toBuilder().autoDelete(AUTO_DELETE.booleanValue()).build();
        Assert.assertEquals((Object)PERSISTENT_DISK_CONFIGURATION, (Object)persistentDiskConfiguration);
        AttachedDisk.ScratchDiskConfiguration scratchDiskConfiguration = SCRATCH_DISK_CONFIGURATION.toBuilder().interfaceType(AttachedDisk.AttachedDiskConfiguration.InterfaceType.SCSI).build();
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.InterfaceType.SCSI, (Object)scratchDiskConfiguration.interfaceType());
        scratchDiskConfiguration = scratchDiskConfiguration.toBuilder().interfaceType(INTERFACE_TYPE).build();
        Assert.assertEquals((Object)SCRATCH_DISK_CONFIGURATION, (Object)scratchDiskConfiguration);
        AttachedDisk.CreateDiskConfiguration createDiskConfiguration = CREATE_DISK_CONFIGURATION.toBuilder().autoDelete(Boolean.valueOf(false)).build();
        Assert.assertFalse((boolean)createDiskConfiguration.autoDelete());
        createDiskConfiguration = createDiskConfiguration.toBuilder().autoDelete(AUTO_DELETE).build();
        Assert.assertEquals((Object)CREATE_DISK_CONFIGURATION, (Object)createDiskConfiguration);
    }

    @Test
    public void testConfigurationToBuilderIncomplete() {
        AttachedDisk.PersistentDiskConfiguration persistentConfiguration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        this.comparePersistentDiskConfiguration(persistentConfiguration, (AttachedDisk.PersistentDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)persistentConfiguration.toPb()));
        AttachedDisk.ScratchDiskConfiguration scratchDiskConfiguration = AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DISK_TYPE_ID);
        this.compareScratchDiskConfiguration(scratchDiskConfiguration, (AttachedDisk.ScratchDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)scratchDiskConfiguration.toPb()));
        AttachedDisk.CreateDiskConfiguration createDiskConfiguration = AttachedDisk.CreateDiskConfiguration.of((ImageId)IMAGE_ID);
        this.compareCreateDiskConfiguration(createDiskConfiguration, (AttachedDisk.CreateDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)createDiskConfiguration.toPb()));
    }

    @Test
    public void testToBuilder() {
        this.compareAttachedDisk(PERSISTENT_DISK, PERSISTENT_DISK.toBuilder().build());
        this.compareAttachedDisk(SCRATCH_DISK, SCRATCH_DISK.toBuilder().build());
        this.compareAttachedDisk(CREATED_DISK, CREATED_DISK.toBuilder().build());
        AttachedDisk attachedDisk = PERSISTENT_DISK.toBuilder().deviceName("newDeviceName").build();
        Assert.assertEquals((Object)"newDeviceName", (Object)attachedDisk.deviceName());
        attachedDisk = attachedDisk.toBuilder().deviceName(DEVICE_NAME).build();
        this.compareAttachedDisk(PERSISTENT_DISK, attachedDisk);
    }

    @Test
    public void testToBuilderIncomplete() {
        AttachedDisk attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        Assert.assertEquals((Object)attachedDisk, (Object)attachedDisk.toBuilder().build());
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)SCRATCH_DISK_CONFIGURATION);
        Assert.assertEquals((Object)attachedDisk, (Object)attachedDisk.toBuilder().build());
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION);
        Assert.assertEquals((Object)attachedDisk, (Object)attachedDisk.toBuilder().build());
    }

    @Test
    public void testConfigurationBuilder() {
        Assert.assertTrue((boolean)CREATE_DISK_CONFIGURATION.boot());
        Assert.assertEquals((Object)AUTO_DELETE, (Object)CREATE_DISK_CONFIGURATION.autoDelete());
        Assert.assertNull((Object)CREATE_DISK_CONFIGURATION.interfaceType());
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.Type.PERSISTENT, (Object)CREATE_DISK_CONFIGURATION.type());
        Assert.assertEquals((Object)IMAGE_ID, (Object)CREATE_DISK_CONFIGURATION.sourceImage());
        Assert.assertEquals((Object)DISK_NAME, (Object)CREATE_DISK_CONFIGURATION.diskName());
        Assert.assertEquals((Object)DISK_TYPE_ID, (Object)CREATE_DISK_CONFIGURATION.diskType());
        Assert.assertEquals((Object)DISK_SIZE_GB, (Object)CREATE_DISK_CONFIGURATION.diskSizeGb());
        Assert.assertEquals((Object)IMAGE_ID, (Object)CREATE_DISK_CONFIGURATION.sourceImage());
        Assert.assertEquals((Object)BOOT, (Object)PERSISTENT_DISK_CONFIGURATION.boot());
        Assert.assertEquals((Object)AUTO_DELETE, (Object)PERSISTENT_DISK_CONFIGURATION.autoDelete());
        Assert.assertNull((Object)PERSISTENT_DISK_CONFIGURATION.interfaceType());
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.Type.PERSISTENT, (Object)PERSISTENT_DISK_CONFIGURATION.type());
        Assert.assertEquals((Object)MODE, (Object)PERSISTENT_DISK_CONFIGURATION.mode());
        Assert.assertEquals((Object)DISK_ID, (Object)PERSISTENT_DISK_CONFIGURATION.sourceDisk());
        Assert.assertFalse((boolean)SCRATCH_DISK_CONFIGURATION.boot());
        Assert.assertTrue((boolean)SCRATCH_DISK_CONFIGURATION.autoDelete());
        Assert.assertEquals((Object)INTERFACE_TYPE, (Object)SCRATCH_DISK_CONFIGURATION.interfaceType());
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.Type.SCRATCH, (Object)SCRATCH_DISK_CONFIGURATION.type());
        Assert.assertEquals((Object)DISK_TYPE_ID, (Object)SCRATCH_DISK_CONFIGURATION.diskType());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)PERSISTENT_DISK_CONFIGURATION, (Object)PERSISTENT_DISK.configuration());
        Assert.assertEquals((Object)DEVICE_NAME, (Object)PERSISTENT_DISK.deviceName());
        Assert.assertEquals((Object)INDEX, (Object)PERSISTENT_DISK.index());
        Assert.assertEquals(LICENSES, (Object)PERSISTENT_DISK.licenses());
        Assert.assertEquals((Object)SCRATCH_DISK_CONFIGURATION, (Object)SCRATCH_DISK.configuration());
        Assert.assertEquals((Object)DEVICE_NAME, (Object)SCRATCH_DISK.deviceName());
        Assert.assertEquals((Object)INDEX, (Object)SCRATCH_DISK.index());
        Assert.assertEquals(LICENSES, (Object)SCRATCH_DISK.licenses());
        Assert.assertEquals((Object)CREATE_DISK_CONFIGURATION, (Object)CREATED_DISK.configuration());
        Assert.assertEquals((Object)DEVICE_NAME, (Object)CREATED_DISK.deviceName());
        Assert.assertEquals((Object)INDEX, (Object)CREATED_DISK.index());
        Assert.assertEquals(LICENSES, (Object)CREATED_DISK.licenses());
    }

    @Test
    public void testConfigurationOf() {
        AttachedDisk.PersistentDiskConfiguration persistentConfiguration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        Assert.assertEquals((Object)DISK_ID, (Object)persistentConfiguration.sourceDisk());
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.Type.PERSISTENT, (Object)persistentConfiguration.type());
        Assert.assertNull((Object)persistentConfiguration.autoDelete());
        Assert.assertNull((Object)persistentConfiguration.boot());
        Assert.assertNull((Object)persistentConfiguration.interfaceType());
        AttachedDisk.ScratchDiskConfiguration scratchDiskConfiguration = AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DISK_TYPE_ID);
        Assert.assertEquals((Object)DISK_TYPE_ID, (Object)scratchDiskConfiguration.diskType());
        Assert.assertNull((Object)scratchDiskConfiguration.interfaceType());
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.Type.SCRATCH, (Object)scratchDiskConfiguration.type());
        Assert.assertTrue((boolean)scratchDiskConfiguration.autoDelete());
        Assert.assertFalse((boolean)scratchDiskConfiguration.boot());
        Assert.assertNull((Object)scratchDiskConfiguration.interfaceType());
        AttachedDisk.CreateDiskConfiguration createDiskConfiguration = AttachedDisk.CreateDiskConfiguration.of((ImageId)IMAGE_ID);
        Assert.assertEquals((Object)IMAGE_ID, (Object)createDiskConfiguration.sourceImage());
        Assert.assertNull((Object)createDiskConfiguration.diskType());
        Assert.assertNull((Object)createDiskConfiguration.diskName());
        Assert.assertNull((Object)createDiskConfiguration.diskSizeGb());
        Assert.assertNull((Object)createDiskConfiguration.interfaceType());
        Assert.assertEquals((Object)AttachedDisk.AttachedDiskConfiguration.Type.PERSISTENT, (Object)createDiskConfiguration.type());
        Assert.assertNull((Object)createDiskConfiguration.autoDelete());
        Assert.assertTrue((boolean)createDiskConfiguration.boot());
        Assert.assertNull((Object)createDiskConfiguration.interfaceType());
    }

    @Test
    public void testOf() {
        AttachedDisk attachedDisk = AttachedDisk.of((String)DEVICE_NAME, (AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        Assert.assertEquals((Object)PERSISTENT_DISK_CONFIGURATION, (Object)attachedDisk.configuration());
        Assert.assertEquals((Object)DEVICE_NAME, (Object)attachedDisk.deviceName());
        Assert.assertNull((Object)attachedDisk.index());
        Assert.assertNull((Object)attachedDisk.licenses());
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        Assert.assertEquals((Object)PERSISTENT_DISK_CONFIGURATION, (Object)attachedDisk.configuration());
        Assert.assertNull((Object)attachedDisk.deviceName());
        Assert.assertNull((Object)attachedDisk.index());
        Assert.assertNull((Object)attachedDisk.licenses());
        attachedDisk = AttachedDisk.of((String)DEVICE_NAME, (AttachedDisk.AttachedDiskConfiguration)SCRATCH_DISK_CONFIGURATION);
        Assert.assertEquals((Object)SCRATCH_DISK_CONFIGURATION, (Object)attachedDisk.configuration());
        Assert.assertEquals((Object)DEVICE_NAME, (Object)attachedDisk.deviceName());
        Assert.assertNull((Object)attachedDisk.index());
        Assert.assertNull((Object)attachedDisk.licenses());
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)SCRATCH_DISK_CONFIGURATION);
        Assert.assertEquals((Object)SCRATCH_DISK_CONFIGURATION, (Object)attachedDisk.configuration());
        Assert.assertNull((Object)attachedDisk.deviceName());
        Assert.assertNull((Object)attachedDisk.index());
        Assert.assertNull((Object)attachedDisk.licenses());
        attachedDisk = AttachedDisk.of((String)DEVICE_NAME, (AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION);
        Assert.assertEquals((Object)CREATE_DISK_CONFIGURATION, (Object)attachedDisk.configuration());
        Assert.assertEquals((Object)DEVICE_NAME, (Object)attachedDisk.deviceName());
        Assert.assertNull((Object)attachedDisk.index());
        Assert.assertNull((Object)attachedDisk.licenses());
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION);
        Assert.assertEquals((Object)CREATE_DISK_CONFIGURATION, (Object)attachedDisk.configuration());
        Assert.assertNull((Object)attachedDisk.deviceName());
        Assert.assertNull((Object)attachedDisk.index());
        Assert.assertNull((Object)attachedDisk.licenses());
    }

    @Test
    public void testConfigurationToAndFromPb() {
        AttachedDisk.PersistentDiskConfiguration persistentConfiguration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
        this.comparePersistentDiskConfiguration(persistentConfiguration, (AttachedDisk.PersistentDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)persistentConfiguration.toPb()));
        this.comparePersistentDiskConfiguration(PERSISTENT_DISK_CONFIGURATION, (AttachedDisk.PersistentDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)PERSISTENT_DISK_CONFIGURATION.toPb()));
        AttachedDisk.ScratchDiskConfiguration scratchDiskConfiguration = AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DISK_TYPE_ID);
        this.compareScratchDiskConfiguration(scratchDiskConfiguration, (AttachedDisk.ScratchDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)scratchDiskConfiguration.toPb()));
        this.compareScratchDiskConfiguration(SCRATCH_DISK_CONFIGURATION, (AttachedDisk.ScratchDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)SCRATCH_DISK_CONFIGURATION.toPb()));
        AttachedDisk.CreateDiskConfiguration createDiskConfiguration = AttachedDisk.CreateDiskConfiguration.of((ImageId)IMAGE_ID);
        this.compareCreateDiskConfiguration(createDiskConfiguration, (AttachedDisk.CreateDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)createDiskConfiguration.toPb()));
        this.compareCreateDiskConfiguration(CREATE_DISK_CONFIGURATION, (AttachedDisk.CreateDiskConfiguration)AttachedDisk.AttachedDiskConfiguration.fromPb((com.google.api.services.compute.model.AttachedDisk)CREATE_DISK_CONFIGURATION.toPb()));
    }

    @Test
    public void testToAndFromPb() {
        AttachedDisk attachedDisk = AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)PERSISTENT_DISK.toPb());
        this.compareAttachedDisk(PERSISTENT_DISK, attachedDisk);
        attachedDisk = AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)SCRATCH_DISK.toPb());
        this.compareAttachedDisk(SCRATCH_DISK, attachedDisk);
        attachedDisk = AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)CREATED_DISK.toPb());
        this.compareAttachedDisk(CREATED_DISK, attachedDisk);
        attachedDisk = AttachedDisk.of((String)DEVICE_NAME, (AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        this.compareAttachedDisk(attachedDisk, AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)attachedDisk.toPb()));
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        this.compareAttachedDisk(attachedDisk, AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)attachedDisk.toPb()));
        attachedDisk = AttachedDisk.of((String)DEVICE_NAME, (AttachedDisk.AttachedDiskConfiguration)SCRATCH_DISK_CONFIGURATION);
        this.compareAttachedDisk(attachedDisk, AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)attachedDisk.toPb()));
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)SCRATCH_DISK_CONFIGURATION);
        this.compareAttachedDisk(attachedDisk, AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)attachedDisk.toPb()));
        attachedDisk = AttachedDisk.of((String)DEVICE_NAME, (AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION);
        this.compareAttachedDisk(attachedDisk, AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)attachedDisk.toPb()));
        attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION);
        this.compareAttachedDisk(attachedDisk, AttachedDisk.fromPb((com.google.api.services.compute.model.AttachedDisk)attachedDisk.toPb()));
    }

    @Test
    public void testConfigurationSetProjectId() {
        AttachedDisk.PersistentDiskConfiguration persistentConfiguration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DiskId.of((String)"zone", (String)"disk"));
        this.comparePersistentDiskConfiguration(AttachedDisk.PersistentDiskConfiguration.of((DiskId)DiskId.of((String)"project", (String)"zone", (String)"disk")), persistentConfiguration.setProjectId("project"));
        AttachedDisk.ScratchDiskConfiguration scratchDiskConfiguration = AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)"zone", (String)"diskType"));
        this.compareScratchDiskConfiguration(AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)"project", (String)"zone", (String)"diskType")), scratchDiskConfiguration.setProjectId("project"));
        AttachedDisk.CreateDiskConfiguration createDiskConfiguration = CREATE_DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)"zone", (String)"diskType")).sourceImage(ImageId.of((String)"image")).build();
        this.compareCreateDiskConfiguration(CREATE_DISK_CONFIGURATION, createDiskConfiguration.setProjectId("project"));
    }

    @Test
    public void testSetProjectId() {
        AttachedDisk.PersistentDiskConfiguration persistentConfiguration = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DiskId.of((String)"zone", (String)"disk"));
        AttachedDisk.PersistentDiskConfiguration persistentConfigurationWithProject = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DiskId.of((String)"project", (String)"zone", (String)"disk"));
        AttachedDisk attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)persistentConfiguration);
        this.compareAttachedDisk(AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)persistentConfigurationWithProject), attachedDisk.setProjectId("project"));
        AttachedDisk.ScratchDiskConfiguration scratchDiskConfiguration = AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)"zone", (String)"diskType"));
        AttachedDisk.ScratchDiskConfiguration scratchDiskConfigurationWithProject = AttachedDisk.ScratchDiskConfiguration.of((DiskTypeId)DiskTypeId.of((String)"project", (String)"zone", (String)"diskType"));
        this.compareAttachedDisk(AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)scratchDiskConfigurationWithProject), AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)scratchDiskConfiguration).setProjectId("project"));
        AttachedDisk.CreateDiskConfiguration createDiskConfiguration = AttachedDisk.CreateDiskConfiguration.of((ImageId)ImageId.of((String)"image"));
        AttachedDisk.CreateDiskConfiguration createDiskConfigurationWithProject = AttachedDisk.CreateDiskConfiguration.of((ImageId)ImageId.of((String)"project", (String)"image"));
        this.compareAttachedDisk(AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)createDiskConfigurationWithProject), AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)createDiskConfiguration).setProjectId("project"));
        createDiskConfiguration = CREATE_DISK_CONFIGURATION.toBuilder().diskType(DiskTypeId.of((String)"zone", (String)"diskType")).sourceImage(ImageId.of((String)"image")).build();
        this.compareAttachedDisk(AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)CREATE_DISK_CONFIGURATION), AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)createDiskConfiguration).setProjectId("project"));
    }

    public void compareAttachedDiskConfiguration(AttachedDisk.AttachedDiskConfiguration expected, AttachedDisk.AttachedDiskConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.interfaceType(), (Object)value.interfaceType());
        Assert.assertEquals((Object)expected.boot(), (Object)value.boot());
        Assert.assertEquals((Object)expected.autoDelete(), (Object)value.autoDelete());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }

    public void comparePersistentDiskConfiguration(AttachedDisk.PersistentDiskConfiguration expected, AttachedDisk.PersistentDiskConfiguration value) {
        this.compareAttachedDiskConfiguration((AttachedDisk.AttachedDiskConfiguration)expected, (AttachedDisk.AttachedDiskConfiguration)value);
        Assert.assertEquals((Object)expected.mode(), (Object)value.mode());
        Assert.assertEquals((Object)expected.sourceDisk(), (Object)value.sourceDisk());
    }

    public void compareCreateDiskConfiguration(AttachedDisk.CreateDiskConfiguration expected, AttachedDisk.CreateDiskConfiguration value) {
        this.compareAttachedDiskConfiguration((AttachedDisk.AttachedDiskConfiguration)expected, (AttachedDisk.AttachedDiskConfiguration)value);
        Assert.assertEquals((Object)expected.diskName(), (Object)value.diskName());
        Assert.assertEquals((Object)expected.diskType(), (Object)value.diskType());
        Assert.assertEquals((Object)expected.diskSizeGb(), (Object)value.diskSizeGb());
        Assert.assertEquals((Object)expected.sourceImage(), (Object)value.sourceImage());
    }

    public void compareScratchDiskConfiguration(AttachedDisk.ScratchDiskConfiguration expected, AttachedDisk.ScratchDiskConfiguration value) {
        this.compareAttachedDiskConfiguration((AttachedDisk.AttachedDiskConfiguration)expected, (AttachedDisk.AttachedDiskConfiguration)value);
        Assert.assertEquals((Object)expected.diskType(), (Object)value.diskType());
    }

    public void compareAttachedDisk(AttachedDisk expected, AttachedDisk value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.deviceName(), (Object)value.deviceName());
        Assert.assertEquals((Object)expected.index(), (Object)value.index());
        Assert.assertEquals((Object)expected.configuration(), (Object)value.configuration());
        Assert.assertEquals((Object)expected.licenses(), (Object)value.licenses());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

