/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.compute.ComputeException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class ComputeExceptionTest {
    @Test
    public void testResourceManagerException() {
        ComputeException exception = new ComputeException(500, "message");
        Assert.assertEquals((long)500L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new ComputeException(403, "message");
        Assert.assertEquals((long)403L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertFalse((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        SocketTimeoutException cause = new SocketTimeoutException();
        exception = new ComputeException((IOException)cause);
        Assert.assertNull((Object)exception.reason());
        Assert.assertNull((Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
        exception = new ComputeException(403, "message", (Throwable)cause);
        Assert.assertEquals((long)403L, (long)exception.code());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertNull((Object)exception.reason());
        Assert.assertFalse((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        Object cause = new ComputeException(500, "message");
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn(cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            ComputeException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)500L, (long)ex.code());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertTrue((boolean)ex.retryable());
                Assert.assertTrue((boolean)ex.idempotent());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
        cause = new IllegalArgumentException("message");
        exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getMessage()).andReturn((Object)"message").times(1);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn(cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            ComputeException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)0L, (long)ex.code());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertFalse((boolean)ex.retryable());
                Assert.assertTrue((boolean)ex.idempotent());
                Assert.assertSame((Object)cause, (Object)ex.getCause());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }
}

