/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.AccessConfig;
import com.google.api.services.compute.model.Scheduling;
import com.google.cloud.Page;
import com.google.cloud.RetryParams;
import com.google.cloud.ServiceOptions;
import com.google.cloud.compute.Address;
import com.google.cloud.compute.AddressId;
import com.google.cloud.compute.AddressInfo;
import com.google.cloud.compute.AttachedDisk;
import com.google.cloud.compute.Compute;
import com.google.cloud.compute.ComputeException;
import com.google.cloud.compute.ComputeOptions;
import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.Disk;
import com.google.cloud.compute.DiskConfiguration;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.DiskInfo;
import com.google.cloud.compute.DiskType;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.GlobalAddressId;
import com.google.cloud.compute.GlobalOperationId;
import com.google.cloud.compute.Image;
import com.google.cloud.compute.ImageConfiguration;
import com.google.cloud.compute.ImageId;
import com.google.cloud.compute.ImageInfo;
import com.google.cloud.compute.Instance;
import com.google.cloud.compute.InstanceId;
import com.google.cloud.compute.InstanceInfo;
import com.google.cloud.compute.License;
import com.google.cloud.compute.LicenseId;
import com.google.cloud.compute.MachineType;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.Metadata;
import com.google.cloud.compute.Network;
import com.google.cloud.compute.NetworkConfiguration;
import com.google.cloud.compute.NetworkId;
import com.google.cloud.compute.NetworkInfo;
import com.google.cloud.compute.NetworkInterface;
import com.google.cloud.compute.Operation;
import com.google.cloud.compute.OperationId;
import com.google.cloud.compute.Region;
import com.google.cloud.compute.RegionAddressId;
import com.google.cloud.compute.RegionId;
import com.google.cloud.compute.RegionOperationId;
import com.google.cloud.compute.ResourceId;
import com.google.cloud.compute.SchedulingOptions;
import com.google.cloud.compute.Snapshot;
import com.google.cloud.compute.SnapshotId;
import com.google.cloud.compute.SnapshotInfo;
import com.google.cloud.compute.StandardDiskConfiguration;
import com.google.cloud.compute.StandardNetworkConfiguration;
import com.google.cloud.compute.Subnetwork;
import com.google.cloud.compute.SubnetworkId;
import com.google.cloud.compute.SubnetworkInfo;
import com.google.cloud.compute.Tags;
import com.google.cloud.compute.Zone;
import com.google.cloud.compute.ZoneId;
import com.google.cloud.compute.ZoneOperationId;
import com.google.cloud.compute.spi.ComputeRpc;
import com.google.cloud.compute.spi.ComputeRpcFactory;
import com.google.cloud.spi.ServiceRpcFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ComputeImplTest {
    private static final String PROJECT = "project";
    private static final String GENERATED_ID = "42";
    private static final Long CREATION_TIMESTAMP = 1453293540000L;
    private static final String DESCRIPTION = "description";
    private static final String VALID_DISK_SIZE = "10GB-10TB";
    private static final Long DEFAULT_DISK_SIZE_GB = 10L;
    private static final DiskTypeId DISK_TYPE_ID = DiskTypeId.of((String)"project", (String)"zone", (String)"diskType");
    private static final DiskType DISK_TYPE = DiskType.builder().generatedId("42").diskTypeId(DISK_TYPE_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").validDiskSize("10GB-10TB").defaultDiskSizeGb(DEFAULT_DISK_SIZE_GB).build();
    private static final MachineTypeId MACHINE_TYPE_ID = MachineTypeId.of((String)"project", (String)"zone", (String)"type");
    private static final Integer GUEST_CPUS = 1;
    private static final Integer MEMORY_MB = 2;
    private static final List<Integer> SCRATCH_DISKS = ImmutableList.of((Object)3);
    private static final Integer MAXIMUM_PERSISTENT_DISKS = 4;
    private static final Long MAXIMUM_PERSISTENT_DISKS_SIZE_GB = 5L;
    private static final MachineType MACHINE_TYPE = MachineType.builder().generatedId("42").machineTypeId(MACHINE_TYPE_ID).creationTimestamp(CREATION_TIMESTAMP).description("description").cpus(GUEST_CPUS).memoryMb(MEMORY_MB).scratchDisksSizeGb(SCRATCH_DISKS).maximumPersistentDisks(MAXIMUM_PERSISTENT_DISKS).maximumPersistentDisksSizeGb(MAXIMUM_PERSISTENT_DISKS_SIZE_GB).build();
    private static final RegionId REGION_ID = RegionId.of((String)"project", (String)"region");
    private static final Region.Status REGION_STATUS = Region.Status.DOWN;
    private static final ZoneId ZONE_ID1 = ZoneId.of((String)"project", (String)"zone1");
    private static final ZoneId ZONE_ID2 = ZoneId.of((String)"project", (String)"zone2");
    private static final List<ZoneId> ZONES = ImmutableList.of((Object)ZONE_ID1, (Object)ZONE_ID2);
    private static final Region.Quota QUOTA1 = new Region.Quota("METRIC1", 2.0, 1.0);
    private static final Region.Quota QUOTA2 = new Region.Quota("METRIC2", 4.0, 3.0);
    private static final List<Region.Quota> QUOTAS = ImmutableList.of((Object)QUOTA1, (Object)QUOTA2);
    private static final Region REGION = Region.builder().regionId(REGION_ID).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(REGION_STATUS).zones(ZONES).quotas(QUOTAS).build();
    private static final ZoneId ZONE_ID = ZoneId.of((String)"project", (String)"zone");
    private static final Zone.Status ZONE_STATUS = Zone.Status.DOWN;
    private static final Zone ZONE = Zone.builder().zoneId(ZONE_ID).generatedId("42").creationTimestamp(CREATION_TIMESTAMP).description("description").status(ZONE_STATUS).region(REGION_ID).build();
    private static final LicenseId LICENSE_ID = LicenseId.of((String)"project", (String)"license");
    private static final Boolean CHARGES_USE_FEE = true;
    private static final License LICENSE = new License(LICENSE_ID, CHARGES_USE_FEE);
    private static final Operation.OperationError OPERATION_ERROR1 = new Operation.OperationError("code1", "location1", "message1");
    private static final Operation.OperationError OPERATION_ERROR2 = new Operation.OperationError("code2", "location2", "message2");
    private static final Operation.OperationWarning OPERATION_WARNING1 = new Operation.OperationWarning("code1", "message1", (Map)ImmutableMap.of((Object)"k1", (Object)"v1"));
    private static final Operation.OperationWarning OPERATION_WARNING2 = new Operation.OperationWarning("code2", "location2", (Map)ImmutableMap.of((Object)"k2", (Object)"v2"));
    private static final String CLIENT_OPERATION_ID = "clientOperationId";
    private static final String OPERATION_TYPE = "delete";
    private static final String TARGET_LINK = "targetLink";
    private static final String TARGET_ID = "42";
    private static final Operation.Status STATUS = Operation.Status.DONE;
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String USER = "user";
    private static final Integer PROGRESS = 100;
    private static final Long INSERT_TIME = 1453293540000L;
    private static final Long START_TIME = 1453293420000L;
    private static final Long END_TIME = 1453293480000L;
    private static final List<Operation.OperationError> ERRORS = ImmutableList.of((Object)OPERATION_ERROR1, (Object)OPERATION_ERROR2);
    private static final List<Operation.OperationWarning> WARNINGS = ImmutableList.of((Object)OPERATION_WARNING1, (Object)OPERATION_WARNING2);
    private static final Integer HTTP_ERROR_STATUS_CODE = 404;
    private static final String HTTP_ERROR_MESSAGE = "NOT FOUND";
    private static final GlobalOperationId GLOBAL_OPERATION_ID = GlobalOperationId.of((String)"project", (String)"op");
    private static final ZoneOperationId ZONE_OPERATION_ID = ZoneOperationId.of((String)"project", (String)"zone", (String)"op");
    private static final RegionOperationId REGION_OPERATION_ID = RegionOperationId.of((String)"project", (String)"region", (String)"op");
    private static final RegionAddressId REGION_ADDRESS_ID = RegionAddressId.of((String)"project", (String)"region", (String)"address");
    private static final GlobalAddressId GLOBAL_ADDRESS_ID = GlobalAddressId.of((String)"project", (String)"address");
    private static final AddressInfo REGION_ADDRESS = AddressInfo.builder((AddressId)REGION_ADDRESS_ID).build();
    private static final AddressInfo GLOBAL_ADDRESS = AddressInfo.builder((AddressId)GLOBAL_ADDRESS_ID).build();
    private static final DiskId DISK_ID = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final SnapshotId SNAPSHOT_ID = SnapshotId.of((String)"project", (String)"snapshot");
    private static final SnapshotInfo SNAPSHOT = SnapshotInfo.of((SnapshotId)SNAPSHOT_ID, (DiskId)DISK_ID);
    private static final ImageId IMAGE_ID = ImageId.of((String)"project", (String)"image");
    private static final ImageInfo IMAGE = ImageInfo.of((ImageId)IMAGE_ID, (ImageConfiguration)DiskImageConfiguration.of((DiskId)DISK_ID));
    private static final DeprecationStatus<ImageId> DEPRECATION_STATUS = DeprecationStatus.builder((DeprecationStatus.Status)DeprecationStatus.Status.DEPRECATED, (ResourceId)IMAGE_ID).build();
    private static final DiskInfo DISK = DiskInfo.of((DiskId)DISK_ID, (DiskConfiguration)StandardDiskConfiguration.of((DiskTypeId)DISK_TYPE_ID));
    private static final NetworkId NETWORK_ID = NetworkId.of((String)"project", (String)"network");
    private static final SubnetworkId SUBNETWORK_ID = SubnetworkId.of((String)"project", (String)"region", (String)"network");
    private static final SubnetworkInfo SUBNETWORK = SubnetworkInfo.of((SubnetworkId)SUBNETWORK_ID, (NetworkId)NETWORK_ID, (String)"192.168.0.0/16");
    private static final NetworkInfo NETWORK = NetworkInfo.of((NetworkId)NETWORK_ID, (NetworkConfiguration)StandardNetworkConfiguration.of((String)"192.168.0.0/16"));
    private static final InstanceId INSTANCE_ID = InstanceId.of((String)"project", (String)"zone", (String)"instance");
    private static final AttachedDisk.PersistentDiskConfiguration PERSISTENT_DISK_CONFIGURATION = AttachedDisk.PersistentDiskConfiguration.of((DiskId)DISK_ID);
    private static final AttachedDisk ATTACHED_DISK = AttachedDisk.of((String)"device", (AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
    private static final NetworkInterface NETWORK_INTERFACE = NetworkInterface.of((NetworkId)NETWORK_ID);
    private static final InstanceInfo INSTANCE = InstanceInfo.of((InstanceId)INSTANCE_ID, (MachineTypeId)MACHINE_TYPE_ID, (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NETWORK_INTERFACE);
    private static final Map<ComputeRpc.Option, ?> EMPTY_RPC_OPTIONS = ImmutableMap.of();
    private static final Compute.DiskTypeOption DISK_TYPE_OPTION_FIELDS = Compute.DiskTypeOption.fields((Compute.DiskTypeField[])new Compute.DiskTypeField[]{Compute.DiskTypeField.ID, Compute.DiskTypeField.DESCRIPTION});
    private static final Compute.DiskTypeFilter DISK_TYPE_FILTER = Compute.DiskTypeFilter.equals((Compute.DiskTypeField)Compute.DiskTypeField.DESCRIPTION, (String)"someDescription");
    private static final Compute.DiskTypeListOption DISK_TYPE_LIST_PAGE_TOKEN = Compute.DiskTypeListOption.pageToken((String)"cursor");
    private static final Compute.DiskTypeListOption DISK_TYPE_LIST_PAGE_SIZE = Compute.DiskTypeListOption.pageSize((long)42L);
    private static final Compute.DiskTypeListOption DISK_TYPE_LIST_FILTER = Compute.DiskTypeListOption.filter((Compute.DiskTypeFilter)DISK_TYPE_FILTER);
    private static final Map<ComputeRpc.Option, ?> DISK_TYPE_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"description eq someDescription");
    private static final Compute.DiskTypeAggregatedListOption DISK_TYPE_AGGREGATED_LIST_PAGE_TOKEN = Compute.DiskTypeAggregatedListOption.pageToken((String)"cursor");
    private static final Compute.DiskTypeAggregatedListOption DISK_TYPE_AGGREGATED_LIST_PAGE_SIZE = Compute.DiskTypeAggregatedListOption.pageSize((long)42L);
    private static final Compute.DiskTypeAggregatedListOption DISK_TYPE_AGGREGATED_LIST_FILTER = Compute.DiskTypeAggregatedListOption.filter((Compute.DiskTypeFilter)DISK_TYPE_FILTER);
    private static final Compute.MachineTypeOption MACHINE_TYPE_OPTION_FIELDS = Compute.MachineTypeOption.fields((Compute.MachineTypeField[])new Compute.MachineTypeField[]{Compute.MachineTypeField.ID, Compute.MachineTypeField.DESCRIPTION});
    private static final Compute.MachineTypeFilter MACHINE_TYPE_FILTER = Compute.MachineTypeFilter.notEquals((Compute.MachineTypeField)Compute.MachineTypeField.MAXIMUM_PERSISTENT_DISKS, (long)42L);
    private static final Compute.MachineTypeListOption MACHINE_TYPE_LIST_PAGE_TOKEN = Compute.MachineTypeListOption.pageToken((String)"cursor");
    private static final Compute.MachineTypeListOption MACHINE_TYPE_LIST_PAGE_SIZE = Compute.MachineTypeListOption.pageSize((long)42L);
    private static final Compute.MachineTypeListOption MACHINE_TYPE_LIST_FILTER = Compute.MachineTypeListOption.filter((Compute.MachineTypeFilter)MACHINE_TYPE_FILTER);
    private static final Map<ComputeRpc.Option, ?> MACHINE_TYPE_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"maximumPersistentDisks ne 42");
    private static final Compute.MachineTypeAggregatedListOption MACHINE_TYPE_AGGREGATED_LIST_PAGE_TOKEN = Compute.MachineTypeAggregatedListOption.pageToken((String)"cursor");
    private static final Compute.MachineTypeAggregatedListOption MACHINE_TYPE_AGGREGATED_LIST_PAGE_SIZE = Compute.MachineTypeAggregatedListOption.pageSize((long)42L);
    private static final Compute.MachineTypeAggregatedListOption MACHINE_TYPE_AGGREGATED_LIST_FILTER = Compute.MachineTypeAggregatedListOption.filter((Compute.MachineTypeFilter)MACHINE_TYPE_FILTER);
    private static final Compute.RegionOption REGION_OPTION_FIELDS = Compute.RegionOption.fields((Compute.RegionField[])new Compute.RegionField[]{Compute.RegionField.ID, Compute.RegionField.DESCRIPTION});
    private static final Compute.RegionFilter REGION_FILTER = Compute.RegionFilter.equals((Compute.RegionField)Compute.RegionField.ID, (String)"someId");
    private static final Compute.RegionListOption REGION_LIST_PAGE_TOKEN = Compute.RegionListOption.pageToken((String)"cursor");
    private static final Compute.RegionListOption REGION_LIST_PAGE_SIZE = Compute.RegionListOption.pageSize((long)42L);
    private static final Compute.RegionListOption REGION_LIST_FILTER = Compute.RegionListOption.filter((Compute.RegionFilter)REGION_FILTER);
    private static final Map<ComputeRpc.Option, ?> REGION_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"id eq someId");
    private static final Compute.ZoneOption ZONE_OPTION_FIELDS = Compute.ZoneOption.fields((Compute.ZoneField[])new Compute.ZoneField[]{Compute.ZoneField.ID, Compute.ZoneField.DESCRIPTION});
    private static final Compute.ZoneFilter ZONE_FILTER = Compute.ZoneFilter.notEquals((Compute.ZoneField)Compute.ZoneField.NAME, (String)"someName");
    private static final Compute.ZoneListOption ZONE_LIST_PAGE_TOKEN = Compute.ZoneListOption.pageToken((String)"cursor");
    private static final Compute.ZoneListOption ZONE_LIST_PAGE_SIZE = Compute.ZoneListOption.pageSize((long)42L);
    private static final Compute.ZoneListOption ZONE_LIST_FILTER = Compute.ZoneListOption.filter((Compute.ZoneFilter)ZONE_FILTER);
    private static final Map<ComputeRpc.Option, ?> ZONE_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"name ne someName");
    private static final Compute.LicenseOption LICENSE_OPTION_FIELDS = Compute.LicenseOption.fields((Compute.LicenseField[])new Compute.LicenseField[]{Compute.LicenseField.CHARGES_USE_FEE});
    private static final Compute.OperationOption OPERATION_OPTION_FIELDS = Compute.OperationOption.fields((Compute.OperationField[])new Compute.OperationField[]{Compute.OperationField.ID, Compute.OperationField.DESCRIPTION});
    private static final Compute.OperationFilter OPERATION_FILTER = Compute.OperationFilter.notEquals((Compute.OperationField)Compute.OperationField.PROGRESS, (long)0L);
    private static final Compute.OperationListOption OPERATION_LIST_PAGE_TOKEN = Compute.OperationListOption.pageToken((String)"cursor");
    private static final Compute.OperationListOption OPERATION_LIST_PAGE_SIZE = Compute.OperationListOption.pageSize((long)42L);
    private static final Compute.OperationListOption OPERATION_LIST_FILTER = Compute.OperationListOption.filter((Compute.OperationFilter)OPERATION_FILTER);
    private static final Map<ComputeRpc.Option, ?> OPERATION_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"progress ne 0");
    private static final Compute.AddressOption ADDRESS_OPTION_FIELDS = Compute.AddressOption.fields((Compute.AddressField[])new Compute.AddressField[]{Compute.AddressField.ID, Compute.AddressField.DESCRIPTION});
    private static final Compute.AddressFilter ADDRESS_FILTER = Compute.AddressFilter.notEquals((Compute.AddressField)Compute.AddressField.REGION, (String)"someRegion");
    private static final Compute.AddressListOption ADDRESS_LIST_PAGE_TOKEN = Compute.AddressListOption.pageToken((String)"cursor");
    private static final Compute.AddressListOption ADDRESS_LIST_PAGE_SIZE = Compute.AddressListOption.pageSize((long)42L);
    private static final Compute.AddressListOption ADDRESS_LIST_FILTER = Compute.AddressListOption.filter((Compute.AddressFilter)ADDRESS_FILTER);
    private static final Map<ComputeRpc.Option, ?> ADDRESS_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"region ne someRegion");
    private static final Compute.AddressAggregatedListOption ADDRESS_AGGREGATED_LIST_PAGE_TOKEN = Compute.AddressAggregatedListOption.pageToken((String)"cursor");
    private static final Compute.AddressAggregatedListOption ADDRESS_AGGREGATED_LIST_PAGE_SIZE = Compute.AddressAggregatedListOption.pageSize((long)42L);
    private static final Compute.AddressAggregatedListOption ADDRESS_AGGREGATED_LIST_FILTER = Compute.AddressAggregatedListOption.filter((Compute.AddressFilter)ADDRESS_FILTER);
    private static final Compute.SnapshotOption SNAPSHOT_OPTION_FIELDS = Compute.SnapshotOption.fields((Compute.SnapshotField[])new Compute.SnapshotField[]{Compute.SnapshotField.ID, Compute.SnapshotField.DESCRIPTION});
    private static final Compute.SnapshotFilter SNAPSHOT_FILTER = Compute.SnapshotFilter.equals((Compute.SnapshotField)Compute.SnapshotField.DISK_SIZE_GB, (long)500L);
    private static final Compute.SnapshotListOption SNAPSHOT_LIST_PAGE_TOKEN = Compute.SnapshotListOption.pageToken((String)"cursor");
    private static final Compute.SnapshotListOption SNAPSHOT_LIST_PAGE_SIZE = Compute.SnapshotListOption.pageSize((long)42L);
    private static final Compute.SnapshotListOption SNAPSHOT_LIST_FILTER = Compute.SnapshotListOption.filter((Compute.SnapshotFilter)SNAPSHOT_FILTER);
    private static final Map<ComputeRpc.Option, ?> SNAPSHOT_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"diskSizeGb eq 500");
    private static final Compute.ImageOption IMAGE_OPTION_FIELDS = Compute.ImageOption.fields((Compute.ImageField[])new Compute.ImageField[]{Compute.ImageField.ID, Compute.ImageField.DESCRIPTION});
    private static final Compute.ImageFilter IMAGE_FILTER = Compute.ImageFilter.notEquals((Compute.ImageField)Compute.ImageField.DISK_SIZE_GB, (long)500L);
    private static final Compute.ImageListOption IMAGE_LIST_PAGE_TOKEN = Compute.ImageListOption.pageToken((String)"cursor");
    private static final Compute.ImageListOption IMAGE_LIST_PAGE_SIZE = Compute.ImageListOption.pageSize((long)42L);
    private static final Compute.ImageListOption IMAGE_LIST_FILTER = Compute.ImageListOption.filter((Compute.ImageFilter)IMAGE_FILTER);
    private static final Map<ComputeRpc.Option, ?> IMAGE_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"diskSizeGb ne 500");
    private static final Compute.DiskOption DISK_OPTION_FIELDS = Compute.DiskOption.fields((Compute.DiskField[])new Compute.DiskField[]{Compute.DiskField.ID, Compute.DiskField.DESCRIPTION});
    private static final Compute.DiskFilter DISK_FILTER = Compute.DiskFilter.notEquals((Compute.DiskField)Compute.DiskField.SIZE_GB, (long)500L);
    private static final Compute.DiskListOption DISK_LIST_PAGE_TOKEN = Compute.DiskListOption.pageToken((String)"cursor");
    private static final Compute.DiskListOption DISK_LIST_PAGE_SIZE = Compute.DiskListOption.pageSize((long)42L);
    private static final Compute.DiskListOption DISK_LIST_FILTER = Compute.DiskListOption.filter((Compute.DiskFilter)DISK_FILTER);
    private static final Map<ComputeRpc.Option, ?> DISK_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"sizeGb ne 500");
    private static final Compute.DiskAggregatedListOption DISK_AGGREGATED_LIST_PAGE_TOKEN = Compute.DiskAggregatedListOption.pageToken((String)"cursor");
    private static final Compute.DiskAggregatedListOption DISK_AGGREGATED_LIST_PAGE_SIZE = Compute.DiskAggregatedListOption.pageSize((long)42L);
    private static final Compute.DiskAggregatedListOption DISK_AGGREGATED_LIST_FILTER = Compute.DiskAggregatedListOption.filter((Compute.DiskFilter)DISK_FILTER);
    private static final Compute.SubnetworkOption SUBNETWORK_OPTION_FIELDS = Compute.SubnetworkOption.fields((Compute.SubnetworkField[])new Compute.SubnetworkField[]{Compute.SubnetworkField.ID, Compute.SubnetworkField.DESCRIPTION});
    private static final Compute.SubnetworkFilter SUBNETWORK_FILTER = Compute.SubnetworkFilter.equals((Compute.SubnetworkField)Compute.SubnetworkField.IP_CIDR_RANGE, (String)"192.168.0.0/16");
    private static final Compute.SubnetworkListOption SUBNETWORK_LIST_PAGE_TOKEN = Compute.SubnetworkListOption.pageToken((String)"cursor");
    private static final Compute.SubnetworkListOption SUBNETWORK_LIST_PAGE_SIZE = Compute.SubnetworkListOption.pageSize((long)42L);
    private static final Compute.SubnetworkListOption SUBNETWORK_LIST_FILTER = Compute.SubnetworkListOption.filter((Compute.SubnetworkFilter)SUBNETWORK_FILTER);
    private static final Map<ComputeRpc.Option, ?> SUBNETWORK_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"ipCidrRange eq 192.168.0.0/16");
    private static final Compute.SubnetworkAggregatedListOption SUBNETWORK_AGGREGATED_LIST_PAGE_TOKEN = Compute.SubnetworkAggregatedListOption.pageToken((String)"cursor");
    private static final Compute.SubnetworkAggregatedListOption SUBNETWORK_AGGREGATED_LIST_PAGE_SIZE = Compute.SubnetworkAggregatedListOption.pageSize((long)42L);
    private static final Compute.SubnetworkAggregatedListOption SUBNETWORK_AGGREGATED_LIST_FILTER = Compute.SubnetworkAggregatedListOption.filter((Compute.SubnetworkFilter)SUBNETWORK_FILTER);
    private static final Compute.NetworkOption NETWORK_OPTION_FIELDS = Compute.NetworkOption.fields((Compute.NetworkField[])new Compute.NetworkField[]{Compute.NetworkField.ID, Compute.NetworkField.DESCRIPTION});
    private static final Compute.NetworkFilter NETWORK_FILTER = Compute.NetworkFilter.equals((Compute.NetworkField)Compute.NetworkField.IPV4_RANGE, (String)"192.168.0.0/16");
    private static final Compute.NetworkListOption NETWORK_LIST_PAGE_TOKEN = Compute.NetworkListOption.pageToken((String)"cursor");
    private static final Compute.NetworkListOption NETWORK_LIST_PAGE_SIZE = Compute.NetworkListOption.pageSize((long)42L);
    private static final Compute.NetworkListOption NETWORK_LIST_FILTER = Compute.NetworkListOption.filter((Compute.NetworkFilter)NETWORK_FILTER);
    private static final Map<ComputeRpc.Option, ?> NETWORK_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"IPv4Range eq 192.168.0.0/16");
    private static final Compute.InstanceOption INSTANCE_OPTION_FIELDS = Compute.InstanceOption.fields((Compute.InstanceField[])new Compute.InstanceField[]{Compute.InstanceField.ID, Compute.InstanceField.DESCRIPTION});
    private static final Compute.InstanceFilter INSTANCE_FILTER = Compute.InstanceFilter.equals((Compute.InstanceField)Compute.InstanceField.CAN_IP_FORWARD, (boolean)true);
    private static final Compute.InstanceListOption INSTANCE_LIST_PAGE_TOKEN = Compute.InstanceListOption.pageToken((String)"cursor");
    private static final Compute.InstanceListOption INSTANCE_LIST_PAGE_SIZE = Compute.InstanceListOption.pageSize((long)42L);
    private static final Compute.InstanceListOption INSTANCE_LIST_FILTER = Compute.InstanceListOption.filter((Compute.InstanceFilter)INSTANCE_FILTER);
    private static final Map<ComputeRpc.Option, ?> INSTANCE_LIST_OPTIONS = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)"cursor", (Object)ComputeRpc.Option.MAX_RESULTS, (Object)42L, (Object)ComputeRpc.Option.FILTER, (Object)"canIpForward eq true");
    private static final Compute.InstanceAggregatedListOption INSTANCE_AGGREGATED_LIST_PAGE_TOKEN = Compute.InstanceAggregatedListOption.pageToken((String)"cursor");
    private static final Compute.InstanceAggregatedListOption INSTANCE_AGGREGATED_LIST_PAGE_SIZE = Compute.InstanceAggregatedListOption.pageSize((long)42L);
    private static final Compute.InstanceAggregatedListOption INSTANCE_AGGREGATED_LIST_FILTER = Compute.InstanceAggregatedListOption.filter((Compute.InstanceFilter)INSTANCE_FILTER);
    private static final Function<Operation, com.google.api.services.compute.model.Operation> OPERATION_TO_PB_FUNCTION = new Function<Operation, com.google.api.services.compute.model.Operation>(){

        public com.google.api.services.compute.model.Operation apply(Operation operation) {
            return operation.toPb();
        }
    };
    private ComputeOptions options;
    private ComputeRpcFactory rpcFactoryMock;
    private ComputeRpc computeRpcMock;
    private Compute compute;
    private Operation globalOperation;
    private Operation zoneOperation;
    private Operation regionOperation;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void setUp() {
        this.rpcFactoryMock = (ComputeRpcFactory)EasyMock.createMock(ComputeRpcFactory.class);
        this.computeRpcMock = (ComputeRpc)EasyMock.createMock(ComputeRpc.class);
        EasyMock.expect((Object)this.rpcFactoryMock.create((ServiceOptions)EasyMock.anyObject(ComputeOptions.class))).andReturn((Object)this.computeRpcMock).times(2);
        EasyMock.replay((Object[])new Object[]{this.rpcFactoryMock});
        this.options = ((ComputeOptions.Builder)((ComputeOptions.Builder)((ComputeOptions.Builder)ComputeOptions.builder().projectId(PROJECT)).serviceRpcFactory((ServiceRpcFactory)this.rpcFactoryMock)).retryParams(RetryParams.noRetries())).build();
        Compute otherService = (Compute)this.options.toBuilder().build().service();
        this.globalOperation = new Operation.Builder(otherService).generatedId("42").operationId((OperationId)GLOBAL_OPERATION_ID).clientOperationId(CLIENT_OPERATION_ID).operationType(OPERATION_TYPE).targetLink(TARGET_LINK).targetId("42").status(STATUS).statusMessage(STATUS_MESSAGE).user(USER).progress(PROGRESS).insertTime(INSERT_TIME).startTime(START_TIME).endTime(END_TIME).errors(ERRORS).warnings(WARNINGS).httpErrorStatusCode(HTTP_ERROR_STATUS_CODE).httpErrorMessage(HTTP_ERROR_MESSAGE).description(DESCRIPTION).build();
        this.zoneOperation = new Operation.Builder(otherService).generatedId("42").operationId((OperationId)ZONE_OPERATION_ID).clientOperationId(CLIENT_OPERATION_ID).operationType(OPERATION_TYPE).targetLink(TARGET_LINK).targetId("42").status(STATUS).statusMessage(STATUS_MESSAGE).user(USER).progress(PROGRESS).insertTime(INSERT_TIME).startTime(START_TIME).endTime(END_TIME).errors(ERRORS).warnings(WARNINGS).httpErrorStatusCode(HTTP_ERROR_STATUS_CODE).httpErrorMessage(HTTP_ERROR_MESSAGE).description(DESCRIPTION).build();
        this.regionOperation = new Operation.Builder(otherService).generatedId("42").operationId((OperationId)REGION_OPERATION_ID).clientOperationId(CLIENT_OPERATION_ID).operationType(OPERATION_TYPE).targetLink(TARGET_LINK).targetId("42").status(STATUS).statusMessage(STATUS_MESSAGE).user(USER).progress(PROGRESS).insertTime(INSERT_TIME).startTime(START_TIME).endTime(END_TIME).errors(ERRORS).warnings(WARNINGS).httpErrorStatusCode(HTTP_ERROR_STATUS_CODE).httpErrorMessage(HTTP_ERROR_MESSAGE).description(DESCRIPTION).build();
    }

    @After
    public void tearDown() {
        EasyMock.verify((Object[])new Object[]{this.rpcFactoryMock, this.computeRpcMock});
    }

    @Test
    public void testGetOptions() {
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertSame((Object)this.options, (Object)this.compute.options());
    }

    @Test
    public void testGetDiskType() {
        EasyMock.expect((Object)this.computeRpcMock.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andReturn((Object)DISK_TYPE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        DiskType diskType = this.compute.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), new Compute.DiskTypeOption[0]);
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskType);
    }

    @Test
    public void testGetDiskType_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), new Compute.DiskTypeOption[0]));
    }

    @Test
    public void testGetDiskTypeFromDiskTypeId() {
        EasyMock.expect((Object)this.computeRpcMock.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andReturn((Object)DISK_TYPE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        DiskType diskType = this.compute.getDiskType(DISK_TYPE_ID, new Compute.DiskTypeOption[0]);
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskType);
    }

    @Test
    public void testGetDiskTypeWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getDiskType((String)EasyMock.eq((Object)DISK_TYPE_ID.zone()), (String)EasyMock.eq((Object)DISK_TYPE_ID.type()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)DISK_TYPE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        DiskType diskType = this.compute.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), new Compute.DiskTypeOption[]{DISK_TYPE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(DISK_TYPE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskType);
    }

    @Test
    public void testListDiskTypes() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskTypeList = ImmutableList.of((Object)DISK_TYPE, (Object)DISK_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(DISK_TYPE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDiskTypes(DISK_TYPE_ID.zone(), new Compute.DiskTypeListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testListDiskTypesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskTypeList = ImmutableList.of((Object)DISK_TYPE, (Object)DISK_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        ImmutableList nextDiskTypeList = ImmutableList.of((Object)DISK_TYPE);
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextDiskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(DISK_TYPE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(DISK_TYPE_ID.zone(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDiskTypes(DISK_TYPE_ID.zone(), new Compute.DiskTypeListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextDiskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testListEmptyDiskTypes() {
        ImmutableList diskTypes = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)diskTypes);
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(DISK_TYPE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listDiskTypes(DISK_TYPE_ID.zone(), new Compute.DiskTypeListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypes.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testListDiskTypesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskTypeList = ImmutableList.of((Object)DISK_TYPE, (Object)DISK_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(DISK_TYPE_ID.zone(), DISK_TYPE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDiskTypes(DISK_TYPE_ID.zone(), new Compute.DiskTypeListOption[]{DISK_TYPE_LIST_PAGE_SIZE, DISK_TYPE_LIST_PAGE_TOKEN, DISK_TYPE_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testAggregatedListDiskTypes() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskTypeList = ImmutableList.of((Object)DISK_TYPE, (Object)DISK_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDiskTypes(new Compute.DiskTypeAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testAggregatedListDiskTypesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskTypeList = ImmutableList.of((Object)DISK_TYPE, (Object)DISK_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        ImmutableList nextDiskTypeList = ImmutableList.of((Object)DISK_TYPE);
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextDiskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDiskTypes(new Compute.DiskTypeAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextDiskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testAggregatedListEmptyDiskTypes() {
        ImmutableList diskTypes = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)diskTypes);
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listDiskTypes(new Compute.DiskTypeAggregatedListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypes.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testAggregatedListDiskTypesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskTypeList = ImmutableList.of((Object)DISK_TYPE, (Object)DISK_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskTypeList, (Function)DiskType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDiskTypes(DISK_TYPE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDiskTypes(new Compute.DiskTypeAggregatedListOption[]{DISK_TYPE_AGGREGATED_LIST_PAGE_SIZE, DISK_TYPE_AGGREGATED_LIST_PAGE_TOKEN, DISK_TYPE_AGGREGATED_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), DiskType.class));
    }

    @Test
    public void testGetMachineType() {
        EasyMock.expect((Object)this.computeRpcMock.getMachineType(MACHINE_TYPE_ID.zone(), MACHINE_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andReturn((Object)MACHINE_TYPE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        MachineType machineType = this.compute.getMachineType(MACHINE_TYPE_ID.zone(), MACHINE_TYPE_ID.type(), new Compute.MachineTypeOption[0]);
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)machineType);
    }

    @Test
    public void testGetMachineType_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getMachineType(MACHINE_TYPE_ID.zone(), MACHINE_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getMachineType(MACHINE_TYPE_ID.zone(), MACHINE_TYPE_ID.type(), new Compute.MachineTypeOption[0]));
    }

    @Test
    public void testGetMachineTypeFromMachineTypeId() {
        EasyMock.expect((Object)this.computeRpcMock.getMachineType(MACHINE_TYPE_ID.zone(), MACHINE_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andReturn((Object)MACHINE_TYPE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        MachineType machineType = this.compute.getMachineType(MACHINE_TYPE_ID, new Compute.MachineTypeOption[0]);
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)machineType);
    }

    @Test
    public void testGetMachineTypeWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getMachineType((String)EasyMock.eq((Object)MACHINE_TYPE_ID.zone()), (String)EasyMock.eq((Object)MACHINE_TYPE_ID.type()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)MACHINE_TYPE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        MachineType machineType = this.compute.getMachineType(MACHINE_TYPE_ID.zone(), MACHINE_TYPE_ID.type(), new Compute.MachineTypeOption[]{MACHINE_TYPE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(DISK_TYPE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)MACHINE_TYPE, (Object)machineType);
    }

    @Test
    public void testListMachineTypes() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList machineTypeList = ImmutableList.of((Object)MACHINE_TYPE, (Object)MACHINE_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)machineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(MACHINE_TYPE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listMachineTypes(MACHINE_TYPE_ID.zone(), new Compute.MachineTypeListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testListMachineTypesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList machineTypeList = ImmutableList.of((Object)MACHINE_TYPE, (Object)MACHINE_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)machineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        ImmutableList nextMachineTypeList = ImmutableList.of((Object)MACHINE_TYPE);
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextMachineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(MACHINE_TYPE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(MACHINE_TYPE_ID.zone(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listMachineTypes(MACHINE_TYPE_ID.zone(), new Compute.MachineTypeListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextMachineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testListEmptyMachineTypes() {
        ImmutableList machineTypes = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)machineTypes);
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(MACHINE_TYPE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listMachineTypes(MACHINE_TYPE_ID.zone(), new Compute.MachineTypeListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypes.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testListMachineTypesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList machineTypeList = ImmutableList.of((Object)MACHINE_TYPE, (Object)MACHINE_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)machineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(MACHINE_TYPE_ID.zone(), MACHINE_TYPE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listMachineTypes(MACHINE_TYPE_ID.zone(), new Compute.MachineTypeListOption[]{MACHINE_TYPE_LIST_PAGE_SIZE, MACHINE_TYPE_LIST_PAGE_TOKEN, MACHINE_TYPE_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testAggregatedListMachineTypes() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList machineTypeList = ImmutableList.of((Object)MACHINE_TYPE, (Object)MACHINE_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)machineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listMachineTypes(new Compute.MachineTypeAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testAggregatedListMachineTypesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList machineTypeList = ImmutableList.of((Object)MACHINE_TYPE, (Object)MACHINE_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)machineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        ImmutableList nextMachineTypeList = ImmutableList.of((Object)MACHINE_TYPE);
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextMachineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listMachineTypes(new Compute.MachineTypeAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextMachineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testAggregatedListEmptyMachineTypes() {
        ImmutableList machineTypes = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)machineTypes);
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listMachineTypes(new Compute.MachineTypeAggregatedListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypes.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testAggregatedListMachineTypesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList machineTypeList = ImmutableList.of((Object)MACHINE_TYPE, (Object)MACHINE_TYPE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)machineTypeList, (Function)MachineType.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listMachineTypes(MACHINE_TYPE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listMachineTypes(new Compute.MachineTypeAggregatedListOption[]{MACHINE_TYPE_AGGREGATED_LIST_PAGE_SIZE, MACHINE_TYPE_AGGREGATED_LIST_PAGE_TOKEN, MACHINE_TYPE_AGGREGATED_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])machineTypeList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), MachineType.class));
    }

    @Test
    public void testGetRegion() {
        EasyMock.expect((Object)this.computeRpcMock.getRegion(REGION_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)REGION.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Region region = this.compute.getRegion(REGION_ID.region(), new Compute.RegionOption[0]);
        Assert.assertEquals((Object)REGION, (Object)region);
    }

    @Test
    public void testGetRegion_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getRegion(REGION_ID.region(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getRegion(REGION_ID.region(), new Compute.RegionOption[0]));
    }

    @Test
    public void testGetRegionWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getRegion((String)EasyMock.eq((Object)REGION_ID.region()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)REGION.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Region region = this.compute.getRegion(REGION_ID.region(), new Compute.RegionOption[]{REGION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(REGION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)REGION, (Object)region);
    }

    @Test
    public void testListRegions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList regionList = ImmutableList.of((Object)REGION, (Object)REGION);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)regionList, (Function)Region.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listRegions(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegions(new Compute.RegionListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])regionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Region.class));
    }

    @Test
    public void testListRegionsNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList regionList = ImmutableList.of((Object)REGION, (Object)REGION);
        ImmutableList nextRegionList = ImmutableList.of((Object)REGION);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)regionList, (Function)Region.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextRegionList, (Function)Region.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listRegions(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listRegions((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegions(new Compute.RegionListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])regionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Region.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextRegionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Region.class));
    }

    @Test
    public void testListEmptyRegions() {
        ImmutableList regions = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)regions);
        EasyMock.expect((Object)this.computeRpcMock.listRegions(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listRegions(new Compute.RegionListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])regions.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Region.class));
    }

    @Test
    public void testListRegionsWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList regionList = ImmutableList.of((Object)REGION, (Object)REGION);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)regionList, (Function)Region.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listRegions(REGION_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegions(new Compute.RegionListOption[]{REGION_LIST_PAGE_SIZE, REGION_LIST_PAGE_TOKEN, REGION_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])regionList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Region.class));
    }

    @Test
    public void testGetZone() {
        EasyMock.expect((Object)this.computeRpcMock.getZone(ZONE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)ZONE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Zone zone = this.compute.getZone(ZONE_ID.zone(), new Compute.ZoneOption[0]);
        Assert.assertEquals((Object)ZONE, (Object)zone);
    }

    @Test
    public void testGetZone_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getZone(ZONE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getZone(ZONE_ID.zone(), new Compute.ZoneOption[0]));
    }

    @Test
    public void testGetZoneWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getZone((String)EasyMock.eq((Object)ZONE_ID.zone()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)ZONE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Zone zone = this.compute.getZone(ZONE_ID.zone(), new Compute.ZoneOption[]{ZONE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(ZONE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)ZONE, (Object)zone);
    }

    @Test
    public void testListZones() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList zoneList = ImmutableList.of((Object)ZONE, (Object)ZONE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)zoneList, (Function)Zone.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listZones(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listZones(new Compute.ZoneListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])zoneList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Zone.class));
    }

    @Test
    public void testListZonesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList zoneList = ImmutableList.of((Object)ZONE, (Object)ZONE);
        ImmutableList nextZoneList = ImmutableList.of((Object)ZONE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)zoneList, (Function)Zone.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextZoneList, (Function)Zone.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listZones(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listZones((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listZones(new Compute.ZoneListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])zoneList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Zone.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextZoneList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Zone.class));
    }

    @Test
    public void testListEmptyZones() {
        ImmutableList zones = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)zones);
        EasyMock.expect((Object)this.computeRpcMock.listZones(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listZones(new Compute.ZoneListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])zones.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Zone.class));
    }

    @Test
    public void testListZonesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList zoneList = ImmutableList.of((Object)ZONE, (Object)ZONE);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)zoneList, (Function)Zone.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listZones(ZONE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listZones(new Compute.ZoneListOption[]{ZONE_LIST_PAGE_SIZE, ZONE_LIST_PAGE_TOKEN, ZONE_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])zoneList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Zone.class));
    }

    @Test
    public void testGetLicenseFromString() {
        EasyMock.expect((Object)this.computeRpcMock.getLicense(PROJECT, LICENSE_ID.license(), EMPTY_RPC_OPTIONS)).andReturn((Object)LICENSE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        License license = this.compute.getLicense(LICENSE_ID.license(), new Compute.LicenseOption[0]);
        Assert.assertEquals((Object)LICENSE, (Object)license);
    }

    @Test
    public void testGetLicenseFromString_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getLicense(PROJECT, LICENSE_ID.license(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getLicense(LICENSE_ID.license(), new Compute.LicenseOption[0]));
    }

    @Test
    public void testGetLicenseFromStringWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getLicense((String)EasyMock.eq((Object)PROJECT), (String)EasyMock.eq((Object)LICENSE_ID.license()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)LICENSE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        License license = this.compute.getLicense(LICENSE_ID.license(), new Compute.LicenseOption[]{LICENSE_OPTION_FIELDS});
        Assert.assertEquals((Object)LICENSE, (Object)license);
        String selector = (String)((Map)capturedOptions.getValue()).get(LICENSE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("chargesUseFee"));
        Assert.assertEquals((long)22L, (long)selector.length());
        Assert.assertEquals((Object)LICENSE, (Object)license);
    }

    @Test
    public void testGetLicenseFromIdWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        LicenseId licenseId = LicenseId.of((String)"project2", (String)"license2");
        EasyMock.expect((Object)this.computeRpcMock.getLicense((String)EasyMock.eq((Object)licenseId.project()), (String)EasyMock.eq((Object)licenseId.license()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)LICENSE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        License license = this.compute.getLicense(licenseId, new Compute.LicenseOption[]{LICENSE_OPTION_FIELDS});
        Assert.assertEquals((Object)LICENSE, (Object)license);
        String selector = (String)((Map)capturedOptions.getValue()).get(LICENSE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("chargesUseFee"));
        Assert.assertEquals((long)22L, (long)selector.length());
        Assert.assertEquals((Object)LICENSE, (Object)license);
    }

    @Test
    public void testGetLicenseFromId() {
        LicenseId licenseId = LicenseId.of((String)"project2", (String)"license2");
        EasyMock.expect((Object)this.computeRpcMock.getLicense(licenseId.project(), licenseId.license(), EMPTY_RPC_OPTIONS)).andReturn((Object)LICENSE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        License license = this.compute.getLicense(licenseId, new Compute.LicenseOption[0]);
        Assert.assertEquals((Object)LICENSE, (Object)license);
    }

    @Test
    public void testGetLicenseFromId_Null() {
        LicenseId licenseId = LicenseId.of((String)"project2", (String)"license2");
        EasyMock.expect((Object)this.computeRpcMock.getLicense(licenseId.project(), licenseId.license(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getLicense(licenseId, new Compute.LicenseOption[0]));
    }

    @Test
    public void testGetGlobalOperation() {
        EasyMock.expect((Object)this.computeRpcMock.getGlobalOperation(GLOBAL_OPERATION_ID.operation(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.globalOperation, (Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testGetGlobalOperation_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getGlobalOperation(GLOBAL_OPERATION_ID.operation(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testGetGlobalOperationWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getGlobalOperation((String)EasyMock.eq((Object)GLOBAL_OPERATION_ID.operation()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.getOperation((OperationId)GLOBAL_OPERATION_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testListGlobalOperations() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.globalOperation, (Object)this.globalOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listGlobalOperations(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listGlobalOperations(new Compute.OperationListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListGlobalOperationsNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.globalOperation, (Object)this.globalOperation);
        ImmutableList nextOperationList = ImmutableList.of((Object)this.globalOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextOperationList, OPERATION_TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listGlobalOperations(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listGlobalOperations((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listGlobalOperations(new Compute.OperationListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextOperationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListEmptyGlobalOperations() {
        ImmutableList operations = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)operations);
        EasyMock.expect((Object)this.computeRpcMock.listGlobalOperations(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listGlobalOperations(new Compute.OperationListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operations.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListGlobalOperationsWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.globalOperation, (Object)this.globalOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listGlobalOperations(OPERATION_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listGlobalOperations(new Compute.OperationListOption[]{OPERATION_LIST_PAGE_SIZE, OPERATION_LIST_PAGE_TOKEN, OPERATION_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testDeleteGlobalOperation_True() {
        EasyMock.expect((Object)this.computeRpcMock.deleteGlobalOperation(GLOBAL_OPERATION_ID.operation())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertTrue((boolean)this.compute.deleteOperation((OperationId)GLOBAL_OPERATION_ID));
    }

    @Test
    public void testDeleteGlobalOperation_False() {
        EasyMock.expect((Object)this.computeRpcMock.deleteGlobalOperation(GLOBAL_OPERATION_ID.operation())).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertFalse((boolean)this.compute.deleteOperation((OperationId)GLOBAL_OPERATION_ID));
    }

    @Test
    public void testGetRegionOperation() {
        EasyMock.expect((Object)this.computeRpcMock.getRegionOperation(REGION_OPERATION_ID.region(), REGION_OPERATION_ID.operation(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.getOperation((OperationId)REGION_OPERATION_ID, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testGetRegionOperation_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getRegionOperation(REGION_OPERATION_ID.region(), REGION_OPERATION_ID.operation(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.getOperation((OperationId)REGION_OPERATION_ID, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testGetRegionOperationWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getRegionOperation((String)EasyMock.eq((Object)REGION_OPERATION_ID.region()), (String)EasyMock.eq((Object)REGION_OPERATION_ID.operation()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.getOperation((OperationId)REGION_OPERATION_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testListRegionOperations() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.regionOperation, (Object)this.regionOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listRegionOperations(REGION_OPERATION_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegionOperations(REGION_OPERATION_ID.region(), new Compute.OperationListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListRegionOperationsNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.regionOperation, (Object)this.regionOperation);
        ImmutableList nextOperationList = ImmutableList.of((Object)this.regionOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextOperationList, OPERATION_TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listRegionOperations(REGION_OPERATION_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listRegionOperations(REGION_OPERATION_ID.region(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegionOperations(REGION_OPERATION_ID.region(), new Compute.OperationListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextOperationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListEmptyRegionOperations() {
        ImmutableList operations = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)operations);
        EasyMock.expect((Object)this.computeRpcMock.listRegionOperations(REGION_OPERATION_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listRegionOperations(REGION_OPERATION_ID.region(), new Compute.OperationListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operations.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListRegionOperationsWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.regionOperation, (Object)this.regionOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listRegionOperations(REGION_OPERATION_ID.region(), OPERATION_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegionOperations(REGION_OPERATION_ID.region(), new Compute.OperationListOption[]{OPERATION_LIST_PAGE_SIZE, OPERATION_LIST_PAGE_TOKEN, OPERATION_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testDeleteRegionOperation_True() {
        EasyMock.expect((Object)this.computeRpcMock.deleteRegionOperation(REGION_OPERATION_ID.region(), REGION_OPERATION_ID.operation())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertTrue((boolean)this.compute.deleteOperation((OperationId)REGION_OPERATION_ID));
    }

    @Test
    public void testDeleteRegionOperation_False() {
        EasyMock.expect((Object)this.computeRpcMock.deleteRegionOperation(REGION_OPERATION_ID.region(), REGION_OPERATION_ID.operation())).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertFalse((boolean)this.compute.deleteOperation((OperationId)REGION_OPERATION_ID));
    }

    @Test
    public void testGetZoneOperation() {
        EasyMock.expect((Object)this.computeRpcMock.getZoneOperation(ZONE_OPERATION_ID.zone(), ZONE_OPERATION_ID.operation(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.getOperation((OperationId)ZONE_OPERATION_ID, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testGetZoneOperation_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getZoneOperation(ZONE_OPERATION_ID.zone(), ZONE_OPERATION_ID.operation(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getOperation((OperationId)ZONE_OPERATION_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testGetZoneOperationWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getZoneOperation((String)EasyMock.eq((Object)ZONE_OPERATION_ID.zone()), (String)EasyMock.eq((Object)ZONE_OPERATION_ID.operation()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.getOperation((OperationId)ZONE_OPERATION_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testListZoneOperations() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.zoneOperation, (Object)this.zoneOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listZoneOperations(ZONE_OPERATION_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listZoneOperations(ZONE_OPERATION_ID.zone(), new Compute.OperationListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListZoneOperationsNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.zoneOperation, (Object)this.zoneOperation);
        ImmutableList nextOperationList = ImmutableList.of((Object)this.zoneOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextOperationList, OPERATION_TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listZoneOperations(ZONE_OPERATION_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listZoneOperations(ZONE_OPERATION_ID.zone(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listZoneOperations(ZONE_OPERATION_ID.zone(), new Compute.OperationListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextOperationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListEmptyZoneOperations() {
        ImmutableList operations = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)operations);
        EasyMock.expect((Object)this.computeRpcMock.listZoneOperations(ZONE_OPERATION_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listZoneOperations(ZONE_OPERATION_ID.zone(), new Compute.OperationListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operations.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testListZoneOperationsWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList operationList = ImmutableList.of((Object)this.zoneOperation, (Object)this.zoneOperation);
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)operationList, OPERATION_TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listZoneOperations(ZONE_OPERATION_ID.zone(), OPERATION_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listZoneOperations(ZONE_OPERATION_ID.zone(), new Compute.OperationListOption[]{OPERATION_LIST_PAGE_SIZE, OPERATION_LIST_PAGE_TOKEN, OPERATION_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])operationList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Operation.class));
    }

    @Test
    public void testDeleteZoneOperation_True() {
        EasyMock.expect((Object)this.computeRpcMock.deleteZoneOperation(ZONE_OPERATION_ID.zone(), ZONE_OPERATION_ID.operation())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertTrue((boolean)this.compute.deleteOperation((OperationId)ZONE_OPERATION_ID));
    }

    @Test
    public void testDeleteZoneOperation_False() {
        EasyMock.expect((Object)this.computeRpcMock.deleteZoneOperation(ZONE_OPERATION_ID.zone(), ZONE_OPERATION_ID.operation())).andReturn((Object)false);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertFalse((boolean)this.compute.deleteOperation((OperationId)ZONE_OPERATION_ID));
    }

    @Test
    public void testGetGlobalAddress() {
        EasyMock.expect((Object)this.computeRpcMock.getGlobalAddress(GLOBAL_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn((Object)GLOBAL_ADDRESS.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Address address = this.compute.getAddress((AddressId)GLOBAL_ADDRESS_ID, new Compute.AddressOption[0]);
        Assert.assertEquals((Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)), (Object)address);
    }

    @Test
    public void testGetGlobalAddress_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getGlobalAddress(GLOBAL_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getAddress((AddressId)GLOBAL_ADDRESS_ID, new Compute.AddressOption[0]));
    }

    @Test
    public void testGetGlobalAddressWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getGlobalAddress((String)EasyMock.eq((Object)GLOBAL_ADDRESS_ID.address()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)GLOBAL_ADDRESS.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Address address = this.compute.getAddress((AddressId)GLOBAL_ADDRESS_ID, new Compute.AddressOption[]{ADDRESS_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(ADDRESS_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)), (Object)address);
    }

    @Test
    public void testGetRegionAddress() {
        EasyMock.expect((Object)this.computeRpcMock.getRegionAddress(REGION_ADDRESS_ID.region(), REGION_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn((Object)REGION_ADDRESS.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Address address = this.compute.getAddress((AddressId)REGION_ADDRESS_ID, new Compute.AddressOption[0]);
        Assert.assertEquals((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)address);
    }

    @Test
    public void testGetRegionAddress_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getRegionAddress(REGION_ADDRESS_ID.region(), REGION_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn((Object)REGION_ADDRESS.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Address address = this.compute.getAddress((AddressId)REGION_ADDRESS_ID, new Compute.AddressOption[0]);
        Assert.assertEquals((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)address);
    }

    @Test
    public void testGetRegionAddressWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getRegionAddress((String)EasyMock.eq((Object)REGION_ADDRESS_ID.region()), (String)EasyMock.eq((Object)REGION_ADDRESS_ID.address()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)REGION_ADDRESS.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Address address = this.compute.getAddress((AddressId)REGION_ADDRESS_ID, new Compute.AddressOption[]{ADDRESS_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(ADDRESS_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)address);
    }

    @Test
    public void testDeleteGlobalAddress_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteGlobalAddress(GLOBAL_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.globalOperation, (Object)this.compute.deleteAddress((AddressId)GLOBAL_ADDRESS_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteGlobalAddressWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteGlobalAddress((String)EasyMock.eq((Object)GLOBAL_ADDRESS_ID.address()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteAddress((AddressId)GLOBAL_ADDRESS_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testDeleteGlobalAddress_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteGlobalAddress(GLOBAL_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteAddress((AddressId)GLOBAL_ADDRESS_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteRegionAddress_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteRegionAddress(REGION_ADDRESS_ID.region(), REGION_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.regionOperation, (Object)this.compute.deleteAddress((AddressId)REGION_ADDRESS_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteRegionAddressWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteRegionAddress((String)EasyMock.eq((Object)REGION_ADDRESS_ID.region()), (String)EasyMock.eq((Object)REGION_ADDRESS_ID.address()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteAddress((AddressId)REGION_ADDRESS_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testDeleteRegionAddress_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteRegionAddress(REGION_ADDRESS_ID.region(), REGION_ADDRESS_ID.address(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteAddress((AddressId)REGION_ADDRESS_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testListGlobalAddresses() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listGlobalAddresses(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listGlobalAddresses(new Compute.AddressListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testListGlobalAddressesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)));
        ImmutableList nextAddressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextAddressList, (Function)AddressInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listGlobalAddresses(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listGlobalAddresses((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listGlobalAddresses(new Compute.AddressListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextAddressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testListEmptyGlobalAddresses() {
        ImmutableList addresses = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)addresses);
        EasyMock.expect((Object)this.computeRpcMock.listGlobalAddresses(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listGlobalAddresses(new Compute.AddressListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addresses.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testListGlobalAddressesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(GLOBAL_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listGlobalAddresses(ADDRESS_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listGlobalAddresses(new Compute.AddressListOption[]{ADDRESS_LIST_PAGE_SIZE, ADDRESS_LIST_PAGE_TOKEN, ADDRESS_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testListRegionAddresses() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listRegionAddresses(REGION_ADDRESS_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegionAddresses(REGION_ADDRESS_ID.region(), new Compute.AddressListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testListRegionAddressesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ImmutableList nextAddressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextAddressList, (Function)AddressInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listRegionAddresses(REGION_ADDRESS_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listRegionAddresses(REGION_ADDRESS_ID.region(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegionAddresses(REGION_ADDRESS_ID.region(), new Compute.AddressListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextAddressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testListEmptyRegionAddresses() {
        ImmutableList addresses = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)addresses);
        EasyMock.expect((Object)this.computeRpcMock.listRegionAddresses(REGION_ADDRESS_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listRegionAddresses(REGION_ADDRESS_ID.region(), new Compute.AddressListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addresses.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testListRegionAddressesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listRegionAddresses(REGION_ADDRESS_ID.region(), ADDRESS_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listRegionAddresses(REGION_ADDRESS_ID.region(), new Compute.AddressListOption[]{ADDRESS_LIST_PAGE_SIZE, ADDRESS_LIST_PAGE_TOKEN, ADDRESS_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testAggregatedListAddresses() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listAddresses(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listAddresses(new Compute.AddressAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testAggregatedListAddressesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ImmutableList nextAddressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextAddressList, (Function)AddressInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listAddresses(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listAddresses((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listAddresses(new Compute.AddressAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextAddressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testAggregatedListEmptyAddresses() {
        ImmutableList addresses = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)addresses);
        EasyMock.expect((Object)this.computeRpcMock.listAddresses(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Page page = this.compute.listAddresses(new Compute.AddressAggregatedListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addresses.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testAggregatedListAddressesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList addressList = ImmutableList.of((Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)), (Object)new Address(this.compute, new AddressInfo.BuilderImpl(REGION_ADDRESS)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)addressList, (Function)AddressInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listAddresses(ADDRESS_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listAddresses(new Compute.AddressAggregatedListOption[]{ADDRESS_AGGREGATED_LIST_PAGE_SIZE, ADDRESS_AGGREGATED_LIST_PAGE_TOKEN, ADDRESS_AGGREGATED_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])addressList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Address.class));
    }

    @Test
    public void testCreateGlobalAddress() {
        EasyMock.expect((Object)this.computeRpcMock.createGlobalAddress(GLOBAL_ADDRESS.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        GlobalAddressId incompleteId = GlobalAddressId.of((String)"address");
        Operation operation = this.compute.create(GLOBAL_ADDRESS.toBuilder().addressId((AddressId)incompleteId).build(), new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testCreateGlobalAddressWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createGlobalAddress((com.google.api.services.compute.model.Address)EasyMock.eq((Object)GLOBAL_ADDRESS.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(GLOBAL_ADDRESS, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testCreateRegionAddress() {
        EasyMock.expect((Object)this.computeRpcMock.createRegionAddress(REGION_ADDRESS_ID.region(), REGION_ADDRESS.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        RegionAddressId incompleteId = RegionAddressId.of((String)"region", (String)"address");
        Operation operation = this.compute.create(REGION_ADDRESS.toBuilder().addressId((AddressId)incompleteId).build(), new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testCreateRegionAddressWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createRegionAddress((String)EasyMock.eq((Object)REGION_ADDRESS_ID.region()), (com.google.api.services.compute.model.Address)EasyMock.eq((Object)REGION_ADDRESS.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(REGION_ADDRESS, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testCreateSnapshot() {
        EasyMock.expect((Object)this.computeRpcMock.createSnapshot(DISK_ID.zone(), DISK_ID.disk(), SNAPSHOT_ID.snapshot(), null, EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(SNAPSHOT, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testCreateSnapshotWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createSnapshot((String)EasyMock.eq((Object)DISK_ID.zone()), (String)EasyMock.eq((Object)DISK_ID.disk()), (String)EasyMock.eq((Object)SNAPSHOT_ID.snapshot()), (String)EasyMock.isNull(), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(SNAPSHOT, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testGetSnapshot() {
        EasyMock.expect((Object)this.computeRpcMock.getSnapshot(SNAPSHOT_ID.snapshot(), EMPTY_RPC_OPTIONS)).andReturn((Object)SNAPSHOT.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Snapshot snapshot = this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), new Compute.SnapshotOption[0]);
        Assert.assertEquals((Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)), (Object)snapshot);
    }

    @Test
    public void testGetSnapshot_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getSnapshot(SNAPSHOT_ID.snapshot(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), new Compute.SnapshotOption[0]));
    }

    @Test
    public void testGetSnapshotWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getSnapshot((String)EasyMock.eq((Object)SNAPSHOT_ID.snapshot()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)SNAPSHOT.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Snapshot snapshot = this.compute.getSnapshot(SNAPSHOT_ID.snapshot(), new Compute.SnapshotOption[]{SNAPSHOT_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(SNAPSHOT_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)), (Object)snapshot);
    }

    @Test
    public void testDeleteSnapshot_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteSnapshot(SNAPSHOT_ID.snapshot(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.globalOperation, (Object)this.compute.deleteSnapshot(SNAPSHOT_ID.snapshot(), new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteSnapshotWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteSnapshot((String)EasyMock.eq((Object)SNAPSHOT_ID.snapshot()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteSnapshot(SNAPSHOT_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testDeleteSnapshot_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteSnapshot(SNAPSHOT_ID.snapshot(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteSnapshot(SNAPSHOT_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testListSnapshots() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList snapshotList = ImmutableList.of((Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)), (Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)snapshotList, (Function)SnapshotInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listSnapshots(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSnapshots(new Compute.SnapshotListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])snapshotList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Snapshot.class));
    }

    @Test
    public void testListSnapshotsNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList snapshotList = ImmutableList.of((Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)), (Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)));
        ImmutableList nextSnapshotList = ImmutableList.of((Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)snapshotList, (Function)SnapshotInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextSnapshotList, (Function)SnapshotInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listSnapshots(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listSnapshots((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSnapshots(new Compute.SnapshotListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])snapshotList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Snapshot.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextSnapshotList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Snapshot.class));
    }

    @Test
    public void testListEmptySnapshots() {
        this.compute = (Compute)this.options.service();
        ImmutableList snapshots = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)snapshots);
        EasyMock.expect((Object)this.computeRpcMock.listSnapshots(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSnapshots(new Compute.SnapshotListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])snapshots.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Snapshot.class));
    }

    @Test
    public void testListSnapshotsWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList snapshotList = ImmutableList.of((Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)), (Object)new Snapshot(this.compute, new SnapshotInfo.BuilderImpl(SNAPSHOT)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)snapshotList, (Function)SnapshotInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listSnapshots(SNAPSHOT_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSnapshots(new Compute.SnapshotListOption[]{SNAPSHOT_LIST_PAGE_SIZE, SNAPSHOT_LIST_PAGE_TOKEN, SNAPSHOT_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])snapshotList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Snapshot.class));
    }

    @Test
    public void testCreateImage() {
        EasyMock.expect((Object)this.computeRpcMock.createImage(IMAGE.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(IMAGE, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testCreateImageWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createImage((com.google.api.services.compute.model.Image)EasyMock.eq((Object)IMAGE.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(IMAGE, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testGetImage() {
        EasyMock.expect((Object)this.computeRpcMock.getImage(IMAGE_ID.project(), IMAGE_ID.image(), EMPTY_RPC_OPTIONS)).andReturn((Object)IMAGE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Image image = this.compute.getImage(IMAGE_ID, new Compute.ImageOption[0]);
        Assert.assertEquals((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)), (Object)image);
    }

    @Test
    public void testGetImage_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getImage(IMAGE_ID.project(), IMAGE_ID.image(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getImage(IMAGE_ID, new Compute.ImageOption[0]));
    }

    @Test
    public void testGetImageWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getImage((String)EasyMock.eq((Object)IMAGE_ID.project()), (String)EasyMock.eq((Object)IMAGE_ID.image()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)IMAGE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Image image = this.compute.getImage(IMAGE_ID, new Compute.ImageOption[]{IMAGE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(IMAGE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains("sourceDisk"));
        Assert.assertTrue((boolean)selector.contains("rawDisk"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)42L, (long)selector.length());
        Assert.assertEquals((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)), (Object)image);
    }

    @Test
    public void testDeleteImage_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteImage(IMAGE_ID.project(), IMAGE_ID.image(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.globalOperation, (Object)this.compute.deleteImage(IMAGE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteImageWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteImage((String)EasyMock.eq((Object)PROJECT), (String)EasyMock.eq((Object)IMAGE_ID.image()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteImage(ImageId.of((String)"image"), new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testDeleteImage_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteImage(IMAGE_ID.project(), IMAGE_ID.image(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteImage(IMAGE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeprecateImage_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deprecateImage(IMAGE_ID.project(), IMAGE_ID.image(), DEPRECATION_STATUS.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.globalOperation, (Object)this.compute.deprecate(IMAGE_ID, DEPRECATION_STATUS, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeprecateImageWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deprecateImage((String)EasyMock.eq((Object)PROJECT), (String)EasyMock.eq((Object)IMAGE_ID.image()), (com.google.api.services.compute.model.DeprecationStatus)EasyMock.eq((Object)DEPRECATION_STATUS.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deprecate(ImageId.of((String)"image"), DEPRECATION_STATUS, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testDeprecateImage_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deprecateImage(IMAGE_ID.project(), IMAGE_ID.image(), DEPRECATION_STATUS.toPb(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deprecate(IMAGE_ID, DEPRECATION_STATUS, new Compute.OperationOption[0]));
    }

    @Test
    public void testListImages() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList imageList = ImmutableList.of((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)), (Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)imageList, (Function)ImageInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listImages(PROJECT, EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listImages(new Compute.ImageListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])imageList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
    }

    @Test
    public void testListImagesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList imageList = ImmutableList.of((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)), (Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)));
        ImmutableList nextImageList = ImmutableList.of((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)imageList, (Function)ImageInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextImageList, (Function)ImageInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listImages(PROJECT, EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listImages(PROJECT, (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listImages(new Compute.ImageListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])imageList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextImageList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
    }

    @Test
    public void testListImagesForProject() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList imageList = ImmutableList.of((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)), (Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)imageList, (Function)ImageInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listImages("otherProject", EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listImages("otherProject", new Compute.ImageListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])imageList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
    }

    @Test
    public void testListEmptyImages() {
        this.compute = (Compute)this.options.service();
        ImmutableList images = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)images);
        EasyMock.expect((Object)this.computeRpcMock.listImages(PROJECT, EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listImages(new Compute.ImageListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])images.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
    }

    @Test
    public void testListEmptyImagesForProject() {
        this.compute = (Compute)this.options.service();
        ImmutableList images = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)images);
        EasyMock.expect((Object)this.computeRpcMock.listImages("otherProject", EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listImages("otherProject", new Compute.ImageListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])images.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
    }

    @Test
    public void testListImagesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList imageList = ImmutableList.of((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)), (Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)imageList, (Function)ImageInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listImages(PROJECT, IMAGE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listImages(new Compute.ImageListOption[]{IMAGE_LIST_PAGE_SIZE, IMAGE_LIST_PAGE_TOKEN, IMAGE_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])imageList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
    }

    @Test
    public void testListImagesForProjectWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList imageList = ImmutableList.of((Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)), (Object)new Image(this.compute, new ImageInfo.BuilderImpl(IMAGE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)imageList, (Function)ImageInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listImages("other", IMAGE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listImages("other", new Compute.ImageListOption[]{IMAGE_LIST_PAGE_SIZE, IMAGE_LIST_PAGE_TOKEN, IMAGE_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])imageList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Image.class));
    }

    @Test
    public void testGetDisk() {
        EasyMock.expect((Object)this.computeRpcMock.getDisk(DISK_ID.zone(), DISK_ID.disk(), EMPTY_RPC_OPTIONS)).andReturn((Object)DISK.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Disk disk = this.compute.getDisk(DISK_ID, new Compute.DiskOption[0]);
        Assert.assertEquals((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)disk);
    }

    @Test
    public void testGetDisk_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getDisk(DISK_ID.zone(), DISK_ID.disk(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getDisk(DISK_ID, new Compute.DiskOption[0]));
    }

    @Test
    public void testGetDiskWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getDisk((String)EasyMock.eq((Object)DISK_ID.zone()), (String)EasyMock.eq((Object)DISK_ID.disk()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)DISK.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Disk disk = this.compute.getDisk(DISK_ID, new Compute.DiskOption[]{DISK_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(DISK_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("type"));
        Assert.assertTrue((boolean)selector.contains("sourceImage"));
        Assert.assertTrue((boolean)selector.contains("sourceSnapshot"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)55L, (long)selector.length());
        Assert.assertEquals((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)disk);
    }

    @Test
    public void testDeleteDisk_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteDisk(DISK_ID.zone(), DISK_ID.disk(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.deleteDisk(DISK_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteDiskWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteDisk((String)EasyMock.eq((Object)DISK_ID.zone()), (String)EasyMock.eq((Object)DISK_ID.disk()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteDisk(DISK_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testDeleteDisk_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteDisk(DISK_ID.zone(), DISK_ID.disk(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteDisk(DISK_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testListDisks() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskList, (Function)DiskInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDisks(DISK_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(DISK_ID.zone(), new Compute.DiskListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testListDisksNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ImmutableList nextDiskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskList, (Function)DiskInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextDiskList, (Function)DiskInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listDisks(DISK_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listDisks(DISK_ID.zone(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(DISK_ID.zone(), new Compute.DiskListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextDiskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testListEmptyDisks() {
        this.compute = (Compute)this.options.service();
        ImmutableList disks = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)disks);
        EasyMock.expect((Object)this.computeRpcMock.listDisks(DISK_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(DISK_ID.zone(), new Compute.DiskListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])disks.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testListDisksWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskList, (Function)DiskInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDisks(DISK_ID.zone(), DISK_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(DISK_ID.zone(), new Compute.DiskListOption[]{DISK_LIST_PAGE_SIZE, DISK_LIST_PAGE_TOKEN, DISK_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testAggregatedListDisks() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskList, (Function)DiskInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDisks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(new Compute.DiskAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testAggregatedListDisksNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ImmutableList nextDiskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskList, (Function)DiskInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextDiskList, (Function)DiskInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listDisks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listDisks((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(new Compute.DiskAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextDiskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testAggregatedListEmptyDisks() {
        this.compute = (Compute)this.options.service();
        ImmutableList diskList = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)diskList);
        EasyMock.expect((Object)this.computeRpcMock.listDisks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(new Compute.DiskAggregatedListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testAggregatedListDisksWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList diskList = ImmutableList.of((Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)), (Object)new Disk(this.compute, new DiskInfo.BuilderImpl(DISK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)diskList, (Function)DiskInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listDisks(DISK_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listDisks(new Compute.DiskAggregatedListOption[]{DISK_AGGREGATED_LIST_PAGE_SIZE, DISK_AGGREGATED_LIST_PAGE_TOKEN, DISK_AGGREGATED_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])diskList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Disk.class));
    }

    @Test
    public void testCreateDisk() {
        EasyMock.expect((Object)this.computeRpcMock.createDisk(DISK_ID.zone(), DISK.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        DiskId diskId = DiskId.of((String)"zone", (String)"disk");
        DiskTypeId diskTypeId = DiskTypeId.of((String)"zone", (String)"diskType");
        DiskInfo disk = DISK.toBuilder().diskId(diskId).configuration((DiskConfiguration)StandardDiskConfiguration.of((DiskTypeId)diskTypeId)).build();
        Operation operation = this.compute.create(disk, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testCreateDiskWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createDisk((String)EasyMock.eq((Object)DISK_ID.zone()), (com.google.api.services.compute.model.Disk)EasyMock.eq((Object)DISK.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(DISK, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testResizeDisk_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.resizeDisk(DISK_ID.zone(), DISK_ID.disk(), 42L, EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.resize(DISK_ID, 42L, new Compute.OperationOption[0]));
    }

    @Test
    public void testResizeDiskWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.resizeDisk((String)EasyMock.eq((Object)DISK_ID.zone()), (String)EasyMock.eq((Object)DISK_ID.disk()), EasyMock.eq((long)42L), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.resize(DISK_ID, 42L, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testResizeDisk_Null() {
        EasyMock.expect((Object)this.computeRpcMock.resizeDisk(DISK_ID.zone(), DISK_ID.disk(), 42L, EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.resize(DISK_ID, 42L, new Compute.OperationOption[0]));
    }

    @Test
    public void testGetSubnetwork() {
        EasyMock.expect((Object)this.computeRpcMock.getSubnetwork(SUBNETWORK_ID.region(), SUBNETWORK_ID.subnetwork(), EMPTY_RPC_OPTIONS)).andReturn((Object)SUBNETWORK.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Subnetwork subnetwork = this.compute.getSubnetwork(SUBNETWORK_ID, new Compute.SubnetworkOption[0]);
        Assert.assertEquals((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)subnetwork);
    }

    @Test
    public void testGetSubnetwork_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getSubnetwork(SUBNETWORK_ID.region(), SUBNETWORK_ID.subnetwork(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getSubnetwork(SUBNETWORK_ID, new Compute.SubnetworkOption[0]));
    }

    @Test
    public void testGetSubnetworkWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getSubnetwork((String)EasyMock.eq((Object)SUBNETWORK_ID.region()), (String)EasyMock.eq((Object)SUBNETWORK_ID.subnetwork()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)SUBNETWORK.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Subnetwork subnetwork = this.compute.getSubnetwork(SUBNETWORK_ID, new Compute.SubnetworkOption[]{SUBNETWORK_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(SUBNETWORK_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)subnetwork);
    }

    @Test
    public void testDeleteSubnetwork_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteSubnetwork(SUBNETWORK_ID.region(), SUBNETWORK_ID.subnetwork(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.regionOperation, (Object)this.compute.deleteSubnetwork(SUBNETWORK_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteSubnetworkWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteSubnetwork((String)EasyMock.eq((Object)SUBNETWORK_ID.region()), (String)EasyMock.eq((Object)SUBNETWORK_ID.subnetwork()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteSubnetwork(SUBNETWORK_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testDeleteSubnetwork_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteSubnetwork(SUBNETWORK_ID.region(), SUBNETWORK_ID.subnetwork(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteSubnetwork(SUBNETWORK_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testListSubnetworks() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)subnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(SUBNETWORK_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(SUBNETWORK_ID.region(), new Compute.SubnetworkListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testListSubnetworksNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ImmutableList nextSubnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)subnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextSubnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(SUBNETWORK_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(SUBNETWORK_ID.region(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(SUBNETWORK_ID.region(), new Compute.SubnetworkListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextSubnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testListEmptySubnetworks() {
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworks = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)subnetworks);
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(SUBNETWORK_ID.region(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(SUBNETWORK_ID.region(), new Compute.SubnetworkListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworks.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testListSubnetworksWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)subnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(SUBNETWORK_ID.region(), SUBNETWORK_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(SUBNETWORK_ID.region(), new Compute.SubnetworkListOption[]{SUBNETWORK_LIST_PAGE_SIZE, SUBNETWORK_LIST_PAGE_TOKEN, SUBNETWORK_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testAggregatedListSubnetworks() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)subnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(new Compute.SubnetworkAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testAggregatedListSubnetworksNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ImmutableList nextSubnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)subnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextSubnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(new Compute.SubnetworkAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextSubnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testAggregatedListEmptySubnetworks() {
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworks = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)subnetworks);
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(new Compute.SubnetworkAggregatedListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworks.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testAggregatedListSubnetworksWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList subnetworkList = ImmutableList.of((Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)), (Object)new Subnetwork(this.compute, new SubnetworkInfo.BuilderImpl(SUBNETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)subnetworkList, (Function)SubnetworkInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listSubnetworks(SUBNETWORK_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listSubnetworks(new Compute.SubnetworkAggregatedListOption[]{SUBNETWORK_AGGREGATED_LIST_PAGE_SIZE, SUBNETWORK_AGGREGATED_LIST_PAGE_TOKEN, SUBNETWORK_AGGREGATED_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])subnetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Subnetwork.class));
    }

    @Test
    public void testCreateSubnetwork() {
        EasyMock.expect((Object)this.computeRpcMock.createSubnetwork(SUBNETWORK_ID.region(), SUBNETWORK.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        SubnetworkId subnetworkId = SubnetworkId.of((String)"region", (String)"network");
        NetworkId networkId = NetworkId.of((String)"network");
        SubnetworkInfo subnetwork = SubnetworkInfo.of((SubnetworkId)subnetworkId, (NetworkId)networkId, (String)"192.168.0.0/16");
        Operation operation = this.compute.create(subnetwork, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testCreateSubnetworkWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createSubnetwork((String)EasyMock.eq((Object)SUBNETWORK_ID.region()), (com.google.api.services.compute.model.Subnetwork)EasyMock.eq((Object)SUBNETWORK.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.regionOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(SUBNETWORK, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.regionOperation, (Object)operation);
    }

    @Test
    public void testGetNetwork() {
        EasyMock.expect((Object)this.computeRpcMock.getNetwork(NETWORK_ID.network(), EMPTY_RPC_OPTIONS)).andReturn((Object)NETWORK.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Network network = this.compute.getNetwork(NETWORK_ID.network(), new Compute.NetworkOption[0]);
        Assert.assertEquals((Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)), (Object)network);
    }

    @Test
    public void testGetNetwork_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getNetwork(NETWORK_ID.network(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getNetwork(NETWORK_ID.network(), new Compute.NetworkOption[0]));
    }

    @Test
    public void testGetNetworkWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getNetwork((String)EasyMock.eq((Object)NETWORK_ID.network()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)NETWORK.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Network network = this.compute.getNetwork(NETWORK_ID.network(), new Compute.NetworkOption[]{NETWORK_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(NETWORK_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertTrue((boolean)selector.contains("IPv4Range"));
        Assert.assertTrue((boolean)selector.contains("autoCreateSubnetworks"));
        Assert.assertEquals((long)55L, (long)selector.length());
        Assert.assertEquals((Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)), (Object)network);
    }

    @Test
    public void testDeleteNetwork_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteNetwork(NETWORK_ID.network(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.globalOperation, (Object)this.compute.deleteNetwork(NETWORK_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteNetworkWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteNetwork((String)EasyMock.eq((Object)NETWORK_ID.network()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteNetwork(NETWORK_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testDeleteNetwork_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteNetwork(NETWORK_ID.network(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteNetwork(NETWORK_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testListNetworks() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList networkList = ImmutableList.of((Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)), (Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)networkList, (Function)NetworkInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listNetworks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listNetworks(new Compute.NetworkListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])networkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Network.class));
    }

    @Test
    public void testListNetworksNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList networkList = ImmutableList.of((Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)), (Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)));
        ImmutableList nextNetworkList = ImmutableList.of((Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)networkList, (Function)NetworkInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextNetworkList, (Function)NetworkInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listNetworks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listNetworks((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listNetworks(new Compute.NetworkListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])networkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Network.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextNetworkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Network.class));
    }

    @Test
    public void testListEmptyNetworks() {
        this.compute = (Compute)this.options.service();
        ImmutableList networks = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)networks);
        EasyMock.expect((Object)this.computeRpcMock.listNetworks(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listNetworks(new Compute.NetworkListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])networks.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Network.class));
    }

    @Test
    public void testListNetworksWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList networkList = ImmutableList.of((Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)), (Object)new Network(this.compute, new NetworkInfo.BuilderImpl(NETWORK)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)networkList, (Function)NetworkInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listNetworks(NETWORK_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listNetworks(new Compute.NetworkListOption[]{NETWORK_LIST_PAGE_SIZE, NETWORK_LIST_PAGE_TOKEN, NETWORK_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])networkList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Network.class));
    }

    @Test
    public void testCreateNetwork() {
        EasyMock.expect((Object)this.computeRpcMock.createNetwork(NETWORK.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        NetworkInfo network = NetworkInfo.of((NetworkId)NetworkId.of((String)"network"), (NetworkConfiguration)StandardNetworkConfiguration.of((String)"192.168.0.0/16"));
        Operation operation = this.compute.create(network, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testCreateNetworkWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createNetwork((com.google.api.services.compute.model.Network)EasyMock.eq((Object)NETWORK.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.globalOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(NETWORK, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.globalOperation, (Object)operation);
    }

    @Test
    public void testGetInstance() {
        EasyMock.expect((Object)this.computeRpcMock.getInstance(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn((Object)INSTANCE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Instance instance = this.compute.getInstance(INSTANCE_ID, new Compute.InstanceOption[0]);
        Assert.assertEquals((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)instance);
    }

    @Test
    public void testGetInstance_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getInstance(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getInstance(INSTANCE_ID, new Compute.InstanceOption[0]));
    }

    @Test
    public void testGetInstanceWithSelectedFields() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.getInstance((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)INSTANCE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Instance instance = this.compute.getInstance(INSTANCE_ID, new Compute.InstanceOption[]{INSTANCE_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(INSTANCE_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)instance);
    }

    @Test
    public void testDeleteInstance_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteInstance(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.deleteInstance(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteInstanceWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteInstance((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteInstance(INSTANCE_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testDeleteInstance_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteInstance(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteInstance(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testListInstances() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList instanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)instanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listInstances(INSTANCE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(INSTANCE_ID.zone(), new Compute.InstanceListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testListInstancesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList instanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ImmutableList nextInstanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)instanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextInstanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listInstances(INSTANCE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listInstances(INSTANCE_ID.zone(), (Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(INSTANCE_ID.zone(), new Compute.InstanceListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextInstanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testListEmptyInstances() {
        this.compute = (Compute)this.options.service();
        ImmutableList instances = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)instances);
        EasyMock.expect((Object)this.computeRpcMock.listInstances(INSTANCE_ID.zone(), EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(INSTANCE_ID.zone(), new Compute.InstanceListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instances.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testListInstancesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList instanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)instanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listInstances(INSTANCE_ID.zone(), INSTANCE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(INSTANCE_ID.zone(), new Compute.InstanceListOption[]{INSTANCE_LIST_PAGE_SIZE, INSTANCE_LIST_PAGE_TOKEN, INSTANCE_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testAggregatedListInstances() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList instanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)instanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listInstances(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(new Compute.InstanceAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testAggregatedListInstancesNextPage() {
        String cursor = "cursor";
        String nextCursor = "nextCursor";
        this.compute = (Compute)this.options.service();
        ImmutableList instanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ImmutableList nextInstanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)instanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        ComputeRpc.Tuple nextResult = ComputeRpc.Tuple.of((Object)nextCursor, (Object)Iterables.transform((Iterable)nextInstanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        ImmutableMap nextOptions = ImmutableMap.of((Object)ComputeRpc.Option.PAGE_TOKEN, (Object)cursor);
        EasyMock.expect((Object)this.computeRpcMock.listInstances(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.expect((Object)this.computeRpcMock.listInstances((Map)nextOptions)).andReturn((Object)nextResult);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(new Compute.InstanceAggregatedListOption[0]);
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
        page = page.nextPage();
        Assert.assertEquals((Object)nextCursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])nextInstanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testAggregatedListEmptyInstances() {
        this.compute = (Compute)this.options.service();
        ImmutableList instanceList = ImmutableList.of();
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of(null, (Object)instanceList);
        EasyMock.expect((Object)this.computeRpcMock.listInstances(EMPTY_RPC_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(new Compute.InstanceAggregatedListOption[0]);
        Assert.assertNull((Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testAggregatedListInstancesWithOptions() {
        String cursor = "cursor";
        this.compute = (Compute)this.options.service();
        ImmutableList instanceList = ImmutableList.of((Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)), (Object)new Instance(this.compute, new InstanceInfo.BuilderImpl(INSTANCE)));
        ComputeRpc.Tuple result = ComputeRpc.Tuple.of((Object)cursor, (Object)Iterables.transform((Iterable)instanceList, (Function)InstanceInfo.TO_PB_FUNCTION));
        EasyMock.expect((Object)this.computeRpcMock.listInstances(INSTANCE_LIST_OPTIONS)).andReturn((Object)result);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        Page page = this.compute.listInstances(new Compute.InstanceAggregatedListOption[]{INSTANCE_AGGREGATED_LIST_PAGE_SIZE, INSTANCE_AGGREGATED_LIST_PAGE_TOKEN, INSTANCE_AGGREGATED_LIST_FILTER});
        Assert.assertEquals((Object)cursor, (Object)page.nextPageCursor());
        Assert.assertArrayEquals((Object[])instanceList.toArray(), (Object[])Iterables.toArray((Iterable)page.values(), Instance.class));
    }

    @Test
    public void testCreateInstance() {
        EasyMock.expect((Object)this.computeRpcMock.createInstance(INSTANCE_ID.zone(), INSTANCE.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        InstanceInfo instance = InstanceInfo.of((InstanceId)InstanceId.of((String)"zone", (String)"instance"), (MachineTypeId)MachineTypeId.of((String)"zone", (String)"type"), (AttachedDisk)ATTACHED_DISK, (NetworkInterface)NetworkInterface.of((NetworkId)NetworkId.of((String)"network")));
        Operation operation = this.compute.create(instance, new Compute.OperationOption[0]);
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testCreateInstanceWithOptions() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.createInstance((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (com.google.api.services.compute.model.Instance)EasyMock.eq((Object)INSTANCE.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.create(INSTANCE, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testAddAccessConfig_Operation() {
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of((String)"192.168.1.1");
        EasyMock.expect((Object)this.computeRpcMock.addAccessConfig(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "networkInterface", accessConfig.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.addAccessConfig(INSTANCE_ID, "networkInterface", accessConfig, new Compute.OperationOption[0]));
    }

    @Test
    public void testAddAccessConfigWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of((String)"192.168.1.1");
        EasyMock.expect((Object)this.computeRpcMock.addAccessConfig((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (String)EasyMock.eq((Object)"networkInterface"), (AccessConfig)EasyMock.eq((Object)accessConfig.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.addAccessConfig(INSTANCE_ID, "networkInterface", accessConfig, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testAddAccessConfig_Null() {
        NetworkInterface.AccessConfig accessConfig = NetworkInterface.AccessConfig.of((String)"192.168.1.1");
        EasyMock.expect((Object)this.computeRpcMock.addAccessConfig(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "networkInterface", accessConfig.toPb(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.addAccessConfig(INSTANCE_ID, "networkInterface", accessConfig, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDisk_Operation() {
        AttachedDisk attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        EasyMock.expect((Object)this.computeRpcMock.attachDisk(INSTANCE_ID.zone(), INSTANCE_ID.instance(), attachedDisk.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.attachDisk(INSTANCE_ID, PERSISTENT_DISK_CONFIGURATION, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskWithSelectedFields_Operation() {
        AttachedDisk attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.attachDisk((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (com.google.api.services.compute.model.AttachedDisk)EasyMock.eq((Object)attachedDisk.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.attachDisk(INSTANCE_ID, PERSISTENT_DISK_CONFIGURATION, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testAttachDisk_Null() {
        AttachedDisk attachedDisk = AttachedDisk.of((AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        EasyMock.expect((Object)this.computeRpcMock.attachDisk(INSTANCE_ID.zone(), INSTANCE_ID.instance(), attachedDisk.toPb(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.attachDisk(INSTANCE_ID, PERSISTENT_DISK_CONFIGURATION, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskName_Operation() {
        AttachedDisk attachedDisk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        EasyMock.expect((Object)this.computeRpcMock.attachDisk(INSTANCE_ID.zone(), INSTANCE_ID.instance(), attachedDisk.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.attachDisk(INSTANCE_ID, "dev0", PERSISTENT_DISK_CONFIGURATION, new Compute.OperationOption[0]));
    }

    @Test
    public void testAttachDiskNameWithSelectedFields_Operation() {
        AttachedDisk attachedDisk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.attachDisk((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (com.google.api.services.compute.model.AttachedDisk)EasyMock.eq((Object)attachedDisk.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.attachDisk(INSTANCE_ID, "dev0", PERSISTENT_DISK_CONFIGURATION, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testAttachDiskName_Null() {
        AttachedDisk attachedDisk = AttachedDisk.of((String)"dev0", (AttachedDisk.AttachedDiskConfiguration)PERSISTENT_DISK_CONFIGURATION);
        EasyMock.expect((Object)this.computeRpcMock.attachDisk(INSTANCE_ID.zone(), INSTANCE_ID.instance(), attachedDisk.toPb(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.attachDisk(INSTANCE_ID, "dev0", PERSISTENT_DISK_CONFIGURATION, new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteAccessConfig_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.deleteAccessConfig(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "networkInterface", "accessConfig", EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.deleteAccessConfig(INSTANCE_ID, "networkInterface", "accessConfig", new Compute.OperationOption[0]));
    }

    @Test
    public void testDeleteAccessConfigWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.deleteAccessConfig((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (String)EasyMock.eq((Object)"networkInterface"), (String)EasyMock.eq((Object)"accessConfig"), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.deleteAccessConfig(INSTANCE_ID, "networkInterface", "accessConfig", new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testDeleteAccessConfig_Null() {
        EasyMock.expect((Object)this.computeRpcMock.deleteAccessConfig(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "networkInterface", "accessConfig", EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.deleteAccessConfig(INSTANCE_ID, "networkInterface", "accessConfig", new Compute.OperationOption[0]));
    }

    @Test
    public void testDetachDisk_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.detachDisk(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "device", EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.detachDisk(INSTANCE_ID, "device", new Compute.OperationOption[0]));
    }

    @Test
    public void testDetachDiskWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.detachDisk((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (String)EasyMock.eq((Object)"device"), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.detachDisk(INSTANCE_ID, "device", new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testDetachDisk_Null() {
        EasyMock.expect((Object)this.computeRpcMock.detachDisk(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "device", EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.detachDisk(INSTANCE_ID, "device", new Compute.OperationOption[0]));
    }

    @Test
    public void testSerialPortOutputFromPort() {
        String output = "output";
        EasyMock.expect((Object)this.computeRpcMock.getSerialPortOutput(INSTANCE_ID.zone(), INSTANCE_ID.instance(), Integer.valueOf(2), EMPTY_RPC_OPTIONS)).andReturn((Object)output);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)output, (Object)this.compute.getSerialPortOutput(INSTANCE_ID, 2));
    }

    @Test
    public void testSerialPortOutputDefault() {
        String output = "output";
        EasyMock.expect((Object)this.computeRpcMock.getSerialPortOutput(INSTANCE_ID.zone(), INSTANCE_ID.instance(), null, EMPTY_RPC_OPTIONS)).andReturn((Object)output);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)output, (Object)this.compute.getSerialPortOutput(INSTANCE_ID));
    }

    @Test
    public void testSerialPortOutputFromPort_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getSerialPortOutput(INSTANCE_ID.zone(), INSTANCE_ID.instance(), Integer.valueOf(2), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getSerialPortOutput(INSTANCE_ID, 2));
    }

    @Test
    public void testSerialPortOutputDefault_Null() {
        EasyMock.expect((Object)this.computeRpcMock.getSerialPortOutput(INSTANCE_ID.zone(), INSTANCE_ID.instance(), null, EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.getSerialPortOutput(INSTANCE_ID));
    }

    @Test
    public void testResetInstance_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.reset(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.reset(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testResetInstanceWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.reset((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.reset(INSTANCE_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testResetInstance_Null() {
        EasyMock.expect((Object)this.computeRpcMock.reset(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.reset(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetDiskAutodelete_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.setDiskAutoDelete(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "device", true, EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.setDiskAutoDelete(INSTANCE_ID, "device", true, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetDiskAutodeleteWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.setDiskAutoDelete((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (String)EasyMock.eq((Object)"device"), EasyMock.eq((boolean)true), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.setDiskAutoDelete(INSTANCE_ID, "device", true, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testSetDiskAutodelete_Null() {
        EasyMock.expect((Object)this.computeRpcMock.setDiskAutoDelete(INSTANCE_ID.zone(), INSTANCE_ID.instance(), "device", false, EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.setDiskAutoDelete(INSTANCE_ID, "device", false, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMachineType_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.setMachineType(INSTANCE_ID.zone(), INSTANCE_ID.instance(), MACHINE_TYPE_ID.selfLink(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.setMachineType(INSTANCE_ID, MachineTypeId.of((String)"zone", (String)"type"), new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMachineTypeWithOptions_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.setMachineType((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (String)EasyMock.eq((Object)MACHINE_TYPE_ID.selfLink()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.setMachineType(INSTANCE_ID, MachineTypeId.of((String)"zone", (String)"type"), new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testSetMachineType_Null() {
        EasyMock.expect((Object)this.computeRpcMock.setMachineType(INSTANCE_ID.zone(), INSTANCE_ID.instance(), MACHINE_TYPE_ID.selfLink(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.setMachineType(INSTANCE_ID, MachineTypeId.of((String)"zone", (String)"type"), new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMetadata_Operation() {
        Metadata metadata = Metadata.builder().add("key", "value").fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.computeRpcMock.setMetadata(INSTANCE_ID.zone(), INSTANCE_ID.instance(), metadata.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetMetadataWithOptions_Operation() {
        Capture capturedOptions = Capture.newInstance();
        Metadata metadata = Metadata.builder().add("key", "value").fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.computeRpcMock.setMetadata((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (com.google.api.services.compute.model.Metadata)EasyMock.eq((Object)metadata.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testSetMetadata_Null() {
        Metadata metadata = Metadata.builder().add("key", "value").fingerprint("fingerprint").build();
        EasyMock.expect((Object)this.computeRpcMock.setMetadata(INSTANCE_ID.zone(), INSTANCE_ID.instance(), metadata.toPb(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.setMetadata(INSTANCE_ID, metadata, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetSchedulingOptions_Operation() {
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        EasyMock.expect((Object)this.computeRpcMock.setScheduling(INSTANCE_ID.zone(), INSTANCE_ID.instance(), schedulingOptions.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.setSchedulingOptions(INSTANCE_ID, schedulingOptions, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetSchedulingOptionsWithOptions_Operation() {
        Capture capturedOptions = Capture.newInstance();
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        EasyMock.expect((Object)this.computeRpcMock.setScheduling((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (Scheduling)EasyMock.eq((Object)schedulingOptions.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.setSchedulingOptions(INSTANCE_ID, schedulingOptions, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testSetSchedulingOptions_Null() {
        SchedulingOptions schedulingOptions = SchedulingOptions.standard((boolean)true, (SchedulingOptions.Maintenance)SchedulingOptions.Maintenance.MIGRATE);
        EasyMock.expect((Object)this.computeRpcMock.setScheduling(INSTANCE_ID.zone(), INSTANCE_ID.instance(), schedulingOptions.toPb(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.setSchedulingOptions(INSTANCE_ID, schedulingOptions, new Compute.OperationOption[0]));
    }

    @Test
    public void testTags_Operation() {
        Tags tags = Tags.of((String[])new String[]{"tag1", "tag2"});
        EasyMock.expect((Object)this.computeRpcMock.setTags(INSTANCE_ID.zone(), INSTANCE_ID.instance(), tags.toPb(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[0]));
    }

    @Test
    public void testSetTagsWithOptions_Operation() {
        Tags tags = Tags.of((String[])new String[]{"tag1", "tag2"});
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.setTags((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (com.google.api.services.compute.model.Tags)EasyMock.eq((Object)tags.toPb()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testSetTags_Null() {
        Tags tags = Tags.of((String[])new String[]{"tag1", "tag2"});
        EasyMock.expect((Object)this.computeRpcMock.setTags(INSTANCE_ID.zone(), INSTANCE_ID.instance(), tags.toPb(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.setTags(INSTANCE_ID, tags, new Compute.OperationOption[0]));
    }

    @Test
    public void testStartInstance_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.start(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.start(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testStartInstanceWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.start((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.start(INSTANCE_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testStartInstance_Null() {
        EasyMock.expect((Object)this.computeRpcMock.start(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.start(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testStopInstance_Operation() {
        EasyMock.expect((Object)this.computeRpcMock.stop(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertEquals((Object)this.zoneOperation, (Object)this.compute.stop(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testStopInstanceWithSelectedFields_Operation() {
        Capture capturedOptions = Capture.newInstance();
        EasyMock.expect((Object)this.computeRpcMock.stop((String)EasyMock.eq((Object)INSTANCE_ID.zone()), (String)EasyMock.eq((Object)INSTANCE_ID.instance()), (Map)EasyMock.capture((Capture)capturedOptions))).andReturn((Object)this.zoneOperation.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Operation operation = this.compute.stop(INSTANCE_ID, new Compute.OperationOption[]{OPERATION_OPTION_FIELDS});
        String selector = (String)((Map)capturedOptions.getValue()).get(OPERATION_OPTION_FIELDS.rpcOption());
        Assert.assertTrue((boolean)selector.contains("selfLink"));
        Assert.assertTrue((boolean)selector.contains("id"));
        Assert.assertTrue((boolean)selector.contains(DESCRIPTION));
        Assert.assertEquals((long)23L, (long)selector.length());
        Assert.assertEquals((Object)this.zoneOperation, (Object)operation);
    }

    @Test
    public void testStopInstance_Null() {
        EasyMock.expect((Object)this.computeRpcMock.stop(INSTANCE_ID.zone(), INSTANCE_ID.instance(), EMPTY_RPC_OPTIONS)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)this.options.service();
        Assert.assertNull((Object)this.compute.stop(INSTANCE_ID, new Compute.OperationOption[0]));
    }

    @Test
    public void testRetryableException() {
        EasyMock.expect((Object)this.computeRpcMock.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andThrow((Throwable)new ComputeException(500, "InternalError")).andReturn((Object)DISK_TYPE.toPb());
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)((ComputeOptions.Builder)this.options.toBuilder().retryParams(RetryParams.defaultInstance())).build().service();
        DiskType diskType = this.compute.getDiskType(DISK_TYPE_ID, new Compute.DiskTypeOption[0]);
        Assert.assertEquals((Object)DISK_TYPE, (Object)diskType);
    }

    @Test
    public void testNonRetryableException() {
        String exceptionMessage = "Not Implemented";
        EasyMock.expect((Object)this.computeRpcMock.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andThrow((Throwable)new ComputeException(501, exceptionMessage));
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)((ComputeOptions.Builder)this.options.toBuilder().retryParams(RetryParams.defaultInstance())).build().service();
        this.thrown.expect(ComputeException.class);
        this.thrown.expectMessage(exceptionMessage);
        this.compute.getDiskType(DISK_TYPE_ID, new Compute.DiskTypeOption[0]);
    }

    @Test
    public void testRuntimeException() {
        String exceptionMessage = "Artificial runtime exception";
        EasyMock.expect((Object)this.computeRpcMock.getDiskType(DISK_TYPE_ID.zone(), DISK_TYPE_ID.type(), EMPTY_RPC_OPTIONS)).andThrow((Throwable)new RuntimeException(exceptionMessage));
        EasyMock.replay((Object[])new Object[]{this.computeRpcMock});
        this.compute = (Compute)((ComputeOptions.Builder)this.options.toBuilder().retryParams(RetryParams.defaultInstance())).build().service();
        this.thrown.expect(ComputeException.class);
        this.thrown.expectMessage(exceptionMessage);
        this.compute.getDiskType(DISK_TYPE_ID, new Compute.DiskTypeOption[0]);
    }
}

