/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DeprecationStatus;
import com.google.cloud.compute.DiskTypeId;
import com.google.cloud.compute.MachineTypeId;
import com.google.cloud.compute.ResourceId;
import com.google.common.base.Function;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.junit.Assert;
import org.junit.Test;

public class DeprecationStatusTest {
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = ISODateTimeFormat.dateTime();
    private static final Long DELETED_MILLIS = 1453293540000L;
    private static final Long DEPRECATED_MILLIS = 1453293420000L;
    private static final Long OBSOLETE_MILLIS = 1453293480000L;
    private static final String DELETED = TIMESTAMP_FORMATTER.print(DELETED_MILLIS.longValue());
    private static final String DEPRECATED = TIMESTAMP_FORMATTER.print(DEPRECATED_MILLIS.longValue());
    private static final String OBSOLETE = TIMESTAMP_FORMATTER.print(OBSOLETE_MILLIS.longValue());
    private static final DiskTypeId DISK_TYPE_ID = DiskTypeId.of((String)"project", (String)"zone", (String)"diskType");
    private static final MachineTypeId MACHINE_TYPE_ID = MachineTypeId.of((String)"project", (String)"zone", (String)"machineType");
    private static final DeprecationStatus.Status STATUS = DeprecationStatus.Status.DELETED;
    private static final DeprecationStatus<DiskTypeId> DISK_TYPE_STATUS = DeprecationStatus.builder((DeprecationStatus.Status)STATUS).replacement((ResourceId)DISK_TYPE_ID).deprecated(DEPRECATED).obsolete(OBSOLETE).deleted(DELETED).build();
    private static final DeprecationStatus<DiskTypeId> DISK_TYPE_STATUS_MILLIS = DeprecationStatus.builder((DeprecationStatus.Status)STATUS).replacement((ResourceId)DISK_TYPE_ID).deprecated(DEPRECATED_MILLIS.longValue()).obsolete(OBSOLETE_MILLIS.longValue()).deleted(DELETED_MILLIS.longValue()).build();
    private static final DeprecationStatus<MachineTypeId> MACHINE_TYPE_STATUS = DeprecationStatus.builder((DeprecationStatus.Status)STATUS, (ResourceId)MACHINE_TYPE_ID).deprecated(DEPRECATED).obsolete(OBSOLETE).deleted(DELETED).build();

    @Test
    public void testBuilder() {
        this.compareDeprecationStatus(DISK_TYPE_STATUS, DISK_TYPE_STATUS_MILLIS);
        Assert.assertEquals((Object)DELETED, (Object)DISK_TYPE_STATUS.deleted());
        Assert.assertEquals((Object)DEPRECATED, (Object)DISK_TYPE_STATUS.deprecated());
        Assert.assertEquals((Object)OBSOLETE, (Object)DISK_TYPE_STATUS.obsolete());
        Assert.assertEquals((Object)DISK_TYPE_ID, (Object)DISK_TYPE_STATUS.replacement());
        Assert.assertEquals((Object)DEPRECATED_MILLIS, (Object)DISK_TYPE_STATUS.deprecatedMillis());
        Assert.assertEquals((Object)DELETED_MILLIS, (Object)DISK_TYPE_STATUS.deletedMillis());
        Assert.assertEquals((Object)OBSOLETE_MILLIS, (Object)DISK_TYPE_STATUS.obsoleteMillis());
        Assert.assertEquals((Object)STATUS, (Object)DISK_TYPE_STATUS.status());
        Assert.assertEquals((Object)DELETED, (Object)DISK_TYPE_STATUS_MILLIS.deleted());
        Assert.assertEquals((Object)DEPRECATED, (Object)DISK_TYPE_STATUS_MILLIS.deprecated());
        Assert.assertEquals((Object)OBSOLETE, (Object)DISK_TYPE_STATUS_MILLIS.obsolete());
        Assert.assertEquals((Object)DISK_TYPE_ID, (Object)DISK_TYPE_STATUS_MILLIS.replacement());
        Assert.assertEquals((Object)DEPRECATED_MILLIS, (Object)DISK_TYPE_STATUS_MILLIS.deprecatedMillis());
        Assert.assertEquals((Object)DELETED_MILLIS, (Object)DISK_TYPE_STATUS_MILLIS.deletedMillis());
        Assert.assertEquals((Object)OBSOLETE_MILLIS, (Object)DISK_TYPE_STATUS_MILLIS.obsoleteMillis());
        Assert.assertEquals((Object)STATUS, (Object)DISK_TYPE_STATUS.status());
        Assert.assertEquals((Object)DELETED, (Object)MACHINE_TYPE_STATUS.deleted());
        Assert.assertEquals((Object)DEPRECATED, (Object)MACHINE_TYPE_STATUS.deprecated());
        Assert.assertEquals((Object)OBSOLETE, (Object)MACHINE_TYPE_STATUS.obsolete());
        Assert.assertEquals((Object)DEPRECATED_MILLIS, (Object)MACHINE_TYPE_STATUS.deprecatedMillis());
        Assert.assertEquals((Object)DELETED_MILLIS, (Object)MACHINE_TYPE_STATUS.deletedMillis());
        Assert.assertEquals((Object)OBSOLETE_MILLIS, (Object)MACHINE_TYPE_STATUS.obsoleteMillis());
        Assert.assertEquals((Object)MACHINE_TYPE_ID, (Object)MACHINE_TYPE_STATUS.replacement());
        Assert.assertEquals((Object)STATUS, (Object)MACHINE_TYPE_STATUS.status());
    }

    @Test
    public void testGettersIllegalArgument() {
        DeprecationStatus deprecationStatus = DeprecationStatus.builder((DeprecationStatus.Status)STATUS, (ResourceId)MACHINE_TYPE_ID).deprecated("deprecated").obsolete("obsolete").deleted("delete").build();
        Assert.assertEquals((Object)"deprecated", (Object)deprecationStatus.deprecated());
        try {
            deprecationStatus.deprecatedMillis();
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        Assert.assertEquals((Object)"obsolete", (Object)deprecationStatus.obsolete());
        try {
            deprecationStatus.obsoleteMillis();
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
        Assert.assertEquals((Object)"delete", (Object)deprecationStatus.deleted());
        try {
            deprecationStatus.deletedMillis();
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testToBuilder() {
        this.compareDeprecationStatus(DISK_TYPE_STATUS, DISK_TYPE_STATUS.toBuilder().build());
        this.compareDeprecationStatus(MACHINE_TYPE_STATUS, MACHINE_TYPE_STATUS.toBuilder().build());
        DeprecationStatus deprecationStatus = DISK_TYPE_STATUS.toBuilder().deleted(DEPRECATED).build();
        Assert.assertEquals((Object)DEPRECATED, (Object)deprecationStatus.deleted());
        deprecationStatus = deprecationStatus.toBuilder().deleted(DELETED).build();
        this.compareDeprecationStatus(DISK_TYPE_STATUS, deprecationStatus);
    }

    @Test
    public void testToBuilderIncomplete() {
        DeprecationStatus diskStatus = DeprecationStatus.of((DeprecationStatus.Status)STATUS, (ResourceId)DISK_TYPE_ID);
        Assert.assertEquals((Object)diskStatus, (Object)diskStatus.toBuilder().build());
    }

    @Test
    public void testOf() {
        DeprecationStatus diskStatus = DeprecationStatus.of((DeprecationStatus.Status)STATUS, (ResourceId)DISK_TYPE_ID);
        Assert.assertNull((Object)diskStatus.deleted());
        Assert.assertNull((Object)diskStatus.deprecated());
        Assert.assertNull((Object)diskStatus.obsolete());
        Assert.assertEquals((Object)DISK_TYPE_ID, (Object)diskStatus.replacement());
        Assert.assertEquals((Object)STATUS, (Object)diskStatus.status());
    }

    @Test
    public void testToAndFromPb() {
        DeprecationStatus diskStatus = DeprecationStatus.fromPb((com.google.api.services.compute.model.DeprecationStatus)DISK_TYPE_STATUS.toPb(), (Function)DiskTypeId.FROM_URL_FUNCTION);
        this.compareDeprecationStatus(DISK_TYPE_STATUS, diskStatus);
        DeprecationStatus machineStatus = DeprecationStatus.fromPb((com.google.api.services.compute.model.DeprecationStatus)MACHINE_TYPE_STATUS.toPb(), (Function)MachineTypeId.FROM_URL_FUNCTION);
        this.compareDeprecationStatus(MACHINE_TYPE_STATUS, machineStatus);
        diskStatus = DeprecationStatus.builder((DeprecationStatus.Status)STATUS, (ResourceId)DISK_TYPE_ID).deprecated(DEPRECATED).build();
        Assert.assertEquals((Object)diskStatus, (Object)DeprecationStatus.fromPb((com.google.api.services.compute.model.DeprecationStatus)diskStatus.toPb(), (Function)DiskTypeId.FROM_URL_FUNCTION));
        machineStatus = DeprecationStatus.builder((DeprecationStatus.Status)STATUS, (ResourceId)MACHINE_TYPE_ID).deprecated(DEPRECATED).build();
        Assert.assertEquals((Object)machineStatus, (Object)DeprecationStatus.fromPb((com.google.api.services.compute.model.DeprecationStatus)machineStatus.toPb(), (Function)MachineTypeId.FROM_URL_FUNCTION));
        diskStatus = DeprecationStatus.of((DeprecationStatus.Status)STATUS, (ResourceId)DISK_TYPE_ID);
        Assert.assertEquals((Object)diskStatus, (Object)DeprecationStatus.fromPb((com.google.api.services.compute.model.DeprecationStatus)diskStatus.toPb(), (Function)DiskTypeId.FROM_URL_FUNCTION));
    }

    private void compareDeprecationStatus(DeprecationStatus expected, DeprecationStatus value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.deleted(), (Object)value.deleted());
        Assert.assertEquals((Object)expected.deprecated(), (Object)value.deprecated());
        Assert.assertEquals((Object)expected.obsolete(), (Object)value.obsolete());
        Assert.assertEquals((Object)expected.deletedMillis(), (Object)value.deletedMillis());
        Assert.assertEquals((Object)expected.deprecatedMillis(), (Object)value.deprecatedMillis());
        Assert.assertEquals((Object)expected.obsoleteMillis(), (Object)value.obsoleteMillis());
        Assert.assertEquals((Object)expected.replacement(), (Object)value.replacement());
        Assert.assertEquals((Object)expected.status(), (Object)value.status());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

