/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.ZoneId;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DiskIdTest {
    private static final String PROJECT = "project";
    private static final String ZONE = "zone";
    private static final String NAME = "disk";
    private static final String URL = "https://www.googleapis.com/compute/v1/projects/project/zones/zone/disks/disk";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testOf() {
        DiskId diskId = DiskId.of((String)PROJECT, (String)ZONE, (String)NAME);
        Assert.assertEquals((Object)PROJECT, (Object)diskId.project());
        Assert.assertEquals((Object)ZONE, (Object)diskId.zone());
        Assert.assertEquals((Object)NAME, (Object)diskId.disk());
        Assert.assertEquals((Object)URL, (Object)diskId.selfLink());
        diskId = DiskId.of((String)ZONE, (String)NAME);
        Assert.assertNull((Object)diskId.project());
        Assert.assertEquals((Object)ZONE, (Object)diskId.zone());
        Assert.assertEquals((Object)NAME, (Object)diskId.disk());
        diskId = DiskId.of((ZoneId)ZoneId.of((String)ZONE), (String)NAME);
        Assert.assertNull((Object)diskId.project());
        Assert.assertEquals((Object)ZONE, (Object)diskId.zone());
        Assert.assertEquals((Object)NAME, (Object)diskId.disk());
    }

    @Test
    public void testToAndFromUrl() {
        DiskId diskId = DiskId.of((String)PROJECT, (String)ZONE, (String)NAME);
        this.compareDiskId(diskId, DiskId.fromUrl((String)diskId.selfLink()));
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("notMatchingUrl is not a valid disk URL");
        DiskId.fromUrl((String)"notMatchingUrl");
    }

    @Test
    public void testSetProjectId() {
        DiskId diskId = DiskId.of((String)PROJECT, (String)ZONE, (String)NAME);
        Assert.assertSame((Object)diskId, (Object)diskId.setProjectId(PROJECT));
        this.compareDiskId(diskId, DiskId.of((String)ZONE, (String)NAME).setProjectId(PROJECT));
    }

    @Test
    public void testMatchesUrl() {
        Assert.assertTrue((boolean)DiskId.matchesUrl((String)DiskId.of((String)PROJECT, (String)ZONE, (String)NAME).selfLink()));
        Assert.assertFalse((boolean)DiskId.matchesUrl((String)"notMatchingUrl"));
    }

    private void compareDiskId(DiskId expected, DiskId value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.project(), (Object)expected.project());
        Assert.assertEquals((Object)expected.zone(), (Object)expected.zone());
        Assert.assertEquals((Object)expected.disk(), (Object)expected.disk());
        Assert.assertEquals((Object)expected.selfLink(), (Object)expected.selfLink());
        Assert.assertEquals((long)expected.hashCode(), (long)expected.hashCode());
    }
}

