/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute;

import com.google.api.services.compute.model.Image;
import com.google.cloud.compute.DiskId;
import com.google.cloud.compute.DiskImageConfiguration;
import com.google.cloud.compute.ImageConfiguration;
import org.junit.Assert;
import org.junit.Test;

public class DiskImageConfigurationTest {
    private static final DiskId SOURCE_DISK = DiskId.of((String)"project", (String)"zone", (String)"disk");
    private static final String SOURCE_DISK_ID = "diskId";
    private static final Long ARCHIVE_SIZE_BYTES = 42L;
    private static final ImageConfiguration.SourceType SOURCE_TYPE = ImageConfiguration.SourceType.RAW;
    private static final DiskImageConfiguration CONFIGURATION = ((DiskImageConfiguration.Builder)((DiskImageConfiguration.Builder)DiskImageConfiguration.builder((DiskId)SOURCE_DISK).sourceDiskId("diskId").sourceType(SOURCE_TYPE)).archiveSizeBytes(ARCHIVE_SIZE_BYTES)).build();

    @Test
    public void testToBuilder() {
        this.compareDiskImageConfiguration(CONFIGURATION, CONFIGURATION.toBuilder().build());
        DiskId newDisk = DiskId.of((String)"newProject", (String)"newZone", (String)"newDisk");
        String newDiskId = "newDiskId";
        DiskImageConfiguration configuration = CONFIGURATION.toBuilder().sourceDisk(newDisk).sourceDiskId(newDiskId).build();
        Assert.assertEquals((Object)newDisk, (Object)configuration.sourceDisk());
        Assert.assertEquals((Object)newDiskId, (Object)configuration.sourceDiskId());
        configuration = configuration.toBuilder().sourceDiskId(SOURCE_DISK_ID).sourceDisk(SOURCE_DISK).build();
        this.compareDiskImageConfiguration(CONFIGURATION, configuration);
    }

    @Test
    public void testToBuilderIncomplete() {
        DiskImageConfiguration configuration = DiskImageConfiguration.of((DiskId)SOURCE_DISK);
        this.compareDiskImageConfiguration(configuration, configuration.toBuilder().build());
    }

    @Test
    public void testBuilder() {
        Assert.assertEquals((Object)SOURCE_TYPE, (Object)CONFIGURATION.sourceType());
        Assert.assertEquals((Object)SOURCE_DISK, (Object)CONFIGURATION.sourceDisk());
        Assert.assertEquals((Object)SOURCE_DISK_ID, (Object)CONFIGURATION.sourceDiskId());
        Assert.assertEquals((Object)ARCHIVE_SIZE_BYTES, (Object)CONFIGURATION.archiveSizeBytes());
        Assert.assertEquals((Object)ImageConfiguration.Type.DISK, (Object)CONFIGURATION.type());
    }

    @Test
    public void testToAndFromPb() {
        Assert.assertTrue((boolean)(ImageConfiguration.fromPb((Image)CONFIGURATION.toPb()) instanceof DiskImageConfiguration));
        this.compareDiskImageConfiguration(CONFIGURATION, (DiskImageConfiguration)ImageConfiguration.fromPb((Image)CONFIGURATION.toPb()));
        DiskImageConfiguration configuration = DiskImageConfiguration.of((DiskId)SOURCE_DISK);
        this.compareDiskImageConfiguration(configuration, DiskImageConfiguration.fromPb((Image)configuration.toPb()));
    }

    @Test
    public void testOf() {
        DiskImageConfiguration configuration = DiskImageConfiguration.of((DiskId)SOURCE_DISK);
        Assert.assertEquals((Object)ImageConfiguration.Type.DISK, (Object)configuration.type());
        Assert.assertNull((Object)configuration.sourceDiskId());
        Assert.assertNull((Object)configuration.sourceType());
        Assert.assertNull((Object)configuration.archiveSizeBytes());
        Assert.assertEquals((Object)SOURCE_DISK, (Object)configuration.sourceDisk());
    }

    @Test
    public void testSetProjectId() {
        DiskImageConfiguration configuration = CONFIGURATION.toBuilder().sourceDisk(DiskId.of((String)"zone", (String)"disk")).build();
        this.compareDiskImageConfiguration(CONFIGURATION, configuration.setProjectId("project"));
    }

    private void compareDiskImageConfiguration(DiskImageConfiguration expected, DiskImageConfiguration value) {
        Assert.assertEquals((Object)expected, (Object)value);
        Assert.assertEquals((Object)expected.type(), (Object)value.type());
        Assert.assertEquals((Object)expected.archiveSizeBytes(), (Object)value.archiveSizeBytes());
        Assert.assertEquals((Object)expected.sourceDisk(), (Object)value.sourceDisk());
        Assert.assertEquals((Object)expected.sourceDiskId(), (Object)value.sourceDiskId());
        Assert.assertEquals((Object)expected.sourceType(), (Object)value.sourceType());
        Assert.assertEquals((long)expected.hashCode(), (long)value.hashCode());
    }
}

